/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simantics.Simantics;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.document.server.DocumentHistory;
import org.simantics.document.server.DocumentHistoryListener;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.request.URIDocumentRequest;
import org.simantics.utils.datastructures.Pair;

public class DocumentHistoryCollector {
    static Map<String, DocumentHistory> histories = new HashMap<String, DocumentHistory>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<DocumentHistory, DocumentHistoryListener> initializeAndGetInternal(Listener<Integer> listener, String location, int sequenceNumber) {
        Map<String, DocumentHistory> map = histories;
        synchronized (map) {
            DocumentHistory history = histories.get(location);
            if (history == null) {
                history = new DocumentHistory();
                histories.put(location, history);
            }
            history.registerListener(listener);
            if (history.hasListeners()) {
                if (history.updater == null) {
                    history.updater = new DocumentHistoryListener(history);
                    return Pair.make((Object)history, (Object)history.updater);
                }
            } else if (history.updater != null) {
                history.updater.dispose();
                history.updater = null;
            }
            return Pair.make((Object)history, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Pair<Integer, Collection<JSONObject>> fetchFromCache(Listener<Integer> listener, String location, int sequenceNumber) {
        Map<String, DocumentHistory> map = histories;
        synchronized (map) {
            DocumentHistory history = histories.get(location);
            if (history == null) {
                return null;
            }
            DocumentHistory documentHistory = history;
            synchronized (documentHistory) {
                if (!history.hasListeners()) {
                    return null;
                }
                if (!listener.isDisposed()) {
                    history.registerListener(listener);
                }
                return DocumentHistoryCollector.fetchChanges(location, sequenceNumber);
            }
        }
    }

    private static void initializeAndGet(Listener<Integer> listener, String location, int sequenceNumber) {
        Pair<DocumentHistory, DocumentHistoryListener> status = DocumentHistoryCollector.initializeAndGetInternal(listener, location, sequenceNumber);
        try {
            if (status.second != null) {
                Simantics.getSession().syncRequest((Read)new URIDocumentRequest(location), (Listener)status.second);
            } else {
                List current = (List)Simantics.getSession().syncRequest((Read)new URIDocumentRequest(location), (Listener)TransientCacheListener.instance());
                ((DocumentHistory)status.first).refresh(current);
            }
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentHistory fetchHistory(String location) {
        Map<String, DocumentHistory> map = histories;
        synchronized (map) {
            return histories.get(location);
        }
    }

    private static Collection<JSONObject> fetchChanges(DocumentHistory history, int sequenceNumber) {
        return new ArrayList<JSONObject>(history.entries.tailMap(sequenceNumber, false).values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<Integer, Collection<JSONObject>> fetchChanges(String location, int sequenceNumber) {
        DocumentHistory history;
        DocumentHistory documentHistory = history = DocumentHistoryCollector.fetchHistory(location);
        synchronized (documentHistory) {
            return Pair.make((Object)history.lastRevision, DocumentHistoryCollector.fetchChanges(history, sequenceNumber));
        }
    }

    public static Pair<Integer, Collection<JSONObject>> getContent(Listener<Integer> listener, String location, int sequenceNumber) {
        Pair<Integer, Collection<JSONObject>> cache = DocumentHistoryCollector.fetchFromCache(listener, location, sequenceNumber);
        if (cache != null) {
            return cache;
        }
        DocumentHistoryCollector.initializeAndGet(listener, location, sequenceNumber);
        return DocumentHistoryCollector.fetchChanges(location, sequenceNumber);
    }
}

