/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.simantics.db.procedure.Listener;
import org.simantics.document.server.DocumentHistoryListener;
import org.simantics.document.server.JSONObject;

class DocumentHistory {
    private CopyOnWriteArrayList<Listener<Integer>> listeners = new CopyOnWriteArrayList();
    public TreeMap<Integer, JSONObject> entries = new TreeMap();
    public Map<String, Integer> lastRevisions = new HashMap<String, Integer>();
    public List<JSONObject> previous = new ArrayList<JSONObject>();
    public int lastRevision = 0;
    public DocumentHistoryListener updater = null;

    private void pruneListeners() {
        ArrayList<Listener<Integer>> removals = new ArrayList<Listener<Integer>>();
        for (Listener<Integer> listener : this.listeners) {
            if (!listener.isDisposed()) continue;
            removals.add(listener);
        }
        this.listeners.removeAll(removals);
    }

    public void registerListener(Listener<Integer> listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void fireListeners(Integer value) {
        ArrayList<Listener<Integer>> removals = new ArrayList<Listener<Integer>>();
        for (Listener<Integer> listener : this.listeners) {
            if (listener.isDisposed()) {
                removals.add(listener);
                continue;
            }
            listener.execute((Object)value);
        }
        this.listeners.removeAll(removals);
    }

    public synchronized void refresh(List<JSONObject> result) {
        Set added = null;
        Set removed = null;
        int oldIndex = 0;
        int newIndex = 0;
        while (true) {
            boolean noMoreNews;
            boolean noMoreOlds = oldIndex == this.previous.size();
            boolean bl = noMoreNews = newIndex == result.size();
            if (noMoreOlds) {
                if (noMoreNews) break;
                int i = newIndex;
                while (i < result.size()) {
                    if (added == null) {
                        added = new THashSet();
                    }
                    added.add(result.get(i));
                    ++i;
                }
                break;
            }
            if (noMoreNews) {
                int i = oldIndex;
                while (i < this.previous.size()) {
                    if (removed == null) {
                        removed = new THashSet();
                    }
                    removed.add(this.previous.get(i));
                    ++i;
                }
                break;
            }
            JSONObject o = this.previous.get(oldIndex);
            JSONObject n = result.get(newIndex);
            int comp = o.id.compareTo(n.id);
            if (comp == 0) {
                if (!n.equals((Object)o)) {
                    if (added == null) {
                        added = new THashSet();
                    }
                    added.add(n);
                }
                ++oldIndex;
                ++newIndex;
                continue;
            }
            if (comp > 0) {
                if (added == null) {
                    added = new THashSet();
                }
                added.add(n);
                ++newIndex;
                continue;
            }
            if (comp >= 0) continue;
            if (removed == null) {
                removed = new THashSet();
            }
            removed.add(o);
            ++oldIndex;
        }
        if (added != null) {
            for (JSONObject entry : added) {
                this.add(entry);
            }
        }
        if (removed != null) {
            for (JSONObject entry : removed) {
                this.remove(entry);
            }
        }
        this.previous = result;
    }

    public void add(JSONObject entry) {
        Integer rev = this.lastRevisions.get(entry.getId());
        if (rev != null) {
            this.entries.remove(rev);
        }
        ++this.lastRevision;
        this.lastRevisions.put(entry.getId(), this.lastRevision);
        this.entries.put(this.lastRevision, entry);
        this.fireListeners(this.lastRevision);
    }

    public void remove(JSONObject entry) {
        JSONObject object = new JSONObject(entry.getId());
        object.addJSONField("id", entry.getId());
        object.addJSONField("parent", "");
        Integer rev = this.lastRevisions.get(object.getId());
        if (rev != null) {
            this.entries.remove(rev);
        }
        ++this.lastRevision;
        this.lastRevisions.put(object.getId(), this.lastRevision);
        this.entries.put(this.lastRevision, object);
        this.fireListeners(this.lastRevision);
    }

    public boolean hasListeners() {
        this.pruneListeners();
        return !this.listeners.isEmpty();
    }
}

