/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.cojen.util.ReferencedValueHashMap;

public class WeakValuedHashMap<K, V>
extends ReferencedValueHashMap<K, V> {
    public WeakValuedHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public WeakValuedHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public WeakValuedHashMap() {
    }

    public WeakValuedHashMap(Map<? extends K, ? extends V> t) {
        super(t);
    }

    @Override
    ReferencedValueHashMap.Entry<K, V> newEntry(int hash, K key, V value, ReferencedValueHashMap.Entry<K, V> next) {
        return new WeakEntry<K, V>(hash, key, value, next);
    }

    static class WeakEntry<K, V>
    extends ReferencedValueHashMap.Entry<K, V> {
        WeakEntry(int hash, K key, V value, ReferencedValueHashMap.Entry<K, V> next) {
            super(hash, key, value, next);
        }

        WeakEntry(int hash, K key, Reference<V> value, ReferencedValueHashMap.Entry<K, V> next) {
            super(hash, key, value, next);
        }

        @Override
        ReferencedValueHashMap.Entry newEntry(int hash, K key, Reference<V> value, ReferencedValueHashMap.Entry<K, V> next) {
            return new WeakEntry<K, V>(hash, key, value, next);
        }

        @Override
        Reference<V> newReference(V value) {
            return new WeakReference<V>(value);
        }
    }
}

