/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.cojen.util.WeakIdentityMap;

public class WeakCanonicalSet<T>
extends AbstractSet<T> {
    private Entry<T>[] table;
    private int count;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue<T> queue;

    public WeakCanonicalSet() {
        int initialCapacity = 101;
        float loadFactor = 0.75f;
        this.loadFactor = 0.75f;
        this.table = new Entry[101];
        this.threshold = 75;
        this.queue = new ReferenceQueue();
    }

    public synchronized <U extends T> U put(U obj) {
        Reference<T> ref;
        if (obj == null) {
            return null;
        }
        Entry<T>[] tab = this.table;
        ReferenceQueue<T> queue = this.queue;
        while ((ref = queue.poll()) != null) {
            int index = (((Entry)ref).hash & Integer.MAX_VALUE) % tab.length;
            Entry<T> e = tab[index];
            Entry<T> prev = null;
            while (e != null) {
                if (e.get() == null) {
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[index] = e.next;
                    }
                    --this.count;
                } else {
                    prev = e;
                }
                e = e.next;
            }
        }
        int hash = this.hashCode(obj);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<T> e = tab[index];
        Entry<T> prev = null;
        while (e != null) {
            Object iobj = e.get();
            if (iobj == null) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
            } else {
                if (e.hash == hash && obj.getClass() == iobj.getClass() && this.equals(obj, iobj)) {
                    return (U)iobj;
                }
                prev = e;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = new Entry<U>(obj, this.queue, hash, tab[index]);
        ++this.count;
        return obj;
    }

    @Override
    public Iterator<T> iterator() {
        return new SetIterator();
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public synchronized boolean contains(Object obj) {
        if (obj == null) {
            return false;
        }
        Entry<T>[] tab = this.table;
        int hash = this.hashCode(obj);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<T> e = tab[index];
        Entry<T> prev = null;
        while (e != null) {
            Object iobj = e.get();
            if (iobj == null) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
            } else {
                if (e.hash == hash && obj.getClass() == iobj.getClass() && this.equals(obj, iobj)) {
                    return true;
                }
                prev = e;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public synchronized String toString() {
        return WeakIdentityMap.toString(this);
    }

    protected int hashCode(Object obj) {
        return obj.hashCode();
    }

    protected boolean equals(Object a, Object b) {
        return a.equals(b);
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry<T>[] tab = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newTab = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTab;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry<T> old = tab[i];
            while (old != null) {
                Entry<T> e = old;
                old = old.next;
                if (e.get() == null) {
                    --this.count;
                    continue;
                }
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newTab[index];
                newTab[index] = e;
            }
        }
    }

    private static class Entry<T>
    extends WeakReference<T> {
        int hash;
        Entry<T> next;

        Entry(T canonical, ReferenceQueue<T> queue, int hash, Entry<T> next) {
            super(canonical, queue);
            this.hash = hash;
            this.next = next;
        }
    }

    private class SetIterator
    implements Iterator<T> {
        private final Entry<T>[] table;
        private int index;
        private T entryCanonical;
        private Entry<T> entry;

        SetIterator() {
            this.table = WeakCanonicalSet.this.table;
            this.index = this.table.length;
        }

        @Override
        public boolean hasNext() {
            while (this.entry == null || (this.entryCanonical = this.entry.get()) == null) {
                if (this.entry != null) {
                    this.entry = this.entry.next;
                    continue;
                }
                if (this.index <= 0) {
                    return false;
                }
                this.entry = this.table[--this.index];
            }
            return true;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.entry = this.entry.next;
            return this.entryCanonical;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

