/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.RuntimeClassFile;
import org.cojen.classfile.TypeDesc;

public abstract class ThrowUnchecked {
    private static volatile ThrowUnchecked cImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void fire(Throwable t) {
        if (t == null) return;
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        ThrowUnchecked impl = cImpl;
        if (impl == null) {
            Class<ThrowUnchecked> clazz = ThrowUnchecked.class;
            // MONITORENTER : org.cojen.util.ThrowUnchecked.class
            impl = cImpl;
            if (impl == null) {
                cImpl = impl = AccessController.doPrivileged(new PrivilegedAction<ThrowUnchecked>(){

                    @Override
                    public ThrowUnchecked run() {
                        return ThrowUnchecked.generateImpl();
                    }
                });
            }
            // MONITOREXIT : clazz
        }
        impl.doFire(t);
    }

    public static void fireDeclared(Throwable t, Class ... declaredTypes) {
        if (t != null) {
            if (declaredTypes != null) {
                Class[] classArray = declaredTypes;
                int n = declaredTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    Class declaredType = classArray[n2];
                    if (declaredType.isInstance(t)) {
                        ThrowUnchecked.fire(t);
                    }
                    ++n2;
                }
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new UndeclaredThrowableException(t);
        }
    }

    public static void fireFirstDeclared(Throwable t, Class ... declaredTypes) {
        Throwable cause = t;
        while (cause != null) {
            if ((cause = cause.getCause()) == null) break;
            if (declaredTypes != null) {
                Class[] classArray = declaredTypes;
                int n = declaredTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    Class declaredType = classArray[n2];
                    if (declaredType.isInstance(cause)) {
                        ThrowUnchecked.fire(cause);
                    }
                    ++n2;
                }
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (!(cause instanceof Error)) continue;
            throw (Error)cause;
        }
        throw new UndeclaredThrowableException(t);
    }

    public static void fireCause(Throwable t) {
        if (t != null) {
            Throwable cause = t.getCause();
            if (cause == null) {
                cause = t;
            }
            ThrowUnchecked.fire(cause);
        }
    }

    public static void fireDeclaredCause(Throwable t, Class ... declaredTypes) {
        if (t != null) {
            Throwable cause = t.getCause();
            if (cause == null) {
                cause = t;
            }
            ThrowUnchecked.fireDeclared(cause, declaredTypes);
        }
    }

    public static void fireFirstDeclaredCause(Throwable t, Class ... declaredTypes) {
        Throwable cause = t;
        while (cause != null) {
            if ((cause = cause.getCause()) == null) break;
            if (declaredTypes != null) {
                Class[] classArray = declaredTypes;
                int n = declaredTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    Class declaredType = classArray[n2];
                    if (declaredType.isInstance(cause)) {
                        ThrowUnchecked.fire(cause);
                    }
                    ++n2;
                }
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (!(cause instanceof Error)) continue;
            throw (Error)cause;
        }
        ThrowUnchecked.fireDeclaredCause(t, declaredTypes);
    }

    public static void fireRootCause(Throwable t) {
        Throwable root = t;
        while (root != null) {
            Throwable cause = root.getCause();
            if (cause == null) break;
            root = cause;
        }
        ThrowUnchecked.fire(root);
    }

    public static void fireDeclaredRootCause(Throwable t, Class ... declaredTypes) {
        Throwable root = t;
        while (root != null) {
            Throwable cause = root.getCause();
            if (cause == null) break;
            root = cause;
        }
        ThrowUnchecked.fireDeclared(root, declaredTypes);
    }

    private static ThrowUnchecked generateImpl() {
        RuntimeClassFile cf = new RuntimeClassFile(null, ThrowUnchecked.class.getName());
        cf.addDefaultConstructor();
        CodeBuilder b = new CodeBuilder(cf.addMethod(Modifiers.PROTECTED, "doFire", null, new TypeDesc[]{TypeDesc.forClass(Throwable.class)}));
        b.loadLocal(b.getParameter(0));
        b.throwObject();
        try {
            return (ThrowUnchecked)cf.defineClass().newInstance();
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    protected ThrowUnchecked() {
    }

    protected abstract void doFire(Throwable var1);
}

