/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.RuntimeClassFile;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.SoftValuedHashMap;
import org.cojen.util.WeakIdentityMap;

public class QuickConstructorGenerator {
    private static Map<Class<?>, Map<Class<?>, Object>> cCache = new WeakIdentityMap();

    public static synchronized <F> F getInstance(final Class<?> objectType, final Class<F> factory) {
        Object instance;
        Map<Class<?>, Object> innerCache = cCache.get(factory);
        if (innerCache == null) {
            innerCache = new SoftValuedHashMap();
            cCache.put(factory, innerCache);
        }
        if ((instance = innerCache.get(objectType)) != null) {
            return (F)instance;
        }
        if (objectType == null) {
            throw new IllegalArgumentException("No object type");
        }
        if (factory == null) {
            throw new IllegalArgumentException("No factory type");
        }
        if (!factory.isInterface()) {
            throw new IllegalArgumentException("Factory must be an interface");
        }
        final Map<Class<?>, Object> fInnerCache = innerCache;
        return (F)AccessController.doPrivileged(new PrivilegedAction<F>(){

            @Override
            public F run() {
                return QuickConstructorGenerator.getInstance(fInnerCache, objectType, factory);
            }
        });
    }

    private static synchronized <F> F getInstance(Map<Class<?>, Object> innerCache, Class<?> objectType, Class<F> factory) {
        Object instance;
        int index;
        String prefix = objectType.getName();
        if (prefix.startsWith("java.") && (index = prefix.lastIndexOf(46)) > 0) {
            prefix = prefix.substring(index + 1);
        }
        RuntimeClassFile cf = null;
        Method[] methodArray = factory.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (Modifier.isAbstract(method.getModifiers())) {
                Constructor<?> ctor;
                try {
                    ctor = objectType.getConstructor(method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException(e);
                }
                if (!method.getReturnType().isAssignableFrom(objectType)) {
                    throw new IllegalArgumentException("Method return type must be \"" + objectType.getName() + "\" or supertype: " + method);
                }
                Class<?>[] methodExTypes = method.getExceptionTypes();
                Class<?>[] classArray = ctor.getExceptionTypes();
                int n3 = classArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    block16: {
                        Class<?> ctorExType = classArray[n4];
                        if (!RuntimeException.class.isAssignableFrom(ctorExType) && !Error.class.isAssignableFrom(ctorExType)) {
                            Class<?>[] classArray2 = methodExTypes;
                            int n5 = methodExTypes.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                Class<?> methodExType = classArray2[n6];
                                if (!methodExType.isAssignableFrom(ctorExType)) {
                                    ++n6;
                                    continue;
                                }
                                break block16;
                            }
                            throw new IllegalArgumentException("Method must declare throwing \"" + ctorExType.getName() + "\": " + method);
                        }
                    }
                    ++n4;
                }
                if (cf == null) {
                    cf = new RuntimeClassFile(prefix, null, objectType.getClassLoader());
                    cf.setSourceFile(QuickConstructorGenerator.class.getName());
                    cf.setTarget("1.5");
                    cf.addInterface(factory);
                    cf.markSynthetic();
                    cf.addDefaultConstructor();
                }
                CodeBuilder b = new CodeBuilder(cf.addMethod(method));
                b.newObject(TypeDesc.forClass(objectType));
                b.dup();
                int count = b.getParameterCount();
                int i = 0;
                while (i < count) {
                    b.loadLocal(b.getParameter(i));
                    ++i;
                }
                b.invoke(ctor);
                b.returnValue(TypeDesc.OBJECT);
            }
            ++n2;
        }
        if (cf == null) {
            throw new IllegalArgumentException("No methods in factory to implement");
        }
        try {
            instance = cf.defineClass().newInstance();
        }
        catch (IllegalAccessException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (InstantiationException e) {
            throw new UndeclaredThrowableException(e);
        }
        innerCache.put(objectType, instance);
        return (F)instance;
    }
}

