/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.RuntimeClassFile;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.KeyFactory;
import org.cojen.util.SoftValuedHashMap;

public abstract class PatternMatcher<V> {
    private static final int[] NO_POSITIONS = new int[0];
    private static Map cPatternMatcherClasses = new SoftValuedHashMap();
    protected final V[] mValues;

    public static synchronized <V> PatternMatcher<V> forPatterns(Map<String, V> patternMap) {
        final Maker maker = new Maker(patternMap);
        final Class clazz = (Class)cPatternMatcherClasses.get(maker.getKey());
        return (PatternMatcher)AccessController.doPrivileged(new PrivilegedAction<PatternMatcher<V>>(){

            @Override
            public PatternMatcher<V> run() {
                Class clz = clazz;
                if (clz == null) {
                    clz = maker.createClassFile().defineClass();
                    cPatternMatcherClasses.put(maker.getKey(), clz);
                }
                try {
                    Constructor ctor = clz.getConstructor(Object[].class);
                    return (PatternMatcher)ctor.newInstance(maker.getMappedValues());
                }
                catch (NoSuchMethodException e) {
                    throw new InternalError(e.toString());
                }
                catch (InstantiationException e) {
                    throw new InternalError(e.toString());
                }
                catch (IllegalAccessException e) {
                    throw new InternalError(e.toString());
                }
                catch (InvocationTargetException e) {
                    throw new InternalError(e.toString());
                }
            }
        });
    }

    protected PatternMatcher(V[] values) {
        this.mValues = values;
    }

    public Result<V> getMatch(String lookup) {
        int strLen = lookup.length();
        char[] chars = new char[strLen + 1];
        lookup.getChars(0, strLen, chars, 0);
        chars[strLen] = 65535;
        TinyList resultList = new TinyList();
        this.fillMatchResults(chars, 1, resultList);
        return (Result)resultList.mElement;
    }

    public Result<V>[] getMatches(String lookup, int limit) {
        int strLen = lookup.length();
        char[] chars = new char[strLen + 1];
        lookup.getChars(0, strLen, chars, 0);
        chars[strLen] = 65535;
        ArrayList resultList = new ArrayList();
        this.fillMatchResults(chars, limit, resultList);
        return resultList.toArray(new Result[resultList.size()]);
    }

    protected abstract void fillMatchResults(char[] var1, int var2, List var3);

    protected static boolean addMatchResult(int limit, List results, String pattern, Object value, int[] positions, int len) {
        int size = results.size();
        if (size < limit) {
            if (positions == null || len == 0) {
                positions = NO_POSITIONS;
            } else {
                int[] original = positions;
                positions = new int[len];
                int i = 0;
                while (i < len) {
                    positions[i] = original[i];
                    ++i;
                }
            }
            results.add(new Result<Object>(pattern, value, positions));
            return size + 1 < limit;
        }
        return false;
    }

    private static class Maker {
        private PatternNode mPatternRoot;
        private Object mKey;
        private Object[] mMappedValues;
        private int mMaxWildPerKey;
        private TypeDesc mIntType;
        private TypeDesc mBooleanType;
        private TypeDesc mListType;
        private TypeDesc mStringType;
        private TypeDesc mObjectType;
        private TypeDesc mIntArrayType;
        private CodeBuilder mBuilder;
        private LocalVariable mLookupLocal;
        private LocalVariable mLimitLocal;
        private LocalVariable mResultsLocal;
        private LocalVariable mPositionsLocal;
        private LocalVariable mIndexLocal;
        private Stack mTempLocals;
        private Label mReturnLabel;
        private int mReferenceLine;

        Maker(Map patternMap) {
            String key;
            Object[] keys = patternMap.keySet().toArray(new String[0]);
            int i = 0;
            while (i < keys.length) {
                key = keys[i];
                if (!key.endsWith("*")) {
                    keys[i] = key.concat("\uffff");
                }
                ++i;
            }
            Arrays.sort(keys, new PatternComparator());
            this.mMappedValues = new Object[keys.length];
            i = 0;
            while (i < keys.length) {
                key = keys[i];
                if (key.endsWith("\uffff")) {
                    key = key.substring(0, key.length() - 1);
                }
                this.mMappedValues[i] = patternMap.get(key);
                ++i;
            }
            this.mPatternRoot = new PatternNode();
            i = 0;
            while (i < keys.length) {
                key = keys[i];
                this.mPatternRoot.buildPathTo(key, i);
                ++i;
            }
            this.mMaxWildPerKey = this.mPatternRoot.getMaxWildcardCount();
            this.mKey = KeyFactory.createKey(keys);
        }

        public Object getKey() {
            return this.mKey;
        }

        public Object getMappedValues() {
            return this.mMappedValues;
        }

        public RuntimeClassFile createClassFile() {
            RuntimeClassFile cf = new RuntimeClassFile(PatternMatcher.class.getName(), PatternMatcher.class.getName(), PatternMatcher.class.getClassLoader());
            cf.markSynthetic();
            cf.setSourceFile(PatternMatcher.class.getName());
            TypeDesc objectArrayType = TypeDesc.OBJECT.toArrayType();
            TypeDesc[] params = new TypeDesc[]{objectArrayType};
            MethodInfo mi = cf.addConstructor(Modifiers.PUBLIC, params);
            this.mBuilder = new CodeBuilder(mi);
            this.mBuilder.loadThis();
            this.mBuilder.loadLocal(this.mBuilder.getParameter(0));
            this.mBuilder.invokeSuperConstructor(params);
            this.mBuilder.returnVoid();
            this.mIntType = TypeDesc.INT;
            this.mBooleanType = TypeDesc.BOOLEAN;
            this.mListType = TypeDesc.forClass(List.class);
            this.mStringType = TypeDesc.STRING;
            this.mObjectType = TypeDesc.OBJECT;
            this.mIntArrayType = TypeDesc.INT.toArrayType();
            TypeDesc charArrayType = TypeDesc.CHAR.toArrayType();
            params = new TypeDesc[]{charArrayType, this.mIntType, this.mListType};
            mi = cf.addMethod(Modifiers.PUBLIC, "fillMatchResults", null, params);
            this.mBuilder = new CodeBuilder(mi);
            this.mLookupLocal = this.mBuilder.getParameter(0);
            this.mLimitLocal = this.mBuilder.getParameter(1);
            this.mResultsLocal = this.mBuilder.getParameter(2);
            this.mPositionsLocal = this.mBuilder.createLocalVariable("positions", this.mIntArrayType);
            this.mIndexLocal = this.mBuilder.createLocalVariable("index", this.mIntType);
            this.mBuilder.mapLineNumber(++this.mReferenceLine);
            this.mBuilder.loadConstant(this.mMaxWildPerKey * 2);
            this.mBuilder.newObject(this.mIntArrayType);
            this.mBuilder.storeLocal(this.mPositionsLocal);
            this.mBuilder.loadConstant(0);
            this.mBuilder.storeLocal(this.mIndexLocal);
            this.mTempLocals = new Stack();
            this.mReturnLabel = this.mBuilder.createLabel();
            this.generateBranches(this.mPatternRoot, -1, 0);
            this.mReturnLabel.setLocation();
            this.mBuilder.returnVoid();
            return cf;
        }

        private void generateBranches(PatternNode node, int depth, int posIndex) {
            this.generateBranches(node, depth, posIndex, null);
        }

        private void generateBranches(PatternNode node, int depth, int posIndex, LocalVariable tempChar) {
            int c = node.mChar;
            List subNodes = node.mSubNodes;
            this.mBuilder.mapLineNumber(++this.mReferenceLine);
            if (c == 42) {
                LocalVariable savedIndex = this.mTempLocals.isEmpty() ? this.mBuilder.createLocalVariable("temp", this.mIntType) : (LocalVariable)this.mTempLocals.pop();
                this.mBuilder.loadLocal(this.mIndexLocal);
                this.mBuilder.storeLocal(savedIndex);
                this.mBuilder.loadLocal(this.mPositionsLocal);
                this.mBuilder.loadConstant(posIndex);
                this.mBuilder.loadLocal(this.mIndexLocal);
                if (depth > 0) {
                    this.mBuilder.loadConstant(depth);
                    this.mBuilder.math((byte)96);
                }
                this.mBuilder.storeToArray(TypeDesc.INT);
                if (subNodes == null) {
                    this.generateWildcard(null, depth, posIndex + 2);
                } else {
                    int size = subNodes.size();
                    int i = 0;
                    while (i < size) {
                        this.generateWildcard((PatternNode)subNodes.get(i), depth, posIndex + 2);
                        this.mBuilder.loadLocal(savedIndex);
                        this.mBuilder.storeLocal(this.mIndexLocal);
                        ++i;
                    }
                }
                this.mTempLocals.push(savedIndex);
                if (node.mPattern != null) {
                    this.generateAddMatchResult(node);
                }
                return;
            }
            Label noMatch = this.mBuilder.createLabel();
            if (c >= 0) {
                if (tempChar != null) {
                    this.mBuilder.loadLocal(tempChar);
                    this.mTempLocals.push(tempChar);
                } else {
                    this.mBuilder.loadLocal(this.mLookupLocal);
                    this.mBuilder.loadLocal(this.mIndexLocal);
                    if (depth > 0) {
                        this.mBuilder.loadConstant(depth);
                        this.mBuilder.math((byte)96);
                    }
                    this.mBuilder.loadFromArray(TypeDesc.CHAR);
                }
                this.mBuilder.loadConstant((char)c);
                this.mBuilder.ifComparisonBranch(noMatch, "!=");
            }
            if (subNodes != null) {
                int size = subNodes.size();
                int i = 0;
                while (i < size) {
                    this.generateBranches((PatternNode)subNodes.get(i), depth + 1, posIndex);
                    ++i;
                }
            }
            if (node.mPattern != null) {
                this.generateAddMatchResult(node);
            }
            noMatch.setLocation();
        }

        private void generateWildcard(PatternNode node, int depth, int posIndex) {
            Label loopStart = this.mBuilder.createLabel().setLocation();
            Label loopEnd = this.mBuilder.createLabel();
            Label loopContinue = this.mBuilder.createLabel();
            this.mBuilder.loadLocal(this.mPositionsLocal);
            this.mBuilder.loadConstant(posIndex - 1);
            this.mBuilder.loadLocal(this.mIndexLocal);
            if (depth > 0) {
                this.mBuilder.loadConstant(depth);
                this.mBuilder.math((byte)96);
            }
            this.mBuilder.storeToArray(TypeDesc.INT);
            this.mBuilder.loadLocal(this.mLookupLocal);
            this.mBuilder.loadLocal(this.mIndexLocal);
            if (depth > 0) {
                this.mBuilder.loadConstant(depth);
                this.mBuilder.math((byte)96);
            }
            this.mBuilder.loadFromArray(TypeDesc.CHAR);
            if (node == null) {
                this.mBuilder.loadConstant(65535);
                this.mBuilder.ifComparisonBranch(loopEnd, "==");
            } else {
                LocalVariable tempChar = this.mTempLocals.isEmpty() ? this.mBuilder.createLocalVariable("temp", this.mIntType) : (LocalVariable)this.mTempLocals.pop();
                this.mBuilder.storeLocal(tempChar);
                this.mBuilder.loadLocal(tempChar);
                this.mBuilder.loadConstant(65535);
                this.mBuilder.ifComparisonBranch(loopEnd, "==");
                this.generateBranches(node, depth, posIndex, tempChar);
            }
            loopContinue.setLocation();
            this.mBuilder.integerIncrement(this.mIndexLocal, 1);
            this.mBuilder.branch(loopStart);
            loopEnd.setLocation();
        }

        private void generateAddMatchResult(PatternNode node) {
            this.mBuilder.mapLineNumber(++this.mReferenceLine);
            this.mBuilder.loadLocal(this.mLimitLocal);
            this.mBuilder.loadLocal(this.mResultsLocal);
            this.mBuilder.loadConstant(node.mPattern);
            this.mBuilder.loadThis();
            this.mBuilder.loadField("mValues", TypeDesc.OBJECT.toArrayType());
            this.mBuilder.loadConstant(node.mOrder);
            this.mBuilder.loadFromArray(TypeDesc.OBJECT);
            this.mBuilder.loadLocal(this.mPositionsLocal);
            this.mBuilder.loadConstant(node.getWildcardCount() * 2);
            TypeDesc[] params = new TypeDesc[]{this.mIntType, this.mListType, this.mStringType, this.mObjectType, this.mIntArrayType, this.mIntType};
            this.mBuilder.invokeStatic(PatternMatcher.class.getName(), "addMatchResult", this.mBooleanType, params);
            this.mBuilder.ifZeroComparisonBranch(this.mReturnLabel, "==");
        }
    }

    private static class PatternComparator
    implements Comparator {
        private PatternComparator() {
        }

        public int compare(Object a, Object b) {
            String sa = (String)a;
            String sb = (String)b;
            int alen = sa.length();
            int blen = sb.length();
            int mlen = Math.min(alen, blen);
            int i = 0;
            while (i < mlen) {
                char ca = sa.charAt(i);
                char cb = sb.charAt(i);
                if (ca == '*') {
                    if (cb != '*') {
                        return 1;
                    }
                } else {
                    if (cb == '*') {
                        return -1;
                    }
                    if (ca < cb) {
                        return -1;
                    }
                    if (ca > cb) {
                        return 1;
                    }
                }
                ++i;
            }
            if (alen < blen) {
                return 1;
            }
            if (alen > blen) {
                return -1;
            }
            return 0;
        }
    }

    private static class PatternNode {
        public final int mChar;
        public String mPattern;
        public int mOrder;
        public List mSubNodes;

        public PatternNode() {
            this.mChar = -1;
        }

        public PatternNode(char c) {
            this.mChar = c;
        }

        public void buildPathTo(String pattern, int order) {
            this.buildPathTo(pattern, order, 0);
        }

        public int getHeight() {
            int height = 1;
            if (this.mSubNodes != null) {
                int size = this.mSubNodes.size();
                int i = 0;
                while (i < size) {
                    int subH = ((PatternNode)this.mSubNodes.get(i)).getHeight();
                    if (subH > height) {
                        height = subH;
                    }
                    ++i;
                }
            }
            return height;
        }

        public int getWildcardCount() {
            int wildCount = 0;
            String pattern = this.mPattern;
            if (pattern != null) {
                int len = pattern.length();
                int i = 0;
                while (i < len) {
                    if (pattern.charAt(i) == '*') {
                        ++wildCount;
                    }
                    ++i;
                }
            }
            return wildCount;
        }

        public int getMaxWildcardCount() {
            int wildCount = this.getWildcardCount();
            if (this.mSubNodes != null) {
                int i = 0;
                while (i < this.mSubNodes.size()) {
                    int count = ((PatternNode)this.mSubNodes.get(i)).getMaxWildcardCount();
                    if (count > wildCount) {
                        wildCount = count;
                    }
                    ++i;
                }
            }
            return wildCount;
        }

        private void buildPathTo(String pattern, int order, int index) {
            if (index >= pattern.length()) {
                if (pattern.endsWith("\uffff")) {
                    pattern = pattern.substring(0, pattern.length() - 1);
                }
                this.mPattern = pattern;
                this.mOrder = order;
                return;
            }
            char c = pattern.charAt(index);
            if (this.mSubNodes == null) {
                this.mSubNodes = new ArrayList(10);
            }
            int size = this.mSubNodes.size();
            int i = 0;
            while (i < size) {
                PatternNode node = (PatternNode)this.mSubNodes.get(i);
                if (node.mChar == c) {
                    node.buildPathTo(pattern, order, index + 1);
                    return;
                }
                ++i;
            }
            PatternNode node = new PatternNode(c);
            this.mSubNodes.add(node);
            node.buildPathTo(pattern, order, index + 1);
        }

        public void dump(PrintStream out, String indent) {
            if (this.mSubNodes != null) {
                String subIndent = indent.concat(" ");
                int i = 0;
                while (i < this.mSubNodes.size()) {
                    ((PatternNode)this.mSubNodes.get(i)).dump(out, subIndent);
                    ++i;
                }
            }
            out.print(indent);
            out.print('\'');
            out.print((char)this.mChar);
            out.print('\'');
            if (this.mPattern != null) {
                out.print(" -> ");
                out.print(this.mPattern);
            }
            out.println();
        }
    }

    public static class Result<V> {
        private final String mPattern;
        private final V mValue;
        private final int[] mPositions;

        Result(String pattern, V value, int[] positions) {
            this.mPattern = pattern;
            this.mValue = value;
            this.mPositions = positions;
        }

        public String getPattern() {
            return this.mPattern;
        }

        public V getValue() {
            return this.mValue;
        }

        public int[] getWildcardPositions() {
            return this.mPositions;
        }
    }

    private static class TinyList
    extends AbstractList {
        public Object mElement;

        private TinyList() {
        }

        @Override
        public int size() {
            return this.mElement == null ? 0 : 1;
        }

        @Override
        public boolean add(Object obj) {
            if (this.mElement == null) {
                this.mElement = obj;
                return true;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(int index) {
            if (index == 0 && this.mElement != null) {
                return this.mElement;
            }
            throw new IndexOutOfBoundsException();
        }
    }
}

