/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.io.Serializable;
import java.util.Arrays;

public class KeyFactory {
    static final Object NULL = new Comparable(){

        public int compareTo(Object obj) {
            return obj == this || obj == null ? 0 : 1;
        }
    };

    public static Object createKey(boolean[] obj) {
        return obj == null ? NULL : new BooleanArrayKey(obj);
    }

    public static Object createKey(byte[] obj) {
        return obj == null ? NULL : new ByteArrayKey(obj);
    }

    public static Object createKey(char[] obj) {
        return obj == null ? NULL : new CharArrayKey(obj);
    }

    public static Object createKey(double[] obj) {
        return obj == null ? NULL : new DoubleArrayKey(obj);
    }

    public static Object createKey(float[] obj) {
        return obj == null ? NULL : new FloatArrayKey(obj);
    }

    public static Object createKey(int[] obj) {
        return obj == null ? NULL : new IntArrayKey(obj);
    }

    public static Object createKey(long[] obj) {
        return obj == null ? NULL : new LongArrayKey(obj);
    }

    public static Object createKey(short[] obj) {
        return obj == null ? NULL : new ShortArrayKey(obj);
    }

    public static Object createKey(Object[] obj) {
        return obj == null ? NULL : new ObjectArrayKey(obj);
    }

    public static Object createKey(Object obj) {
        if (obj == null) {
            return NULL;
        }
        if (!obj.getClass().isArray()) {
            return obj;
        }
        if (obj instanceof Object[]) {
            return KeyFactory.createKey((Object[])obj);
        }
        if (obj instanceof int[]) {
            return KeyFactory.createKey((int[])obj);
        }
        if (obj instanceof float[]) {
            return KeyFactory.createKey((float[])obj);
        }
        if (obj instanceof long[]) {
            return KeyFactory.createKey((long[])obj);
        }
        if (obj instanceof double[]) {
            return KeyFactory.createKey((double[])obj);
        }
        if (obj instanceof byte[]) {
            return KeyFactory.createKey((byte[])obj);
        }
        if (obj instanceof char[]) {
            return KeyFactory.createKey((char[])obj);
        }
        if (obj instanceof boolean[]) {
            return KeyFactory.createKey((boolean[])obj);
        }
        if (obj instanceof short[]) {
            return KeyFactory.createKey((short[])obj);
        }
        return obj;
    }

    static int hashCode(boolean[] a) {
        int hash = 0;
        int i = a.length;
        while (--i >= 0) {
            hash = (hash << 1) + (a[i] ? 0 : 1);
        }
        return hash == 0 ? -1 : hash;
    }

    static int hashCode(byte[] a) {
        int hash = 0;
        int i = a.length;
        while (--i >= 0) {
            hash = (hash << 1) + a[i];
        }
        return hash == 0 ? -1 : hash;
    }

    static int hashCode(char[] a) {
        int hash = 0;
        int i = a.length;
        while (--i >= 0) {
            hash = (hash << 1) + a[i];
        }
        return hash == 0 ? -1 : hash;
    }

    static int hashCode(double[] a) {
        int hash = 0;
        int i = a.length;
        while (--i >= 0) {
            long v = Double.doubleToLongBits(a[i]);
            hash = hash * 31 + (int)(v ^ v >>> 32);
        }
        return hash == 0 ? -1 : hash;
    }

    static int hashCode(float[] a) {
        int hash = 0;
        int i = a.length;
        while (--i >= 0) {
            hash = hash * 31 + Float.floatToIntBits(a[i]);
        }
        return hash == 0 ? -1 : hash;
    }

    static int hashCode(int[] a) {
        int hash = 0;
        int i = a.length;
        while (--i >= 0) {
            hash = (hash << 1) + a[i];
        }
        return hash == 0 ? -1 : hash;
    }

    static int hashCode(long[] a) {
        int hash = 0;
        int i = a.length;
        while (--i >= 0) {
            long v = a[i];
            hash = hash * 31 + (int)(v ^ v >>> 32);
        }
        return hash == 0 ? -1 : hash;
    }

    static int hashCode(short[] a) {
        int hash = 0;
        int i = a.length;
        while (--i >= 0) {
            hash = (hash << 1) + a[i];
        }
        return hash == 0 ? -1 : hash;
    }

    static int hashCode(Object[] a) {
        int hash = 0;
        int i = a.length;
        while (--i >= 0) {
            hash = hash * 31 + KeyFactory.hashCode(a[i]);
        }
        return hash == 0 ? -1 : hash;
    }

    static int hashCode(Object a) {
        if (a == null) {
            return -1;
        }
        if (!a.getClass().isArray()) {
            return a.hashCode();
        }
        if (a instanceof Object[]) {
            return KeyFactory.hashCode((Object[])a);
        }
        if (a instanceof int[]) {
            return KeyFactory.hashCode((int[])a);
        }
        if (a instanceof float[]) {
            return KeyFactory.hashCode((float[])a);
        }
        if (a instanceof long[]) {
            return KeyFactory.hashCode((long[])a);
        }
        if (a instanceof double[]) {
            return KeyFactory.hashCode((double[])a);
        }
        if (a instanceof byte[]) {
            return KeyFactory.hashCode((byte[])a);
        }
        if (a instanceof char[]) {
            return KeyFactory.hashCode((char[])a);
        }
        if (a instanceof boolean[]) {
            return KeyFactory.hashCode((boolean[])a);
        }
        if (a instanceof short[]) {
            return KeyFactory.hashCode((short[])a);
        }
        int hash = a.getClass().hashCode();
        return hash == 0 ? -1 : hash;
    }

    /*
     * Unable to fully structure code
     */
    static boolean equals(Object[] a, Object[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        i = a.length;
        if (i == b.length) ** GOTO lbl10
        return false;
lbl-1000:
        // 1 sources

        {
            if (KeyFactory.equals(a[i], b[i])) continue;
            return false;
lbl10:
            // 2 sources

            ** while (--i >= 0)
        }
lbl11:
        // 1 sources

        return true;
    }

    static boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        Class<?> ac = a.getClass();
        if (!ac.isArray()) {
            return a.equals(b);
        }
        if (ac != b.getClass()) {
            return false;
        }
        if (a instanceof Object[]) {
            return KeyFactory.equals((Object[])a, (Object[])b);
        }
        if (a instanceof int[]) {
            return Arrays.equals((int[])a, (int[])b);
        }
        if (a instanceof float[]) {
            return Arrays.equals((float[])a, (float[])b);
        }
        if (a instanceof long[]) {
            return Arrays.equals((long[])a, (long[])b);
        }
        if (a instanceof double[]) {
            return Arrays.equals((double[])a, (double[])b);
        }
        if (a instanceof byte[]) {
            return Arrays.equals((byte[])a, (byte[])b);
        }
        if (a instanceof char[]) {
            return Arrays.equals((char[])a, (char[])b);
        }
        if (a instanceof boolean[]) {
            return Arrays.equals((boolean[])a, (boolean[])b);
        }
        if (a instanceof short[]) {
            return Arrays.equals((short[])a, (short[])b);
        }
        return a.equals(b);
    }

    static int compare(boolean[] a, boolean[] b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return 1;
        }
        if (b == null) {
            return -1;
        }
        int i = 0;
        int length = Math.min(a.length, b.length);
        if (i < length) {
            boolean bv;
            boolean av = !a[i];
            boolean bl = bv = !b[i];
            return av < bv ? -1 : (av > bv ? 1 : 0);
        }
        return a.length < b.length ? -1 : (a.length > b.length ? 1 : 0);
    }

    static int compare(byte[] a, byte[] b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return 1;
        }
        if (b == null) {
            return -1;
        }
        int i = 0;
        int length = Math.min(a.length, b.length);
        if (i < length) {
            byte av = a[i];
            byte bv = b[i];
            return av < bv ? -1 : (av > bv ? 1 : 0);
        }
        return a.length < b.length ? -1 : (a.length > b.length ? 1 : 0);
    }

    static int compare(char[] a, char[] b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return 1;
        }
        if (b == null) {
            return -1;
        }
        int i = 0;
        int length = Math.min(a.length, b.length);
        if (i < length) {
            char av = a[i];
            char bv = b[i];
            return av < bv ? -1 : (av > bv ? 1 : 0);
        }
        return a.length < b.length ? -1 : (a.length > b.length ? 1 : 0);
    }

    static int compare(double[] a, double[] b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return 1;
        }
        if (b == null) {
            return -1;
        }
        int length = Math.min(a.length, b.length);
        int i = 0;
        while (i < length) {
            int v = Double.compare(a[i], b[i]);
            if (v != 0) {
                return v;
            }
            ++i;
        }
        return a.length < b.length ? -1 : (a.length > b.length ? 1 : 0);
    }

    static int compare(float[] a, float[] b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return 1;
        }
        if (b == null) {
            return -1;
        }
        int length = Math.min(a.length, b.length);
        int i = 0;
        while (i < length) {
            int v = Float.compare(a[i], b[i]);
            if (v != 0) {
                return v;
            }
            ++i;
        }
        return a.length < b.length ? -1 : (a.length > b.length ? 1 : 0);
    }

    static int compare(int[] a, int[] b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return 1;
        }
        if (b == null) {
            return -1;
        }
        int i = 0;
        int length = Math.min(a.length, b.length);
        if (i < length) {
            int av = a[i];
            int bv = b[i];
            return av < bv ? -1 : (av > bv ? 1 : 0);
        }
        return a.length < b.length ? -1 : (a.length > b.length ? 1 : 0);
    }

    static int compare(long[] a, long[] b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return 1;
        }
        if (b == null) {
            return -1;
        }
        int i = 0;
        int length = Math.min(a.length, b.length);
        if (i < length) {
            long av = a[i];
            long bv = b[i];
            return av < bv ? -1 : (av > bv ? 1 : 0);
        }
        return a.length < b.length ? -1 : (a.length > b.length ? 1 : 0);
    }

    static int compare(short[] a, short[] b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return 1;
        }
        if (b == null) {
            return -1;
        }
        int i = 0;
        int length = Math.min(a.length, b.length);
        if (i < length) {
            short av = a[i];
            short bv = b[i];
            return av < bv ? -1 : (av > bv ? 1 : 0);
        }
        return a.length < b.length ? -1 : (a.length > b.length ? 1 : 0);
    }

    static int compare(Object[] a, Object[] b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return 1;
        }
        if (b == null) {
            return -1;
        }
        int length = Math.min(a.length, b.length);
        int i = 0;
        while (i < length) {
            int v = KeyFactory.compare(a[i], b[i]);
            if (v != 0) {
                return v;
            }
            ++i;
        }
        return a.length < b.length ? -1 : (a.length > b.length ? 1 : 0);
    }

    static int compare(Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return 1;
        }
        if (b == null) {
            return -1;
        }
        Class<?> ac = a.getClass();
        if (!ac.isArray()) {
            return ((Comparable)a).compareTo(b);
        }
        if (ac != b.getClass()) {
            throw new ClassCastException();
        }
        if (a instanceof Object[]) {
            return KeyFactory.compare((Object[])a, (Object[])b);
        }
        if (a instanceof int[]) {
            return KeyFactory.compare((int[])a, (int[])b);
        }
        if (a instanceof float[]) {
            return KeyFactory.compare((float[])a, (float[])b);
        }
        if (a instanceof long[]) {
            return KeyFactory.compare((long[])a, (long[])b);
        }
        if (a instanceof double[]) {
            return KeyFactory.compare((double[])a, (double[])b);
        }
        if (a instanceof byte[]) {
            return KeyFactory.compare((byte[])a, (byte[])b);
        }
        if (a instanceof char[]) {
            return KeyFactory.compare((char[])a, (char[])b);
        }
        if (a instanceof boolean[]) {
            return KeyFactory.compare((boolean[])a, (boolean[])b);
        }
        if (a instanceof short[]) {
            return KeyFactory.compare((short[])a, (short[])b);
        }
        throw new ClassCastException();
    }

    protected KeyFactory() {
    }

    private static interface ArrayKey
    extends Comparable,
    Serializable {
        public int hashCode();

        public boolean equals(Object var1);

        public int compareTo(Object var1);
    }

    private static class BooleanArrayKey
    implements ArrayKey {
        protected final boolean[] mArray;
        private transient int mHash;

        BooleanArrayKey(boolean[] array) {
            this.mArray = array;
        }

        @Override
        public int hashCode() {
            int hash = this.mHash;
            return hash == 0 ? (this.mHash = KeyFactory.hashCode(this.mArray)) : hash;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj ? true : (obj instanceof BooleanArrayKey ? Arrays.equals(this.mArray, ((BooleanArrayKey)obj).mArray) : false);
        }

        @Override
        public int compareTo(Object obj) {
            return KeyFactory.compare(this.mArray, ((BooleanArrayKey)obj).mArray);
        }
    }

    private static class ByteArrayKey
    implements ArrayKey {
        protected final byte[] mArray;
        private transient int mHash;

        ByteArrayKey(byte[] array) {
            this.mArray = array;
        }

        @Override
        public int hashCode() {
            int hash = this.mHash;
            return hash == 0 ? (this.mHash = KeyFactory.hashCode(this.mArray)) : hash;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj ? true : (obj instanceof ByteArrayKey ? Arrays.equals(this.mArray, ((ByteArrayKey)obj).mArray) : false);
        }

        @Override
        public int compareTo(Object obj) {
            return KeyFactory.compare(this.mArray, ((ByteArrayKey)obj).mArray);
        }
    }

    private static class CharArrayKey
    implements ArrayKey {
        protected final char[] mArray;
        private transient int mHash;

        CharArrayKey(char[] array) {
            this.mArray = array;
        }

        @Override
        public int hashCode() {
            int hash = this.mHash;
            return hash == 0 ? (this.mHash = KeyFactory.hashCode(this.mArray)) : hash;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj ? true : (obj instanceof CharArrayKey ? Arrays.equals(this.mArray, ((CharArrayKey)obj).mArray) : false);
        }

        @Override
        public int compareTo(Object obj) {
            return KeyFactory.compare(this.mArray, ((CharArrayKey)obj).mArray);
        }
    }

    private static class DoubleArrayKey
    implements ArrayKey {
        protected final double[] mArray;
        private transient int mHash;

        DoubleArrayKey(double[] array) {
            this.mArray = array;
        }

        @Override
        public int hashCode() {
            int hash = this.mHash;
            return hash == 0 ? (this.mHash = KeyFactory.hashCode(this.mArray)) : hash;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj ? true : (obj instanceof DoubleArrayKey ? Arrays.equals(this.mArray, ((DoubleArrayKey)obj).mArray) : false);
        }

        @Override
        public int compareTo(Object obj) {
            return KeyFactory.compare(this.mArray, ((DoubleArrayKey)obj).mArray);
        }
    }

    private static class FloatArrayKey
    implements ArrayKey {
        protected final float[] mArray;
        private transient int mHash;

        FloatArrayKey(float[] array) {
            this.mArray = array;
        }

        @Override
        public int hashCode() {
            int hash = this.mHash;
            return hash == 0 ? (this.mHash = KeyFactory.hashCode(this.mArray)) : hash;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj ? true : (obj instanceof FloatArrayKey ? Arrays.equals(this.mArray, ((FloatArrayKey)obj).mArray) : false);
        }

        @Override
        public int compareTo(Object obj) {
            return KeyFactory.compare(this.mArray, ((FloatArrayKey)obj).mArray);
        }
    }

    private static class IntArrayKey
    implements ArrayKey {
        protected final int[] mArray;
        private transient int mHash;

        IntArrayKey(int[] array) {
            this.mArray = array;
        }

        @Override
        public int hashCode() {
            int hash = this.mHash;
            return hash == 0 ? (this.mHash = KeyFactory.hashCode(this.mArray)) : hash;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj ? true : (obj instanceof IntArrayKey ? Arrays.equals(this.mArray, ((IntArrayKey)obj).mArray) : false);
        }

        @Override
        public int compareTo(Object obj) {
            return KeyFactory.compare(this.mArray, ((IntArrayKey)obj).mArray);
        }
    }

    private static class LongArrayKey
    implements ArrayKey {
        protected final long[] mArray;
        private transient int mHash;

        LongArrayKey(long[] array) {
            this.mArray = array;
        }

        @Override
        public int hashCode() {
            int hash = this.mHash;
            return hash == 0 ? (this.mHash = KeyFactory.hashCode(this.mArray)) : hash;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj ? true : (obj instanceof LongArrayKey ? Arrays.equals(this.mArray, ((LongArrayKey)obj).mArray) : false);
        }

        @Override
        public int compareTo(Object obj) {
            return KeyFactory.compare(this.mArray, ((LongArrayKey)obj).mArray);
        }
    }

    private static class ObjectArrayKey
    implements ArrayKey {
        protected final Object[] mArray;
        private transient int mHash;

        ObjectArrayKey(Object[] array) {
            this.mArray = array;
        }

        @Override
        public int hashCode() {
            int hash = this.mHash;
            return hash == 0 ? (this.mHash = KeyFactory.hashCode(this.mArray)) : hash;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj ? true : (obj instanceof ObjectArrayKey ? KeyFactory.equals(this.mArray, ((ObjectArrayKey)obj).mArray) : false);
        }

        @Override
        public int compareTo(Object obj) {
            return KeyFactory.compare(this.mArray, ((ObjectArrayKey)obj).mArray);
        }
    }

    private static class ShortArrayKey
    implements ArrayKey {
        protected final short[] mArray;
        private transient int mHash;

        ShortArrayKey(short[] array) {
            this.mArray = array;
        }

        @Override
        public int hashCode() {
            int hash = this.mHash;
            return hash == 0 ? (this.mHash = KeyFactory.hashCode(this.mArray)) : hash;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj ? true : (obj instanceof ShortArrayKey ? Arrays.equals(this.mArray, ((ShortArrayKey)obj).mArray) : false);
        }

        @Override
        public int compareTo(Object obj) {
            return KeyFactory.compare(this.mArray, ((ShortArrayKey)obj).mArray);
        }
    }
}

