/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IntHashMap<V>
extends AbstractMap<Integer, V>
implements Map<Integer, V>,
Cloneable,
Serializable {
    private transient Entry<V>[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount = 0;
    private transient Set keySet = null;
    private transient Set entrySet = null;
    private transient Collection values = null;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;

    public IntHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public IntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashMap() {
        this(101, 0.75f);
    }

    public IntHashMap(Map<? extends Integer, ? extends V> t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean containsValue(Object value) {
        Entry<V>[] tab = this.table;
        if (value == null) {
            int i = tab.length;
            while (i-- > 0) {
                Entry<V> e = tab[i];
                while (e != null) {
                    if (e.value == null) {
                        return true;
                    }
                    e = e.next;
                }
            }
        } else {
            int i = tab.length;
            while (i-- > 0) {
                Entry<V> e = tab[i];
                while (e != null) {
                    if (value.equals(e.value)) {
                        return true;
                    }
                    e = e.next;
                }
            }
        }
        return false;
    }

    public boolean containsKey(Integer key) {
        return this.containsKey((int)key);
    }

    public boolean containsKey(int key) {
        Entry<V>[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        Entry<V> e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public V get(Integer key) {
        return this.get((int)key);
    }

    public V get(int key) {
        Entry<V>[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        Entry<V> e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry<V>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        ++this.modCount;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry<V> old = oldMap[i];
            while (old != null) {
                Entry<V> e = old;
                old = old.next;
                int index = (e.key & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    @Override
    public V put(Integer key, V value) {
        return this.put((int)key, value);
    }

    @Override
    public V put(int key, V value) {
        Entry<V>[] tab = this.table;
        int index = 0;
        index = (key & Integer.MAX_VALUE) % tab.length;
        Entry<V> e = tab[index];
        while (e != null) {
            if (e.key == key) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (key & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new Entry<V>(key, value, tab[index]);
        ++this.count;
        return null;
    }

    public V remove(Integer key) {
        return this.remove((int)key);
    }

    public V remove(int key) {
        Entry<V>[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        Entry<V> e = tab[index];
        Entry<V> prev = null;
        while (e != null) {
            if (e.key == key) {
                ++this.modCount;
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    @Override
    public void clear() {
        Entry<V>[] tab = this.table;
        ++this.modCount;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    @Override
    public Object clone() {
        try {
            IntHashMap t = (IntHashMap)super.clone();
            t.table = new Entry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                Entry<V> entry = t.table[i] = this.table[i] != null ? (Entry<V>)this.table[i].clone() : null;
            }
            t.keySet = null;
            t.entrySet = null;
            t.values = null;
            t.modCount = 0;
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Set<Integer> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<Integer>(){

                @Override
                public Iterator iterator() {
                    return new IntHashIterator(0);
                }

                @Override
                public int size() {
                    return IntHashMap.this.count;
                }

                @Override
                public boolean contains(Object o) {
                    return IntHashMap.this.containsKey(o);
                }

                @Override
                public boolean remove(Object o) {
                    return IntHashMap.this.remove(o) != null;
                }

                @Override
                public void clear() {
                    IntHashMap.this.clear();
                }
            };
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public Iterator iterator() {
                    return new IntHashIterator(1);
                }

                @Override
                public int size() {
                    return IntHashMap.this.count;
                }

                @Override
                public boolean contains(Object o) {
                    return IntHashMap.this.containsValue(o);
                }

                @Override
                public void clear() {
                    IntHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Integer, V>>(){

                @Override
                public Iterator iterator() {
                    return new IntHashIterator(2);
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Integer key = (Integer)entry.getKey();
                    Entry[] tab = IntHashMap.this.table;
                    int hash = key == null ? 0 : key.hashCode();
                    int index = (hash & Integer.MAX_VALUE) % tab.length;
                    Entry e = tab[index];
                    while (e != null) {
                        if (e.key == hash && e.equals(entry)) {
                            return true;
                        }
                        e = e.next;
                    }
                    return false;
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Integer key = (Integer)entry.getKey();
                    Entry[] tab = IntHashMap.this.table;
                    int hash = key == null ? 0 : key.hashCode();
                    int index = (hash & Integer.MAX_VALUE) % tab.length;
                    Entry e = tab[index];
                    Entry prev = null;
                    while (e != null) {
                        if (e.key == hash && e.equals(entry)) {
                            IntHashMap intHashMap = IntHashMap.this;
                            intHashMap.modCount = intHashMap.modCount + 1;
                            if (prev != null) {
                                prev.next = e.next;
                            } else {
                                tab[index] = e.next;
                            }
                            IntHashMap intHashMap2 = IntHashMap.this;
                            intHashMap2.count = intHashMap2.count - 1;
                            e.value = null;
                            return true;
                        }
                        prev = e;
                        e = e.next;
                    }
                    return false;
                }

                @Override
                public int size() {
                    return IntHashMap.this.count;
                }

                @Override
                public void clear() {
                    IntHashMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.count);
        int index = this.table.length - 1;
        while (index >= 0) {
            Entry<V> entry = this.table[index];
            while (entry != null) {
                s.writeInt(entry.key);
                s.writeObject(entry.value);
                entry = entry.next;
            }
            --index;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = new Entry[numBuckets];
        int size = s.readInt();
        int i = 0;
        while (i < size) {
            int key = s.readInt();
            Object value = s.readObject();
            this.put(key, (V)value);
            ++i;
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    private static class Entry<V>
    implements Map.Entry<Integer, V> {
        int key;
        V value;
        Entry<V> next;
        private Integer objectKey;

        Entry(int key, V value, Entry<V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new Entry<V>(this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        @Override
        public Integer getKey() {
            return this.objectKey != null ? this.objectKey : (this.objectKey = Integer.valueOf(this.key));
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.getKey().equals(e.getKey()) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            return this.key ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return String.valueOf(String.valueOf(this.key)) + "=" + this.value;
        }
    }

    private class IntHashIterator
    implements Iterator {
        Entry[] table;
        int index;
        Entry entry;
        Entry lastReturned;
        int type;
        private int expectedModCount;

        IntHashIterator(int type) {
            this.table = IntHashMap.this.table;
            this.index = this.table.length;
            this.expectedModCount = IntHashMap.this.modCount;
            this.type = type;
        }

        @Override
        public boolean hasNext() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            return this.entry != null;
        }

        /*
         * Unable to fully structure code
         */
        public Object next() {
            if (IntHashMap.access$2(IntHashMap.this) == this.expectedModCount) ** GOTO lbl4
            throw new ConcurrentModificationException();
lbl-1000:
            // 1 sources

            {
                this.entry = this.table[--this.index];
lbl4:
                // 2 sources

                ** while (this.entry == null && this.index > 0)
            }
lbl5:
            // 1 sources

            if (this.entry != null) {
                e = this.lastReturned = this.entry;
                this.entry = e.next;
                return this.type == 0 ? e.getKey() : (this.type == 1 ? e.value : e);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (IntHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry[] tab = IntHashMap.this.table;
            int index = (this.lastReturned.key & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                if (e == this.lastReturned) {
                    IntHashMap intHashMap = IntHashMap.this;
                    intHashMap.modCount = intHashMap.modCount + 1;
                    ++this.expectedModCount;
                    if (prev == null) {
                        tab[index] = e.next;
                    } else {
                        prev.next = e.next;
                    }
                    IntHashMap intHashMap2 = IntHashMap.this;
                    intHashMap2.count = intHashMap2.count - 1;
                    this.lastReturned = null;
                    return;
                }
                prev = e;
                e = e.next;
            }
            throw new ConcurrentModificationException();
        }
    }
}

