/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.cojen.classfile.ClassFile;
import org.cojen.util.WeakIdentityMap;

@Deprecated
public class ClassInjector {
    private static final boolean DEBUG = Boolean.getBoolean("org.cojen.classfile.RuntimeClassFile.DEBUG") || Boolean.getBoolean("org.cojen.util.ClassInjector.DEBUG") || Boolean.getBoolean("cojen.util.ClassInjector.DEBUG");
    private static final Random cRandom = new Random();
    private static Map cLoaders = new WeakIdentityMap();
    private final String mName;
    private final Loader mLoader;
    private ByteArrayOutputStream mData;
    private Class mClass;

    public static ClassInjector create() {
        return ClassInjector.create(null, null);
    }

    public static ClassInjector create(String prefix, ClassLoader parent) {
        return ClassInjector.create(prefix, parent, false);
    }

    public static ClassInjector createExplicit(String name, ClassLoader parent) {
        if (name == null) {
            throw new IllegalArgumentException("Explicit class name not provided");
        }
        return ClassInjector.create(name, parent, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassInjector create(String prefix, ClassLoader parent, boolean explicit) {
        Loader loader;
        if (prefix == null) {
            prefix = ClassInjector.class.getName();
        }
        if (parent == null && (parent = ClassInjector.class.getClassLoader()) == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        String name = explicit ? prefix : null;
        Random random = cRandom;
        synchronized (random) {
            block26: {
                block28: {
                    block29: {
                        block27: {
                            if (!(parent instanceof Loader)) break block27;
                            loader = (Loader)parent;
                            break block28;
                        }
                        SoftReference ref = (SoftReference)cLoaders.get(parent);
                        if (ref == null) break block29;
                        loader = (Loader)ref.get();
                        if (loader != null && loader.isValid()) break block28;
                        ref.clear();
                    }
                    loader = parent == null ? new Loader() : new Loader(parent);
                    cLoaders.put(parent, new SoftReference<Loader>(loader));
                }
                if (explicit) {
                    int i = 0;
                    while (i < 2) {
                        if (loader.reserveName(name)) {
                            try {
                                loader.loadClass(name);
                            }
                            catch (ClassNotFoundException e) {
                                break block26;
                            }
                        }
                        if (i > 0) {
                            throw new IllegalStateException("Class name already reserved: " + name);
                        }
                        loader = parent == null ? new Loader() : new Loader(parent);
                        ++i;
                    }
                    cLoaders.put(parent, new SoftReference<Loader>(loader));
                } else {
                    int tryCount = 0;
                    while (tryCount < 1000) {
                        name = null;
                        long ID = cRandom.nextInt();
                        switch (tryCount) {
                            case 0: {
                                ID &= 0xFFL;
                                break;
                            }
                            case 1: {
                                ID &= 0xFFFFL;
                                break;
                            }
                            default: {
                                ID &= 0xFFFFFFFFL;
                            }
                        }
                        name = String.valueOf(prefix) + '$' + ID;
                        if (loader.reserveName(name)) {
                            try {
                                loader.loadClass(name);
                            }
                            catch (ClassNotFoundException e) {
                                break;
                            }
                            catch (LinkageError linkageError) {
                                // empty catch block
                            }
                        }
                        ++tryCount;
                    }
                }
            }
        }
        if (name == null) {
            throw new InternalError("Unable to create unique class name");
        }
        return new ClassInjector(name, loader);
    }

    private ClassInjector(String name, Loader loader) {
        this.mName = name;
        this.mLoader = loader;
    }

    public String getClassName() {
        return this.mName;
    }

    public OutputStream openStream() throws IllegalStateException {
        if (this.mClass != null) {
            throw new IllegalStateException("New class has already been defined");
        }
        ByteArrayOutputStream data = this.mData;
        if (data != null) {
            throw new IllegalStateException("Stream already opened");
        }
        this.mData = data = new ByteArrayOutputStream();
        return data;
    }

    public Class defineClass(ClassFile cf) {
        try {
            cf.writeTo(this.openStream());
        }
        catch (IOException e) {
            throw new InternalError(e.toString());
        }
        return this.getNewClass();
    }

    public Class getNewClass() throws IllegalStateException, ClassFormatError {
        if (this.mClass != null) {
            return this.mClass;
        }
        ByteArrayOutputStream data = this.mData;
        if (data == null) {
            throw new IllegalStateException("Class not defined yet");
        }
        byte[] bytes = data.toByteArray();
        if (DEBUG) {
            File file = new File(String.valueOf(this.mName.replace('.', '/')) + ".class");
            try {
                File tempDir = new File(System.getProperty("java.io.tmpdir"));
                file = new File(tempDir, file.getPath());
            }
            catch (SecurityException tempDir) {
                // empty catch block
            }
            try {
                file.getParentFile().mkdirs();
                System.out.println("ClassInjector writing to " + file);
                FileOutputStream out = new FileOutputStream(file);
                ((OutputStream)out).write(bytes);
                ((OutputStream)out).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mClass = this.mLoader.define(this.mName, bytes);
        this.mData = null;
        return this.mClass;
    }

    private static final class Loader
    extends ClassLoader {
        private Set mReservedNames = new HashSet();

        Loader(ClassLoader parent) {
            super(parent);
        }

        Loader() {
        }

        synchronized boolean reserveName(String name) {
            return this.mReservedNames.add(name);
        }

        synchronized boolean isValid() {
            return this.mReservedNames.size() < 100;
        }

        Class define(String name, byte[] b) {
            Class<?> clazz = this.defineClass(name, b, 0, b.length);
            this.resolveClass(clazz);
            return clazz;
        }
    }
}

