/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.RuntimeClassFile;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.BeanIntrospector;
import org.cojen.util.BeanProperty;
import org.cojen.util.NoSuchPropertyException;
import org.cojen.util.WeakIdentityMap;

public abstract class BeanPropertyAccessor<B> {
    private static final int READ_METHOD = 1;
    private static final int WRITE_METHOD = 2;
    private static final int TRY_READ_METHOD = 3;
    private static final int TRY_WRITE_METHOD = 4;
    private static final int HAS_READ_METHOD = 5;
    private static final int HAS_WRITE_METHOD = 6;
    private static final Map<PropertySet, Map<Class, SoftReference<BeanPropertyAccessor>>> cAccessors = new HashMap<PropertySet, Map<Class, SoftReference<BeanPropertyAccessor>>>();

    public static <B> BeanPropertyAccessor<B> forClass(Class<B> clazz) {
        return BeanPropertyAccessor.forClass(clazz, PropertySet.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <B> BeanPropertyAccessor<B> forClass(Class<B> clazz, PropertySet set) {
        Map<PropertySet, Map<Class, SoftReference<BeanPropertyAccessor>>> map = cAccessors;
        synchronized (map) {
            BeanPropertyAccessor<B> bpa;
            SoftReference<BeanPropertyAccessor> ref;
            Map<Class, SoftReference<BeanPropertyAccessor>> accessors = cAccessors.get((Object)set);
            if (accessors == null) {
                accessors = new WeakIdentityMap<Class, SoftReference<BeanPropertyAccessor>>();
                cAccessors.put(set, accessors);
            }
            if ((ref = accessors.get(clazz)) != null && (bpa = ref.get()) != null) {
                return bpa;
            }
            bpa = BeanPropertyAccessor.generate(clazz, set);
            accessors.put(clazz, new SoftReference<BeanPropertyAccessor<B>>(bpa));
            return bpa;
        }
    }

    private static <B> BeanPropertyAccessor<B> generate(final Class<B> beanType, final PropertySet set) {
        return (BeanPropertyAccessor)AccessController.doPrivileged(new PrivilegedAction<BeanPropertyAccessor<B>>(){

            @Override
            public BeanPropertyAccessor<B> run() {
                Class clazz = BeanPropertyAccessor.generateClassFile(beanType, set).defineClass();
                try {
                    return (BeanPropertyAccessor)clazz.newInstance();
                }
                catch (InstantiationException e) {
                    throw new InternalError(e.toString());
                }
                catch (IllegalAccessException e) {
                    throw new InternalError(e.toString());
                }
            }
        });
    }

    private static RuntimeClassFile generateClassFile(Class beanType, PropertySet set) {
        BeanProperty[][] props = BeanPropertyAccessor.getBeanProperties(beanType, set);
        RuntimeClassFile cf = new RuntimeClassFile(BeanPropertyAccessor.class.getName(), BeanPropertyAccessor.class.getName(), beanType.getClassLoader());
        cf.markSynthetic();
        cf.setSourceFile(BeanPropertyAccessor.class.getName());
        try {
            cf.setTarget(System.getProperty("java.specification.version"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        MethodInfo ctor = cf.addConstructor(Modifiers.PUBLIC, null);
        ctor.markSynthetic();
        CodeBuilder b = new CodeBuilder(ctor);
        b.loadThis();
        b.invokeSuperConstructor(null);
        b.returnVoid();
        BeanPropertyAccessor.generateAccessMethod(cf, beanType, props[0], 1);
        BeanPropertyAccessor.generateAccessMethod(cf, beanType, props[0], 3);
        BeanPropertyAccessor.generateAccessMethod(cf, beanType, props[0], 5);
        BeanPropertyAccessor.generateAccessMethod(cf, beanType, props[1], 2);
        BeanPropertyAccessor.generateAccessMethod(cf, beanType, props[1], 4);
        BeanPropertyAccessor.generateAccessMethod(cf, beanType, props[1], 6);
        BeanPropertyAccessor.generateSearchMethod(cf, beanType, props[0]);
        return cf;
    }

    private static void generateAccessMethod(ClassFile cf, Class beanType, BeanProperty[] properties, int methodType) {
        LocalVariable valueVar;
        LocalVariable propertyVar;
        LocalVariable beanVar;
        MethodInfo mi;
        switch (methodType) {
            default: {
                TypeDesc[] params = new TypeDesc[]{TypeDesc.OBJECT, TypeDesc.STRING};
                mi = cf.addMethod(Modifiers.PUBLIC, "getPropertyValue", TypeDesc.OBJECT, params);
                break;
            }
            case 2: {
                TypeDesc[] params = new TypeDesc[]{TypeDesc.OBJECT, TypeDesc.STRING, TypeDesc.OBJECT};
                mi = cf.addMethod(Modifiers.PUBLIC, "setPropertyValue", null, params);
                break;
            }
            case 3: {
                TypeDesc[] params = new TypeDesc[]{TypeDesc.OBJECT, TypeDesc.STRING};
                mi = cf.addMethod(Modifiers.PUBLIC, "tryGetPropertyValue", TypeDesc.OBJECT, params);
                break;
            }
            case 4: {
                TypeDesc[] params = new TypeDesc[]{TypeDesc.OBJECT, TypeDesc.STRING, TypeDesc.OBJECT};
                mi = cf.addMethod(Modifiers.PUBLIC, "trySetPropertyValue", TypeDesc.BOOLEAN, params);
                break;
            }
            case 5: {
                TypeDesc[] params = new TypeDesc[]{TypeDesc.STRING};
                mi = cf.addMethod(Modifiers.PUBLIC, "hasReadableProperty", TypeDesc.BOOLEAN, params);
                break;
            }
            case 6: {
                TypeDesc[] params = new TypeDesc[]{TypeDesc.STRING};
                mi = cf.addMethod(Modifiers.PUBLIC, "hasWritableProperty", TypeDesc.BOOLEAN, params);
            }
        }
        mi.markSynthetic();
        CodeBuilder b = new CodeBuilder(mi);
        switch (methodType) {
            default: {
                beanVar = b.getParameter(0);
                propertyVar = b.getParameter(1);
                valueVar = null;
                break;
            }
            case 2: 
            case 4: {
                beanVar = b.getParameter(0);
                propertyVar = b.getParameter(1);
                valueVar = b.getParameter(2);
                break;
            }
            case 5: 
            case 6: {
                beanVar = null;
                propertyVar = b.getParameter(0);
                valueVar = null;
            }
        }
        if (beanVar != null) {
            b.loadLocal(beanVar);
            b.checkCast(TypeDesc.forClass(beanType));
            b.storeLocal(beanVar);
        }
        if (properties.length > 0) {
            int[] cases = new int[BeanPropertyAccessor.hashCapacity(properties.length)];
            int caseCount = cases.length;
            int i = 0;
            while (i < caseCount) {
                cases[i] = i;
                ++i;
            }
            Location[] switchLabels = new Label[caseCount];
            Label noMatch = b.createLabel();
            List[] caseMethods = BeanPropertyAccessor.caseMethods(caseCount, properties);
            int i2 = 0;
            while (i2 < caseCount) {
                List matches = caseMethods[i2];
                switchLabels[i2] = matches == null || matches.size() == 0 ? noMatch : b.createLabel();
                ++i2;
            }
            if (properties.length > 1) {
                b.loadLocal(propertyVar);
                b.invokeVirtual(String.class.getName(), "hashCode", TypeDesc.INT, null);
                b.loadConstant(Integer.MAX_VALUE);
                b.math((byte)126);
                b.loadConstant(caseCount);
                b.math((byte)112);
                b.switchBranch(cases, switchLabels, noMatch);
            }
            TypeDesc[] params = new TypeDesc[]{TypeDesc.OBJECT};
            int i3 = 0;
            while (i3 < caseCount) {
                List matches = caseMethods[i3];
                if (matches != null && matches.size() != 0) {
                    switchLabels[i3].setLocation();
                    int matchCount = matches.size();
                    int j = 0;
                    while (j < matchCount) {
                        Label notEqual;
                        BeanProperty bp = (BeanProperty)matches.get(j);
                        b.loadConstant(bp.getName());
                        b.loadLocal(propertyVar);
                        b.invokeVirtual(String.class.getName(), "equals", TypeDesc.BOOLEAN, params);
                        if (j == matchCount - 1) {
                            notEqual = null;
                            b.ifZeroComparisonBranch(noMatch, "==");
                        } else {
                            notEqual = b.createLabel();
                            b.ifZeroComparisonBranch(notEqual, "==");
                        }
                        switch (methodType) {
                            default: {
                                b.loadLocal(beanVar);
                                b.invoke(bp.getReadMethod());
                                TypeDesc type = TypeDesc.forClass(bp.getType());
                                b.convert(type, type.toObjectType());
                                b.returnValue(TypeDesc.OBJECT);
                                break;
                            }
                            case 2: 
                            case 4: {
                                b.loadLocal(beanVar);
                                b.loadLocal(valueVar);
                                TypeDesc type = TypeDesc.forClass(bp.getType());
                                b.checkCast(type.toObjectType());
                                b.convert(type.toObjectType(), type);
                                b.invoke(bp.getWriteMethod());
                                if (methodType == 2) {
                                    b.returnVoid();
                                    break;
                                }
                                b.loadConstant(true);
                                b.returnValue(TypeDesc.BOOLEAN);
                                break;
                            }
                            case 5: 
                            case 6: {
                                b.loadConstant(true);
                                b.returnValue(TypeDesc.BOOLEAN);
                            }
                        }
                        if (notEqual != null) {
                            notEqual.setLocation();
                        }
                        ++j;
                    }
                }
                ++i3;
            }
            noMatch.setLocation();
        }
        if (methodType == 5 || methodType == 6 || methodType == 4) {
            b.loadConstant(false);
            b.returnValue(TypeDesc.BOOLEAN);
        } else if (methodType == 3) {
            b.loadNull();
            b.returnValue(TypeDesc.OBJECT);
        } else {
            b.newObject(TypeDesc.forClass(NoSuchPropertyException.class));
            b.dup();
            b.loadLocal(propertyVar);
            b.loadConstant(methodType == 1);
            TypeDesc[] params = new TypeDesc[]{TypeDesc.STRING, TypeDesc.BOOLEAN};
            b.invokeConstructor(NoSuchPropertyException.class.getName(), params);
            b.throwObject();
        }
    }

    private static int hashCapacity(int min) {
        BigInteger capacity = BigInteger.valueOf(min * 2 + 1);
        while (!capacity.isProbablePrime(10)) {
            capacity = capacity.add(BigInteger.valueOf(2L));
        }
        return capacity.intValue();
    }

    private static List[] caseMethods(int caseCount, BeanProperty[] props) {
        List[] cases = new List[caseCount];
        int i = 0;
        while (i < props.length) {
            BeanProperty prop = props[i];
            int hashCode = prop.getName().hashCode();
            int caseValue = (hashCode & Integer.MAX_VALUE) % caseCount;
            ArrayList<BeanProperty> matches = cases[caseValue];
            if (matches == null) {
                matches = cases[caseValue] = new ArrayList<BeanProperty>();
            }
            matches.add(prop);
            ++i;
        }
        return cases;
    }

    private static void generateSearchMethod(ClassFile cf, Class beanType, BeanProperty[] properties) {
        TypeDesc[] params = new TypeDesc[]{TypeDesc.OBJECT, TypeDesc.OBJECT};
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC, "hasPropertyValue", TypeDesc.BOOLEAN, params);
        mi.markSynthetic();
        CodeBuilder b = new CodeBuilder(mi);
        LocalVariable beanVar = b.getParameter(0);
        b.loadLocal(beanVar);
        b.checkCast(TypeDesc.forClass(beanType));
        b.storeLocal(beanVar);
        LocalVariable valueVar = b.getParameter(1);
        b.loadLocal(valueVar);
        Label searchNotNull = b.createLabel();
        b.ifNullBranch(searchNotNull, false);
        BeanProperty[] beanPropertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            BeanProperty bp = beanPropertyArray[n2];
            if (!bp.getType().isPrimitive()) {
                b.loadLocal(beanVar);
                b.invoke(bp.getReadMethod());
                Label noMatch = b.createLabel();
                b.ifNullBranch(noMatch, false);
                b.loadConstant(true);
                b.returnValue(TypeDesc.BOOLEAN);
                noMatch.setLocation();
            }
            ++n2;
        }
        b.loadConstant(false);
        b.returnValue(TypeDesc.BOOLEAN);
        searchNotNull.setLocation();
        TypeDesc[] params2 = new TypeDesc[]{TypeDesc.OBJECT};
        int pass = 1;
        while (pass <= 2) {
            BeanProperty[] beanPropertyArray2 = properties;
            int n3 = properties.length;
            int n4 = 0;
            while (n4 < n3) {
                BeanProperty bp = beanPropertyArray2[n4];
                boolean primitive = bp.getType().isPrimitive();
                if (!(pass == 1 && primitive || pass == 2 && !primitive)) {
                    b.loadLocal(valueVar);
                    b.loadLocal(beanVar);
                    b.invoke(bp.getReadMethod());
                    b.convert(TypeDesc.forClass(bp.getType()), TypeDesc.OBJECT);
                    b.invokeVirtual(Object.class.getName(), "equals", TypeDesc.BOOLEAN, params2);
                    Label noMatch = b.createLabel();
                    b.ifZeroComparisonBranch(noMatch, "==");
                    b.loadConstant(true);
                    b.returnValue(TypeDesc.BOOLEAN);
                    noMatch.setLocation();
                }
                ++n4;
            }
            ++pass;
        }
        b.loadConstant(false);
        b.returnValue(TypeDesc.BOOLEAN);
    }

    private static BeanProperty[][] getBeanProperties(Class beanType, PropertySet set) {
        ArrayList<BeanProperty> readProperties = new ArrayList<BeanProperty>();
        ArrayList<BeanProperty> writeProperties = new ArrayList<BeanProperty>();
        Map<String, BeanProperty> map = BeanIntrospector.getAllProperties(beanType);
        for (BeanProperty bp : map.values()) {
            boolean checkedAllowed;
            if ((set == PropertySet.READ_WRITE || set == PropertySet.READ_WRITE_UNCHECKED_EXCEPTIONS) && (bp.getReadMethod() == null || bp.getWriteMethod() == null)) continue;
            boolean bl = checkedAllowed = set != PropertySet.UNCHECKED_EXCEPTIONS && set != PropertySet.READ_WRITE_UNCHECKED_EXCEPTIONS;
            if (bp.getReadMethod() != null && (checkedAllowed || !BeanPropertyAccessor.throwsCheckedException(bp.getReadMethod()))) {
                readProperties.add(bp);
            }
            if (bp.getWriteMethod() == null || !checkedAllowed && BeanPropertyAccessor.throwsCheckedException(bp.getWriteMethod())) continue;
            writeProperties.add(bp);
        }
        BeanProperty[][] props = new BeanProperty[2][];
        props[0] = new BeanProperty[readProperties.size()];
        readProperties.toArray(props[0]);
        props[1] = new BeanProperty[writeProperties.size()];
        writeProperties.toArray(props[1]);
        return props;
    }

    static boolean throwsCheckedException(Method method) {
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        if (exceptionTypes == null) {
            return false;
        }
        Class<?>[] classArray = exceptionTypes;
        int n = exceptionTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> exceptionType = classArray[n2];
            if (!RuntimeException.class.isAssignableFrom(exceptionType) && !Error.class.isAssignableFrom(exceptionType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected BeanPropertyAccessor() {
    }

    public abstract Object getPropertyValue(B var1, String var2) throws NoSuchPropertyException;

    public abstract void setPropertyValue(B var1, String var2, Object var3) throws NoSuchPropertyException;

    public abstract boolean hasReadableProperty(String var1);

    public abstract boolean hasWritableProperty(String var1);

    public abstract boolean hasPropertyValue(B var1, Object var2);

    public abstract Object tryGetPropertyValue(B var1, String var2);

    public abstract boolean trySetPropertyValue(B var1, String var2, Object var3);

    public static enum PropertySet {
        ALL,
        UNCHECKED_EXCEPTIONS,
        READ_WRITE,
        READ_WRITE_UNCHECKED_EXCEPTIONS;

    }
}

