/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.cojen.util.BeanProperty;
import org.cojen.util.WeakIdentityMap;

public class BeanIntrospector {
    private static Map<Class, SoftReference<Map<String, BeanProperty>>> cPropertiesCache = new WeakIdentityMap<Class, SoftReference<Map<String, BeanProperty>>>();

    public static void main(String[] args) throws Exception {
        System.out.println(BeanIntrospector.getAllProperties(Class.forName(args[0])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, BeanProperty> getAllProperties(Class clazz) {
        Map<Class, SoftReference<Map<String, BeanProperty>>> map = cPropertiesCache;
        synchronized (map) {
            Map<String, BeanProperty> properties;
            SoftReference<Map<String, BeanProperty>> ref = cPropertiesCache.get(clazz);
            if (ref != null && (properties = ref.get()) != null) {
                return properties;
            }
            properties = BeanIntrospector.createProperties(clazz);
            cPropertiesCache.put(clazz, new SoftReference<Map<String, BeanProperty>>(properties));
            return properties;
        }
    }

    private static Map<String, BeanProperty> createProperties(Class clazz) {
        if (clazz == null || clazz.isPrimitive()) {
            return Collections.emptyMap();
        }
        HashMap<String, BeanProperty> properties = new HashMap<String, BeanProperty>();
        BeanIntrospector.fillInProperties(clazz, properties);
        if (clazz.isInterface()) {
            BeanIntrospector.fillInProperties(Object.class, properties);
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            BeanIntrospector.fillInProperties(interfaces[i], properties);
            ++i;
        }
        return Collections.unmodifiableMap(properties);
    }

    private static void fillInProperties(Class clazz, Map<String, BeanProperty> properties) {
        IndexedProperty indexedProperty;
        Class<?>[] params;
        SimpleProperty withCovariant;
        SimpleProperty property;
        String name;
        Class<?> type;
        Method method;
        Method[] methods = clazz.getMethods();
        int i = 0;
        while (i < methods.length) {
            block9: {
                block12: {
                    block10: {
                        block11: {
                            method = methods[i];
                            if (Modifier.isStatic(method.getModifiers()) || (type = method.getReturnType()) == Void.TYPE || method.getParameterTypes().length > 0 || (name = BeanIntrospector.extractPropertyName(method, "get")) == null) break block9;
                            if (!properties.containsKey(name)) break block10;
                            property = (SimpleProperty)properties.get(name);
                            withCovariant = property.addCovariantType(type);
                            if (withCovariant != null) break block11;
                            if (property.getReadMethod() == null) break block12;
                            break block9;
                        }
                        property = withCovariant;
                        properties.put(name, property);
                        if (type == property.getType() || property.getReadMethod() == null) break block12;
                        break block9;
                    }
                    property = new SimpleProperty(name, type);
                    properties.put(name, property);
                }
                property.setReadMethod(method);
            }
            ++i;
        }
        i = 0;
        while (i < methods.length) {
            block13: {
                block15: {
                    block14: {
                        method = methods[i];
                        if (Modifier.isStatic(method.getModifiers()) || (type = method.getReturnType()) != Boolean.TYPE || method.getParameterTypes().length > 0 || (name = BeanIntrospector.extractPropertyName(method, "is")) == null) break block13;
                        if (!properties.containsKey(name)) break block14;
                        property = (SimpleProperty)properties.get(name);
                        if (type == property.getType() && property.getReadMethod() == null) break block15;
                        break block13;
                    }
                    property = new SimpleProperty(name, type);
                    properties.put(name, property);
                }
                property.setReadMethod(method);
            }
            ++i;
        }
        i = 0;
        while (i < methods.length) {
            block16: {
                block19: {
                    block17: {
                        block18: {
                            method = methods[i];
                            if (Modifier.isStatic(method.getModifiers()) || method.getReturnType() != Void.TYPE || (params = method.getParameterTypes()).length != 1 || (name = BeanIntrospector.extractPropertyName(method, "set")) == null) break block16;
                            type = params[0];
                            if (!properties.containsKey(name)) break block17;
                            property = (SimpleProperty)properties.get(name);
                            withCovariant = property.addCovariantType(type);
                            if (withCovariant != null) break block18;
                            if (property.getWriteMethod() == null) break block19;
                            break block16;
                        }
                        property = withCovariant;
                        properties.put(name, property);
                        if (type == property.getType() || property.getWriteMethod() == null) break block19;
                        break block16;
                    }
                    property = new SimpleProperty(name, type);
                    properties.put(name, property);
                }
                property.setWriteMethod(method);
            }
            ++i;
        }
        i = 0;
        while (i < methods.length) {
            block20: {
                block22: {
                    block21: {
                        method = methods[i];
                        if (Modifier.isStatic(method.getModifiers()) || (type = method.getReturnType()) == Void.TYPE || (params = method.getParameterTypes()).length != 1 || (name = BeanIntrospector.extractPropertyName(method, "get")) == null) break block20;
                        if (!properties.containsKey(name)) break block21;
                        property = (SimpleProperty)properties.get(name);
                        if (type != property.getType()) break block20;
                        if (property instanceof IndexedProperty) {
                            indexedProperty = (IndexedProperty)property;
                        } else {
                            indexedProperty = new IndexedProperty(property);
                            properties.put(name, indexedProperty);
                        }
                        break block22;
                    }
                    indexedProperty = new IndexedProperty(name, type);
                    properties.put(name, indexedProperty);
                }
                indexedProperty.addIndexedReadMethod(method);
            }
            ++i;
        }
        i = 0;
        while (i < methods.length) {
            block23: {
                block25: {
                    block24: {
                        method = methods[i];
                        if (Modifier.isStatic(method.getModifiers()) || method.getReturnType() != Void.TYPE || (params = method.getParameterTypes()).length != 2 || (name = BeanIntrospector.extractPropertyName(method, "set")) == null) break block23;
                        type = params[1];
                        if (!properties.containsKey(name)) break block24;
                        property = (SimpleProperty)properties.get(name);
                        if (type != property.getType()) break block23;
                        if (property instanceof IndexedProperty) {
                            indexedProperty = (IndexedProperty)property;
                        } else {
                            indexedProperty = new IndexedProperty(property);
                            properties.put(name, indexedProperty);
                        }
                        break block25;
                    }
                    indexedProperty = new IndexedProperty(name, type);
                    properties.put(name, indexedProperty);
                }
                indexedProperty.addIndexedWriteMethod(method);
            }
            ++i;
        }
    }

    private static String extractPropertyName(Method method, String prefix) {
        String name = method.getName();
        if (!name.startsWith(prefix)) {
            return null;
        }
        if (name.length() == prefix.length()) {
            return "";
        }
        if (!Character.isUpperCase((name = name.substring(prefix.length())).charAt(0)) || name.indexOf(36) >= 0) {
            return null;
        }
        if (name.length() == 1 || !Character.isUpperCase(name.charAt(1))) {
            char[] chars = name.toCharArray();
            chars[0] = Character.toLowerCase(chars[0]);
            name = new String(chars);
        }
        return name.intern();
    }

    private static class IndexedProperty
    extends SimpleProperty {
        private Method[] mIndexedReadMethods;
        private Method[] mIndexedWriteMethods;

        IndexedProperty(String name, Class type) {
            super(name, type);
        }

        IndexedProperty(String name, Class type, Class[] covariantTypes) {
            super(name, type, covariantTypes);
        }

        IndexedProperty(BeanProperty property) {
            super(property.getName(), property.getType(), property.getCovariantTypes());
            this.setReadMethod(property.getReadMethod());
            this.setWriteMethod(property.getWriteMethod());
        }

        @Override
        public int getIndexTypesCount() {
            Method[] methods = this.mIndexedReadMethods;
            if (methods != null) {
                return methods.length;
            }
            methods = this.mIndexedWriteMethods;
            return methods == null ? 0 : methods.length;
        }

        @Override
        public Class getIndexType(int index) {
            Method method;
            Method[] methods = this.mIndexedReadMethods;
            if (methods != null && (method = methods[0]) != null) {
                return method.getParameterTypes()[0];
            }
            methods = this.mIndexedWriteMethods;
            if (methods != null && (method = methods[index]) != null) {
                return method.getParameterTypes()[0];
            }
            if (index >= this.getIndexTypesCount()) {
                throw new IndexOutOfBoundsException();
            }
            return null;
        }

        @Override
        public Method getIndexedReadMethod(int index) {
            return this.mIndexedReadMethods[index];
        }

        @Override
        public Method getIndexedWriteMethod(int index) {
            return this.mIndexedWriteMethods[index];
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("BeanProperty{name=");
            buf.append(this.getName());
            buf.append(", type=");
            buf.append(this.getType().getName());
            Object[] covariantTypes = this.getCovariantTypes();
            if (covariantTypes.length > 0) {
                buf.append(", covariantTypes=");
                buf.append(Arrays.toString(covariantTypes));
            }
            buf.append(", ");
            int count = this.getIndexTypesCount();
            int i = 0;
            while (i < count) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append("indexType[");
                buf.append(i);
                buf.append("]=");
                buf.append(this.getIndexType(0));
                ++i;
            }
            buf.append('}');
            return buf.toString();
        }

        @Override
        IndexedProperty addCovariantType(Class type) {
            SimpleProperty property = super.addCovariantType(type);
            if (property == null) {
                return null;
            }
            IndexedProperty ix = new IndexedProperty(property);
            ix.mIndexedReadMethods = this.mIndexedReadMethods;
            ix.mIndexedWriteMethods = this.mIndexedWriteMethods;
            return ix;
        }

        void addIndexedReadMethod(Method method) {
            Class<?> indexType = method.getParameterTypes()[0];
            int count = this.getIndexTypesCount();
            int i = 0;
            while (i < count) {
                if (this.getIndexType(i) == indexType) break;
                ++i;
            }
            if (i >= count) {
                this.expandCapactity();
            }
            if (this.mIndexedReadMethods[i] == null) {
                this.mIndexedReadMethods[i] = method;
            }
        }

        void addIndexedWriteMethod(Method method) {
            Class<?> indexType = method.getParameterTypes()[0];
            int count = this.getIndexTypesCount();
            int i = 0;
            while (i < count) {
                if (this.getIndexType(i) == indexType) break;
                ++i;
            }
            if (i >= count) {
                this.expandCapactity();
            }
            if (this.mIndexedWriteMethods[i] == null) {
                this.mIndexedWriteMethods[i] = method;
            }
        }

        private void expandCapactity() {
            int count = this.getIndexTypesCount();
            Method[] methods = new Method[count + 1];
            if (this.mIndexedReadMethods != null) {
                System.arraycopy(this.mIndexedReadMethods, 0, methods, 0, count);
            }
            this.mIndexedReadMethods = methods;
            methods = new Method[count + 1];
            if (this.mIndexedWriteMethods != null) {
                System.arraycopy(this.mIndexedWriteMethods, 0, methods, 0, count);
            }
            this.mIndexedWriteMethods = methods;
        }
    }

    private static class SimpleProperty
    implements BeanProperty {
        private static final Class[] EMPTY = new Class[0];
        private final String mName;
        private final Class mType;
        private final Class[] mCovariantTypes;
        private Method mReadMethod;
        private Method mWriteMethod;

        SimpleProperty(String name, Class type) {
            this(name, type, null);
        }

        SimpleProperty(String name, Class type, Class[] covariantTypes) {
            this.mName = name;
            this.mType = type;
            this.mCovariantTypes = covariantTypes == null || covariantTypes.length == 0 ? EMPTY : covariantTypes;
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        public Class getType() {
            return this.mType;
        }

        @Override
        public Class[] getCovariantTypes() {
            if (this.mCovariantTypes.length == 0) {
                return EMPTY;
            }
            return (Class[])this.mCovariantTypes.clone();
        }

        @Override
        public Method getReadMethod() {
            return this.mReadMethod;
        }

        @Override
        public Method getWriteMethod() {
            return this.mWriteMethod;
        }

        @Override
        public int getIndexTypesCount() {
            return 0;
        }

        @Override
        public Class getIndexType(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Method getIndexedReadMethod(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Method getIndexedWriteMethod(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public String toString() {
            String str = "BeanProperty{name=" + this.getName() + ", type=" + this.getType().getName();
            Object[] covariantTypes = this.getCovariantTypes();
            if (covariantTypes.length > 0) {
                str = String.valueOf(str) + ", covariantTypes=" + Arrays.toString(covariantTypes);
            }
            return String.valueOf(str) + '}';
        }

        SimpleProperty addCovariantType(Class type) {
            if (this.mType == type) {
                return null;
            }
            Class[] classArray = this.mCovariantTypes;
            int n = this.mCovariantTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Class covariant = classArray[n2];
                if (covariant == type) {
                    return null;
                }
                ++n2;
            }
            Class newType = this.mType;
            if (this.mType.isAssignableFrom(type)) {
                newType = type;
            }
            Class[] classArray2 = this.mCovariantTypes;
            int n3 = this.mCovariantTypes.length;
            n = 0;
            while (n < n3) {
                Class covariant = classArray2[n];
                if (covariant.isAssignableFrom(type)) {
                    newType = type;
                }
                ++n;
            }
            Class[] newCovariant = new Class[1 + this.mCovariantTypes.length];
            System.arraycopy(this.mCovariantTypes, 0, newCovariant, 1, this.mCovariantTypes.length);
            newCovariant[0] = newType == this.mType ? type : this.mType;
            SimpleProperty property = new SimpleProperty(this.mName, newType, newCovariant);
            property.mReadMethod = this.mReadMethod;
            property.mWriteMethod = this.mWriteMethod;
            return property;
        }

        void setReadMethod(Method method) {
            this.mReadMethod = method;
        }

        void setWriteMethod(Method method) {
            this.mWriteMethod = method;
        }
    }
}

