/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.RuntimeClassFile;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.BeanIntrospector;
import org.cojen.util.BeanProperty;
import org.cojen.util.SoftValuedHashMap;

public class BeanComparator<T>
implements Comparator<T>,
Serializable {
    private static Map cGeneratedComparatorCache = new SoftValuedHashMap();
    private Class<T> mBeanClass;
    private transient Map<String, BeanProperty> mProperties;
    private String mOrderByName;
    private Comparator<?> mUsingComparator;
    private int mFlags;
    private Comparator<String> mCollator;
    private BeanComparator<T> mParent;
    private transient Comparator<T> mComparator;
    private transient boolean mHasHashCode;
    private transient int mHashCode;

    public static <T> BeanComparator<T> forClass(Class<T> clazz) {
        return new BeanComparator<T>(clazz);
    }

    private static boolean equalTest(Object obj1, Object obj2) {
        return obj1 == obj2 ? true : (obj1 == null || obj2 == null ? false : obj1.equals(obj2));
    }

    private BeanComparator(Class<T> clazz) {
        this.mBeanClass = clazz;
        this.mCollator = String.CASE_INSENSITIVE_ORDER;
    }

    private BeanComparator(BeanComparator<T> parent) {
        this.mParent = parent;
        this.mBeanClass = parent.mBeanClass;
        this.mProperties = super.getProperties();
        this.mCollator = parent.mCollator;
    }

    public BeanComparator<T> orderBy(String propertyName) throws IllegalArgumentException {
        BeanProperty prop;
        String subName;
        int dot = propertyName.indexOf(46);
        if (dot < 0) {
            subName = null;
        } else {
            subName = propertyName.substring(dot + 1);
            propertyName = propertyName.substring(0, dot);
        }
        boolean reverse = false;
        if (propertyName.length() > 0) {
            char prefix = propertyName.charAt(0);
            switch (prefix) {
                default: {
                    break;
                }
                case '-': {
                    reverse = true;
                }
                case '+': {
                    propertyName = propertyName.substring(1);
                }
            }
        }
        if ((prop = this.getProperties().get(propertyName)) == null) {
            throw new IllegalArgumentException("Property '" + propertyName + "' doesn't exist in '" + this.mBeanClass.getName() + '\'');
        }
        if (prop.getReadMethod() == null) {
            throw new IllegalArgumentException("Property '" + propertyName + "' cannot be read");
        }
        if (propertyName.equals(this.mOrderByName)) {
            propertyName = new String(propertyName);
        }
        BeanComparator<T> bc = new BeanComparator<T>(this);
        bc.mOrderByName = propertyName;
        if (subName != null) {
            BeanComparator<T> subOrder = BeanComparator.forClass(prop.getType());
            subOrder.mCollator = this.mCollator;
            bc = bc.using(subOrder.orderBy(subName));
        }
        return reverse ? bc.reverse() : bc;
    }

    public <S> BeanComparator<T> using(Comparator<S> c) {
        BeanComparator<T> bc = new BeanComparator<T>(this);
        bc.mOrderByName = this.mOrderByName;
        bc.mUsingComparator = c;
        bc.mFlags = this.mFlags;
        return bc;
    }

    public BeanComparator<T> reverse() {
        BeanComparator<T> bc = new BeanComparator<T>(this);
        bc.mOrderByName = this.mOrderByName;
        bc.mUsingComparator = this.mUsingComparator;
        bc.mFlags = this.mFlags ^ 1;
        return bc;
    }

    public BeanComparator<T> nullHigh() {
        BeanComparator<T> bc = new BeanComparator<T>(this);
        bc.mOrderByName = this.mOrderByName;
        bc.mUsingComparator = this.mUsingComparator;
        bc.mFlags = this.mFlags ^ (this.mFlags & 1) << 1;
        return bc;
    }

    public BeanComparator<T> nullLow() {
        BeanComparator<T> bc = new BeanComparator<T>(this);
        bc.mOrderByName = this.mOrderByName;
        bc.mUsingComparator = this.mUsingComparator;
        bc.mFlags = this.mFlags ^ (~this.mFlags & 1) << 1;
        return bc;
    }

    public BeanComparator<T> caseSensitive() {
        if ((this.mFlags & 4) != 0) {
            return this;
        }
        BeanComparator<T> bc = new BeanComparator<T>(this);
        bc.mOrderByName = this.mOrderByName;
        bc.mUsingComparator = this.mUsingComparator;
        bc.mFlags = this.mFlags | 4;
        return bc;
    }

    public BeanComparator<T> collate(Comparator<String> c) {
        BeanComparator<T> bc = new BeanComparator<T>(this);
        bc.mOrderByName = this.mOrderByName;
        bc.mUsingComparator = this.mUsingComparator;
        bc.mFlags = this.mFlags & 0xFFFFFFFB;
        bc.mCollator = c;
        return bc;
    }

    @Override
    public int compare(T obj1, T obj2) throws ClassCastException {
        Comparator c = this.mComparator;
        if (c == null) {
            this.mComparator = c = (Comparator)AccessController.doPrivileged(new PrivilegedAction<Comparator<T>>(){

                @Override
                public Comparator<T> run() {
                    return BeanComparator.this.generateComparator();
                }
            });
        }
        return c.compare(obj1, obj2);
    }

    public int hashCode() {
        if (!this.mHasHashCode) {
            this.setHashCode(new Rules(this));
        }
        return this.mHashCode;
    }

    private void setHashCode(Rules rules) {
        this.mHashCode = rules.hashCode();
        this.mHasHashCode = true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BeanComparator) {
            BeanComparator bc = (BeanComparator)obj;
            return this.mFlags == bc.mFlags && BeanComparator.equalTest(this.mBeanClass, bc.mBeanClass) && BeanComparator.equalTest(this.mOrderByName, bc.mOrderByName) && BeanComparator.equalTest(this.mUsingComparator, bc.mUsingComparator) && BeanComparator.equalTest(this.mCollator, bc.mCollator) && BeanComparator.equalTest(this.mParent, bc.mParent);
        }
        return false;
    }

    private Map<String, BeanProperty> getProperties() {
        if (this.mProperties == null) {
            this.mProperties = BeanIntrospector.getAllProperties(this.mBeanClass);
        }
        return this.mProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Comparator<T> generateComparator() {
        Rules rules = new Rules(this);
        if (!this.mHasHashCode) {
            this.setHashCode(rules);
        }
        Map map = cGeneratedComparatorCache;
        synchronized (map) {
            Class clazz;
            Object c = cGeneratedComparatorCache.get(rules);
            if (c == null) {
                clazz = this.generateComparatorClass(rules);
                cGeneratedComparatorCache.put(rules, clazz);
            } else {
                if (c instanceof Comparator) {
                    return (Comparator)c;
                }
                clazz = (Class)c;
            }
            BeanComparator[] ruleParts = rules.getRuleParts();
            Comparator[] collators = new Comparator[ruleParts.length];
            Comparator[] usingComparators = new Comparator[ruleParts.length];
            boolean singleton = true;
            int i = 0;
            while (i < ruleParts.length) {
                BeanComparator rp = ruleParts[i];
                Comparator<String> c2 = rp.mCollator;
                collators[i] = c2;
                if (collators[i] != null && c2 != String.CASE_INSENSITIVE_ORDER) {
                    singleton = false;
                }
                if ((usingComparators[i] = rp.mUsingComparator) != null) {
                    singleton = false;
                }
                ++i;
            }
            try {
                Constructor ctor = clazz.getDeclaredConstructor(Comparator[].class, Comparator[].class);
                c = (Comparator)ctor.newInstance(collators, usingComparators);
            }
            catch (NoSuchMethodException e) {
                throw new InternalError(e.toString());
            }
            catch (InstantiationException e) {
                throw new InternalError(e.toString());
            }
            catch (IllegalAccessException e) {
                throw new InternalError(e.toString());
            }
            catch (IllegalArgumentException e) {
                throw new InternalError(e.toString());
            }
            catch (InvocationTargetException e) {
                throw new InternalError(e.getTargetException().toString());
            }
            if (singleton) {
                cGeneratedComparatorCache.put(rules, c);
            }
            return (Comparator)c;
        }
    }

    private Class generateComparatorClass(Rules rules) {
        Method compareToMethod;
        Method compareMethod;
        RuntimeClassFile cf = new RuntimeClassFile(this.getClass().getName(), null, this.mBeanClass.getClassLoader());
        cf.markSynthetic();
        cf.setSourceFile(BeanComparator.class.getName());
        try {
            cf.setTarget(System.getProperty("java.specification.version"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        cf.addInterface(Comparator.class);
        cf.addInterface(Serializable.class);
        TypeDesc comparatorType = TypeDesc.forClass(Comparator.class);
        TypeDesc comparatorArrayType = comparatorType.toArrayType();
        cf.addField(Modifiers.PRIVATE, "mCollators", comparatorArrayType).markSynthetic();
        cf.addField(Modifiers.PRIVATE, "mUsingComparators", comparatorArrayType).markSynthetic();
        TypeDesc[] paramTypes = new TypeDesc[]{comparatorArrayType, comparatorArrayType};
        MethodInfo ctor = cf.addConstructor(Modifiers.PUBLIC, paramTypes);
        ctor.markSynthetic();
        CodeBuilder builder = new CodeBuilder(ctor);
        builder.loadThis();
        builder.invokeSuperConstructor(null);
        builder.loadThis();
        builder.loadLocal(builder.getParameter(0));
        builder.storeField("mCollators", comparatorArrayType);
        builder.loadThis();
        builder.loadLocal(builder.getParameter(1));
        builder.storeField("mUsingComparators", comparatorArrayType);
        builder.returnVoid();
        try {
            compareMethod = Comparator.class.getMethod("compare", Object.class, Object.class);
            compareToMethod = Comparable.class.getMethod("compareTo", Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.toString());
        }
        MethodInfo mi = cf.addMethod(compareMethod);
        mi.markSynthetic();
        builder = new CodeBuilder(mi);
        Label endLabel = builder.createLabel();
        LocalVariable obj1 = builder.getParameter(0);
        LocalVariable obj2 = builder.getParameter(1);
        BeanComparator[] ruleParts = rules.getRuleParts();
        BeanComparator bc = ruleParts[0];
        if ((bc.mFlags & 1) != 0) {
            LocalVariable temp = obj1;
            obj1 = obj2;
            obj2 = temp;
        }
        builder.loadLocal(obj1);
        builder.loadLocal(obj2);
        builder.ifEqualBranch(endLabel, true);
        boolean nullHigh = (bc.mFlags & 2) == 0;
        Label label = builder.createLabel();
        builder.loadLocal(obj1);
        builder.ifNullBranch(label, false);
        builder.loadConstant(nullHigh ? 1 : -1);
        builder.returnValue(TypeDesc.INT);
        label.setLocation();
        label = builder.createLabel();
        builder.loadLocal(obj2);
        builder.ifNullBranch(label, false);
        builder.loadConstant(nullHigh ? -1 : 1);
        builder.returnValue(TypeDesc.INT);
        label.setLocation();
        LocalVariable result = builder.createLocalVariable("result", TypeDesc.INT);
        if (bc.mUsingComparator != null) {
            builder.loadThis();
            builder.loadField("mUsingComparators", comparatorArrayType);
            builder.loadConstant(0);
            builder.loadFromArray(TypeDesc.forClass(Comparator.class));
            builder.loadLocal(obj1);
            builder.loadLocal(obj2);
            builder.invoke(compareMethod);
            builder.storeLocal(result);
            builder.loadLocal(result);
            label = builder.createLabel();
            builder.ifZeroComparisonBranch(label, "==");
            builder.loadLocal(result);
            builder.returnValue(TypeDesc.INT);
            label.setLocation();
        }
        TypeDesc type = TypeDesc.forClass(bc.mBeanClass);
        builder.loadLocal(obj1);
        builder.checkCast(type);
        builder.storeLocal(obj1);
        builder.loadLocal(obj2);
        builder.checkCast(type);
        builder.storeLocal(obj2);
        int i = 1;
        while (i < ruleParts.length) {
            bc = ruleParts[i];
            BeanProperty prop = bc.getProperties().get(bc.mOrderByName);
            Class propertyClass = prop.getType();
            TypeDesc propertyType = TypeDesc.forClass(propertyClass);
            LocalVariable p1 = builder.createLocalVariable("p1", propertyType);
            LocalVariable p2 = builder.createLocalVariable("p2", propertyType);
            builder.loadLocal(obj1);
            builder.invoke(prop.getReadMethod());
            builder.storeLocal(p1);
            builder.loadLocal(obj2);
            builder.invoke(prop.getReadMethod());
            builder.storeLocal(p2);
            if ((bc.mFlags & 1) != 0) {
                LocalVariable temp = p1;
                p1 = p2;
                p2 = temp;
            }
            Label nextLabel = builder.createLabel();
            if (!propertyClass.isPrimitive()) {
                builder.loadLocal(p1);
                builder.loadLocal(p2);
                builder.ifEqualBranch(nextLabel, true);
                nullHigh = (bc.mFlags & 2) == 0;
                label = builder.createLabel();
                builder.loadLocal(p1);
                builder.ifNullBranch(label, false);
                builder.loadConstant(nullHigh ? 1 : -1);
                builder.returnValue(TypeDesc.INT);
                label.setLocation();
                label = builder.createLabel();
                builder.loadLocal(p2);
                builder.ifNullBranch(label, false);
                builder.loadConstant(nullHigh ? -1 : 1);
                builder.returnValue(TypeDesc.INT);
                label.setLocation();
            }
            if (bc.mUsingComparator != null) {
                builder.loadThis();
                builder.loadField("mUsingComparators", comparatorArrayType);
                builder.loadConstant(i);
                builder.loadFromArray(TypeDesc.forClass(Comparator.class));
                builder.loadLocal(p1);
                builder.convert(propertyType, propertyType.toObjectType());
                builder.loadLocal(p2);
                builder.convert(propertyType, propertyType.toObjectType());
                builder.invoke(compareMethod);
            } else if ((bc.mFlags & 4) == 0 && bc.mCollator != null && propertyClass.isAssignableFrom(String.class)) {
                Label resultLabel = builder.createLabel();
                if (!String.class.isAssignableFrom(propertyClass)) {
                    TypeDesc stringType = TypeDesc.STRING;
                    builder.loadLocal(p1);
                    builder.instanceOf(stringType);
                    Label notString = builder.createLabel();
                    builder.ifZeroComparisonBranch(notString, "==");
                    builder.loadLocal(p2);
                    builder.instanceOf(stringType);
                    Label isString = builder.createLabel();
                    builder.ifZeroComparisonBranch(isString, "!=");
                    notString.setLocation();
                    BeanComparator.generateComparableCompareTo(builder, propertyClass, compareToMethod, resultLabel, nextLabel, p1, p2);
                    isString.setLocation();
                }
                builder.loadThis();
                builder.loadField("mCollators", comparatorArrayType);
                builder.loadConstant(i);
                builder.loadFromArray(TypeDesc.forClass(Comparator.class));
                builder.loadLocal(p1);
                builder.loadLocal(p2);
                builder.invoke(compareMethod);
                resultLabel.setLocation();
            } else if (propertyClass.isPrimitive()) {
                BeanComparator.generatePrimitiveComparison(builder, propertyClass, p1, p2);
            } else {
                BeanComparator.generateComparableCompareTo(builder, propertyClass, compareToMethod, null, nextLabel, p1, p2);
            }
            if (i < ruleParts.length - 1) {
                builder.storeLocal(result);
                builder.loadLocal(result);
                builder.ifZeroComparisonBranch(nextLabel, "==");
                builder.loadLocal(result);
            }
            builder.returnValue(TypeDesc.INT);
            nextLabel.setLocation();
            ++i;
        }
        endLabel.setLocation();
        builder.loadConstant(0);
        builder.returnValue(TypeDesc.INT);
        return cf.defineClass();
    }

    private static void generatePrimitiveComparison(CodeBuilder builder, Class type, LocalVariable a, LocalVariable b) {
        if (type == Float.TYPE) {
            Method floatToIntBits;
            Label done = builder.createLabel();
            builder.loadLocal(a);
            builder.loadLocal(b);
            builder.math((byte)-106);
            Label label = builder.createLabel();
            builder.ifZeroComparisonBranch(label, ">=");
            builder.loadConstant(-1);
            builder.branch(done);
            label.setLocation();
            builder.loadLocal(a);
            builder.loadLocal(b);
            builder.math((byte)-107);
            label = builder.createLabel();
            builder.ifZeroComparisonBranch(label, "<=");
            builder.loadConstant(1);
            builder.branch(done);
            try {
                floatToIntBits = Float.class.getMethod("floatToIntBits", Float.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new InternalError(e.toString());
            }
            label.setLocation();
            builder.loadLocal(a);
            builder.invoke(floatToIntBits);
            builder.convert(TypeDesc.INT, TypeDesc.LONG);
            builder.loadLocal(b);
            builder.invoke(floatToIntBits);
            builder.convert(TypeDesc.INT, TypeDesc.LONG);
            builder.math((byte)-108);
            done.setLocation();
        } else if (type == Double.TYPE) {
            Method doubleToLongBits;
            Label done = builder.createLabel();
            builder.loadLocal(a);
            builder.loadLocal(b);
            done = builder.createLabel();
            builder.math((byte)-104);
            Label label = builder.createLabel();
            builder.ifZeroComparisonBranch(label, ">=");
            builder.loadConstant(-1);
            builder.branch(done);
            label.setLocation();
            builder.loadLocal(a);
            builder.loadLocal(b);
            builder.math((byte)-105);
            label = builder.createLabel();
            builder.ifZeroComparisonBranch(label, "<=");
            builder.loadConstant(1);
            builder.branch(done);
            try {
                doubleToLongBits = Double.class.getMethod("doubleToLongBits", Double.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new InternalError(e.toString());
            }
            label.setLocation();
            builder.loadLocal(a);
            builder.invoke(doubleToLongBits);
            builder.loadLocal(b);
            builder.invoke(doubleToLongBits);
            builder.math((byte)-108);
            done.setLocation();
        } else if (type == Long.TYPE) {
            builder.loadLocal(a);
            builder.loadLocal(b);
            builder.math((byte)-108);
        } else if (type == Integer.TYPE) {
            builder.loadLocal(a);
            builder.convert(TypeDesc.INT, TypeDesc.LONG);
            builder.loadLocal(b);
            builder.convert(TypeDesc.INT, TypeDesc.LONG);
            builder.math((byte)-108);
        } else {
            builder.loadLocal(a);
            builder.loadLocal(b);
            builder.math((byte)100);
        }
    }

    private static void generateComparableCompareTo(CodeBuilder builder, Class type, Method compareToMethod, Label goodLabel, Label nextLabel, LocalVariable a, LocalVariable b) {
        if (Comparable.class.isAssignableFrom(type)) {
            builder.loadLocal(a);
            builder.loadLocal(b);
            builder.invoke(compareToMethod);
            if (goodLabel != null) {
                builder.branch(goodLabel);
            }
        } else {
            TypeDesc comparableType = TypeDesc.forClass(Comparable.class);
            boolean locateGoodLabel = false;
            if (goodLabel == null) {
                goodLabel = builder.createLabel();
                locateGoodLabel = true;
            }
            Label tryStart = builder.createLabel().setLocation();
            builder.loadLocal(a);
            builder.checkCast(comparableType);
            builder.loadLocal(b);
            builder.checkCast(comparableType);
            Label tryEnd = builder.createLabel().setLocation();
            builder.invoke(compareToMethod);
            builder.branch(goodLabel);
            builder.exceptionHandler(tryStart, tryEnd, ClassCastException.class.getName());
            builder.pop();
            if (nextLabel == null) {
                builder.loadConstant(0);
            } else {
                builder.branch(nextLabel);
            }
            if (locateGoodLabel) {
                goodLabel.setLocation();
            }
        }
    }

    private static class Rules {
        private BeanComparator[] mRuleParts;
        private int mHashCode;

        public Rules(BeanComparator bc) {
            this.mRuleParts = this.reduceRules(bc);
            int hash = 0;
            int i = this.mRuleParts.length - 1;
            while (i >= 0) {
                bc = this.mRuleParts[i];
                hash *= 31;
                hash += bc.mFlags << 4;
                Object obj = bc.mBeanClass;
                if (obj != null) {
                    hash += obj.hashCode();
                }
                if ((obj = bc.mOrderByName) != null) {
                    hash += obj.hashCode();
                }
                if ((obj = bc.mUsingComparator) != null) {
                    hash += obj.getClass().hashCode();
                }
                if ((obj = bc.mCollator) != null) {
                    hash += obj.getClass().hashCode();
                }
                --i;
            }
            this.mHashCode = hash;
        }

        public BeanComparator[] getRuleParts() {
            return this.mRuleParts;
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public boolean equals(Object obj) {
            BeanComparator[] ruleParts2;
            if (!(obj instanceof Rules)) {
                return false;
            }
            BeanComparator[] ruleParts1 = this.getRuleParts();
            if (ruleParts1.length != (ruleParts2 = ((Rules)obj).getRuleParts()).length) {
                return false;
            }
            int i = 0;
            while (i < ruleParts1.length) {
                BeanComparator bc1 = ruleParts1[i];
                BeanComparator bc2 = ruleParts2[i];
                if (bc1.mFlags != bc2.mFlags) {
                    return false;
                }
                if (!BeanComparator.equalTest(bc1.mBeanClass, bc2.mBeanClass)) {
                    return false;
                }
                if (!BeanComparator.equalTest(bc1.mOrderByName, bc2.mOrderByName)) {
                    return false;
                }
                if (bc1.mUsingComparator == null != (bc2.mUsingComparator == null)) {
                    return false;
                }
                if (bc1.mCollator == null != (bc2.mCollator == null)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private BeanComparator[] reduceRules(BeanComparator bc) {
            ArrayList<BeanComparator> rules = new ArrayList<BeanComparator>();
            rules.add(bc);
            String name = bc.mOrderByName;
            while ((bc = bc.mParent) != null) {
                if (name == bc.mOrderByName) continue;
                rules.add(bc);
                name = bc.mOrderByName;
            }
            int size = rules.size();
            BeanComparator[] bcs = new BeanComparator[size];
            int i = 0;
            while (i < size) {
                bcs[size - i - 1] = (BeanComparator)rules.get(i);
                ++i;
            }
            return bcs;
        }
    }
}

