/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import org.cojen.util.BeanComparator;
import org.cojen.util.ThrowUnchecked;

public class AnnotationVisitor<R, P> {
    private final Comparator<Method> mMethodComparator;

    public AnnotationVisitor(boolean sort) {
        this.mMethodComparator = sort ? BeanComparator.forClass(Method.class).orderBy("name").caseSensitive() : null;
    }

    public final R visit(Annotation value, P param) {
        return this.visit(null, 0, value, param);
    }

    public R visit(String name, int pos, Annotation value, P param) {
        Class<? extends Annotation> annotationType = value.annotationType();
        Method[] methods = annotationType.getMethods();
        if (this.mMethodComparator != null) {
            Arrays.sort(methods, this.mMethodComparator);
        }
        int i = 0;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> propType;
            Method m = methodArray[n2];
            if (m.getDeclaringClass() == annotationType && m.getParameterTypes().length <= 0 && (propType = m.getReturnType()) != Void.TYPE) {
                Object propValue;
                String propName = m.getName();
                try {
                    propValue = m.invoke((Object)value, new Object[0]);
                }
                catch (Exception e) {
                    ThrowUnchecked.fireRootCause(e);
                    return null;
                }
                if (propType.isArray()) {
                    if (propType.isPrimitive()) {
                        if ((propType = propType.getComponentType()) == Integer.TYPE) {
                            this.visit(propName, i, (int[])propValue, param);
                        } else if (propType == Long.TYPE) {
                            this.visit(propName, i, (long[])propValue, param);
                        } else if (propType == Float.TYPE) {
                            this.visit(propName, i, (float[])propValue, param);
                        } else if (propType == Double.TYPE) {
                            this.visit(propName, i, (double[])propValue, param);
                        } else if (propType == Boolean.TYPE) {
                            this.visit(propName, i, (boolean[])propValue, param);
                        } else if (propType == Byte.TYPE) {
                            this.visit(propName, i, (byte[])propValue, param);
                        } else if (propType == Short.TYPE) {
                            this.visit(propName, i, (short[])propValue, param);
                        } else if (propType == Character.TYPE) {
                            this.visit(propName, i, (char[])propValue, param);
                        }
                    } else if (propValue instanceof String[]) {
                        this.visit(propName, i, (String[])propValue, param);
                    } else if (propValue instanceof Class[]) {
                        this.visit(propName, i, (Class[])propValue, param);
                    } else if (propValue instanceof Enum[]) {
                        this.visit(propName, i, (Enum[])propValue, param);
                    } else if (propValue instanceof Annotation[]) {
                        this.visit(propName, i, (Annotation[])propValue, param);
                    }
                } else if (propType.isPrimitive()) {
                    if (propType == Integer.TYPE) {
                        this.visit(propName, i, (Integer)propValue, param);
                    } else if (propType == Long.TYPE) {
                        this.visit(propName, i, (Long)propValue, param);
                    } else if (propType == Float.TYPE) {
                        this.visit(propName, i, ((Float)propValue).floatValue(), param);
                    } else if (propType == Double.TYPE) {
                        this.visit(propName, i, (Double)propValue, param);
                    } else if (propType == Boolean.TYPE) {
                        this.visit(propName, i, (Boolean)propValue, param);
                    } else if (propType == Byte.TYPE) {
                        this.visit(propName, i, (Byte)propValue, param);
                    } else if (propType == Short.TYPE) {
                        this.visit(propName, i, (Short)propValue, param);
                    } else if (propType == Character.TYPE) {
                        this.visit(propName, i, ((Character)propValue).charValue(), param);
                    }
                } else if (propValue instanceof String) {
                    this.visit(propName, i, (String)propValue, param);
                } else if (propValue instanceof Class) {
                    this.visit(propName, i, (Class)propValue, param);
                } else if (propValue instanceof Enum) {
                    this.visit(propName, i, (Enum)propValue, param);
                } else if (propValue instanceof Annotation) {
                    this.visit(propName, i, (Annotation)propValue, param);
                }
                ++i;
            }
            ++n2;
        }
        return null;
    }

    public R visit(String name, int pos, int value, P param) {
        return null;
    }

    public R visit(String name, int pos, long value, P param) {
        return null;
    }

    public R visit(String name, int pos, float value, P param) {
        return null;
    }

    public R visit(String name, int pos, double value, P param) {
        return null;
    }

    public R visit(String name, int pos, boolean value, P param) {
        return null;
    }

    public R visit(String name, int pos, byte value, P param) {
        return null;
    }

    public R visit(String name, int pos, short value, P param) {
        return null;
    }

    public R visit(String name, int pos, char value, P param) {
        return null;
    }

    public R visit(String name, int pos, String value, P param) {
        return null;
    }

    public R visit(String name, int pos, Class value, P param) {
        return null;
    }

    public R visit(String name, int pos, Enum value, P param) {
        return null;
    }

    public R visit(String name, int pos, Annotation[] value, P param) {
        int i = 0;
        while (i < value.length) {
            this.visit(null, i, value[i], param);
            ++i;
        }
        return null;
    }

    public R visit(String name, int pos, int[] value, P param) {
        int i = 0;
        while (i < value.length) {
            this.visit((String)null, i, value[i], param);
            ++i;
        }
        return null;
    }

    public R visit(String name, int pos, long[] value, P param) {
        int i = 0;
        while (i < value.length) {
            this.visit((String)null, i, value[i], param);
            ++i;
        }
        return null;
    }

    public R visit(String name, int pos, float[] value, P param) {
        int i = 0;
        while (i < value.length) {
            this.visit((String)null, i, value[i], param);
            ++i;
        }
        return null;
    }

    public R visit(String name, int pos, double[] value, P param) {
        int i = 0;
        while (i < value.length) {
            this.visit(null, i, value[i], param);
            ++i;
        }
        return null;
    }

    public R visit(String name, int pos, boolean[] value, P param) {
        int i = 0;
        while (i < value.length) {
            this.visit(null, i, value[i], param);
            ++i;
        }
        return null;
    }

    public R visit(String name, int pos, byte[] value, P param) {
        int i = 0;
        while (i < value.length) {
            this.visit((String)null, i, value[i], param);
            ++i;
        }
        return null;
    }

    public R visit(String name, int pos, short[] value, P param) {
        int i = 0;
        while (i < value.length) {
            this.visit((String)null, i, value[i], param);
            ++i;
        }
        return null;
    }

    public R visit(String name, int pos, char[] value, P param) {
        int i = 0;
        while (i < value.length) {
            this.visit((String)null, i, value[i], param);
            ++i;
        }
        return null;
    }

    public R visit(String name, int pos, String[] value, P param) {
        int i = 0;
        while (i < value.length) {
            this.visit(null, i, value[i], param);
            ++i;
        }
        return null;
    }

    public R visit(String name, int pos, Class[] value, P param) {
        int i = 0;
        while (i < value.length) {
            this.visit(null, i, value[i], param);
            ++i;
        }
        return null;
    }

    public R visit(String name, int pos, Enum[] value, P param) {
        int i = 0;
        while (i < value.length) {
            this.visit(null, i, value[i], param);
            ++i;
        }
        return null;
    }
}

