/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile.constant;

import java.io.DataOutput;
import java.io.IOException;
import org.cojen.classfile.ConstantInfo;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.constant.ConstantUTFInfo;

public class ConstantStringInfo
extends ConstantInfo {
    private final ConstantUTFInfo mStringConstant;

    public ConstantStringInfo(ConstantUTFInfo constant) {
        super(8);
        this.mStringConstant = constant;
    }

    public ConstantStringInfo(ConstantPool cp, String str) {
        super(8);
        this.mStringConstant = cp.addConstantUTF(str);
    }

    public String getValue() {
        return this.mStringConstant.getValue();
    }

    public int hashCode() {
        return this.mStringConstant.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ConstantStringInfo) {
            ConstantStringInfo other = (ConstantStringInfo)obj;
            return this.mStringConstant.equals(other.mStringConstant);
        }
        return false;
    }

    @Override
    protected boolean hasPriority() {
        return true;
    }

    @Override
    public void writeTo(DataOutput dout) throws IOException {
        super.writeTo(dout);
        dout.writeShort(this.mStringConstant.getIndex());
    }

    public String toString() {
        return "CONSTANT_String_info: " + this.getValue();
    }
}

