/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile.constant;

import java.io.DataOutput;
import java.io.IOException;
import org.cojen.classfile.ConstantInfo;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.Descriptor;
import org.cojen.classfile.constant.ConstantUTFInfo;

public class ConstantNameAndTypeInfo
extends ConstantInfo {
    private final ConstantUTFInfo mNameConstant;
    private final ConstantUTFInfo mDescriptorConstant;
    private final Descriptor mType;

    public ConstantNameAndTypeInfo(ConstantUTFInfo nameConstant, ConstantUTFInfo descConstant) {
        super(12);
        this.mNameConstant = nameConstant;
        this.mDescriptorConstant = descConstant;
        this.mType = Descriptor.parse(descConstant.getValue());
    }

    public ConstantNameAndTypeInfo(ConstantPool cp, String name, Descriptor type) {
        super(12);
        this.mNameConstant = cp.addConstantUTF(name);
        this.mDescriptorConstant = cp.addConstantUTF(type.getDescriptor());
        this.mType = type;
    }

    public String getName() {
        return this.mNameConstant.getValue();
    }

    public Descriptor getType() {
        return this.mType;
    }

    public int hashCode() {
        return this.mNameConstant.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConstantNameAndTypeInfo) {
            ConstantNameAndTypeInfo other = (ConstantNameAndTypeInfo)obj;
            return this.mNameConstant.equals(other.mNameConstant) && this.mType.getDescriptor().equals(other.mType.getDescriptor());
        }
        return false;
    }

    @Override
    public void writeTo(DataOutput dout) throws IOException {
        super.writeTo(dout);
        dout.writeShort(this.mNameConstant.getIndex());
        dout.writeShort(this.mDescriptorConstant.getIndex());
    }

    public String toString() {
        return "CONSTANT_NameAndType_info: " + this.getName() + ", " + this.getType();
    }
}

