/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile.constant;

import java.io.DataOutput;
import java.io.IOException;
import org.cojen.classfile.ConstantInfo;

public class ConstantFloatInfo
extends ConstantInfo {
    private final float mValue;

    public ConstantFloatInfo(float value) {
        super(4);
        this.mValue = value;
    }

    public float getValue() {
        return this.mValue;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.mValue);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ConstantFloatInfo) {
            ConstantFloatInfo other = (ConstantFloatInfo)obj;
            return this.mValue == other.mValue;
        }
        return false;
    }

    @Override
    protected boolean hasPriority() {
        return true;
    }

    @Override
    public void writeTo(DataOutput dout) throws IOException {
        super.writeTo(dout);
        dout.writeFloat(this.mValue);
    }

    public String toString() {
        return "CONSTANT_Float_info: " + this.mValue;
    }
}

