/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.cojen.classfile.Attribute;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.TypeDesc;
import org.cojen.classfile.constant.ConstantClassInfo;

public class StackMapTableAttr
extends Attribute {
    private final InitialFrame mInitialFrame;
    private int mSize;
    private int mLength;

    public StackMapTableAttr(ConstantPool cp, String name, int length, DataInput din) throws IOException {
        super(cp, name);
        InitialFrame first;
        int size = din.readUnsignedShort();
        ArrayList frames = new ArrayList(size);
        StackMapFrame last = first = new InitialFrame();
        int i = 0;
        while (i < size) {
            StackMapFrame frame = StackMapFrame.read(last, cp, din);
            if (frame != null) {
                last = frame;
            }
            ++i;
        }
        this.mInitialFrame = first;
        this.mSize = size;
        this.mLength = length;
    }

    @Override
    public int getLength() {
        if (this.mLength < 0) {
            if (this.mInitialFrame.getNext() == null) {
                this.mLength = 0;
            } else {
                int length = 2;
                StackMapFrame frame = this.mInitialFrame;
                while (frame != null) {
                    length += ((StackMapFrame)frame).getLength();
                    frame = frame.getNext();
                }
                this.mLength = length;
            }
        }
        return this.mLength;
    }

    @Override
    public void writeTo(DataOutput dout) throws IOException {
        if (this.mSize == 0) {
            return;
        }
        super.writeTo(dout);
    }

    @Override
    public void writeDataTo(DataOutput dout) throws IOException {
        dout.writeShort(this.mSize);
        StackMapFrame frame = this.mInitialFrame;
        while (frame != null) {
            ((StackMapFrame)frame).writeTo(dout);
            frame = frame.getNext();
        }
    }

    public StackMapFrame getInitialFrame() {
        return this.mInitialFrame;
    }

    public void initialStackMapFrame(MethodInfo method) {
        this.mInitialFrame.set(this.getConstantPool(), method);
    }

    private static class AppendFrame
    extends StackMapFrame {
        private final int mOffsetDelta;
        private final VerificationTypeInfo[] mAppendInfos;
        private transient VerificationTypeInfo[] mLocalInfos;

        AppendFrame(StackMapFrame prev, int numLocals, ConstantPool cp, DataInput din) throws IOException {
            super(prev);
            this.mOffsetDelta = din.readUnsignedShort();
            this.mAppendInfos = VerificationTypeInfo.read(cp, din, numLocals);
        }

        @Override
        public int getLength() {
            int length = 3;
            VerificationTypeInfo[] verificationTypeInfoArray = this.mAppendInfos;
            int n = this.mAppendInfos.length;
            int n2 = 0;
            while (n2 < n) {
                VerificationTypeInfo info = verificationTypeInfoArray[n2];
                length += info.getLength();
                ++n2;
            }
            return length;
        }

        @Override
        public int getOffsetDelta() {
            return this.mOffsetDelta;
        }

        @Override
        public VerificationTypeInfo[] getLocalInfos() {
            if (this.mLocalInfos == null) {
                VerificationTypeInfo[] prevInfos = this.getPrevious().getLocalInfos();
                VerificationTypeInfo[] infos = new VerificationTypeInfo[prevInfos.length + this.mAppendInfos.length];
                System.arraycopy(prevInfos, 0, infos, 0, prevInfos.length);
                System.arraycopy(this.mAppendInfos, 0, infos, prevInfos.length, this.mAppendInfos.length);
                this.mLocalInfos = infos;
            }
            return (VerificationTypeInfo[])this.mLocalInfos.clone();
        }

        @Override
        public VerificationTypeInfo[] getStackItemInfos() {
            return VerificationTypeInfo.EMPTY_ARRAY;
        }

        @Override
        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(251 + this.mAppendInfos.length);
            dout.writeShort(this.mOffsetDelta);
            VerificationTypeInfo[] verificationTypeInfoArray = this.mAppendInfos;
            int n = this.mAppendInfos.length;
            int n2 = 0;
            while (n2 < n) {
                VerificationTypeInfo info = verificationTypeInfoArray[n2];
                info.writeTo(dout);
                ++n2;
            }
        }
    }

    private static class ChopFrame
    extends StackMapFrame {
        private final int mOffsetDelta;
        private final int mChop;
        private transient VerificationTypeInfo[] mLocalInfos;

        ChopFrame(StackMapFrame prev, int chop, DataInput din) throws IOException {
            super(prev);
            this.mOffsetDelta = din.readUnsignedShort();
            this.mChop = chop;
        }

        @Override
        public int getLength() {
            return 3;
        }

        @Override
        public int getOffsetDelta() {
            return this.mOffsetDelta;
        }

        @Override
        public VerificationTypeInfo[] getLocalInfos() {
            if (this.mLocalInfos == null) {
                VerificationTypeInfo[] prevInfos = this.getPrevious().getLocalInfos();
                VerificationTypeInfo[] infos = new VerificationTypeInfo[prevInfos.length - this.mChop];
                System.arraycopy(prevInfos, 0, infos, 0, infos.length);
                this.mLocalInfos = infos;
            }
            return (VerificationTypeInfo[])this.mLocalInfos.clone();
        }

        @Override
        public VerificationTypeInfo[] getStackItemInfos() {
            return VerificationTypeInfo.EMPTY_ARRAY;
        }

        @Override
        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(251 - this.mChop);
            dout.writeShort(this.mOffsetDelta);
        }
    }

    private static class DoubleVariableInfo
    extends VerificationTypeInfo {
        static final DoubleVariableInfo THE = new DoubleVariableInfo();

        private DoubleVariableInfo() {
        }

        @Override
        public TypeDesc getType() {
            return TypeDesc.DOUBLE;
        }

        @Override
        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(3);
        }
    }

    private static class FloatVariableInfo
    extends VerificationTypeInfo {
        static final FloatVariableInfo THE = new FloatVariableInfo();

        private FloatVariableInfo() {
        }

        @Override
        public TypeDesc getType() {
            return TypeDesc.FLOAT;
        }

        @Override
        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(2);
        }
    }

    private static class FullFrame
    extends StackMapFrame {
        private final int mOffsetDelta;
        private final VerificationTypeInfo[] mLocalInfos;
        private final VerificationTypeInfo[] mStackItemInfos;

        FullFrame(StackMapFrame prev, ConstantPool cp, DataInput din) throws IOException {
            super(prev);
            this.mOffsetDelta = din.readUnsignedShort();
            int numLocals = din.readUnsignedShort();
            this.mLocalInfos = VerificationTypeInfo.read(cp, din, numLocals);
            int numStackItems = din.readUnsignedShort();
            this.mStackItemInfos = VerificationTypeInfo.read(cp, din, numStackItems);
        }

        @Override
        public int getLength() {
            VerificationTypeInfo info;
            int length = 7;
            VerificationTypeInfo[] verificationTypeInfoArray = this.mLocalInfos;
            int n = this.mLocalInfos.length;
            int n2 = 0;
            while (n2 < n) {
                info = verificationTypeInfoArray[n2];
                length += info.getLength();
                ++n2;
            }
            verificationTypeInfoArray = this.mStackItemInfos;
            n = this.mStackItemInfos.length;
            n2 = 0;
            while (n2 < n) {
                info = verificationTypeInfoArray[n2];
                length += info.getLength();
                ++n2;
            }
            return length;
        }

        @Override
        public int getOffsetDelta() {
            return this.mOffsetDelta;
        }

        @Override
        public VerificationTypeInfo[] getLocalInfos() {
            return (VerificationTypeInfo[])this.mLocalInfos.clone();
        }

        @Override
        public VerificationTypeInfo[] getStackItemInfos() {
            return (VerificationTypeInfo[])this.mStackItemInfos.clone();
        }

        @Override
        public void writeTo(DataOutput dout) throws IOException {
            VerificationTypeInfo info;
            dout.writeByte(255);
            dout.writeShort(this.mOffsetDelta);
            dout.writeShort(this.mLocalInfos.length);
            VerificationTypeInfo[] verificationTypeInfoArray = this.mLocalInfos;
            int n = this.mLocalInfos.length;
            int n2 = 0;
            while (n2 < n) {
                info = verificationTypeInfoArray[n2];
                info.writeTo(dout);
                ++n2;
            }
            dout.writeShort(this.mStackItemInfos.length);
            verificationTypeInfoArray = this.mStackItemInfos;
            n = this.mStackItemInfos.length;
            n2 = 0;
            while (n2 < n) {
                info = verificationTypeInfoArray[n2];
                info.writeTo(dout);
                ++n2;
            }
        }
    }

    private static class InitialFrame
    extends StackMapFrame {
        private VerificationTypeInfo[] mLocalInfos;

        InitialFrame() {
            super(null);
            this.mOffset = 0;
        }

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public int getOffsetDelta() {
            return 0;
        }

        @Override
        public VerificationTypeInfo[] getLocalInfos() {
            if (this.mLocalInfos == null) {
                return VerificationTypeInfo.EMPTY_ARRAY;
            }
            return (VerificationTypeInfo[])this.mLocalInfos.clone();
        }

        @Override
        public VerificationTypeInfo[] getStackItemInfos() {
            return VerificationTypeInfo.EMPTY_ARRAY;
        }

        @Override
        public void writeTo(DataOutput dout) {
        }

        void set(ConstantPool cp, MethodInfo info) {
            int offset;
            VerificationTypeInfo[] infos;
            TypeDesc[] paramTypes = info.getMethodDescriptor().getParameterTypes();
            if (info.getModifiers().isStatic()) {
                infos = new VerificationTypeInfo[paramTypes.length];
                offset = 0;
            } else {
                infos = new VerificationTypeInfo[1 + paramTypes.length];
                infos[0] = info.getName().equals("<init>") ? UninitThisVariableInfo.THE : VerificationTypeInfo.forType(cp, info.getClassFile().getType());
                offset = 1;
            }
            int i = 0;
            while (i < paramTypes.length) {
                infos[offset + i] = VerificationTypeInfo.forType(cp, paramTypes[i]);
                ++i;
            }
            this.mLocalInfos = infos;
        }
    }

    private static class IntegerVariableInfo
    extends VerificationTypeInfo {
        static final IntegerVariableInfo THE = new IntegerVariableInfo();

        private IntegerVariableInfo() {
        }

        @Override
        public TypeDesc getType() {
            return TypeDesc.INT;
        }

        @Override
        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(1);
        }
    }

    private static class LongVariableInfo
    extends VerificationTypeInfo {
        static final LongVariableInfo THE = new LongVariableInfo();

        private LongVariableInfo() {
        }

        @Override
        public TypeDesc getType() {
            return TypeDesc.LONG;
        }

        @Override
        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(4);
        }
    }

    private static class NullVariableInfo
    extends VerificationTypeInfo {
        static final NullVariableInfo THE = new NullVariableInfo();

        private NullVariableInfo() {
        }

        @Override
        public TypeDesc getType() {
            return null;
        }

        @Override
        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(5);
        }

        @Override
        public String toString() {
            return "<null>";
        }
    }

    private static class ObjectVariableInfo
    extends VerificationTypeInfo {
        private final ConstantClassInfo mClassInfo;

        ObjectVariableInfo(ConstantPool cp, DataInput din) throws IOException {
            this.mClassInfo = (ConstantClassInfo)cp.getConstant(din.readUnsignedShort());
        }

        ObjectVariableInfo(ConstantPool cp, TypeDesc desc) {
            this.mClassInfo = cp.addConstantClass(desc);
        }

        @Override
        public int getLength() {
            return 3;
        }

        @Override
        public TypeDesc getType() {
            return this.mClassInfo.getType();
        }

        @Override
        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(7);
            dout.writeShort(this.mClassInfo.getIndex());
        }
    }

    private static class SameFrame
    extends StackMapFrame {
        private final int mOffsetDelta;

        SameFrame(StackMapFrame prev, int offsetDelta) {
            super(prev);
            this.mOffsetDelta = offsetDelta;
        }

        @Override
        public int getLength() {
            return 1;
        }

        @Override
        public int getOffsetDelta() {
            return this.mOffsetDelta;
        }

        @Override
        public VerificationTypeInfo[] getLocalInfos() {
            return this.getPrevious().getLocalInfos();
        }

        @Override
        public VerificationTypeInfo[] getStackItemInfos() {
            return VerificationTypeInfo.EMPTY_ARRAY;
        }

        @Override
        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(this.mOffsetDelta);
        }
    }

    private static class SameFrameExtended
    extends StackMapFrame {
        private final int mOffsetDelta;

        SameFrameExtended(StackMapFrame prev, DataInput din) throws IOException {
            super(prev);
            this.mOffsetDelta = din.readUnsignedShort();
        }

        @Override
        public int getLength() {
            return 3;
        }

        @Override
        public int getOffsetDelta() {
            return this.mOffsetDelta;
        }

        @Override
        public VerificationTypeInfo[] getLocalInfos() {
            return this.getPrevious().getLocalInfos();
        }

        @Override
        public VerificationTypeInfo[] getStackItemInfos() {
            return VerificationTypeInfo.EMPTY_ARRAY;
        }

        @Override
        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(251);
            dout.writeShort(this.mOffsetDelta);
        }
    }

    private static class SameLocalsOneStackItemFrame
    extends StackMapFrame {
        private final int mOffsetDelta;
        private final VerificationTypeInfo mStackItemInfo;

        SameLocalsOneStackItemFrame(StackMapFrame prev, int offsetDelta, ConstantPool cp, DataInput din) throws IOException {
            super(prev);
            this.mOffsetDelta = offsetDelta;
            this.mStackItemInfo = VerificationTypeInfo.read(cp, din);
        }

        @Override
        public int getLength() {
            return 1 + this.mStackItemInfo.getLength();
        }

        @Override
        public int getOffsetDelta() {
            return this.mOffsetDelta;
        }

        @Override
        public VerificationTypeInfo[] getLocalInfos() {
            return this.getPrevious().getLocalInfos();
        }

        @Override
        public VerificationTypeInfo[] getStackItemInfos() {
            return new VerificationTypeInfo[]{this.mStackItemInfo};
        }

        @Override
        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(64 + this.mOffsetDelta);
            this.mStackItemInfo.writeTo(dout);
        }
    }

    private static class SameLocalsOneStackItemFrameExtended
    extends StackMapFrame {
        private final int mOffsetDelta;
        private final VerificationTypeInfo mStackItemInfo;

        SameLocalsOneStackItemFrameExtended(StackMapFrame prev, ConstantPool cp, DataInput din) throws IOException {
            super(prev);
            this.mOffsetDelta = din.readUnsignedShort();
            this.mStackItemInfo = VerificationTypeInfo.read(cp, din);
        }

        @Override
        public int getLength() {
            return 3 + this.mStackItemInfo.getLength();
        }

        @Override
        public int getOffsetDelta() {
            return this.mOffsetDelta;
        }

        @Override
        public VerificationTypeInfo[] getLocalInfos() {
            return this.getPrevious().getLocalInfos();
        }

        @Override
        public VerificationTypeInfo[] getStackItemInfos() {
            return new VerificationTypeInfo[]{this.mStackItemInfo};
        }

        @Override
        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(257);
            dout.writeShort(this.mOffsetDelta);
            this.mStackItemInfo.writeTo(dout);
        }
    }

    public static abstract class StackMapFrame {
        private final StackMapFrame mPrev;
        private StackMapFrame mNext;
        int mOffset = -1;

        static StackMapFrame read(StackMapFrame prev, ConstantPool cp, DataInput din) throws IOException {
            int frameType = din.readUnsignedByte();
            if (frameType <= 63) {
                return new SameFrame(prev, frameType);
            }
            if (frameType <= 127) {
                return new SameLocalsOneStackItemFrame(prev, frameType - 64, cp, din);
            }
            if (frameType <= 246) {
                return null;
            }
            if (frameType == 247) {
                return new SameLocalsOneStackItemFrameExtended(prev, cp, din);
            }
            if (frameType <= 250) {
                return new ChopFrame(prev, 251 - frameType, din);
            }
            if (frameType == 251) {
                return new SameFrameExtended(prev, din);
            }
            if (frameType <= 254) {
                return new AppendFrame(prev, frameType - 251, cp, din);
            }
            return new FullFrame(prev, cp, din);
        }

        StackMapFrame(StackMapFrame prev) {
            this.mPrev = prev;
            if (this.mPrev != null) {
                prev.mNext = this;
            }
        }

        public abstract int getLength();

        public abstract int getOffsetDelta();

        public int getOffset() {
            if (this.mOffset < 0) {
                this.mOffset = this.mPrev == null || this.mPrev instanceof InitialFrame ? this.getOffsetDelta() : this.mPrev.getOffset() + 1 + this.getOffsetDelta();
            }
            return this.mOffset;
        }

        public abstract VerificationTypeInfo[] getLocalInfos();

        public abstract VerificationTypeInfo[] getStackItemInfos();

        public StackMapFrame getPrevious() {
            return this.mPrev;
        }

        public StackMapFrame getNext() {
            return this.mNext;
        }

        public abstract void writeTo(DataOutput var1) throws IOException;
    }

    private static class TopVariableInfo
    extends VerificationTypeInfo {
        static final TopVariableInfo THE = new TopVariableInfo();

        private TopVariableInfo() {
        }

        @Override
        public TypeDesc getType() {
            return null;
        }

        @Override
        public boolean isTop() {
            return true;
        }

        @Override
        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(0);
        }

        @Override
        public String toString() {
            return "<top>";
        }
    }

    private static class UninitThisVariableInfo
    extends VerificationTypeInfo {
        static final UninitThisVariableInfo THE = new UninitThisVariableInfo();

        private UninitThisVariableInfo() {
        }

        @Override
        public TypeDesc getType() {
            return null;
        }

        @Override
        public boolean isThis() {
            return true;
        }

        @Override
        public boolean isUninitialized() {
            return true;
        }

        @Override
        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(6);
        }

        @Override
        public String toString() {
            return "<uninitialized this>";
        }
    }

    private static class UninitVariableInfo
    extends VerificationTypeInfo {
        private final int mOffset;

        UninitVariableInfo(ConstantPool cp, DataInput din) throws IOException {
            this.mOffset = din.readUnsignedShort();
        }

        @Override
        public int getLength() {
            return 3;
        }

        @Override
        public TypeDesc getType() {
            return null;
        }

        @Override
        public boolean isUninitialized() {
            return true;
        }

        @Override
        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(8);
            dout.writeShort(this.mOffset);
        }

        @Override
        public String toString() {
            return "<uninitialized>";
        }
    }

    public static abstract class VerificationTypeInfo {
        static final VerificationTypeInfo[] EMPTY_ARRAY = new VerificationTypeInfo[0];

        static VerificationTypeInfo read(ConstantPool cp, DataInput din) throws IOException {
            int type = din.readUnsignedByte();
            switch (type) {
                case 0: {
                    return TopVariableInfo.THE;
                }
                case 1: {
                    return IntegerVariableInfo.THE;
                }
                case 2: {
                    return FloatVariableInfo.THE;
                }
                case 3: {
                    return DoubleVariableInfo.THE;
                }
                case 4: {
                    return LongVariableInfo.THE;
                }
                case 5: {
                    return NullVariableInfo.THE;
                }
                case 6: {
                    return UninitThisVariableInfo.THE;
                }
                case 7: {
                    return new ObjectVariableInfo(cp, din);
                }
                case 8: {
                    return new UninitVariableInfo(cp, din);
                }
            }
            return null;
        }

        static VerificationTypeInfo forType(ConstantPool cp, TypeDesc type) {
            switch (type.getTypeCode()) {
                default: {
                    return TopVariableInfo.THE;
                }
                case 0: {
                    return new ObjectVariableInfo(cp, type);
                }
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    return IntegerVariableInfo.THE;
                }
                case 11: {
                    return LongVariableInfo.THE;
                }
                case 6: {
                    return FloatVariableInfo.THE;
                }
                case 7: 
            }
            return DoubleVariableInfo.THE;
        }

        private static VerificationTypeInfo[] read(ConstantPool cp, DataInput din, int num) throws IOException {
            VerificationTypeInfo[] infos = new VerificationTypeInfo[num];
            int i = 0;
            while (i < num) {
                infos[i] = VerificationTypeInfo.read(cp, din);
                ++i;
            }
            return infos;
        }

        VerificationTypeInfo() {
        }

        public int getLength() {
            return 1;
        }

        public abstract TypeDesc getType();

        public boolean isTop() {
            return false;
        }

        public boolean isThis() {
            return false;
        }

        public boolean isUninitialized() {
            return false;
        }

        public abstract void writeTo(DataOutput var1) throws IOException;

        public String toString() {
            return this.getType().getFullName();
        }
    }
}

