/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.cojen.classfile.Attribute;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.constant.ConstantUTFInfo;

public class SignatureAttr
extends Attribute {
    private final ConstantUTFInfo mSignature;

    public SignatureAttr(ConstantPool cp, ConstantUTFInfo signature) {
        this(cp, "Signature", signature);
    }

    public SignatureAttr(ConstantPool cp, String name, ConstantUTFInfo signature) {
        super(cp, name);
        this.mSignature = signature;
    }

    public SignatureAttr(ConstantPool cp, String name, int length, DataInput din) throws IOException {
        super(cp, name);
        int index = din.readUnsignedShort();
        if ((length -= 2) > 0) {
            din.skipBytes(length);
        }
        this.mSignature = (ConstantUTFInfo)cp.getConstant(index);
    }

    public ConstantUTFInfo getSignature() {
        return this.mSignature;
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public void writeDataTo(DataOutput dout) throws IOException {
        dout.writeShort(this.mSignature.getIndex());
    }
}

