/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.cojen.classfile.Attribute;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.FixedLocation;
import org.cojen.classfile.Location;

public class LineNumberTableAttr
extends Attribute {
    private List<Entry> mEntries = new ArrayList<Entry>();
    private boolean mClean = false;

    public LineNumberTableAttr(ConstantPool cp) {
        super(cp, "LineNumberTable");
    }

    public LineNumberTableAttr(ConstantPool cp, String name) {
        super(cp, name);
    }

    public LineNumberTableAttr(ConstantPool cp, String name, int length, DataInput din) throws IOException {
        super(cp, name);
        int size = din.readUnsignedShort();
        int i = 0;
        while (i < size) {
            int start_pc = din.readUnsignedShort();
            int line_number = din.readUnsignedShort();
            try {
                this.addEntry(new FixedLocation(start_pc), line_number);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++i;
        }
    }

    public int getLineNumber(Location start) {
        this.clean();
        int index = Collections.binarySearch(this.mEntries, new Entry(start, 0));
        if (index < 0 && (index = -index - 2) < 0) {
            return -1;
        }
        return this.mEntries.get((int)index).mLineNumber;
    }

    public void addEntry(Location start, int line_number) throws IllegalArgumentException {
        if (line_number < 0 || line_number > 65535) {
            throw new IllegalArgumentException("Value for line number out of valid range: " + line_number);
        }
        this.mEntries.add(new Entry(start, line_number));
        this.mClean = false;
    }

    @Override
    public int getLength() {
        this.clean();
        return 2 + 4 * this.mEntries.size();
    }

    @Override
    public void writeDataTo(DataOutput dout) throws IOException {
        int size = this.mEntries.size();
        dout.writeShort(size);
        int i = 0;
        while (i < size) {
            Entry entry = this.mEntries.get(i);
            int start_pc = entry.mStart.getLocation();
            if (start_pc < 0 || start_pc > 65535) {
                throw new IllegalStateException("Value for line number table entry start PC out of valid range: " + start_pc);
            }
            dout.writeShort(start_pc);
            dout.writeShort(entry.mLineNumber);
            ++i;
        }
    }

    private void clean() {
        if (!this.mClean) {
            this.mClean = true;
            TreeSet<Entry> reduced = new TreeSet<Entry>();
            int i = this.mEntries.size();
            while (--i >= 0) {
                reduced.add(this.mEntries.get(i));
            }
            this.mEntries = new ArrayList<Entry>(reduced);
        }
    }

    private static class Entry
    implements Comparable<Entry> {
        public final Location mStart;
        public final int mLineNumber;

        public Entry(Location start, int line_number) {
            this.mStart = start;
            this.mLineNumber = line_number;
        }

        @Override
        public int compareTo(Entry other) {
            int thatLoc;
            int thisLoc = this.mStart.getLocation();
            if (thisLoc < (thatLoc = other.mStart.getLocation())) {
                return -1;
            }
            if (thisLoc > thatLoc) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object other) {
            if (other instanceof Entry) {
                return this.mStart.getLocation() == ((Entry)other).mStart.getLocation();
            }
            return false;
        }

        public String toString() {
            return "start_pc=" + this.mStart.getLocation() + " => " + "line_number=" + this.mLineNumber;
        }
    }
}

