/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.cojen.classfile.Attribute;
import org.cojen.classfile.ConstantInfo;
import org.cojen.classfile.ConstantPool;

public class ConstantValueAttr
extends Attribute {
    private final ConstantInfo mConstant;

    public ConstantValueAttr(ConstantPool cp, ConstantInfo constant) {
        super(cp, "ConstantValue");
        this.mConstant = constant;
    }

    public ConstantValueAttr(ConstantPool cp, String name, ConstantInfo constant) {
        super(cp, name);
        this.mConstant = constant;
    }

    public ConstantValueAttr(ConstantPool cp, String name, int length, DataInput din) throws IOException {
        super(cp, name);
        int index = din.readUnsignedShort();
        if ((length -= 2) > 0) {
            din.skipBytes(length);
        }
        this.mConstant = cp.getConstant(index);
    }

    public ConstantInfo getConstant() {
        return this.mConstant;
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public void writeDataTo(DataOutput dout) throws IOException {
        dout.writeShort(this.mConstant.getIndex());
    }
}

