/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cojen.classfile.Attribute;
import org.cojen.classfile.AttributeFactory;
import org.cojen.classfile.CodeBuffer;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.ExceptionHandler;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.attribute.LineNumberTableAttr;
import org.cojen.classfile.attribute.LocalVariableTableAttr;
import org.cojen.classfile.attribute.StackMapTableAttr;

public class CodeAttr
extends Attribute {
    private CodeBuffer mCodeBuffer;
    private List<Attribute> mAttributes = new ArrayList<Attribute>(2);
    private LineNumberTableAttr mLineNumberTable;
    private LocalVariableTableAttr mLocalVariableTable;
    private LineNumberTableAttr mOldLineNumberTable;
    private LocalVariableTableAttr mOldLocalVariableTable;
    private StackMapTableAttr mOldStackMapTable;
    private StackMapTableAttr mStackMapTable;

    public CodeAttr(ConstantPool cp) {
        super(cp, "Code");
    }

    public CodeAttr(ConstantPool cp, String name) {
        super(cp, name);
    }

    public CodeAttr(ConstantPool cp, String name, int length, DataInput din, AttributeFactory attrFactory) throws IOException {
        super(cp, name);
        final int maxStackDepth = din.readUnsignedShort();
        final int maxLocals = din.readUnsignedShort();
        final byte[] byteCodes = new byte[din.readInt()];
        din.readFully(byteCodes);
        int exceptionHandlerCount = din.readUnsignedShort();
        final ExceptionHandler[] handlers = new ExceptionHandler[exceptionHandlerCount];
        int i = 0;
        while (i < exceptionHandlerCount) {
            handlers[i] = ExceptionHandler.readFrom(cp, din);
            ++i;
        }
        this.mCodeBuffer = new CodeBuffer(){

            @Override
            public int getMaxStackDepth() {
                return maxStackDepth;
            }

            @Override
            public int getMaxLocals() {
                return maxLocals;
            }

            @Override
            public byte[] getByteCodes() {
                return (byte[])byteCodes.clone();
            }

            @Override
            public ExceptionHandler[] getExceptionHandlers() {
                return (ExceptionHandler[])handlers.clone();
            }
        };
        int attributeCount = din.readUnsignedShort();
        int i2 = 0;
        while (i2 < attributeCount) {
            this.addAttribute(Attribute.readFrom(cp, din, attrFactory));
            ++i2;
        }
    }

    public CodeBuffer getCodeBuffer() {
        return this.mCodeBuffer;
    }

    public void setCodeBuffer(CodeBuffer code) {
        this.mCodeBuffer = code;
        this.mOldLineNumberTable = this.mLineNumberTable;
        this.mOldLocalVariableTable = this.mLocalVariableTable;
        this.mOldStackMapTable = this.mStackMapTable;
        this.mAttributes.remove(this.mLineNumberTable);
        this.mAttributes.remove(this.mLocalVariableTable);
        this.mAttributes.remove(this.mStackMapTable);
        this.mLineNumberTable = null;
        this.mLocalVariableTable = null;
        this.mStackMapTable = null;
    }

    public int getLineNumber(Location start) {
        LineNumberTableAttr table = this.mOldLineNumberTable;
        if (table == null) {
            table = this.mLineNumberTable;
        }
        if (table == null || start.getLocation() < 0) {
            return -1;
        }
        return table.getLineNumber(start);
    }

    public LocalVariable getLocalVariable(Location useLocation, int number) {
        int useLoc = useLocation.getLocation();
        if (useLoc < 0) {
            return null;
        }
        return this.getLocalVariable(useLoc, number);
    }

    public LocalVariable getLocalVariable(int useLocation, int number) {
        LocalVariableTableAttr table = this.mOldLocalVariableTable;
        if (table == null) {
            table = this.mLocalVariableTable;
        }
        if (table == null) {
            return null;
        }
        return table.getLocalVariable(useLocation, number);
    }

    public void mapLineNumber(Location start, int line_number) {
        if (this.mLineNumberTable == null) {
            this.addAttribute(new LineNumberTableAttr(this.getConstantPool()));
        }
        this.mLineNumberTable.addEntry(start, line_number);
    }

    public void localVariableUse(LocalVariable localVar) {
        if (this.mLocalVariableTable == null) {
            this.addAttribute(new LocalVariableTableAttr(this.getConstantPool()));
        }
        this.mLocalVariableTable.addEntry(localVar);
    }

    public StackMapTableAttr getStackMapTable() {
        return this.mStackMapTable;
    }

    public void initialStackMapFrame(MethodInfo method) {
        if (this.mStackMapTable != null) {
            this.mStackMapTable.initialStackMapFrame(method);
        }
    }

    public void addAttribute(Attribute attr) {
        if (attr instanceof LineNumberTableAttr) {
            if (this.mLineNumberTable != null) {
                this.mAttributes.remove(this.mLineNumberTable);
            }
            this.mLineNumberTable = (LineNumberTableAttr)attr;
        } else if (attr instanceof LocalVariableTableAttr) {
            if (this.mLocalVariableTable != null) {
                this.mAttributes.remove(this.mLocalVariableTable);
            }
            this.mLocalVariableTable = (LocalVariableTableAttr)attr;
        } else if (attr instanceof StackMapTableAttr) {
            if (this.mStackMapTable != null) {
                this.mAttributes.remove(this.mStackMapTable);
            }
            this.mStackMapTable = (StackMapTableAttr)attr;
        }
        this.mAttributes.add(attr);
    }

    @Override
    public Attribute[] getAttributes() {
        return this.mAttributes.toArray(new Attribute[this.mAttributes.size()]);
    }

    @Override
    public int getLength() {
        int length = 12;
        if (this.mCodeBuffer != null) {
            length += this.mCodeBuffer.getByteCodes().length;
            ExceptionHandler[] handlers = this.mCodeBuffer.getExceptionHandlers();
            if (handlers != null) {
                length += 8 * handlers.length;
            }
        }
        int size = this.mAttributes.size();
        int i = 0;
        while (i < size) {
            length += this.mAttributes.get(i).getLength();
            length += 6;
            ++i;
        }
        return length;
    }

    @Override
    public void writeDataTo(DataOutput dout) throws IOException {
        int i;
        if (this.mCodeBuffer == null) {
            throw new IllegalStateException("CodeAttr has no CodeBuffer set");
        }
        ExceptionHandler[] handlers = this.mCodeBuffer.getExceptionHandlers();
        dout.writeShort(this.mCodeBuffer.getMaxStackDepth());
        dout.writeShort(this.mCodeBuffer.getMaxLocals());
        byte[] byteCodes = this.mCodeBuffer.getByteCodes();
        dout.writeInt(byteCodes.length);
        dout.write(byteCodes);
        if (handlers != null) {
            int exceptionHandlerCount = handlers.length;
            dout.writeShort(exceptionHandlerCount);
            i = 0;
            while (i < exceptionHandlerCount) {
                handlers[i].writeTo(dout);
                ++i;
            }
        } else {
            dout.writeShort(0);
        }
        int size = this.mAttributes.size();
        dout.writeShort(size);
        i = 0;
        while (i < size) {
            Attribute attr = this.mAttributes.get(i);
            attr.writeTo(dout);
            ++i;
        }
        this.mOldLineNumberTable = null;
        this.mOldLocalVariableTable = null;
        this.mOldStackMapTable = null;
    }
}

