/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cojen.classfile.ConstantInfo;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.TypeDesc;
import org.cojen.classfile.constant.ConstantDoubleInfo;
import org.cojen.classfile.constant.ConstantFloatInfo;
import org.cojen.classfile.constant.ConstantIntegerInfo;
import org.cojen.classfile.constant.ConstantLongInfo;
import org.cojen.classfile.constant.ConstantUTFInfo;

public class Annotation {
    public static final char MEMBER_TAG_BOOLEAN = 'Z';
    public static final char MEMBER_TAG_BYTE = 'B';
    public static final char MEMBER_TAG_SHORT = 'S';
    public static final char MEMBER_TAG_CHAR = 'C';
    public static final char MEMBER_TAG_INT = 'I';
    public static final char MEMBER_TAG_LONG = 'J';
    public static final char MEMBER_TAG_FLOAT = 'F';
    public static final char MEMBER_TAG_DOUBLE = 'D';
    public static final char MEMBER_TAG_STRING = 's';
    public static final char MEMBER_TAG_CLASS = 'c';
    public static final char MEMBER_TAG_ENUM = 'e';
    public static final char MEMBER_TAG_ARRAY = '[';
    public static final char MEMBER_TAG_ANNOTATION = '@';
    private final ConstantPool mCp;
    private ConstantUTFInfo mType;
    private final Map<String, MemberValue> mMemberValues;

    public Annotation(ConstantPool cp) {
        this.mCp = cp;
        this.mMemberValues = new LinkedHashMap<String, MemberValue>(2);
    }

    public Annotation(ConstantPool cp, DataInput din) throws IOException {
        this.mCp = cp;
        this.mType = (ConstantUTFInfo)cp.getConstant(din.readUnsignedShort());
        int memberCount = din.readUnsignedShort();
        this.mMemberValues = new LinkedHashMap<String, MemberValue>(memberCount);
        int i = 0;
        while (i < memberCount) {
            String name = ((ConstantUTFInfo)cp.getConstant(din.readUnsignedShort())).getValue();
            this.mMemberValues.put(name, new MemberValue(cp, din));
            ++i;
        }
    }

    public ConstantUTFInfo getTypeConstant() {
        return this.mType;
    }

    public TypeDesc getType() {
        return TypeDesc.forDescriptor(this.mType.getValue());
    }

    public void setTypeConstant(ConstantUTFInfo type) {
        this.mType = type;
    }

    public void setType(TypeDesc type) {
        this.setTypeConstant(this.mCp.addConstantUTF(type.getDescriptor()));
    }

    public Map<String, MemberValue> getMemberValues() {
        return Collections.unmodifiableMap(this.mMemberValues);
    }

    public void putMemberValue(String name, MemberValue mv) {
        this.mCp.addConstantUTF(name);
        this.mMemberValues.put(name, mv);
    }

    public void putMemberValue(String name, boolean value) {
        this.mCp.addConstantUTF(name);
        this.mMemberValues.put(name, this.makeMemberValue(value));
    }

    public void putMemberValue(String name, byte value) {
        this.mCp.addConstantUTF(name);
        this.mMemberValues.put(name, this.makeMemberValue(value));
    }

    public void putMemberValue(String name, short value) {
        this.mCp.addConstantUTF(name);
        this.mMemberValues.put(name, this.makeMemberValue(value));
    }

    public void putMemberValue(String name, char value) {
        this.mCp.addConstantUTF(name);
        this.mMemberValues.put(name, this.makeMemberValue(value));
    }

    public void putMemberValue(String name, int value) {
        this.mCp.addConstantUTF(name);
        this.mMemberValues.put(name, this.makeMemberValue(value));
    }

    public void putMemberValue(String name, long value) {
        this.mCp.addConstantUTF(name);
        this.mMemberValues.put(name, this.makeMemberValue(value));
    }

    public void putMemberValue(String name, float value) {
        this.mCp.addConstantUTF(name);
        this.mMemberValues.put(name, this.makeMemberValue(value));
    }

    public void putMemberValue(String name, double value) {
        this.mCp.addConstantUTF(name);
        this.mMemberValues.put(name, this.makeMemberValue(value));
    }

    public void putMemberValue(String name, String value) {
        this.mCp.addConstantUTF(name);
        this.mMemberValues.put(name, this.makeMemberValue(value));
    }

    public void putMemberValue(String name, TypeDesc value) {
        this.mCp.addConstantUTF(name);
        this.mMemberValues.put(name, this.makeMemberValue(value));
    }

    public void putMemberValue(String name, MemberValue[] value) {
        this.mCp.addConstantUTF(name);
        this.mMemberValues.put(name, this.makeMemberValue(value));
    }

    public void putMemberValue(String name, TypeDesc enumType, String enumName) {
        this.mCp.addConstantUTF(name);
        this.mMemberValues.put(name, this.makeMemberValue(enumType, enumName));
    }

    public void putMemberValue(String name, Annotation value) {
        this.mCp.addConstantUTF(name);
        this.mMemberValues.put(name, this.makeMemberValue(value));
    }

    public MemberValue makeMemberValue(boolean value) {
        return new MemberValue('Z', this.mCp.addConstantInteger(value ? 1 : 0));
    }

    public MemberValue makeMemberValue(byte value) {
        return new MemberValue('B', this.mCp.addConstantInteger(value));
    }

    public MemberValue makeMemberValue(short value) {
        return new MemberValue('S', this.mCp.addConstantInteger(value));
    }

    public MemberValue makeMemberValue(char value) {
        return new MemberValue('C', this.mCp.addConstantInteger(value));
    }

    public MemberValue makeMemberValue(int value) {
        return new MemberValue('I', this.mCp.addConstantInteger(value));
    }

    public MemberValue makeMemberValue(long value) {
        return new MemberValue('J', this.mCp.addConstantLong(value));
    }

    public MemberValue makeMemberValue(float value) {
        return new MemberValue('F', this.mCp.addConstantFloat(value));
    }

    public MemberValue makeMemberValue(double value) {
        return new MemberValue('D', this.mCp.addConstantDouble(value));
    }

    public MemberValue makeMemberValue(String value) {
        return new MemberValue('s', this.mCp.addConstantUTF(value));
    }

    public MemberValue makeMemberValue(TypeDesc value) {
        return new MemberValue('c', this.mCp.addConstantUTF(value.getDescriptor()));
    }

    public MemberValue makeMemberValue(TypeDesc enumType, String enumName) {
        return new MemberValue('e', new EnumConstValue(this.mCp.addConstantUTF(enumType.getDescriptor()), this.mCp.addConstantUTF(enumName)));
    }

    public MemberValue makeMemberValue(MemberValue[] value) {
        return new MemberValue('[', value);
    }

    public MemberValue makeMemberValue(Annotation value) {
        return new MemberValue('@', value);
    }

    public Annotation makeAnnotation() {
        return new Annotation(this.mCp);
    }

    public int getLength() {
        int length = 4;
        for (MemberValue mv : this.mMemberValues.values()) {
            length += 2 + mv.getLength();
        }
        return length;
    }

    public void writeTo(DataOutput dout) throws IOException {
        dout.writeShort(this.mType.getIndex());
        int memberCount = this.mMemberValues.size();
        dout.writeShort(memberCount);
        for (Map.Entry<String, MemberValue> entry : this.mMemberValues.entrySet()) {
            dout.writeShort(this.mCp.addConstantUTF(entry.getKey()).getIndex());
            entry.getValue().writeTo(dout);
        }
    }

    public static class EnumConstValue {
        private final ConstantUTFInfo mTypeName;
        private final ConstantUTFInfo mConstName;

        public EnumConstValue(ConstantUTFInfo typeName, ConstantUTFInfo constName) {
            this.mTypeName = typeName;
            this.mConstName = constName;
        }

        public EnumConstValue(ConstantPool cp, DataInput din) throws IOException {
            this.mTypeName = (ConstantUTFInfo)cp.getConstant(din.readUnsignedShort());
            this.mConstName = (ConstantUTFInfo)cp.getConstant(din.readUnsignedShort());
        }

        public ConstantUTFInfo getTypeName() {
            return this.mTypeName;
        }

        public ConstantUTFInfo getConstName() {
            return this.mConstName;
        }

        public int getLength() {
            return 4;
        }

        public void writeTo(DataOutput dout) throws IOException {
            dout.writeShort(this.mTypeName.getIndex());
            dout.writeShort(this.mConstName.getIndex());
        }
    }

    public static class MemberValue {
        private final char mTag;
        private final Object mValue;

        public MemberValue(char tag, Object value) {
            this.mTag = tag;
            switch (this.mTag) {
                default: {
                    throw new IllegalArgumentException("Illegal annotation member value tag: " + this.mTag);
                }
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    if (value instanceof ConstantIntegerInfo) {
                        this.mValue = value;
                        break;
                    }
                    throw new IllegalArgumentException("Value must be ConstantIntegerInfo");
                }
                case 'J': {
                    if (value instanceof ConstantLongInfo) {
                        this.mValue = value;
                        break;
                    }
                    throw new IllegalArgumentException("Value must be ConstantLongInfo");
                }
                case 'F': {
                    if (value instanceof ConstantFloatInfo) {
                        this.mValue = value;
                        break;
                    }
                    throw new IllegalArgumentException("Value must be ConstantFloatInfo");
                }
                case 'D': {
                    if (value instanceof ConstantDoubleInfo) {
                        this.mValue = value;
                        break;
                    }
                    throw new IllegalArgumentException("Value must be ConstantDoubleInfo");
                }
                case 'c': {
                    if (value instanceof ConstantUTFInfo) {
                        this.mValue = value;
                        break;
                    }
                    throw new IllegalArgumentException("Value must be ConstantUTFInfo");
                }
                case 's': {
                    if (value instanceof ConstantUTFInfo) {
                        this.mValue = value;
                        break;
                    }
                    throw new IllegalArgumentException("Value must be ConstantUTFInfo");
                }
                case 'e': {
                    if (value instanceof EnumConstValue) {
                        this.mValue = value;
                        break;
                    }
                    throw new IllegalArgumentException("Value must be EnumConstValue");
                }
                case '[': {
                    if (value instanceof MemberValue[]) {
                        this.mValue = value;
                        break;
                    }
                    throw new IllegalArgumentException("Value must be MemberValue[]");
                }
                case '@': {
                    if (value instanceof Annotation) {
                        this.mValue = value;
                        break;
                    }
                    throw new IllegalArgumentException("Value must be Annotation");
                }
            }
        }

        public MemberValue(ConstantPool cp, DataInput din) throws IOException {
            this.mTag = (char)din.readUnsignedByte();
            switch (this.mTag) {
                default: {
                    throw new IllegalStateException("Illegal annotation member value tag: " + this.mTag);
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': 
                case 'c': 
                case 's': {
                    this.mValue = cp.getConstant(din.readUnsignedShort());
                    break;
                }
                case 'e': {
                    this.mValue = new EnumConstValue(cp, din);
                    break;
                }
                case '[': {
                    int length = din.readUnsignedShort();
                    MemberValue[] values = new MemberValue[length];
                    int i = 0;
                    while (i < length) {
                        values[i] = new MemberValue(cp, din);
                        ++i;
                    }
                    this.mValue = values;
                    break;
                }
                case '@': {
                    this.mValue = new Annotation(cp, din);
                }
            }
        }

        public char getTag() {
            return this.mTag;
        }

        public Object getValue() {
            return this.mValue;
        }

        public int getLength() {
            switch (this.mTag) {
                default: {
                    return 1;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': 
                case 'c': 
                case 's': {
                    return 3;
                }
                case 'e': {
                    return 1 + ((EnumConstValue)this.mValue).getLength();
                }
                case '[': {
                    MemberValue[] values = (MemberValue[])this.mValue;
                    int length = 3;
                    int i = 0;
                    while (i < values.length) {
                        length += values[i].getLength();
                        ++i;
                    }
                    return length;
                }
                case '@': 
            }
            return 1 + ((Annotation)this.mValue).getLength();
        }

        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(this.mTag);
            switch (this.mTag) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': 
                case 'c': 
                case 's': {
                    dout.writeShort(((ConstantInfo)this.mValue).getIndex());
                    break;
                }
                case 'e': {
                    ((EnumConstValue)this.mValue).writeTo(dout);
                    break;
                }
                case '[': {
                    MemberValue[] values = (MemberValue[])this.mValue;
                    dout.writeShort(values.length);
                    int i = 0;
                    while (i < values.length) {
                        values[i].writeTo(dout);
                        ++i;
                    }
                    break;
                }
                case '@': {
                    ((Annotation)this.mValue).writeTo(dout);
                }
            }
        }
    }
}

