/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import java.util.Set;
import org.cojen.classfile.AbstractCodeAssembler;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.LocationRange;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.TypeDesc;

public class NullCodeAssembler
extends AbstractCodeAssembler {
    private final MethodInfo mMethod;
    private final LocalVariable[] mParams;
    private int mInstrCount;

    public NullCodeAssembler(MethodInfo mi) {
        this.mMethod = mi;
        TypeDesc[] paramTypes = this.mMethod.getMethodDescriptor().getParameterTypes();
        this.mParams = new LocalVariable[paramTypes.length];
        int i = 0;
        while (i < paramTypes.length) {
            this.mParams[i] = new Variable(null, paramTypes[i]);
            ++i;
        }
    }

    protected int getInstructionsSeen() {
        return this.mInstrCount;
    }

    @Override
    public int getParameterCount() {
        return this.mMethod.getMethodDescriptor().getParameterCount();
    }

    @Override
    public LocalVariable getParameter(int index) {
        return this.mParams[index];
    }

    @Override
    public LocalVariable createLocalVariable(String name, TypeDesc type) {
        return new Variable(name, type);
    }

    @Override
    public Label createLabel() {
        return new DummyLabel();
    }

    @Override
    public void exceptionHandler(Location startLocation, Location endLocation, String catchClassName) {
    }

    @Override
    public void mapLineNumber(int lineNumber) {
    }

    @Override
    public void loadNull() {
        ++this.mInstrCount;
    }

    @Override
    public void loadConstant(String value) {
        ++this.mInstrCount;
    }

    @Override
    public void loadConstant(TypeDesc type) {
        ++this.mInstrCount;
    }

    @Override
    public void loadConstant(boolean value) {
        ++this.mInstrCount;
    }

    @Override
    public void loadConstant(int value) {
        ++this.mInstrCount;
    }

    @Override
    public void loadConstant(long value) {
        ++this.mInstrCount;
    }

    @Override
    public void loadConstant(float value) {
        ++this.mInstrCount;
    }

    @Override
    public void loadConstant(double value) {
        ++this.mInstrCount;
    }

    @Override
    public void loadLocal(LocalVariable local) {
        ++this.mInstrCount;
    }

    @Override
    public void loadThis() {
        ++this.mInstrCount;
    }

    @Override
    public void storeLocal(LocalVariable local) {
        ++this.mInstrCount;
    }

    @Override
    public void loadFromArray(TypeDesc type) {
        ++this.mInstrCount;
    }

    @Override
    public void storeToArray(TypeDesc type) {
        ++this.mInstrCount;
    }

    @Override
    public void loadField(String fieldName, TypeDesc type) {
        ++this.mInstrCount;
    }

    @Override
    public void loadField(String className, String fieldName, TypeDesc type) {
        ++this.mInstrCount;
    }

    @Override
    public void loadField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        ++this.mInstrCount;
    }

    @Override
    public void loadStaticField(String fieldName, TypeDesc type) {
        ++this.mInstrCount;
    }

    @Override
    public void loadStaticField(String className, String fieldName, TypeDesc type) {
        ++this.mInstrCount;
    }

    @Override
    public void loadStaticField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        ++this.mInstrCount;
    }

    @Override
    public void storeField(String fieldName, TypeDesc type) {
        ++this.mInstrCount;
    }

    @Override
    public void storeField(String className, String fieldName, TypeDesc type) {
        ++this.mInstrCount;
    }

    @Override
    public void storeField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        ++this.mInstrCount;
    }

    @Override
    public void storeStaticField(String fieldName, TypeDesc type) {
        ++this.mInstrCount;
    }

    @Override
    public void storeStaticField(String className, String fieldName, TypeDesc type) {
        ++this.mInstrCount;
    }

    @Override
    public void storeStaticField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        ++this.mInstrCount;
    }

    @Override
    public void returnVoid() {
        ++this.mInstrCount;
    }

    @Override
    public void returnValue(TypeDesc type) {
        ++this.mInstrCount;
    }

    @Override
    public void convert(TypeDesc fromType, TypeDesc toType) {
        ++this.mInstrCount;
    }

    @Override
    public void convert(TypeDesc fromType, TypeDesc toType, int fpConvertMode) {
        ++this.mInstrCount;
    }

    @Override
    public void invokeVirtual(String methodName, TypeDesc ret, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    @Override
    public void invokeVirtual(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    @Override
    public void invokeVirtual(TypeDesc classDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    @Override
    public void invokeStatic(String methodName, TypeDesc ret, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    @Override
    public void invokeStatic(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    @Override
    public void invokeStatic(TypeDesc classDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    @Override
    public void invokeInterface(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    @Override
    public void invokeInterface(TypeDesc classDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    @Override
    public void invokePrivate(String methodName, TypeDesc ret, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    @Override
    public void invokeSuper(String superClassName, String methodName, TypeDesc ret, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    @Override
    public void invokeSuper(TypeDesc superClassDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    @Override
    public void invokeConstructor(TypeDesc[] params) {
        ++this.mInstrCount;
    }

    @Override
    public void invokeConstructor(String className, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    @Override
    public void invokeConstructor(TypeDesc classDesc, TypeDesc[] params) {
        ++this.mInstrCount;
    }

    @Override
    public void invokeSuperConstructor(TypeDesc[] params) {
        ++this.mInstrCount;
    }

    @Override
    public void newObject(TypeDesc type) {
        ++this.mInstrCount;
    }

    @Override
    public void newObject(TypeDesc type, int dimensions) {
        ++this.mInstrCount;
    }

    @Override
    public void dup() {
        ++this.mInstrCount;
    }

    @Override
    public void dupX1() {
        ++this.mInstrCount;
    }

    @Override
    public void dupX2() {
        ++this.mInstrCount;
    }

    @Override
    public void dup2() {
        ++this.mInstrCount;
    }

    @Override
    public void dup2X1() {
        ++this.mInstrCount;
    }

    @Override
    public void dup2X2() {
        ++this.mInstrCount;
    }

    @Override
    public void pop() {
        ++this.mInstrCount;
    }

    @Override
    public void pop2() {
        ++this.mInstrCount;
    }

    @Override
    public void swap() {
        ++this.mInstrCount;
    }

    @Override
    public void swap2() {
        ++this.mInstrCount;
    }

    @Override
    public void branch(Location location) {
        ++this.mInstrCount;
    }

    @Override
    public void ifNullBranch(Location location, boolean choice) {
        ++this.mInstrCount;
    }

    @Override
    public void ifEqualBranch(Location location, boolean choice) {
        ++this.mInstrCount;
    }

    @Override
    public void ifZeroComparisonBranch(Location location, String choice) {
        ++this.mInstrCount;
    }

    @Override
    public void ifComparisonBranch(Location location, String choice) {
        ++this.mInstrCount;
    }

    @Override
    public void switchBranch(int[] cases, Location[] locations, Location defaultLocation) {
        ++this.mInstrCount;
    }

    @Override
    public void jsr(Location location) {
        ++this.mInstrCount;
    }

    @Override
    public void ret(LocalVariable local) {
        ++this.mInstrCount;
    }

    @Override
    public void math(byte opcode) {
        ++this.mInstrCount;
    }

    @Override
    public void arrayLength() {
        ++this.mInstrCount;
    }

    @Override
    public void throwObject() {
        ++this.mInstrCount;
    }

    @Override
    public void checkCast(TypeDesc type) {
        ++this.mInstrCount;
    }

    @Override
    public void instanceOf(TypeDesc type) {
        ++this.mInstrCount;
    }

    @Override
    public void integerIncrement(LocalVariable local, int amount) {
        ++this.mInstrCount;
    }

    @Override
    public void monitorEnter() {
        ++this.mInstrCount;
    }

    @Override
    public void monitorExit() {
        ++this.mInstrCount;
    }

    @Override
    public void nop() {
        ++this.mInstrCount;
    }

    @Override
    public void breakpoint() {
        ++this.mInstrCount;
    }

    private static class DummyLabel
    implements Label {
        DummyLabel() {
        }

        @Override
        public Label setLocation() {
            return this;
        }

        @Override
        public int getLocation() {
            return -1;
        }

        @Override
        public int compareTo(Location loc) {
            return 0;
        }
    }

    private static class Variable
    implements LocalVariable {
        private String mName;
        private final TypeDesc mType;

        Variable(String name, TypeDesc type) {
            this.mName = name;
            this.mType = type;
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        public void setName(String name) {
            this.mName = name;
        }

        @Override
        public TypeDesc getType() {
            return this.mType;
        }

        @Override
        public boolean isDoubleWord() {
            return this.getType().isDoubleWord();
        }

        @Override
        public int getNumber() {
            return -1;
        }

        @Override
        public Set<LocationRange> getLocationRangeSet() {
            return null;
        }
    }
}

