/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cojen.classfile.Attribute;
import org.cojen.classfile.AttributeFactory;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.MethodDesc;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.cojen.classfile.attribute.Annotation;
import org.cojen.classfile.attribute.AnnotationsAttr;
import org.cojen.classfile.attribute.CodeAttr;
import org.cojen.classfile.attribute.DeprecatedAttr;
import org.cojen.classfile.attribute.EnclosingMethodAttr;
import org.cojen.classfile.attribute.ExceptionsAttr;
import org.cojen.classfile.attribute.RuntimeInvisibleAnnotationsAttr;
import org.cojen.classfile.attribute.RuntimeVisibleAnnotationsAttr;
import org.cojen.classfile.attribute.SignatureAttr;
import org.cojen.classfile.attribute.SyntheticAttr;
import org.cojen.classfile.constant.ConstantClassInfo;
import org.cojen.classfile.constant.ConstantUTFInfo;

public class MethodInfo {
    private ClassFile mParent;
    private ConstantPool mCp;
    private String mName;
    private MethodDesc mDesc;
    private Modifiers mModifiers;
    private ConstantUTFInfo mNameConstant;
    private ConstantUTFInfo mDescriptorConstant;
    private List<Attribute> mAttributes = new ArrayList<Attribute>(2);
    private CodeAttr mCode;
    private ExceptionsAttr mExceptions;
    private int mAnonymousInnerClassCount = 0;

    MethodInfo(ClassFile parent, Modifiers modifiers, String name, MethodDesc desc) {
        this.mParent = parent;
        this.mCp = parent.getConstantPool();
        this.mName = name;
        this.mDesc = desc;
        this.mModifiers = modifiers;
        this.mNameConstant = this.mCp.addConstantUTF(name);
        this.mDescriptorConstant = this.mCp.addConstantUTF(desc.getDescriptor());
        if (!modifiers.isAbstract() && !modifiers.isNative()) {
            this.addAttribute(new CodeAttr(this.mCp));
        }
    }

    private MethodInfo(ClassFile parent, int modifier, ConstantUTFInfo nameConstant, ConstantUTFInfo descConstant) {
        this.mParent = parent;
        this.mCp = parent.getConstantPool();
        this.mName = nameConstant.getValue();
        this.mDesc = MethodDesc.forDescriptor(descConstant.getValue());
        this.mModifiers = Modifiers.getInstance(modifier);
        this.mNameConstant = nameConstant;
        this.mDescriptorConstant = descConstant;
    }

    public ClassFile getClassFile() {
        return this.mParent;
    }

    public String getName() {
        return this.mName;
    }

    public MethodDesc getMethodDescriptor() {
        return this.mDesc;
    }

    public Modifiers getModifiers() {
        return this.mModifiers;
    }

    public void setModifiers(Modifiers modifiers) {
        this.mModifiers = modifiers;
    }

    public ConstantUTFInfo getNameConstant() {
        return this.mNameConstant;
    }

    public ConstantUTFInfo getDescriptorConstant() {
        return this.mDescriptorConstant;
    }

    public TypeDesc[] getExceptions() {
        if (this.mExceptions == null) {
            return new TypeDesc[0];
        }
        ConstantClassInfo[] classes = this.mExceptions.getExceptions();
        TypeDesc[] types = new TypeDesc[classes.length];
        int i = 0;
        while (i < types.length) {
            types[i] = classes[i].getType();
            ++i;
        }
        return types;
    }

    public CodeAttr getCodeAttr() {
        return this.mCode;
    }

    public boolean isSynthetic() {
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Attribute attr = this.mAttributes.get(i);
            if (!(attr instanceof SyntheticAttr)) continue;
            return true;
        }
        return false;
    }

    public boolean isDeprecated() {
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Attribute attr = this.mAttributes.get(i);
            if (!(attr instanceof DeprecatedAttr)) continue;
            return true;
        }
        return false;
    }

    public Annotation[] getRuntimeInvisibleAnnotations() {
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Attribute attr = this.mAttributes.get(i);
            if (!(attr instanceof RuntimeInvisibleAnnotationsAttr)) continue;
            return ((AnnotationsAttr)attr).getAnnotations();
        }
        return new Annotation[0];
    }

    public Annotation[] getRuntimeVisibleAnnotations() {
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Attribute attr = this.mAttributes.get(i);
            if (!(attr instanceof RuntimeVisibleAnnotationsAttr)) continue;
            return ((AnnotationsAttr)attr).getAnnotations();
        }
        return new Annotation[0];
    }

    public Annotation addRuntimeInvisibleAnnotation(TypeDesc type) {
        AnnotationsAttr attr = null;
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Attribute a = this.mAttributes.get(i);
            if (!(a instanceof RuntimeInvisibleAnnotationsAttr)) continue;
            attr = (AnnotationsAttr)a;
        }
        if (attr == null) {
            attr = new RuntimeInvisibleAnnotationsAttr(this.mCp);
            this.addAttribute(attr);
        }
        Annotation ann = new Annotation(this.mCp);
        ann.setType(type);
        attr.addAnnotation(ann);
        return ann;
    }

    public Annotation addRuntimeVisibleAnnotation(TypeDesc type) {
        AnnotationsAttr attr = null;
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Attribute a = this.mAttributes.get(i);
            if (!(a instanceof RuntimeVisibleAnnotationsAttr)) continue;
            attr = (AnnotationsAttr)a;
        }
        if (attr == null) {
            attr = new RuntimeVisibleAnnotationsAttr(this.mCp);
            this.addAttribute(attr);
        }
        Annotation ann = new Annotation(this.mCp);
        ann.setType(type);
        attr.addAnnotation(ann);
        return ann;
    }

    public SignatureAttr getSignatureAttr() {
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Attribute attr = this.mAttributes.get(i);
            if (!(attr instanceof SignatureAttr)) continue;
            return (SignatureAttr)attr;
        }
        return null;
    }

    public void addException(TypeDesc type) {
        if (this.mExceptions == null) {
            this.addAttribute(new ExceptionsAttr(this.mCp));
        }
        ConstantClassInfo cci = this.mCp.addConstantClass(type);
        this.mExceptions.addException(cci);
    }

    public ClassFile addInnerClass(String innerClassName) {
        return this.addInnerClass(innerClassName, (String)null);
    }

    public ClassFile addInnerClass(String innerClassName, Class superClass) {
        return this.addInnerClass(innerClassName, superClass.getName());
    }

    public ClassFile addInnerClass(String innerClassName, String superClassName) {
        ClassFile inner;
        if (innerClassName == null) {
            inner = this.mParent.addInnerClass(null, null, superClassName);
        } else {
            String fullInnerClassName = String.valueOf(this.mParent.getClassName()) + '$' + ++this.mAnonymousInnerClassCount + innerClassName;
            inner = this.mParent.addInnerClass(fullInnerClassName, innerClassName, superClassName);
        }
        if (this.mParent.getMajorVersion() >= 49) {
            inner.addAttribute(new EnclosingMethodAttr(this.mCp, this.mCp.addConstantClass(this.mParent.getClassName()), this.mCp.addConstantNameAndType(this.mNameConstant, this.mDescriptorConstant)));
        }
        return inner;
    }

    public void markSynthetic() {
        this.addAttribute(new SyntheticAttr(this.mCp));
    }

    public void markDeprecated() {
        this.addAttribute(new DeprecatedAttr(this.mCp));
    }

    public void addAttribute(Attribute attr) {
        if (attr instanceof CodeAttr) {
            if (this.mCode != null) {
                this.mAttributes.remove(this.mCode);
            }
            this.mCode = (CodeAttr)attr;
            this.mCode.initialStackMapFrame(this);
        } else if (attr instanceof ExceptionsAttr) {
            if (this.mExceptions != null) {
                this.mAttributes.remove(this.mExceptions);
            }
            this.mExceptions = (ExceptionsAttr)attr;
        }
        this.mAttributes.add(attr);
    }

    public Attribute[] getAttributes() {
        return this.mAttributes.toArray(new Attribute[this.mAttributes.size()]);
    }

    public int getLength() {
        int length = 8;
        int size = this.mAttributes.size();
        int i = 0;
        while (i < size) {
            length += this.mAttributes.get(i).getLength();
            ++i;
        }
        return length;
    }

    public void writeTo(DataOutput dout) throws IOException {
        dout.writeShort(this.mModifiers.getBitmask());
        dout.writeShort(this.mNameConstant.getIndex());
        dout.writeShort(this.mDescriptorConstant.getIndex());
        int size = this.mAttributes.size();
        dout.writeShort(size);
        int i = 0;
        while (i < size) {
            Attribute attr = this.mAttributes.get(i);
            try {
                attr.writeTo(dout);
            }
            catch (IllegalStateException e) {
                IllegalStateException e2 = new IllegalStateException(String.valueOf(e.getMessage()) + ": " + this.toString());
                try {
                    e2.initCause(e);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw e2;
            }
            ++i;
        }
    }

    public String toString() {
        String str = this.mDesc.toMethodSignature(this.getName(), this.mModifiers.isVarArgs());
        String modStr = this.mModifiers.toString();
        if (modStr.length() > 0) {
            str = String.valueOf(modStr) + ' ' + str;
        }
        return str;
    }

    static MethodInfo readFrom(ClassFile parent, DataInput din, AttributeFactory attrFactory) throws IOException {
        ConstantPool cp = parent.getConstantPool();
        int modifier = din.readUnsignedShort();
        int index = din.readUnsignedShort();
        ConstantUTFInfo nameConstant = (ConstantUTFInfo)cp.getConstant(index);
        index = din.readUnsignedShort();
        ConstantUTFInfo descConstant = (ConstantUTFInfo)cp.getConstant(index);
        MethodInfo info = new MethodInfo(parent, modifier, nameConstant, descConstant);
        int size = din.readUnsignedShort();
        int i = 0;
        while (i < size) {
            info.addAttribute(Attribute.readFrom(cp, din, attrFactory));
            ++i;
        }
        return info;
    }
}

