/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import java.util.ArrayList;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;

public class MethodDeclarationParser {
    private final Modifiers mModifiers;
    private final TypeDesc mReturnType;
    private final String mMethodName;
    private final TypeDesc[] mParameters;

    private static void skipWhitespace(String src, int[] pos) {
        int length = src.length();
        int i = pos[0];
        while (i < length) {
            char c = src.charAt(i);
            if (!Character.isWhitespace(c)) break;
            ++i;
        }
        pos[0] = i;
    }

    private static String parseIdentifier(String src, int[] pos) {
        MethodDeclarationParser.skipWhitespace(src, pos);
        int i = pos[0];
        int length = src.length();
        if (i >= length) {
            return null;
        }
        int startPos = i;
        char c = src.charAt(i);
        if (!Character.isJavaIdentifierStart(c)) {
            return null;
        }
        ++i;
        while (i < length) {
            c = src.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) break;
            ++i;
        }
        pos[0] = i;
        MethodDeclarationParser.skipWhitespace(src, pos);
        return src.substring(startPos, i);
    }

    private static TypeDesc parseTypeDesc(String src, int[] pos) {
        MethodDeclarationParser.skipWhitespace(src, pos);
        int i = pos[0];
        int length = src.length();
        if (i >= length) {
            return null;
        }
        int startPos = i;
        char c = src.charAt(i);
        if (!Character.isJavaIdentifierStart(c)) {
            return null;
        }
        ++i;
        while (i < length) {
            c = src.charAt(i);
            if (c == '.') {
                if (i + 1 < length && src.charAt(i + 1) == '.') break;
                ++i;
                continue;
            }
            if (!Character.isJavaIdentifierPart(c) && c != '[' && c != ']') break;
            ++i;
        }
        pos[0] = i;
        MethodDeclarationParser.skipWhitespace(src, pos);
        return TypeDesc.forClass(src.substring(startPos, i));
    }

    private static Modifiers parseModifiers(String src, int[] pos) {
        Modifiers modifiers = Modifiers.NONE;
        int length = src.length();
        block9: while (pos[0] < length) {
            int savedPos = pos[0];
            String ident = MethodDeclarationParser.parseIdentifier(src, pos);
            int newPos = pos[0];
            pos[0] = savedPos;
            if (ident == null) break;
            switch (ident.charAt(0)) {
                case 'a': {
                    if (!"abstract".equals(ident)) break block9;
                    modifiers = modifiers.toAbstract(true);
                    break;
                }
                case 'f': {
                    if (!"final".equals(ident)) break block9;
                    modifiers = modifiers.toFinal(true);
                    break;
                }
                case 'n': {
                    if (!"native".equals(ident)) break block9;
                    modifiers = modifiers.toNative(true);
                    break;
                }
                case 'p': {
                    if ("public".equals(ident)) {
                        modifiers = modifiers.toPublic(true);
                        break;
                    }
                    if ("private".equals(ident)) {
                        modifiers = modifiers.toPrivate(true);
                        break;
                    }
                    if (!"protected".equals(ident)) break block9;
                    modifiers = modifiers.toProtected(true);
                    break;
                }
                case 's': {
                    if ("static".equals(ident)) {
                        modifiers = modifiers.toStatic(true);
                        break;
                    }
                    if ("synchronized".equals(ident)) {
                        modifiers = modifiers.toSynchronized(true);
                        break;
                    }
                    if (!"strict".equals(ident)) break block9;
                    modifiers = modifiers.toStrict(true);
                    break;
                }
                case 't': {
                    if (!"transient".equals(ident)) break block9;
                    modifiers = modifiers.toTransient(true);
                    break;
                }
                case 'v': {
                    if (!"volatile".equals(ident)) break block9;
                    modifiers = modifiers.toVolatile(true);
                    break;
                }
                default: {
                    break block9;
                }
            }
            pos[0] = newPos;
        }
        return modifiers;
    }

    private static TypeDesc[] parseParameters(String src, int[] pos, boolean[] isVarArgs) {
        MethodDeclarationParser.skipWhitespace(src, pos);
        int length = src.length();
        if (pos[0] < length && src.charAt(pos[0]) != '(') {
            throw new IllegalArgumentException("Left paren expected");
        }
        pos[0] = pos[0] + 1;
        ArrayList<TypeDesc> list = new ArrayList<TypeDesc>();
        boolean expectParam = false;
        while (pos[0] < length) {
            TypeDesc type = MethodDeclarationParser.parseTypeDesc(src, pos);
            if (type == null) {
                if (!expectParam) break;
                throw new IllegalArgumentException("Parameter type expected");
            }
            list.add(type);
            MethodDeclarationParser.parseIdentifier(src, pos);
            if (pos[0] >= length) continue;
            char c = src.charAt(pos[0]);
            if (c == ',') {
                pos[0] = pos[0] + 1;
                expectParam = true;
                continue;
            }
            if (c == ')') {
                pos[0] = pos[0] + 1;
                break;
            }
            if (c == '.' && pos[0] + 2 < length && src.charAt(pos[0] + 1) == '.' && src.charAt(pos[0] + 2) == '.') {
                type = type.toArrayType();
                isVarArgs[0] = true;
                list.set(list.size() - 1, type);
                pos[0] = pos[0] + 3;
                expectParam = false;
                continue;
            }
            throw new IllegalArgumentException("Expected comma or right paren");
        }
        return list.toArray(new TypeDesc[list.size()]);
    }

    public MethodDeclarationParser(String declaration) throws IllegalArgumentException {
        int[] pos = new int[1];
        Modifiers modifiers = MethodDeclarationParser.parseModifiers(declaration, pos);
        this.mReturnType = MethodDeclarationParser.parseTypeDesc(declaration, pos);
        if (this.mReturnType == null) {
            throw new IllegalArgumentException("No return type");
        }
        this.mMethodName = MethodDeclarationParser.parseIdentifier(declaration, pos);
        if (this.mMethodName == null) {
            throw new IllegalArgumentException("No method name");
        }
        boolean[] isVarArgs = new boolean[1];
        this.mParameters = MethodDeclarationParser.parseParameters(declaration, pos, isVarArgs);
        if (isVarArgs[0]) {
            modifiers = modifiers.toVarArgs(true);
        }
        this.mModifiers = modifiers;
    }

    public Modifiers getModifiers() {
        return this.mModifiers;
    }

    public TypeDesc getReturnType() {
        return this.mReturnType;
    }

    public String getMethodName() {
        return this.mMethodName;
    }

    public TypeDesc[] getParameters() {
        return (TypeDesc[])this.mParameters.clone();
    }
}

