/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.cojen.classfile.BitList;
import org.cojen.classfile.CodeBuffer;
import org.cojen.classfile.ConstantInfo;
import org.cojen.classfile.ExceptionHandler;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.LocationRange;
import org.cojen.classfile.LocationRangeImpl;
import org.cojen.classfile.Opcode;
import org.cojen.classfile.TypeDesc;
import org.cojen.classfile.constant.ConstantClassInfo;

class InstructionList
implements CodeBuffer {
    private static final boolean DEBUG = false;
    private final boolean mSaveLocalVariableInfo;
    Instruction mFirst;
    Instruction mLast;
    boolean mResolved = false;
    private List<ExceptionHandler<LabelInstruction>> mExceptionHandlers = new ArrayList<ExceptionHandler<LabelInstruction>>(4);
    private List<LocalVariable> mLocalVariables = new ArrayList<LocalVariable>();
    private int mNextFixedVariableNumber;
    private int mMaxStack;
    private int mMaxLocals;
    private byte[] mByteCodes;
    private int mBufferLength;

    protected InstructionList(boolean saveLocalVariableInfo) {
        this.mSaveLocalVariableInfo = saveLocalVariableInfo;
    }

    public Collection<Instruction> getInstructions() {
        return new AbstractCollection<Instruction>(){

            @Override
            public Iterator<Instruction> iterator() {
                return new Iterator<Instruction>(){
                    private Instruction mNext;
                    {
                        this.mNext = (this).InstructionList.this.mFirst;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mNext != null;
                    }

                    @Override
                    public Instruction next() {
                        if (this.mNext == null) {
                            throw new NoSuchElementException();
                        }
                        Instruction current = this.mNext;
                        this.mNext = this.mNext.mNext;
                        return current;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                int count = 0;
                Instruction i = InstructionList.this.mFirst;
                while (i != null) {
                    ++count;
                    i = i.mNext;
                }
                return count;
            }
        };
    }

    @Override
    public int getMaxStackDepth() {
        this.resolve();
        return this.mMaxStack;
    }

    @Override
    public int getMaxLocals() {
        this.resolve();
        return this.mMaxLocals;
    }

    @Override
    public byte[] getByteCodes() {
        this.resolve();
        return this.mByteCodes;
    }

    @Override
    public ExceptionHandler[] getExceptionHandlers() {
        this.resolve();
        ExceptionHandler[] handlers = new ExceptionHandler[this.mExceptionHandlers.size()];
        return this.mExceptionHandlers.toArray(handlers);
    }

    public void addExceptionHandler(ExceptionHandler<LabelInstruction> handler) {
        this.mExceptionHandlers.add(handler);
    }

    public LocalVariable createLocalVariable(String name, TypeDesc type) {
        LocalVariableImpl var = new LocalVariableImpl(this.mLocalVariables.size(), name, type, -1);
        this.mLocalVariables.add(var);
        return var;
    }

    public LocalVariable createLocalParameter(String name, TypeDesc type) {
        LocalVariableImpl var = new LocalVariableImpl(this.mLocalVariables.size(), name, type, this.mNextFixedVariableNumber);
        this.mLocalVariables.add(var);
        this.mNextFixedVariableNumber += type.isDoubleWord() ? 2 : 1;
        return var;
    }

    private void resolve() {
        if (this.mResolved) {
            return;
        }
        this.resolve0();
    }

    /*
     * WARNING - void declaration
     */
    private void resolve0() {
        boolean passAgain;
        this.mMaxStack = 0;
        this.mMaxLocals = 0;
        int instrCount = 0;
        Instruction instr = this.mFirst;
        while (instr != null) {
            instr.reset(instrCount++);
            instr = instr.mNext;
        }
        for (ExceptionHandler<LabelInstruction> handler : this.mExceptionHandlers) {
            LabelInstruction start = handler.getStartLocation();
            start.markBranchTarget();
            Instruction instr2 = start;
            Instruction end = handler.getEndLocation();
            while (instr2 != null && instr2 != end) {
                instr2.addExceptionHandler(handler);
                instr2 = instr2.mNext;
            }
        }
        int size = this.mLocalVariables.size();
        BitList[] bitListArray = new BitList[size];
        BitList[] liveOut = new BitList[size];
        int v = 0;
        while (v < size) {
            bitListArray[v] = new BitList(instrCount);
            liveOut[v] = new BitList(instrCount);
            ++v;
        }
        this.livenessAnalysis(bitListArray, liveOut);
        ArrayList<List<LocalVariable>> registerUsers = new ArrayList<List<LocalVariable>>();
        int v2 = 0;
        while (v2 < size) {
            LocalVariableImpl var = (LocalVariableImpl)this.mLocalVariables.get(v2);
            if (var.isFixedNumber()) {
                this.addRegisterUser(registerUsers, var);
                int num = var.getNumber();
                if (var.isDoubleWord()) {
                    ++num;
                }
                if (num >= this.mMaxLocals) {
                    this.mMaxLocals = num + 1;
                }
            }
            ++v2;
        }
        BitList[] live = bitListArray;
        int v3 = 0;
        while (v3 < size) {
            live[v3].or(liveOut[v3]);
            if (live[v3].isAllClear()) {
                live[v3] = null;
            }
            ++v3;
        }
        if (this.mSaveLocalVariableInfo) {
            ArrayList<Instruction> instrList = new ArrayList<Instruction>(instrCount);
            instrList.addAll(this.getInstructions());
            int v4 = 0;
            while (v4 < size) {
                BitList list = live[v4];
                if (list != null) {
                    int start;
                    LocationRangeImpl firstRange = null;
                    HashSet<LocationRangeImpl> rangeSet = null;
                    int end = -1;
                    while ((start = list.nextSetBit(end + 1)) >= 0) {
                        end = list.nextClearBit(start + 1);
                        Location startLoc = (Location)instrList.get(start);
                        Location endLoc = (Location)instrList.get(end < instrCount ? end : instrCount - 1);
                        LocationRangeImpl range = new LocationRangeImpl(startLoc, endLoc);
                        if (firstRange == null) {
                            firstRange = range;
                        } else {
                            if (rangeSet == null) {
                                rangeSet = new HashSet<LocationRangeImpl>(5);
                                rangeSet.add(firstRange);
                            }
                            rangeSet.add(range);
                        }
                        if (end < instrCount) continue;
                    }
                    LocalVariableImpl var = (LocalVariableImpl)this.mLocalVariables.get(v4);
                    if (firstRange == null) {
                        var.setLocationRangeSet(null);
                    } else if (rangeSet == null || rangeSet.size() == 1) {
                        var.setLocationRangeSet(Collections.singleton(firstRange));
                    } else {
                        var.setLocationRangeSet(Collections.unmodifiableSet(rangeSet));
                    }
                }
                ++v4;
            }
        }
        int v4 = 0;
        while (v4 < size) {
            LocalVariableImpl var;
            if (live[v4] != null && !(var = (LocalVariableImpl)this.mLocalVariables.get(v4)).isFixedNumber()) {
                int r;
                block36: {
                    r = 0;
                    do {
                        r = this.findAvailableRegister(registerUsers, r, live, v4);
                        if (!var.isDoubleWord()) break block36;
                    } while (this.findAvailableRegister(registerUsers, ++r, live, v4) != r);
                    --r;
                }
                var.setNumber(r);
                this.addRegisterUser(registerUsers, var);
            }
            ++v4;
        }
        this.mMaxLocals = Math.max(this.mMaxLocals, registerUsers.size());
        HashMap<LabelInstruction, Integer> subAdjustMap = new HashMap<LabelInstruction, Integer>(11);
        this.stackResolve(0, this.mFirst, subAdjustMap);
        for (ExceptionHandler exceptionHandler : this.mExceptionHandlers) {
            Instruction enter = (Instruction)exceptionHandler.getCatchLocation();
            this.stackResolve(1, enter, subAdjustMap);
        }
        do {
            void var3_12;
            passAgain = false;
            this.mByteCodes = new byte[instrCount * 2];
            this.mBufferLength = 0;
            Instruction instruction = this.mFirst;
            while (var3_12 != null) {
                if (!var3_12.isResolved()) {
                    passAgain = true;
                }
                if (var3_12 instanceof Label) {
                    if (var3_12.mLocation != this.mBufferLength) {
                        if (var3_12.mLocation >= 0) {
                            passAgain = true;
                        }
                        var3_12.mLocation = this.mBufferLength;
                    }
                } else {
                    var3_12.mLocation = this.mBufferLength;
                    byte[] bytes = var3_12.getBytes();
                    if (bytes != null) {
                        if (passAgain) {
                            this.mBufferLength += bytes.length;
                        } else {
                            this.addBytes(bytes);
                        }
                    }
                }
                Instruction instruction2 = var3_12.mNext;
            }
        } while (passAgain);
        if (this.mBufferLength != this.mByteCodes.length) {
            byte[] byArray = new byte[this.mBufferLength];
            System.arraycopy(this.mByteCodes, 0, byArray, 0, this.mBufferLength);
            this.mByteCodes = byArray;
        }
        this.mResolved = true;
    }

    private void addBytes(byte[] code) {
        this.growBuffer(code.length);
        System.arraycopy(code, 0, this.mByteCodes, this.mBufferLength, code.length);
        this.mBufferLength += code.length;
    }

    private void growBuffer(int amount) {
        if (this.mBufferLength + amount > this.mByteCodes.length) {
            int newCapacity = this.mByteCodes.length * 2;
            if (this.mBufferLength + amount > newCapacity) {
                newCapacity = this.mBufferLength + amount;
            }
            byte[] newBuffer = new byte[newCapacity];
            System.arraycopy(this.mByteCodes, 0, newBuffer, 0, this.mBufferLength);
            this.mByteCodes = newBuffer;
        }
    }

    private void livenessAnalysis(BitList[] liveIn, BitList[] liveOut) {
        boolean passAgain;
        List[] localStores = new List[liveIn.length];
        int passCount = -1;
        do {
            ++passCount;
            passAgain = false;
            Instruction instr = this.mLast;
            while (instr != null) {
                int n = instr.getLocation();
                int useIndex = -1;
                int defIndex = -1;
                if (instr instanceof LocalOperandInstruction) {
                    LocalOperandInstruction loi = (LocalOperandInstruction)instr;
                    LocalVariableImpl var = loi.getLocalVariable();
                    int varIndex = var.getIndex();
                    if (loi.isLoad()) {
                        useIndex = varIndex;
                    }
                    if (loi.isStore()) {
                        defIndex = varIndex;
                        if (passCount == 0 && loi instanceof StoreLocalInstruction) {
                            ArrayList<StoreLocalInstruction> stores = localStores[varIndex];
                            if (stores == null) {
                                localStores[varIndex] = stores = new ArrayList<StoreLocalInstruction>();
                            }
                            stores.add((StoreLocalInstruction)loi);
                        }
                    }
                }
                int v = liveIn.length;
                while (--v >= 0) {
                    Collection<ExceptionHandler<LabelInstruction>> handlers;
                    LabelInstruction[] targets;
                    boolean setLiveIn;
                    if (useIndex == v || v != defIndex && liveOut[v].get(n)) {
                        passAgain |= liveIn[v].set(n);
                        setLiveIn = true;
                    } else {
                        setLiveIn = false;
                    }
                    boolean setLiveOut = false;
                    if (instr.isFlowThrough() && instr.mNext != null && liveIn[v].get(instr.mNext.getLocation())) {
                        setLiveOut = true;
                        passAgain |= liveOut[v].set(n);
                    }
                    if ((targets = instr.getBranchTargets()) != null) {
                        int i = 0;
                        while (i < targets.length) {
                            if (liveIn[v].get(targets[i].getLocation())) {
                                setLiveOut = true;
                                passAgain |= liveOut[v].set(n);
                            }
                            ++i;
                        }
                    }
                    if ((handlers = instr.getExceptionHandlers()) != null) {
                        for (ExceptionHandler<LabelInstruction> handler : handlers) {
                            Instruction catchInstr = handler.getCatchLocation();
                            if (!liveIn[v].get(catchInstr.getLocation())) continue;
                            setLiveOut = true;
                            passAgain |= liveOut[v].set(n);
                        }
                    }
                    if (setLiveIn || !setLiveOut || v == defIndex) continue;
                    passAgain |= liveIn[v].set(n);
                }
                instr = instr.mPrev;
            }
        } while (passAgain);
        int v = localStores.length;
        while (--v >= 0) {
            List stores = localStores[v];
            if (stores == null) continue;
            int i = stores.size();
            while (--i >= 0) {
                StoreLocalInstruction instr = (StoreLocalInstruction)stores.get(i);
                if (liveOut[v].get(instr.getLocation())) continue;
                instr.discardResult();
            }
        }
    }

    private void addRegisterUser(List<List<LocalVariable>> registerUsers, LocalVariable var) {
        int num = var.getNumber();
        if (num < 0) {
            throw new IllegalStateException("Local variable number not resolved: " + var);
        }
        this.getRegisterUsers(registerUsers, num).add(var);
        if (var.isDoubleWord()) {
            this.getRegisterUsers(registerUsers, num + 1).add(var);
        }
    }

    private List<LocalVariable> getRegisterUsers(List<List<LocalVariable>> registerUsers, int num) {
        while (registerUsers.size() <= num) {
            registerUsers.add(new ArrayList());
        }
        return registerUsers.get(num);
    }

    private int findAvailableRegister(List<List<LocalVariable>> registerUsers, int r, BitList[] live, int v) {
        block0: while (r < registerUsers.size()) {
            List<LocalVariable> users = this.getRegisterUsers(registerUsers, r);
            int i = 0;
            while (i < users.size()) {
                int v2 = ((LocalVariableImpl)users.get(i)).getIndex();
                if (!live[v].intersects(live[v2])) {
                    ++i;
                    continue;
                }
                ++r;
                continue block0;
            }
            break block0;
        }
        return r;
    }

    private int stackResolve(int stackDepth, Instruction instr, Map<LabelInstruction, Integer> subAdjustMap) {
        while (instr != null) {
            Instruction next;
            if (instr.mStackDepth >= 0) break;
            instr.mStackDepth = stackDepth;
            Instruction instruction = next = instr.isFlowThrough() ? instr.mNext : null;
            if ((stackDepth += instr.getStackAdjustment()) > this.mMaxStack) {
                this.mMaxStack = stackDepth;
            } else if (stackDepth < 0) {
                stackDepth = 0;
            }
            LabelInstruction[] targets = instr.getBranchTargets();
            if (targets != null) {
                int i = 0;
                while (i < targets.length) {
                    LabelInstruction target = targets[i];
                    target.markBranchTarget();
                    if (i == 0 && next == null) {
                        next = target;
                    } else if (!instr.isSubroutineCall()) {
                        this.stackResolve(stackDepth, target, subAdjustMap);
                    } else {
                        Integer subAdjust = subAdjustMap.get(target);
                        if (subAdjust == null) {
                            int newDepth = this.stackResolve(stackDepth, target, subAdjustMap);
                            subAdjust = new Integer(newDepth - stackDepth);
                            subAdjustMap.put(target, subAdjust);
                        }
                        stackDepth += subAdjust.intValue();
                    }
                    ++i;
                }
            }
            instr = next;
        }
        return stackDepth;
    }

    static int calcInvokeAdjust(byte opcode, TypeDesc ret, TypeDesc[] params) {
        int stackAdjust = InstructionList.returnSize(ret) - InstructionList.argSize(params);
        switch (opcode) {
            case -72: {
                break;
            }
            case -74: 
            case -73: 
            case -71: {
                --stackAdjust;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not an invoke operation: " + opcode);
            }
        }
        return stackAdjust;
    }

    static byte[] createInvokeBytes(byte opcode, TypeDesc[] params) {
        byte[] bytes;
        if (opcode == -71) {
            bytes = new byte[5];
            bytes[3] = (byte)(1 + InstructionList.argSize(params));
        } else {
            bytes = new byte[3];
        }
        bytes[0] = opcode;
        return bytes;
    }

    private static int returnSize(TypeDesc ret) {
        if (ret == null || ret == TypeDesc.VOID) {
            return 0;
        }
        if (ret.isDoubleWord()) {
            return 2;
        }
        return 1;
    }

    private static int argSize(TypeDesc[] params) {
        int size = 0;
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                size += InstructionList.returnSize(params[i]);
                ++i;
            }
        }
        return size;
    }

    static int calcStackOperationAdjust(byte opcode) {
        switch (opcode) {
            case 89: {
                return 1;
            }
            case 90: {
                return 1;
            }
            case 91: {
                return 1;
            }
            case 92: {
                return 2;
            }
            case 93: {
                return 2;
            }
            case 94: {
                return 2;
            }
            case 87: {
                return -1;
            }
            case 88: {
                return -2;
            }
            case 95: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Not a stack operation: " + opcode);
    }

    public class BranchInstruction
    extends CodeInstruction {
        private final LabelInstruction mTarget;
        private boolean mHasShortHop;
        private boolean mIsSub;

        public BranchInstruction(int stackAdjust, byte opcode, LabelInstruction target) {
            this(stackAdjust, true, opcode, target);
        }

        private BranchInstruction(int stackAdjust, boolean addInstruction, byte opcode, LabelInstruction target) {
            super(stackAdjust, addInstruction);
            this.mHasShortHop = false;
            this.mIsSub = false;
            this.mTarget = target;
            switch (opcode) {
                case -55: {
                    this.mIsSub = true;
                }
                case -56: {
                    this.mBytes = new byte[5];
                    this.mBytes[0] = opcode;
                    break;
                }
                case -88: {
                    this.mIsSub = true;
                }
                case -103: 
                case -102: 
                case -101: 
                case -100: 
                case -99: 
                case -98: 
                case -97: 
                case -96: 
                case -95: 
                case -94: 
                case -93: 
                case -92: 
                case -91: 
                case -90: 
                case -89: 
                case -58: 
                case -57: {
                    this.mBytes = new byte[3];
                    this.mBytes[0] = opcode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Opcode not a branch instruction: " + Opcode.getMnemonic(opcode));
                }
            }
        }

        @Override
        public LabelInstruction[] getBranchTargets() {
            return new LabelInstruction[]{this.mTarget};
        }

        @Override
        public boolean isSubroutineCall() {
            return this.mIsSub;
        }

        @Override
        public byte[] getBytes() {
            if (!this.isResolved() || this.mHasShortHop) {
                return this.mBytes;
            }
            int offset = this.mTarget.getLocation() - this.mLocation;
            byte opcode = this.mBytes[0];
            if (opcode == -56 || opcode == -55) {
                this.mBytes[1] = (byte)(offset >> 24);
                this.mBytes[2] = (byte)(offset >> 16);
                this.mBytes[3] = (byte)(offset >> 8);
                this.mBytes[4] = (byte)(offset >> 0);
            } else if (Short.MIN_VALUE <= offset && offset <= Short.MAX_VALUE) {
                this.mBytes[1] = (byte)(offset >> 8);
                this.mBytes[2] = (byte)(offset >> 0);
            } else if (opcode == -89 || opcode == -88) {
                this.mBytes = new byte[5];
                this.mBytes[0] = opcode == -89 ? -56 : -55;
                this.mBytes[1] = (byte)(offset >> 24);
                this.mBytes[2] = (byte)(offset >> 16);
                this.mBytes[3] = (byte)(offset >> 8);
                this.mBytes[4] = (byte)(offset >> 0);
            } else {
                this.mHasShortHop = true;
                this.mBytes[0] = opcode = Opcode.reverseIfOpcode(opcode);
                this.mBytes[1] = 0;
                this.mBytes[2] = 8;
                this.insert(new BranchInstruction(0, false, -56, this.mTarget));
            }
            return this.mBytes;
        }

        @Override
        public boolean isResolved() {
            return this.mTarget.getLocation() >= 0;
        }
    }

    public abstract class CodeInstruction
    extends Instruction {
        protected byte[] mBytes;

        protected CodeInstruction(int stackAdjust) {
            super(stackAdjust);
        }

        protected CodeInstruction(int stackAdjust, boolean addInstruction) {
            super(stackAdjust, addInstruction);
        }

        protected CodeInstruction(int stackAdjust, byte[] bytes) {
            super(stackAdjust);
            this.mBytes = bytes;
        }

        @Override
        public boolean isFlowThrough() {
            if (this.mBytes != null && this.mBytes.length > 0) {
                switch (this.mBytes[0]) {
                    case -89: 
                    case -84: 
                    case -83: 
                    case -82: 
                    case -81: 
                    case -80: 
                    case -79: 
                    case -65: 
                    case -56: {
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        public byte[] getBytes() {
            return this.mBytes;
        }

        @Override
        public boolean isResolved() {
            return true;
        }
    }

    public class ConstantOperandInstruction
    extends SimpleInstruction {
        private final ConstantInfo mInfo;

        public ConstantOperandInstruction(int stackAdjust, TypeDesc pushed, byte[] bytes, ConstantInfo info) {
            super(stackAdjust, pushed, bytes);
            if (bytes.length < 3) {
                throw new IllegalArgumentException("Byte for instruction is too small");
            }
            this.mInfo = info;
        }

        @Override
        public byte[] getBytes() {
            int index = this.mInfo.getIndex();
            if (index < 0) {
                throw new IllegalStateException("Constant pool index not resolved");
            }
            this.mBytes[1] = (byte)(index >> 8);
            this.mBytes[2] = (byte)index;
            return this.mBytes;
        }

        @Override
        public boolean isResolved() {
            return this.mInfo.getIndex() >= 0;
        }
    }

    public abstract class Instruction
    implements Location {
        private int mStackAdjust;
        Instruction mPrev;
        Instruction mNext;
        int mStackDepth = -1;
        int mLocation = -1;
        private Set<ExceptionHandler<LabelInstruction>> mExceptionHandlers;

        public Instruction(int stackAdjust) {
            this.mStackAdjust = stackAdjust;
            this.add();
        }

        protected Instruction(int stackAdjust, boolean addInstruction) {
            this.mStackAdjust = stackAdjust;
            if (addInstruction) {
                this.add();
            }
        }

        protected void add() {
            InstructionList.this.mResolved = false;
            if (this.mPrev != null) {
                this.mPrev.mNext = this.mNext;
            }
            if (this.mNext != null) {
                this.mNext.mPrev = this.mPrev;
            }
            this.mNext = null;
            if (InstructionList.this.mFirst == null) {
                this.mPrev = null;
                InstructionList.this.mFirst = this;
            } else {
                this.mPrev = InstructionList.this.mLast;
                InstructionList.this.mLast.mNext = this;
            }
            InstructionList.this.mLast = this;
        }

        public void insert(Instruction instr) {
            InstructionList.this.mResolved = false;
            instr.mPrev = this;
            instr.mNext = this.mNext;
            this.mNext = instr;
            if (this == InstructionList.this.mLast) {
                InstructionList.this.mLast = instr;
            }
        }

        public void remove() {
            InstructionList.this.mResolved = false;
            if (this.mPrev != null) {
                this.mPrev.mNext = this.mNext;
            }
            if (this.mNext != null) {
                this.mNext.mPrev = this.mPrev;
            }
            if (this == InstructionList.this.mFirst) {
                InstructionList.this.mFirst = this.mNext;
            }
            if (this == InstructionList.this.mLast) {
                InstructionList.this.mLast = this.mPrev;
            }
            this.mPrev = null;
            this.mNext = null;
        }

        public void replace(Instruction replacement) {
            if (replacement == null) {
                this.remove();
                return;
            }
            InstructionList.this.mResolved = false;
            replacement.mPrev = this.mPrev;
            replacement.mNext = this.mNext;
            if (this.mPrev != null) {
                this.mPrev.mNext = replacement;
            }
            if (this.mNext != null) {
                this.mNext.mPrev = replacement;
            }
            if (this == InstructionList.this.mFirst) {
                InstructionList.this.mFirst = replacement;
            }
            if (this == InstructionList.this.mLast) {
                InstructionList.this.mLast = replacement;
            }
        }

        public int getStackAdjustment() {
            return this.mStackAdjust;
        }

        public int getStackDepth() {
            return this.mStackDepth;
        }

        @Override
        public int getLocation() {
            return this.mLocation;
        }

        public boolean isBranchTarget() {
            return false;
        }

        public LabelInstruction[] getBranchTargets() {
            return null;
        }

        public Collection<ExceptionHandler<LabelInstruction>> getExceptionHandlers() {
            return this.mExceptionHandlers;
        }

        public void addExceptionHandler(ExceptionHandler<LabelInstruction> handler) {
            if (this.mExceptionHandlers == null) {
                this.mExceptionHandlers = new HashSet<ExceptionHandler<LabelInstruction>>(4);
            }
            this.mExceptionHandlers.add(handler);
        }

        public boolean isFlowThrough() {
            return true;
        }

        public boolean isSubroutineCall() {
            return false;
        }

        public abstract byte[] getBytes();

        public abstract boolean isResolved();

        @Override
        public int compareTo(Location other) {
            int locb;
            if (this == other) {
                return 0;
            }
            int loca = this.getLocation();
            if (loca < (locb = other.getLocation())) {
                return -1;
            }
            if (loca > locb) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            String name = this.getClass().getName();
            int index = name.lastIndexOf(46);
            if (index >= 0) {
                name = name.substring(index + 1);
            }
            if ((index = name.lastIndexOf(36)) >= 0) {
                name = name.substring(index + 1);
            }
            StringBuffer buf = new StringBuffer(name.length() + 20);
            int adjust = this.getStackAdjustment();
            int depth = this.getStackDepth();
            if (depth >= 0) {
                buf.append(' ');
            } else {
                buf.append('*');
            }
            buf.append('[');
            buf.append(this.mLocation);
            buf.append("] ");
            buf.append(name);
            buf.append(" (");
            if (depth >= 0) {
                buf.append(depth);
                buf.append(" + ");
                buf.append(adjust);
                buf.append(" = ");
                buf.append(depth + adjust);
            } else {
                buf.append(adjust);
            }
            buf.append(") ");
            try {
                byte[] bytes = this.getBytes();
                boolean wide = false;
                if (bytes != null) {
                    int i = 0;
                    while (i < bytes.length) {
                        if (i > 0) {
                            buf.append(',');
                        }
                        byte code = bytes[i];
                        if (i == 0 || wide) {
                            buf.append(Opcode.getMnemonic(code));
                            wide = code == -60;
                        } else {
                            buf.append(code & 0xFF);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return buf.toString();
        }

        void reset(int instrCount) {
            this.mStackDepth = -1;
            this.mLocation = instrCount;
        }
    }

    public class InvokeConstructorInstruction
    extends InvokeInstruction {
        public InvokeConstructorInstruction(ConstantInfo ctor, TypeDesc type, TypeDesc[] params) {
            super((byte)-73, ctor, null, params);
        }
    }

    public class InvokeInstruction
    extends ConstantOperandInstruction {
        public InvokeInstruction(byte opcode, ConstantInfo method, TypeDesc ret, TypeDesc[] params) {
            super(InstructionList.calcInvokeAdjust(opcode, ret, params), ret, InstructionList.createInvokeBytes(opcode, params), method);
        }

        @Override
        public boolean isFlowThrough() {
            return true;
        }
    }

    public class LabelInstruction
    extends Instruction
    implements Label {
        private boolean mIsTarget;

        public LabelInstruction() {
            super(0, false);
        }

        @Override
        public Label setLocation() {
            this.add();
            return this;
        }

        @Override
        public int getLocation() throws IllegalStateException {
            int loc = this.mLocation;
            if (loc < 0 && this.mPrev == null && this.mNext == null) {
                throw new IllegalStateException("Label location is not set");
            }
            return loc;
        }

        @Override
        public boolean isBranchTarget() {
            return this.mIsTarget;
        }

        void markBranchTarget() {
            this.mIsTarget = true;
        }

        @Override
        public byte[] getBytes() {
            return null;
        }

        @Override
        public boolean isResolved() {
            return this.getLocation() >= 0;
        }

        @Override
        void reset(int instrCount) {
            super.reset(instrCount);
            this.mIsTarget = false;
        }
    }

    public class LoadConstantInstruction
    extends CodeInstruction {
        private final ConstantInfo mInfo;
        private final boolean mWideOnly;

        public LoadConstantInstruction(int stackAdjust, TypeDesc pushed, ConstantInfo info) {
            this(stackAdjust, pushed, info, false);
        }

        public LoadConstantInstruction(int stackAdjust, TypeDesc pushed, ConstantInfo info, boolean wideOnly) {
            super(stackAdjust);
            this.mInfo = info;
            this.mWideOnly = wideOnly;
        }

        @Override
        public boolean isFlowThrough() {
            return true;
        }

        @Override
        public byte[] getBytes() {
            int index = this.mInfo.getIndex();
            if (index < 0) {
                throw new IllegalStateException("Constant pool index not resolved");
            }
            if (this.mWideOnly) {
                byte[] bytes = new byte[]{20, (byte)(index >> 8), (byte)index};
                return bytes;
            }
            if (index <= 255) {
                byte[] bytes = new byte[]{18, (byte)index};
                return bytes;
            }
            byte[] bytes = new byte[]{19, (byte)(index >> 8), (byte)index};
            return bytes;
        }

        @Override
        public boolean isResolved() {
            return this.mInfo.getIndex() >= 0;
        }
    }

    public class LoadLocalInstruction
    extends LocalOperandInstruction {
        public LoadLocalInstruction(int stackAdjust, LocalVariable local) {
            super(stackAdjust, local);
        }

        @Override
        public boolean isFlowThrough() {
            return true;
        }

        @Override
        public byte[] getBytes() {
            byte opcode;
            int varNum = this.getVariableNumber();
            boolean writeIndex = false;
            int typeCode = this.mLocal.getType().getTypeCode();
            block0 : switch (varNum) {
                case 0: {
                    switch (typeCode) {
                        default: {
                            opcode = 42;
                            break block0;
                        }
                        case 11: {
                            opcode = 30;
                            break block0;
                        }
                        case 6: {
                            opcode = 34;
                            break block0;
                        }
                        case 7: {
                            opcode = 38;
                            break block0;
                        }
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: 
                        case 10: 
                    }
                    opcode = 26;
                    break;
                }
                case 1: {
                    switch (typeCode) {
                        default: {
                            opcode = 43;
                            break block0;
                        }
                        case 11: {
                            opcode = 31;
                            break block0;
                        }
                        case 6: {
                            opcode = 35;
                            break block0;
                        }
                        case 7: {
                            opcode = 39;
                            break block0;
                        }
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: 
                        case 10: 
                    }
                    opcode = 27;
                    break;
                }
                case 2: {
                    switch (typeCode) {
                        default: {
                            opcode = 44;
                            break block0;
                        }
                        case 11: {
                            opcode = 32;
                            break block0;
                        }
                        case 6: {
                            opcode = 36;
                            break block0;
                        }
                        case 7: {
                            opcode = 40;
                            break block0;
                        }
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: 
                        case 10: 
                    }
                    opcode = 28;
                    break;
                }
                case 3: {
                    switch (typeCode) {
                        default: {
                            opcode = 45;
                            break block0;
                        }
                        case 11: {
                            opcode = 33;
                            break block0;
                        }
                        case 6: {
                            opcode = 37;
                            break block0;
                        }
                        case 7: {
                            opcode = 41;
                            break block0;
                        }
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: 
                        case 10: 
                    }
                    opcode = 29;
                    break;
                }
                default: {
                    writeIndex = true;
                    switch (typeCode) {
                        default: {
                            opcode = 25;
                            break block0;
                        }
                        case 11: {
                            opcode = 22;
                            break block0;
                        }
                        case 6: {
                            opcode = 23;
                            break block0;
                        }
                        case 7: {
                            opcode = 24;
                            break block0;
                        }
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: 
                        case 10: 
                    }
                    opcode = 21;
                }
            }
            this.mBytes = !writeIndex ? new byte[]{opcode} : (varNum <= 255 ? new byte[]{opcode, (byte)varNum} : new byte[]{-60, opcode, (byte)(varNum >> 8), (byte)varNum});
            return this.mBytes;
        }

        @Override
        public boolean isLoad() {
            return true;
        }

        @Override
        public boolean isStore() {
            return false;
        }
    }

    public abstract class LocalOperandInstruction
    extends CodeInstruction {
        protected final LocalVariableImpl mLocal;

        public LocalOperandInstruction(int stackAdjust, LocalVariable local) {
            super(stackAdjust);
            this.mLocal = (LocalVariableImpl)local;
        }

        @Override
        public boolean isResolved() {
            return this.mLocal.getNumber() >= 0;
        }

        public LocalVariableImpl getLocalVariable() {
            return this.mLocal;
        }

        public int getVariableNumber() {
            int varNum = this.mLocal.getNumber();
            if (varNum < 0) {
                throw new IllegalStateException("Local variable number not resolved: " + this.mLocal);
            }
            return varNum;
        }

        public abstract boolean isLoad();

        public abstract boolean isStore();
    }

    private static class LocalVariableImpl
    implements LocalVariable {
        private final int mIndex;
        private String mName;
        private TypeDesc mType;
        private int mNumber;
        private boolean mFixed;
        private Set<LocationRange> mLocationRangeSet;

        public LocalVariableImpl(int index, String name, TypeDesc type, int number) {
            this.mIndex = index;
            this.mName = name;
            this.mType = type;
            this.mNumber = number;
            if (number >= 0) {
                this.mFixed = true;
            }
        }

        int getIndex() {
            return this.mIndex;
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        public void setName(String name) {
            this.mName = name;
        }

        @Override
        public TypeDesc getType() {
            return this.mType;
        }

        @Override
        public boolean isDoubleWord() {
            return this.mType.isDoubleWord();
        }

        @Override
        public int getNumber() {
            return this.mNumber;
        }

        @Override
        public Set<LocationRange> getLocationRangeSet() {
            return this.mLocationRangeSet;
        }

        void setLocationRangeSet(Set<LocationRange> set) {
            this.mLocationRangeSet = set;
        }

        public void setNumber(int number) {
            this.mNumber = number;
        }

        public void setFixedNumber(int number) {
            this.mNumber = number;
            this.mFixed = true;
        }

        public boolean isFixedNumber() {
            return this.mFixed;
        }

        public String toString() {
            return "variable {type=" + this.getType() + ", name=" + this.getName() + '}';
        }
    }

    public class NewObjectInstruction
    extends ConstantOperandInstruction {
        public NewObjectInstruction(ConstantClassInfo newType) {
            byte[] byArray = new byte[3];
            byArray[0] = -69;
            super(1, TypeDesc.OBJECT, byArray, newType);
        }

        @Override
        public boolean isFlowThrough() {
            return true;
        }
    }

    public class RetInstruction
    extends LocalOperandInstruction {
        public RetInstruction(LocalVariable local) {
            super(0, local);
            LocalVariableImpl localVariableImpl = (LocalVariableImpl)local;
            InstructionList instructionList2 = InstructionList.this;
            int n = instructionList2.mNextFixedVariableNumber;
            instructionList2.mNextFixedVariableNumber = n + 1;
            localVariableImpl.setFixedNumber(n);
        }

        @Override
        public boolean isFlowThrough() {
            return false;
        }

        @Override
        public byte[] getBytes() {
            int varNum = this.getVariableNumber();
            this.mBytes = varNum <= 255 ? new byte[]{-87, (byte)varNum} : new byte[]{-60, -87, (byte)(varNum >> 8), (byte)varNum};
            return this.mBytes;
        }

        @Override
        public boolean isLoad() {
            return true;
        }

        @Override
        public boolean isStore() {
            return false;
        }
    }

    public class ShortIncrementInstruction
    extends LocalOperandInstruction {
        private final short mAmount;

        public ShortIncrementInstruction(LocalVariable local, short amount) {
            super(0, local);
            this.mAmount = amount;
        }

        @Override
        public boolean isFlowThrough() {
            return true;
        }

        @Override
        public byte[] getBytes() {
            int varNum = this.getVariableNumber();
            this.mBytes = -128 <= this.mAmount && this.mAmount <= 127 && varNum <= 255 ? new byte[]{-124, (byte)varNum, (byte)this.mAmount} : new byte[]{-60, -124, (byte)(varNum >> 8), (byte)varNum, (byte)(this.mAmount >> 8), (byte)this.mAmount};
            return this.mBytes;
        }

        @Override
        public boolean isLoad() {
            return true;
        }

        @Override
        public boolean isStore() {
            return true;
        }
    }

    public class SimpleInstruction
    extends CodeInstruction {
        public SimpleInstruction(int stackAdjust, TypeDesc pushed, byte[] bytes) {
            super(stackAdjust, bytes);
        }
    }

    public class StackOperationInstruction
    extends CodeInstruction {
        public StackOperationInstruction(byte opcode) {
            super(InstructionList.calcStackOperationAdjust(opcode), new byte[]{opcode});
        }

        @Override
        public boolean isFlowThrough() {
            return true;
        }
    }

    public class StoreLocalInstruction
    extends LocalOperandInstruction {
        private boolean mDiscardResult;

        public StoreLocalInstruction(int stackAdjust, LocalVariable local) {
            super(stackAdjust, local);
        }

        @Override
        public boolean isFlowThrough() {
            return true;
        }

        @Override
        public byte[] getBytes() {
            byte opcode;
            if (this.mDiscardResult) {
                return new byte[]{this.mLocal.isDoubleWord() ? (byte)88 : 87};
            }
            int varNum = this.getVariableNumber();
            boolean writeIndex = false;
            int typeCode = this.mLocal.getType().getTypeCode();
            block0 : switch (varNum) {
                case 0: {
                    switch (typeCode) {
                        default: {
                            opcode = 75;
                            break block0;
                        }
                        case 11: {
                            opcode = 63;
                            break block0;
                        }
                        case 6: {
                            opcode = 67;
                            break block0;
                        }
                        case 7: {
                            opcode = 71;
                            break block0;
                        }
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: 
                        case 10: 
                    }
                    opcode = 59;
                    break;
                }
                case 1: {
                    switch (typeCode) {
                        default: {
                            opcode = 76;
                            break block0;
                        }
                        case 11: {
                            opcode = 64;
                            break block0;
                        }
                        case 6: {
                            opcode = 68;
                            break block0;
                        }
                        case 7: {
                            opcode = 72;
                            break block0;
                        }
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: 
                        case 10: 
                    }
                    opcode = 60;
                    break;
                }
                case 2: {
                    switch (typeCode) {
                        default: {
                            opcode = 77;
                            break block0;
                        }
                        case 11: {
                            opcode = 65;
                            break block0;
                        }
                        case 6: {
                            opcode = 69;
                            break block0;
                        }
                        case 7: {
                            opcode = 73;
                            break block0;
                        }
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: 
                        case 10: 
                    }
                    opcode = 61;
                    break;
                }
                case 3: {
                    switch (typeCode) {
                        default: {
                            opcode = 78;
                            break block0;
                        }
                        case 11: {
                            opcode = 66;
                            break block0;
                        }
                        case 6: {
                            opcode = 70;
                            break block0;
                        }
                        case 7: {
                            opcode = 74;
                            break block0;
                        }
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: 
                        case 10: 
                    }
                    opcode = 62;
                    break;
                }
                default: {
                    writeIndex = true;
                    switch (typeCode) {
                        default: {
                            opcode = 58;
                            break block0;
                        }
                        case 11: {
                            opcode = 55;
                            break block0;
                        }
                        case 6: {
                            opcode = 56;
                            break block0;
                        }
                        case 7: {
                            opcode = 57;
                            break block0;
                        }
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: 
                        case 10: 
                    }
                    opcode = 54;
                }
            }
            this.mBytes = !writeIndex ? new byte[]{opcode} : (varNum <= 255 ? new byte[]{opcode, (byte)varNum} : new byte[]{-60, opcode, (byte)(varNum >> 8), (byte)varNum});
            return this.mBytes;
        }

        @Override
        public boolean isResolved() {
            return true;
        }

        @Override
        public boolean isLoad() {
            return false;
        }

        @Override
        public boolean isStore() {
            return true;
        }

        public void discardResult() {
            this.mDiscardResult = true;
        }
    }

    public class SwitchInstruction
    extends CodeInstruction {
        private final int[] mCases;
        private final LabelInstruction[] mLocations;
        private final LabelInstruction mDefaultLocation;
        private final byte mOpcode;
        private final int mSmallest;
        private final int mLargest;

        public SwitchInstruction(int[] casesParam, Location[] locationsParam, Location defaultLocation) {
            super(-1);
            if (casesParam.length != locationsParam.length) {
                throw new IllegalArgumentException("Switch cases and locations sizes differ: " + casesParam.length + ", " + locationsParam.length);
            }
            this.mCases = new int[casesParam.length];
            System.arraycopy(casesParam, 0, this.mCases, 0, casesParam.length);
            LabelInstruction[] locations = new LabelInstruction[locationsParam.length];
            int i = 0;
            while (i < locations.length) {
                LabelInstruction location;
                try {
                    location = (LabelInstruction)locationsParam[i];
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException("Switch location is not a label instruction");
                }
                locations[i] = location;
                ++i;
            }
            this.mLocations = locations;
            try {
                this.mDefaultLocation = (LabelInstruction)defaultLocation;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Default location is not a label instruction");
            }
            this.sort(0, this.mCases.length - 1);
            int lastCase = 0;
            int i2 = 0;
            while (i2 < this.mCases.length) {
                if (i2 > 0 && this.mCases[i2] == lastCase) {
                    throw new IllegalArgumentException("Duplicate switch cases: " + lastCase);
                }
                lastCase = this.mCases[i2];
                ++i2;
            }
            this.mSmallest = this.mCases[0];
            this.mLargest = this.mCases[this.mCases.length - 1];
            long tSize = 12L + 4L * ((long)this.mLargest - (long)this.mSmallest + 1L);
            int lSize = 8 + 8 * this.mCases.length;
            this.mOpcode = tSize <= (long)lSize ? (byte)-86 : (byte)-85;
        }

        @Override
        public LabelInstruction[] getBranchTargets() {
            LabelInstruction[] targets = new LabelInstruction[this.mLocations.length + 1];
            System.arraycopy(this.mLocations, 0, targets, 0, this.mLocations.length);
            targets[targets.length - 1] = this.mDefaultLocation;
            return targets;
        }

        @Override
        public boolean isFlowThrough() {
            return false;
        }

        @Override
        public byte[] getBytes() {
            int length = 1;
            int pad = 3 - (this.mLocation & 3);
            length += pad;
            length = this.mOpcode == -86 ? (length += 12 + 4 * (this.mLargest - this.mSmallest + 1)) : (length += 8 + 8 * this.mCases.length);
            this.mBytes = new byte[length];
            if (!this.isResolved()) {
                return this.mBytes;
            }
            this.mBytes[0] = this.mOpcode;
            int cursor = pad + 1;
            int defaultOffset = this.mDefaultLocation.getLocation() - this.mLocation;
            this.mBytes[cursor++] = (byte)(defaultOffset >> 24);
            this.mBytes[cursor++] = (byte)(defaultOffset >> 16);
            this.mBytes[cursor++] = (byte)(defaultOffset >> 8);
            this.mBytes[cursor++] = (byte)(defaultOffset >> 0);
            if (this.mOpcode == -86) {
                this.mBytes[cursor++] = (byte)(this.mSmallest >> 24);
                this.mBytes[cursor++] = (byte)(this.mSmallest >> 16);
                this.mBytes[cursor++] = (byte)(this.mSmallest >> 8);
                this.mBytes[cursor++] = (byte)(this.mSmallest >> 0);
                this.mBytes[cursor++] = (byte)(this.mLargest >> 24);
                this.mBytes[cursor++] = (byte)(this.mLargest >> 16);
                this.mBytes[cursor++] = (byte)(this.mLargest >> 8);
                this.mBytes[cursor++] = (byte)(this.mLargest >> 0);
                int index = 0;
                int case_ = this.mSmallest;
                while (case_ <= this.mLargest) {
                    if (case_ == this.mCases[index]) {
                        int offset = this.mLocations[index].getLocation() - this.mLocation;
                        this.mBytes[cursor++] = (byte)(offset >> 24);
                        this.mBytes[cursor++] = (byte)(offset >> 16);
                        this.mBytes[cursor++] = (byte)(offset >> 8);
                        this.mBytes[cursor++] = (byte)(offset >> 0);
                        ++index;
                    } else {
                        this.mBytes[cursor++] = (byte)(defaultOffset >> 24);
                        this.mBytes[cursor++] = (byte)(defaultOffset >> 16);
                        this.mBytes[cursor++] = (byte)(defaultOffset >> 8);
                        this.mBytes[cursor++] = (byte)(defaultOffset >> 0);
                    }
                    ++case_;
                }
            } else {
                this.mBytes[cursor++] = (byte)(this.mCases.length >> 24);
                this.mBytes[cursor++] = (byte)(this.mCases.length >> 16);
                this.mBytes[cursor++] = (byte)(this.mCases.length >> 8);
                this.mBytes[cursor++] = (byte)(this.mCases.length >> 0);
                int index = 0;
                while (index < this.mCases.length) {
                    int case_ = this.mCases[index];
                    this.mBytes[cursor++] = (byte)(case_ >> 24);
                    this.mBytes[cursor++] = (byte)(case_ >> 16);
                    this.mBytes[cursor++] = (byte)(case_ >> 8);
                    this.mBytes[cursor++] = (byte)(case_ >> 0);
                    int offset = this.mLocations[index].getLocation() - this.mLocation;
                    this.mBytes[cursor++] = (byte)(offset >> 24);
                    this.mBytes[cursor++] = (byte)(offset >> 16);
                    this.mBytes[cursor++] = (byte)(offset >> 8);
                    this.mBytes[cursor++] = (byte)(offset >> 0);
                    ++index;
                }
            }
            return this.mBytes;
        }

        @Override
        public boolean isResolved() {
            if (this.mDefaultLocation.getLocation() >= 0) {
                int i = 0;
                while (i < this.mLocations.length) {
                    if (this.mLocations[i].getLocation() < 0) break;
                    ++i;
                }
                return true;
            }
            return false;
        }

        private void sort(int left, int right) {
            if (left >= right) {
                return;
            }
            this.swap(left, (left + right) / 2);
            int last = left;
            int i = left + 1;
            while (i <= right) {
                if (this.mCases[i] < this.mCases[left]) {
                    this.swap(++last, i);
                }
                ++i;
            }
            this.swap(left, last);
            this.sort(left, last - 1);
            this.sort(last + 1, right);
        }

        private void swap(int i, int j) {
            int tempInt = this.mCases[i];
            this.mCases[i] = this.mCases[j];
            this.mCases[j] = tempInt;
            LabelInstruction tempLocation = this.mLocations[i];
            this.mLocations[i] = this.mLocations[j];
            this.mLocations[j] = tempLocation;
        }
    }
}

