/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.FixedLocation;
import org.cojen.classfile.Location;
import org.cojen.classfile.LocationRange;
import org.cojen.classfile.constant.ConstantClassInfo;

public class ExceptionHandler<L extends Location>
implements LocationRange<L> {
    private L mStart;
    private L mEnd;
    private L mCatch;
    private ConstantClassInfo mCatchType;

    public ExceptionHandler(L startLocation, L endLocation, L catchLocation, ConstantClassInfo catchType) {
        this.mStart = startLocation;
        this.mEnd = endLocation;
        this.mCatch = catchLocation;
        this.mCatchType = catchType;
    }

    @Override
    public L getStartLocation() {
        return this.mStart;
    }

    @Override
    public L getEndLocation() {
        return this.mEnd;
    }

    public L getCatchLocation() {
        return this.mCatch;
    }

    public ConstantClassInfo getCatchType() {
        return this.mCatchType;
    }

    public void writeTo(DataOutput dout) throws IOException {
        int start_pc = this.getStartLocation().getLocation();
        int end_pc = this.getEndLocation().getLocation();
        int handler_pc = this.getCatchLocation().getLocation();
        ConstantClassInfo catchType = this.getCatchType();
        int catch_type = catchType == null ? 0 : catchType.getIndex();
        this.check("exception start PC", start_pc);
        this.check("exception end PC", end_pc);
        this.check("exception handler PC", handler_pc);
        dout.writeShort(start_pc);
        dout.writeShort(end_pc);
        dout.writeShort(handler_pc);
        dout.writeShort(catch_type);
    }

    private void check(String type, int addr) throws IllegalStateException {
        if (addr < 0 || addr > 65535) {
            throw new IllegalStateException("Value for " + type + " out of " + "valid range: " + addr);
        }
    }

    public static ExceptionHandler<FixedLocation> readFrom(ConstantPool cp, DataInput din) throws IOException {
        int start_pc = din.readUnsignedShort();
        int end_pc = din.readUnsignedShort();
        int handler_pc = din.readUnsignedShort();
        int catch_type = din.readUnsignedShort();
        ConstantClassInfo catchTypeConstant = catch_type == 0 ? null : (ConstantClassInfo)cp.getConstant(catch_type);
        return new ExceptionHandler<FixedLocation>(new FixedLocation(start_pc), new FixedLocation(end_pc), new FixedLocation(handler_pc), catchTypeConstant);
    }
}

