/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import org.cojen.classfile.AssemblyStylePrinter;
import org.cojen.classfile.BuilderStylePrinter;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.ClassFileDataLoader;
import org.cojen.classfile.ResourceClassFileDataLoader;

public class DisassemblyTool {
    public static void main(String[] args) throws Exception {
        Printer p;
        ClassFileDataLoader loader;
        InputStream in;
        String style;
        block10: {
            String name;
            if (args.length == 0) {
                System.out.println("DisassemblyTool [-f <format style>] <file or class name>");
                System.out.println();
                System.out.println("The format style may be \"assembly\" (the default) or \"builder\"");
                return;
            }
            if ("-f".equals(args[0])) {
                style = args[1];
                name = args[2];
            } else {
                style = "assembly";
                name = args[0];
            }
            try {
                final File file = new File(name);
                in = new FileInputStream(file);
                loader = new ClassFileDataLoader(){

                    @Override
                    public InputStream getClassData(String name) throws IOException {
                        name = name.substring(name.lastIndexOf(46) + 1);
                        File f = new File(file.getParentFile(), String.valueOf(name) + ".class");
                        if (f.exists()) {
                            return new FileInputStream(f);
                        }
                        return null;
                    }
                };
            }
            catch (FileNotFoundException e) {
                if (name.endsWith(".class")) {
                    System.err.println(e);
                    return;
                }
                loader = new ResourceClassFileDataLoader();
                in = loader.getClassData(name);
                if (in != null) break block10;
                System.err.println(e);
                return;
            }
        }
        in = new BufferedInputStream(in);
        ClassFile cf = ClassFile.readFrom(in, loader, null);
        PrintWriter out = new PrintWriter(System.out);
        if (style == null || style.equals("assembly")) {
            p = new AssemblyStylePrinter();
        } else if (style.equals("builder")) {
            p = new BuilderStylePrinter();
        } else {
            System.err.println("Unknown format style: " + style);
            return;
        }
        p.disassemble(cf, out);
        out.flush();
    }

    public static void call(ClassFile cf) throws Exception {
        PrintWriter out = new PrintWriter(System.out);
        AssemblyStylePrinter p = new AssemblyStylePrinter();
        p.disassemble(cf, out);
        out.flush();
    }

    public static interface Printer {
        public void disassemble(ClassFile var1, PrintWriter var2);
    }
}

