/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import org.cojen.classfile.AbstractCodeAssembler;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeAssembler;
import org.cojen.classfile.CodeBuffer;
import org.cojen.classfile.ConstantInfo;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.ExceptionHandler;
import org.cojen.classfile.InstructionList;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Opcode;
import org.cojen.classfile.TypeDesc;
import org.cojen.classfile.attribute.CodeAttr;
import org.cojen.classfile.constant.ConstantClassInfo;
import org.cojen.classfile.constant.ConstantDoubleInfo;
import org.cojen.classfile.constant.ConstantFieldInfo;
import org.cojen.classfile.constant.ConstantFloatInfo;
import org.cojen.classfile.constant.ConstantIntegerInfo;
import org.cojen.classfile.constant.ConstantLongInfo;
import org.cojen.classfile.constant.ConstantStringInfo;

public class CodeBuilder
extends AbstractCodeAssembler
implements CodeBuffer,
CodeAssembler {
    private final CodeAttr mCodeAttr;
    private final ClassFile mClassFile;
    private final ConstantPool mCp;
    private final InstructionList mInstructions;
    private final LocalVariable mThisReference;
    private final LocalVariable[] mParameters;
    private final int mTarget;
    private final boolean mSaveLineNumberInfo;
    private final boolean mSaveLocalVariableInfo;

    public CodeBuilder(MethodInfo info) {
        this(info, true, false);
    }

    public CodeBuilder(MethodInfo info, boolean saveLineNumberInfo, boolean saveLocalVariableInfo) {
        LocalVariable localVar;
        String target = info.getClassFile().getTarget();
        this.mTarget = "1.0".equals(target) ? 65536 : ("1.1".equals(target) ? 65537 : ("1.2".equals(target) ? 65538 : ("1.3".equals(target) ? 65539 : ("1.4".equals(target) ? 65540 : ("1.5".equals(target) ? 65541 : ("1.6".equals(target) ? 65542 : 65536))))));
        this.mCodeAttr = info.getCodeAttr();
        this.mClassFile = info.getClassFile();
        this.mCp = this.mClassFile.getConstantPool();
        this.mInstructions = new InstructionList(saveLocalVariableInfo);
        this.mCodeAttr.setCodeBuffer(this);
        this.mSaveLineNumberInfo = saveLineNumberInfo;
        this.mSaveLocalVariableInfo = saveLocalVariableInfo;
        if (info.getModifiers().isStatic()) {
            this.mThisReference = null;
        } else {
            this.mThisReference = localVar = this.mInstructions.createLocalParameter("this", this.mClassFile.getType());
            if (saveLocalVariableInfo) {
                this.mCodeAttr.localVariableUse(localVar);
            }
        }
        TypeDesc[] paramTypes = info.getMethodDescriptor().getParameterTypes();
        int paramSize = paramTypes.length;
        this.mParameters = new LocalVariable[paramSize];
        int i = 0;
        while (i < paramTypes.length) {
            this.mParameters[i] = localVar = this.mInstructions.createLocalParameter(null, paramTypes[i]);
            if (saveLocalVariableInfo) {
                this.mCodeAttr.localVariableUse(localVar);
            }
            ++i;
        }
    }

    @Override
    public int getMaxStackDepth() {
        return this.mInstructions.getMaxStackDepth();
    }

    @Override
    public int getMaxLocals() {
        return this.mInstructions.getMaxLocals();
    }

    @Override
    public byte[] getByteCodes() {
        return this.mInstructions.getByteCodes();
    }

    @Override
    public ExceptionHandler[] getExceptionHandlers() {
        return this.mInstructions.getExceptionHandlers();
    }

    private void addInstruction(int stackAdjust, TypeDesc pushed, byte opcode) {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.SimpleInstruction(instructionList, stackAdjust, pushed, new byte[]{opcode});
    }

    private void addInstruction(int stackAdjust, TypeDesc pushed, byte opcode, byte operand) {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.SimpleInstruction(instructionList, stackAdjust, pushed, new byte[]{opcode, operand});
    }

    private void addInstruction(int stackAdjust, TypeDesc pushed, byte opcode, short operand) {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.SimpleInstruction(instructionList, stackAdjust, pushed, new byte[]{opcode, (byte)(operand >> 8), (byte)operand});
    }

    private void addInstruction(int stackAdjust, TypeDesc pushed, byte opcode, ConstantInfo operand) {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        byte[] byArray = new byte[3];
        byArray[0] = opcode;
        new InstructionList.ConstantOperandInstruction(instructionList, stackAdjust, pushed, byArray, operand);
    }

    private String getClassName(TypeDesc classDesc) throws IllegalArgumentException {
        if (classDesc.isPrimitive()) {
            throw new IllegalArgumentException("Primitive type not allowed");
        }
        if (classDesc.isArray()) {
            throw new IllegalArgumentException("Array type not allowed");
        }
        return classDesc.getRootName();
    }

    @Override
    public int getParameterCount() {
        return this.mParameters.length;
    }

    @Override
    public LocalVariable getParameter(int index) {
        return this.mParameters[index];
    }

    @Override
    public LocalVariable createLocalVariable(String name, TypeDesc type) {
        LocalVariable localVar = this.mInstructions.createLocalVariable(name, type);
        if (this.mSaveLocalVariableInfo) {
            this.mCodeAttr.localVariableUse(localVar);
        }
        return localVar;
    }

    @Override
    public Label createLabel() {
        return new InstructionList.LabelInstruction(this.mInstructions);
    }

    @Override
    public void exceptionHandler(Location startLocation, Location endLocation, String catchClassName) {
        if (!(startLocation instanceof InstructionList.LabelInstruction)) {
            throw new IllegalArgumentException("Start location is not a label instruction");
        }
        if (!(endLocation instanceof InstructionList.LabelInstruction)) {
            throw new IllegalArgumentException("End location is not a label instruction");
        }
        Label catchLocation = this.createLabel().setLocation();
        ConstantClassInfo catchClass = catchClassName == null ? null : this.mCp.addConstantClass(catchClassName);
        ExceptionHandler<InstructionList.LabelInstruction> handler = new ExceptionHandler<InstructionList.LabelInstruction>((InstructionList.LabelInstruction)startLocation, (InstructionList.LabelInstruction)endLocation, (InstructionList.LabelInstruction)catchLocation, catchClass);
        this.mInstructions.addExceptionHandler(handler);
    }

    @Override
    public void mapLineNumber(int lineNumber) {
        if (this.mSaveLineNumberInfo) {
            this.mCodeAttr.mapLineNumber(this.createLabel().setLocation(), lineNumber);
        }
    }

    @Override
    public void loadNull() {
        this.addInstruction(1, null, (byte)1);
    }

    @Override
    public void loadConstant(String value) {
        if (value == null) {
            this.loadNull();
            return;
        }
        int strlen = value.length();
        if (strlen <= 21845) {
            ConstantStringInfo info = this.mCp.addConstantString(value);
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.LoadConstantInstruction(instructionList, 1, TypeDesc.STRING, info);
            return;
        }
        int utflen = 0;
        int i = 0;
        while (i < strlen) {
            char c = value.charAt(i);
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        if (utflen <= 65535) {
            ConstantStringInfo info = this.mCp.addConstantString(value);
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.LoadConstantInstruction(instructionList, 1, TypeDesc.STRING, info);
            return;
        }
        TypeDesc stringBufferDesc = this.mTarget >= 65541 ? TypeDesc.forClass("java.lang.StringBuilder") : TypeDesc.forClass(StringBuffer.class);
        TypeDesc intDesc = TypeDesc.INT;
        TypeDesc stringDesc = TypeDesc.STRING;
        TypeDesc[] stringParam = new TypeDesc[]{stringDesc};
        this.newObject(stringBufferDesc);
        this.dup();
        this.loadConstant(strlen);
        this.invokeConstructor(stringBufferDesc, new TypeDesc[]{intDesc});
        int endIndex = 0;
        while (endIndex < strlen) {
            int beginIndex = endIndex;
            utflen = 0;
            while (endIndex < strlen) {
                char c = value.charAt(endIndex);
                int size = c >= '\u0001' && c <= '\u007f' ? 1 : (c > '\u07ff' ? 3 : 2);
                if (utflen + size > 65535) break;
                utflen += size;
                ++endIndex;
            }
            String substr = value.substring(beginIndex, endIndex);
            ConstantStringInfo info = this.mCp.addConstantString(substr);
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.LoadConstantInstruction(instructionList, 1, TypeDesc.STRING, info);
            this.invokeVirtual(stringBufferDesc, "append", stringBufferDesc, stringParam);
        }
        this.invokeVirtual(stringBufferDesc, "toString", stringDesc, null);
    }

    @Override
    public void loadConstant(TypeDesc type) throws IllegalStateException {
        if (type == null) {
            this.loadNull();
            return;
        }
        if (type.isPrimitive()) {
            if (this.mTarget < 65537) {
                throw new IllegalStateException("Loading constant primitive classes not supported below target version 1.1");
            }
            this.loadStaticField(type.toObjectType(), "TYPE", TypeDesc.forClass(Class.class));
        } else {
            if (this.mTarget < 65541) {
                throw new IllegalStateException("Loading constant object classes not supported below target version 1.5");
            }
            ConstantClassInfo info = this.mCp.addConstantClass(type);
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.LoadConstantInstruction(instructionList, 1, TypeDesc.forClass(Class.class), info);
        }
    }

    @Override
    public void loadConstant(boolean value) {
        this.loadConstant(value ? 1 : 0);
    }

    @Override
    public void loadConstant(int value) {
        if (-1 <= value && value <= 5) {
            byte op;
            switch (value) {
                case -1: {
                    op = 2;
                    break;
                }
                case 0: {
                    op = 3;
                    break;
                }
                case 1: {
                    op = 4;
                    break;
                }
                case 2: {
                    op = 5;
                    break;
                }
                case 3: {
                    op = 6;
                    break;
                }
                case 4: {
                    op = 7;
                    break;
                }
                case 5: {
                    op = 8;
                    break;
                }
                default: {
                    op = 0;
                }
            }
            this.addInstruction(1, TypeDesc.INT, op);
        } else if (-128 <= value && value <= 127) {
            this.addInstruction(1, TypeDesc.INT, (byte)16, (byte)value);
        } else if (Short.MIN_VALUE <= value && value <= Short.MAX_VALUE) {
            this.addInstruction(1, TypeDesc.INT, (byte)17, (short)value);
        } else {
            ConstantIntegerInfo info = this.mCp.addConstantInteger(value);
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.LoadConstantInstruction(instructionList, 1, TypeDesc.INT, info);
        }
    }

    @Override
    public void loadConstant(long value) {
        if (value == 0L) {
            this.addInstruction(2, TypeDesc.LONG, (byte)9);
        } else if (value == 1L) {
            this.addInstruction(2, TypeDesc.LONG, (byte)10);
        } else {
            ConstantLongInfo info = this.mCp.addConstantLong(value);
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.LoadConstantInstruction(instructionList, 2, TypeDesc.LONG, info, true);
        }
    }

    @Override
    public void loadConstant(float value) {
        if (value == 0.0f) {
            this.addInstruction(1, TypeDesc.FLOAT, (byte)11);
        } else if (value == 1.0f) {
            this.addInstruction(1, TypeDesc.FLOAT, (byte)12);
        } else if (value == 2.0f) {
            this.addInstruction(1, TypeDesc.FLOAT, (byte)13);
        } else {
            ConstantFloatInfo info = this.mCp.addConstantFloat(value);
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.LoadConstantInstruction(instructionList, 1, TypeDesc.FLOAT, info);
        }
    }

    @Override
    public void loadConstant(double value) {
        if (value == 0.0) {
            this.addInstruction(2, TypeDesc.DOUBLE, (byte)14);
        } else if (value == 1.0) {
            this.addInstruction(2, TypeDesc.DOUBLE, (byte)15);
        } else {
            ConstantDoubleInfo info = this.mCp.addConstantDouble(value);
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.LoadConstantInstruction(instructionList, 2, TypeDesc.DOUBLE, info, true);
        }
    }

    @Override
    public void loadLocal(LocalVariable local) {
        if (local == null) {
            throw new IllegalArgumentException("No local variable specified");
        }
        int stackAdjust = local.getType().isDoubleWord() ? 2 : 1;
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.LoadLocalInstruction(instructionList, stackAdjust, local);
    }

    @Override
    public void loadThis() {
        if (this.mThisReference == null) {
            throw new IllegalStateException("Attempt to load \"this\" reference in a static method");
        }
        this.loadLocal(this.mThisReference);
    }

    @Override
    public void storeLocal(LocalVariable local) {
        if (local == null) {
            throw new IllegalArgumentException("No local variable specified");
        }
        int stackAdjust = local.getType().isDoubleWord() ? -2 : -1;
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.StoreLocalInstruction(instructionList, stackAdjust, local);
    }

    @Override
    public void loadFromArray(TypeDesc type) {
        byte op;
        int stackAdjust = -1;
        switch (type.getTypeCode()) {
            case 10: {
                op = 46;
                break;
            }
            case 4: 
            case 8: {
                op = 51;
                break;
            }
            case 9: {
                op = 53;
                break;
            }
            case 5: {
                op = 52;
                break;
            }
            case 6: {
                op = 48;
                break;
            }
            case 11: {
                stackAdjust = 0;
                op = 47;
                break;
            }
            case 7: {
                stackAdjust = 0;
                op = 49;
                break;
            }
            default: {
                op = 50;
            }
        }
        this.addInstruction(stackAdjust, type, op);
    }

    @Override
    public void storeToArray(TypeDesc type) {
        byte op;
        int stackAdjust = -3;
        switch (type.getTypeCode()) {
            case 10: {
                op = 79;
                break;
            }
            case 4: 
            case 8: {
                op = 84;
                break;
            }
            case 9: {
                op = 86;
                break;
            }
            case 5: {
                op = 85;
                break;
            }
            case 6: {
                op = 81;
                break;
            }
            case 11: {
                stackAdjust = -4;
                op = 80;
                break;
            }
            case 7: {
                stackAdjust = -4;
                op = 82;
                break;
            }
            default: {
                op = 83;
            }
        }
        this.addInstruction(stackAdjust, TypeDesc.VOID, op);
    }

    @Override
    public void loadField(String fieldName, TypeDesc type) {
        this.getfield(0, (byte)-76, this.constantField(fieldName, type), type);
    }

    @Override
    public void loadField(String className, String fieldName, TypeDesc type) {
        this.getfield(0, (byte)-76, this.mCp.addConstantField(className, fieldName, type), type);
    }

    @Override
    public void loadField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        this.loadField(this.getClassName(classDesc), fieldName, type);
    }

    @Override
    public void loadStaticField(String fieldName, TypeDesc type) {
        this.getfield(1, (byte)-78, this.constantField(fieldName, type), type);
    }

    @Override
    public void loadStaticField(String className, String fieldName, TypeDesc type) {
        this.getfield(1, (byte)-78, this.mCp.addConstantField(className, fieldName, type), type);
    }

    @Override
    public void loadStaticField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        this.loadStaticField(this.getClassName(classDesc), fieldName, type);
    }

    private void getfield(int stackAdjust, byte opcode, ConstantInfo info, TypeDesc type) {
        if (type.isDoubleWord()) {
            ++stackAdjust;
        }
        this.addInstruction(stackAdjust, type, opcode, info);
    }

    private ConstantFieldInfo constantField(String fieldName, TypeDesc type) {
        return this.mCp.addConstantField(this.mClassFile.getClassName(), fieldName, type);
    }

    @Override
    public void storeField(String fieldName, TypeDesc type) {
        this.putfield(-1, (byte)-75, this.constantField(fieldName, type), type);
    }

    @Override
    public void storeField(String className, String fieldName, TypeDesc type) {
        this.putfield(-1, (byte)-75, this.mCp.addConstantField(className, fieldName, type), type);
    }

    @Override
    public void storeField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        this.storeField(this.getClassName(classDesc), fieldName, type);
    }

    @Override
    public void storeStaticField(String fieldName, TypeDesc type) {
        this.putfield(0, (byte)-77, this.constantField(fieldName, type), type);
    }

    @Override
    public void storeStaticField(String className, String fieldName, TypeDesc type) {
        this.putfield(0, (byte)-77, this.mCp.addConstantField(className, fieldName, type), type);
    }

    @Override
    public void storeStaticField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        this.storeStaticField(this.getClassName(classDesc), fieldName, type);
    }

    private void putfield(int stackAdjust, byte opcode, ConstantInfo info, TypeDesc type) {
        stackAdjust = type.isDoubleWord() ? (stackAdjust -= 2) : --stackAdjust;
        this.addInstruction(stackAdjust, TypeDesc.VOID, opcode, info);
    }

    @Override
    public void returnVoid() {
        this.addInstruction(0, TypeDesc.VOID, (byte)-79);
    }

    @Override
    public void returnValue(TypeDesc type) {
        byte op;
        int stackAdjust = -1;
        switch (type.getTypeCode()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                op = -84;
                break;
            }
            case 6: {
                op = -82;
                break;
            }
            case 11: {
                stackAdjust = -2;
                op = -83;
                break;
            }
            case 7: {
                stackAdjust = -2;
                op = -81;
                break;
            }
            case 1: {
                stackAdjust = 0;
                op = -79;
                break;
            }
            default: {
                op = -80;
            }
        }
        this.addInstruction(stackAdjust, TypeDesc.VOID, op);
    }

    @Override
    public void convert(TypeDesc fromType, TypeDesc toType) {
        this.convert(fromType, toType, 0);
    }

    @Override
    public void convert(TypeDesc fromType, TypeDesc toType, int fpConvertMode) {
        Label end;
        block70: {
            byte op;
            TypeDesc toPrimitiveType;
            if (fpConvertMode < 0 || fpConvertMode > 2) {
                throw new IllegalArgumentException("Illegal floating point conversion mode");
            }
            if (toType == TypeDesc.OBJECT) {
                if (fromType.isPrimitive()) {
                    toType = fromType.toObjectType();
                } else {
                    return;
                }
            }
            if (fromType == toType) {
                return;
            }
            TypeDesc fromPrimitiveType = fromType.toPrimitiveType();
            if (fromPrimitiveType == null) {
                Class toClass;
                Class fromClass;
                if (!toType.isPrimitive() && (fromClass = fromType.toClass()) != null && (toClass = toType.toClass()) != null && toClass.isAssignableFrom(fromClass)) {
                    return;
                }
                throw this.invalidConversion(fromType, toType);
            }
            int fromTypeCode = fromPrimitiveType.getTypeCode();
            if (toType.toClass() == Number.class) {
                switch (fromTypeCode) {
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        if (fromType.isPrimitive()) {
                            toType = fromType.toObjectType();
                            break;
                        }
                        return;
                    }
                }
            }
            if ((toPrimitiveType = toType.toPrimitiveType()) == null) {
                throw this.invalidConversion(fromType, toType);
            }
            int toTypeCode = toPrimitiveType.getTypeCode();
            end = this.createLabel();
            int stackAdjust = 0;
            block3 : switch (fromTypeCode) {
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    switch (toTypeCode) {
                        case 8: {
                            op = fromTypeCode == 8 ? (byte)0 : -111;
                            break block3;
                        }
                        case 9: {
                            op = fromTypeCode == 9 ? (byte)0 : -109;
                            break block3;
                        }
                        case 5: {
                            op = fromTypeCode == 5 ? (byte)0 : -110;
                            break block3;
                        }
                        case 6: {
                            op = -122;
                            break block3;
                        }
                        case 11: {
                            stackAdjust = 1;
                            op = -123;
                            break block3;
                        }
                        case 7: {
                            stackAdjust = 1;
                            op = -121;
                            break block3;
                        }
                        case 10: {
                            op = 0;
                            break block3;
                        }
                        case 4: {
                            if (!fromType.isPrimitive()) {
                                if (!toType.isPrimitive()) {
                                    this.nullConvert(end);
                                }
                                this.unbox(fromType, fromPrimitiveType);
                            }
                            this.toBoolean(!toType.isPrimitive());
                            break block70;
                        }
                        default: {
                            throw this.invalidConversion(fromType, toType);
                        }
                    }
                }
                case 11: {
                    switch (toTypeCode) {
                        case 10: {
                            stackAdjust = -1;
                            op = -120;
                            break block3;
                        }
                        case 6: {
                            stackAdjust = -1;
                            op = -119;
                            break block3;
                        }
                        case 7: {
                            op = -118;
                            break block3;
                        }
                        case 5: 
                        case 8: 
                        case 9: {
                            this.addInstruction(-1, TypeDesc.INT, (byte)-120);
                            this.convert(TypeDesc.INT, toPrimitiveType);
                        }
                        case 11: {
                            op = 0;
                            break block3;
                        }
                        case 4: {
                            if (!fromType.isPrimitive()) {
                                if (!toType.isPrimitive()) {
                                    this.nullConvert(end);
                                }
                                this.unbox(fromType, fromPrimitiveType);
                            }
                            this.loadConstant(0L);
                            this.math((byte)-108);
                            this.toBoolean(!toType.isPrimitive());
                            break block70;
                        }
                        default: {
                            throw this.invalidConversion(fromType, toType);
                        }
                    }
                }
                case 6: {
                    switch (toTypeCode) {
                        case 10: {
                            op = -117;
                            break block3;
                        }
                        case 11: {
                            stackAdjust = 1;
                            op = -116;
                            break block3;
                        }
                        case 7: {
                            stackAdjust = 1;
                            op = -115;
                            break block3;
                        }
                        case 5: 
                        case 8: 
                        case 9: {
                            this.addInstruction(0, TypeDesc.INT, (byte)-117);
                            this.convert(TypeDesc.INT, toPrimitiveType);
                        }
                        case 6: {
                            op = 0;
                            break block3;
                        }
                        case 4: {
                            if (!fromType.isPrimitive()) {
                                if (!toType.isPrimitive()) {
                                    this.nullConvert(end);
                                }
                                this.unbox(fromType, fromPrimitiveType);
                            }
                            this.loadConstant(0.0f);
                            this.math((byte)-106);
                            this.toBoolean(!toType.isPrimitive());
                            break block70;
                        }
                        default: {
                            throw this.invalidConversion(fromType, toType);
                        }
                    }
                }
                case 7: {
                    switch (toTypeCode) {
                        case 10: {
                            stackAdjust = -1;
                            op = -114;
                            break block3;
                        }
                        case 6: {
                            stackAdjust = -1;
                            op = -112;
                            break block3;
                        }
                        case 11: {
                            op = -113;
                            break block3;
                        }
                        case 5: 
                        case 8: 
                        case 9: {
                            this.addInstruction(-1, TypeDesc.INT, (byte)-114);
                            this.convert(TypeDesc.INT, toPrimitiveType);
                        }
                        case 7: {
                            op = 0;
                            break block3;
                        }
                        case 4: {
                            if (!fromType.isPrimitive()) {
                                if (!toType.isPrimitive()) {
                                    this.nullConvert(end);
                                }
                                this.unbox(fromType, fromPrimitiveType);
                            }
                            this.loadConstant(0.0);
                            this.math((byte)-104);
                            this.toBoolean(!toType.isPrimitive());
                            break block70;
                        }
                        default: {
                            throw this.invalidConversion(fromType, toType);
                        }
                    }
                }
                default: {
                    throw this.invalidConversion(fromType, toType);
                }
            }
            if (!fromType.isPrimitive()) {
                if (!toType.isPrimitive()) {
                    this.nullConvert(end);
                }
                this.unbox(fromType, fromPrimitiveType);
            }
            if (toType.isPrimitive()) {
                if (op != 0) {
                    this.convertPrimitive(stackAdjust, op, fpConvertMode);
                }
            } else {
                if (op == 0) {
                    this.prebox(toPrimitiveType, toType);
                } else if (!fromPrimitiveType.isDoubleWord() && toPrimitiveType.isDoubleWord()) {
                    this.prebox(fromPrimitiveType, toType);
                    this.convertPrimitive(stackAdjust, op, fpConvertMode);
                } else {
                    this.convertPrimitive(stackAdjust, op, fpConvertMode);
                    this.prebox(toPrimitiveType, toType);
                }
                this.box(toPrimitiveType, toType);
            }
        }
        end.setLocation();
    }

    private void unbox(TypeDesc from, TypeDesc to) {
        String methodName;
        switch (to.getTypeCode()) {
            case 4: {
                methodName = "booleanValue";
                break;
            }
            case 5: {
                methodName = "charValue";
                break;
            }
            case 6: {
                methodName = "floatValue";
                break;
            }
            case 7: {
                methodName = "doubleValue";
                break;
            }
            case 8: {
                methodName = "byteValue";
                break;
            }
            case 9: {
                methodName = "shortValue";
                break;
            }
            case 10: {
                methodName = "intValue";
                break;
            }
            case 11: {
                methodName = "longValue";
                break;
            }
            default: {
                return;
            }
        }
        this.invokeVirtual(from.getRootName(), methodName, to, null);
    }

    private void prebox(TypeDesc from, TypeDesc to) {
        if (this.mTarget >= 65541) {
            return;
        }
        switch (from.getTypeCode()) {
            default: {
                break;
            }
            case 4: {
                if (to.toPrimitiveType().getTypeCode() == 4) break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                this.newObject(to);
                this.dupX1();
                this.swap();
                break;
            }
            case 7: 
            case 11: {
                this.newObject(to);
                this.dupX2();
                this.dupX2();
                this.pop();
            }
        }
    }

    private void box(TypeDesc from, TypeDesc to) {
        if (this.mTarget >= 65541) {
            this.invokeStatic(to.getRootName(), "valueOf", to, new TypeDesc[]{from});
            return;
        }
        switch (from.getTypeCode()) {
            case 4: {
                this.toBoolean(true);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.invokeConstructor(to.getRootName(), new TypeDesc[]{from});
            }
        }
    }

    private void toBoolean(boolean box) {
        if (box && this.mTarget >= 65540) {
            this.invokeStatic("java.lang.Boolean", "valueOf", TypeDesc.BOOLEAN.toObjectType(), new TypeDesc[]{TypeDesc.BOOLEAN});
            return;
        }
        Label nonZero = this.createLabel();
        Label done = this.createLabel();
        this.ifZeroComparisonBranch(nonZero, "!=");
        if (box) {
            TypeDesc newType = TypeDesc.BOOLEAN.toObjectType();
            this.loadStaticField(newType.getRootName(), "FALSE", newType);
            this.branch(done);
            nonZero.setLocation();
            this.loadStaticField(newType.getRootName(), "TRUE", newType);
        } else {
            this.loadConstant(false);
            this.branch(done);
            nonZero.setLocation();
            this.loadConstant(true);
        }
        done.setLocation();
    }

    private void convertPrimitive(int stackAdjust, byte op, int fpConvertMode) {
        TypeDesc pushed;
        if (fpConvertMode != 0) {
            switch (op) {
                case -122: {
                    this.invokeStatic("java.lang.Float", "intBitsToFloat", TypeDesc.FLOAT, new TypeDesc[]{TypeDesc.INT});
                    return;
                }
                case -118: {
                    this.invokeStatic("java.lang.Double", "longBitsToDouble", TypeDesc.DOUBLE, new TypeDesc[]{TypeDesc.LONG});
                    return;
                }
                case -117: {
                    if (fpConvertMode == 2) {
                        this.invokeStatic("java.lang.Float", "floatToRawIntBits", TypeDesc.INT, new TypeDesc[]{TypeDesc.FLOAT});
                    } else {
                        this.invokeStatic("java.lang.Float", "floatToIntBits", TypeDesc.INT, new TypeDesc[]{TypeDesc.FLOAT});
                    }
                    return;
                }
                case -113: {
                    if (fpConvertMode == 2) {
                        this.invokeStatic("java.lang.Double", "doubleToRawLongBits", TypeDesc.LONG, new TypeDesc[]{TypeDesc.DOUBLE});
                    } else {
                        this.invokeStatic("java.lang.Double", "doubleToLongBits", TypeDesc.LONG, new TypeDesc[]{TypeDesc.DOUBLE});
                    }
                    return;
                }
            }
        }
        switch (op) {
            case -122: {
                pushed = TypeDesc.FLOAT;
                break;
            }
            case -118: {
                pushed = TypeDesc.DOUBLE;
                break;
            }
            case -117: {
                pushed = TypeDesc.INT;
                break;
            }
            case -113: {
                pushed = TypeDesc.LONG;
                break;
            }
            default: {
                pushed = TypeDesc.VOID;
            }
        }
        this.addInstruction(stackAdjust, pushed, op);
    }

    private void nullConvert(Label end) {
        LocalVariable temp = this.createLocalVariable("temp", TypeDesc.OBJECT);
        this.storeLocal(temp);
        this.loadLocal(temp);
        Label notNull = this.createLabel();
        this.ifNullBranch(notNull, false);
        this.loadNull();
        this.branch(end);
        notNull.setLocation();
        this.loadLocal(temp);
    }

    private IllegalArgumentException invalidConversion(TypeDesc from, TypeDesc to) {
        throw new IllegalArgumentException("Invalid conversion: " + from.getFullName() + " to " + to.getFullName());
    }

    @Override
    public void invokeVirtual(String methodName, TypeDesc ret, TypeDesc[] params) {
        this.invokeVirtual(this.mClassFile.getClassName(), methodName, ret, params);
    }

    @Override
    public void invokeVirtual(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.InvokeInstruction(instructionList, -74, this.mCp.addConstantMethod(className, methodName, ret, params), ret, params);
    }

    @Override
    public void invokeVirtual(TypeDesc classDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.invokeVirtual(this.getClassName(classDesc), methodName, ret, params);
    }

    @Override
    public void invokeStatic(String methodName, TypeDesc ret, TypeDesc[] params) {
        this.invokeStatic(this.mClassFile.getClassName(), methodName, ret, params);
    }

    @Override
    public void invokeStatic(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.InvokeInstruction(instructionList, -72, this.mCp.addConstantMethod(className, methodName, ret, params), ret, params);
    }

    @Override
    public void invokeStatic(TypeDesc classDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.invokeStatic(this.getClassName(classDesc), methodName, ret, params);
    }

    @Override
    public void invokeInterface(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.InvokeInstruction(instructionList, -71, this.mCp.addConstantInterfaceMethod(className, methodName, ret, params), ret, params);
    }

    @Override
    public void invokeInterface(TypeDesc classDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.invokeInterface(this.getClassName(classDesc), methodName, ret, params);
    }

    @Override
    public void invokePrivate(String methodName, TypeDesc ret, TypeDesc[] params) {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.InvokeInstruction(instructionList, -73, this.mCp.addConstantMethod(this.mClassFile.getClassName(), methodName, ret, params), ret, params);
    }

    @Override
    public void invokeSuper(String superClassName, String methodName, TypeDesc ret, TypeDesc[] params) {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.InvokeInstruction(instructionList, -73, this.mCp.addConstantMethod(superClassName, methodName, ret, params), ret, params);
    }

    @Override
    public void invokeSuper(TypeDesc superClassDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.invokeSuper(this.getClassName(superClassDesc), methodName, ret, params);
    }

    @Override
    public void invokeConstructor(TypeDesc[] params) {
        this.invokeConstructor(this.mClassFile.getClassName(), this.mClassFile.getType(), params);
    }

    @Override
    public void invokeConstructor(String className, TypeDesc[] params) {
        this.invokeConstructor(className, TypeDesc.forClass(className), params);
    }

    @Override
    public void invokeConstructor(TypeDesc classDesc, TypeDesc[] params) {
        this.invokeConstructor(this.getClassName(classDesc), classDesc, params);
    }

    private void invokeConstructor(String className, TypeDesc classDesc, TypeDesc[] params) {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.InvokeConstructorInstruction(instructionList, this.mCp.addConstantConstructor(className, params), classDesc, params);
    }

    @Override
    public void invokeSuperConstructor(TypeDesc[] params) {
        this.invokeConstructor(this.mClassFile.getSuperClassName(), params);
    }

    @Override
    public void newObject(TypeDesc type) {
        if (type.isArray()) {
            this.newObject(type, 1);
        } else {
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.NewObjectInstruction(instructionList, this.mCp.addConstantClass(type));
        }
    }

    @Override
    public void newObject(TypeDesc type, int dimensions) {
        if (dimensions <= 0) {
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.NewObjectInstruction(instructionList, this.mCp.addConstantClass(type));
            return;
        }
        TypeDesc componentType = type.getComponentType();
        if (dimensions == 1) {
            if (componentType.isPrimitive()) {
                this.addInstruction(0, type, (byte)-68, (byte)componentType.getTypeCode());
                return;
            }
            this.addInstruction(0, type, (byte)-67, this.mCp.addConstantClass(componentType));
            return;
        }
        int stackAdjust = -(dimensions - 1);
        ConstantClassInfo info = this.mCp.addConstantClass(type);
        byte[] bytes = new byte[4];
        bytes[0] = -59;
        bytes[3] = (byte)dimensions;
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.ConstantOperandInstruction(instructionList, stackAdjust, type, bytes, info);
    }

    @Override
    public void dup() {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.StackOperationInstruction(instructionList, 89);
    }

    @Override
    public void dupX1() {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.StackOperationInstruction(instructionList, 90);
    }

    @Override
    public void dupX2() {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.StackOperationInstruction(instructionList, 91);
    }

    @Override
    public void dup2() {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.StackOperationInstruction(instructionList, 92);
    }

    @Override
    public void dup2X1() {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.StackOperationInstruction(instructionList, 93);
    }

    @Override
    public void dup2X2() {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.StackOperationInstruction(instructionList, 94);
    }

    @Override
    public void pop() {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.StackOperationInstruction(instructionList, 87);
    }

    @Override
    public void pop2() {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.StackOperationInstruction(instructionList, 88);
    }

    @Override
    public void swap() {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.StackOperationInstruction(instructionList, 95);
    }

    @Override
    public void swap2() {
        this.dup2X2();
        this.pop2();
    }

    private void branch(int stackAdjust, Location location, byte opcode) {
        if (!(location instanceof InstructionList.LabelInstruction)) {
            throw new IllegalArgumentException("Branch location is not a label instruction");
        }
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.BranchInstruction(instructionList, stackAdjust, opcode, (InstructionList.LabelInstruction)location);
    }

    @Override
    public void branch(Location location) {
        this.branch(0, location, (byte)-89);
    }

    @Override
    public void ifNullBranch(Location location, boolean choice) {
        this.branch(-1, location, choice ? (byte)-58 : -57);
    }

    @Override
    public void ifEqualBranch(Location location, boolean choice) {
        this.branch(-2, location, choice ? (byte)-91 : -90);
    }

    @Override
    public void ifZeroComparisonBranch(Location location, String choice) throws IllegalArgumentException {
        int opcode;
        if ((choice = choice.intern()) == "==") {
            opcode = -103;
        } else if (choice == "!=") {
            opcode = -102;
        } else if (choice == "<") {
            opcode = -101;
        } else if (choice == ">=") {
            opcode = -100;
        } else if (choice == ">") {
            opcode = -99;
        } else if (choice == "<=") {
            opcode = -98;
        } else {
            throw new IllegalArgumentException("Invalid comparision choice: " + choice);
        }
        this.branch(-1, location, (byte)opcode);
    }

    @Override
    public void ifComparisonBranch(Location location, String choice) throws IllegalArgumentException {
        int opcode;
        if ((choice = choice.intern()) == "==") {
            opcode = -97;
        } else if (choice == "!=") {
            opcode = -96;
        } else if (choice == "<") {
            opcode = -95;
        } else if (choice == ">=") {
            opcode = -94;
        } else if (choice == ">") {
            opcode = -93;
        } else if (choice == "<=") {
            opcode = -92;
        } else {
            throw new IllegalArgumentException("Invalid comparision choice: " + choice);
        }
        this.branch(-2, location, (byte)opcode);
    }

    @Override
    public void switchBranch(int[] cases, Location[] locations, Location defaultLocation) {
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.SwitchInstruction(instructionList, cases, locations, defaultLocation);
    }

    @Override
    public void jsr(Location location) {
        this.branch(1, location, (byte)-88);
    }

    @Override
    public void ret(LocalVariable local) {
        if (local == null) {
            throw new IllegalArgumentException("No local variable specified");
        }
        InstructionList instructionList = this.mInstructions;
        instructionList.getClass();
        new InstructionList.RetInstruction(instructionList, local);
    }

    @Override
    public void math(byte opcode) {
        TypeDesc pushed;
        int stackAdjust;
        switch (opcode) {
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                stackAdjust = 0;
                break;
            }
            case -128: 
            case -126: 
            case -107: 
            case -106: 
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 110: 
            case 112: 
            case 114: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                stackAdjust = -1;
                break;
            }
            case -127: 
            case -125: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 127: {
                stackAdjust = -2;
                break;
            }
            case -108: 
            case -105: 
            case -104: {
                stackAdjust = -3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a math opcode: " + Opcode.getMnemonic(opcode));
            }
        }
        switch (opcode) {
            case -128: 
            case -126: 
            case -108: 
            case -107: 
            case -106: 
            case -105: 
            case -104: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 116: 
            case 120: 
            case 122: 
            case 124: 
            case 126: {
                pushed = TypeDesc.INT;
                break;
            }
            case -127: 
            case -125: 
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 117: 
            case 121: 
            case 123: 
            case 125: 
            case 127: {
                pushed = TypeDesc.LONG;
                break;
            }
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: 
            case 118: {
                pushed = TypeDesc.FLOAT;
                break;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: 
            case 119: {
                pushed = TypeDesc.DOUBLE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a math opcode: " + Opcode.getMnemonic(opcode));
            }
        }
        this.addInstruction(stackAdjust, pushed, opcode);
    }

    @Override
    public void arrayLength() {
        this.addInstruction(0, TypeDesc.INT, (byte)-66);
    }

    @Override
    public void throwObject() {
        this.addInstruction(-1, TypeDesc.VOID, (byte)-65);
    }

    @Override
    public void checkCast(TypeDesc type) {
        ConstantClassInfo info = this.mCp.addConstantClass(type);
        this.addInstruction(0, TypeDesc.VOID, (byte)-64, info);
    }

    @Override
    public void instanceOf(TypeDesc type) {
        ConstantClassInfo info = this.mCp.addConstantClass(type);
        this.addInstruction(0, TypeDesc.INT, (byte)-63, info);
    }

    @Override
    public void integerIncrement(LocalVariable local, int amount) {
        if (local == null) {
            throw new IllegalArgumentException("No local variable specified");
        }
        if (Short.MIN_VALUE <= amount && amount <= Short.MAX_VALUE) {
            InstructionList instructionList = this.mInstructions;
            instructionList.getClass();
            new InstructionList.ShortIncrementInstruction(instructionList, local, (short)amount);
        } else {
            this.loadLocal(local);
            this.loadConstant(amount);
            this.math((byte)96);
            this.storeLocal(local);
        }
    }

    @Override
    public void monitorEnter() {
        this.addInstruction(-1, TypeDesc.VOID, (byte)-62);
    }

    @Override
    public void monitorExit() {
        this.addInstruction(-1, TypeDesc.VOID, (byte)-61);
    }

    @Override
    public void nop() {
        this.addInstruction(0, TypeDesc.VOID, (byte)0);
    }

    @Override
    public void breakpoint() {
        this.addInstruction(0, TypeDesc.VOID, (byte)-54);
    }
}

