/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cojen.classfile.AbstractCodeAssembler;
import org.cojen.classfile.CodeAssembler;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.LocationRange;
import org.cojen.classfile.Opcode;
import org.cojen.classfile.TypeDesc;

public class CodeAssemblerPrinter
extends AbstractCodeAssembler
implements CodeAssembler {
    private final LocalVariable[] mParams;
    private final boolean mIsStatic;
    private final PrintWriter mWriter;
    private final String mLinePrefix;
    private final String mLineSuffix;
    private final String mBulder;
    private boolean mNeedSeparatorLine;
    private int mLocalCounter;
    private int mLabelCounter;
    private int mTypeDescCounter;
    private Map<TypeDesc, String> mTypeDescNames;
    private int mTypeDescArrayCounter;
    private Map<List<TypeDesc>, String> mTypeDescArrayNames;

    public CodeAssemblerPrinter(TypeDesc[] paramTypes, boolean isStatic, PrintWriter writer) {
        this(paramTypes, isStatic, writer, null, null, null);
    }

    public CodeAssemblerPrinter(TypeDesc[] paramTypes, boolean isStatic, PrintWriter writer, String linePrefix, String lineSuffix, String builder) {
        this.mIsStatic = isStatic;
        this.mWriter = writer;
        this.mLinePrefix = linePrefix;
        this.mLineSuffix = lineSuffix;
        if (builder == null || builder.length() == 0) {
            builder = "";
        } else if (!builder.endsWith(".")) {
            builder = String.valueOf(builder) + '.';
        }
        this.mBulder = builder;
        this.mTypeDescNames = new HashMap<TypeDesc, String>();
        this.mTypeDescArrayNames = new HashMap<List<TypeDesc>, String>();
        this.mParams = new LocalVariable[paramTypes.length];
        int varNum = isStatic ? 0 : 1;
        int i = 0;
        while (i < paramTypes.length) {
            String varName = "var_" + ++this.mLocalCounter;
            this.println("LocalVariable " + varName + " = " + this.mBulder + "getParameter(" + i + ')');
            NamedLocal localVar = new NamedLocal(varName, paramTypes[i], varNum);
            varNum += localVar.isDoubleWord() ? 2 : 1;
            this.mParams[i] = localVar;
            ++i;
        }
    }

    @Override
    public int getParameterCount() {
        return this.mParams.length;
    }

    @Override
    public LocalVariable getParameter(int index) {
        return this.mParams[index];
    }

    @Override
    public LocalVariable createLocalVariable(String name, TypeDesc type) {
        String varName = "var_" + ++this.mLocalCounter;
        if (name != null) {
            name = String.valueOf('\"') + name + '\"';
        }
        this.println("LocalVariable " + varName + " = " + this.mBulder + "createLocalVariable(" + name + ", " + this.getTypeDescName(type) + ')');
        return new NamedLocal(varName, type, -1);
    }

    @Override
    public Label createLabel() {
        String name = "label_" + ++this.mLabelCounter;
        this.println("Label " + name + " = " + this.mBulder + "createLabel()");
        return new NamedLabel(name);
    }

    @Override
    public void exceptionHandler(Location startLocation, Location endLocation, String catchClassName) {
        this.println(String.valueOf(this.mBulder) + "exceptionHandler(" + this.getLabelName(startLocation) + ", " + this.getLabelName(endLocation) + ", " + (catchClassName == null ? "null" : String.valueOf('\"') + catchClassName + '\"') + ')');
    }

    @Override
    public void mapLineNumber(int lineNumber) {
        this.separatorLine();
        this.println(String.valueOf(this.mBulder) + "mapLineNumber(" + lineNumber + ')');
    }

    @Override
    public void loadNull() {
        this.println(String.valueOf(this.mBulder) + "loadNull()");
    }

    @Override
    public void loadConstant(String value) {
        if (value == null) {
            this.loadNull();
        } else {
            this.println(String.valueOf(this.mBulder) + "loadConstant(\"" + CodeAssemblerPrinter.escape(value) + "\")");
        }
    }

    @Override
    public void loadConstant(TypeDesc type) {
        if (type == null) {
            this.loadNull();
        } else {
            this.println(String.valueOf(this.mBulder) + "loadConstant(" + this.getTypeDescName(type) + ')');
        }
    }

    @Override
    public void loadConstant(boolean value) {
        this.println(String.valueOf(this.mBulder) + "loadConstant(" + value + ')');
    }

    @Override
    public void loadConstant(int value) {
        this.println(String.valueOf(this.mBulder) + "loadConstant(" + value + ')');
    }

    @Override
    public void loadConstant(long value) {
        this.println(String.valueOf(this.mBulder) + "loadConstant(" + value + "L)");
    }

    @Override
    public void loadConstant(float value) {
        String str = value != value ? "0.0f/0.0f" : (value == Float.NEGATIVE_INFINITY ? "-1.0f/0.0f" : (value == Float.POSITIVE_INFINITY ? "1.0f/0.0f" : String.valueOf(String.valueOf(value)) + 'f'));
        this.println(String.valueOf(this.mBulder) + "loadConstant(" + str + ")");
    }

    @Override
    public void loadConstant(double value) {
        String str = value != value ? "0.0d/0.0d" : (value == Double.NEGATIVE_INFINITY ? "-1.0d/0.0d" : (value == Double.POSITIVE_INFINITY ? "1.0d/0.0d" : String.valueOf(String.valueOf(value)) + 'd'));
        this.println(String.valueOf(this.mBulder) + "loadConstant(" + str + ")");
    }

    @Override
    public void loadLocal(LocalVariable local) {
        this.println(String.valueOf(this.mBulder) + "loadLocal(" + local.getName() + ')');
    }

    @Override
    public void loadThis() {
        this.println(String.valueOf(this.mBulder) + "loadThis()");
    }

    @Override
    public void storeLocal(LocalVariable local) {
        this.println(String.valueOf(this.mBulder) + "storeLocal(" + local.getName() + ')');
    }

    @Override
    public void loadFromArray(TypeDesc type) {
        this.println(String.valueOf(this.mBulder) + "loadFromArray(" + this.getTypeDescName(type) + ')');
    }

    @Override
    public void storeToArray(TypeDesc type) {
        this.println(String.valueOf(this.mBulder) + "storeToArray(" + this.getTypeDescName(type) + ')');
    }

    @Override
    public void loadField(String fieldName, TypeDesc type) {
        this.println(String.valueOf(this.mBulder) + "loadField(\"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    @Override
    public void loadField(String className, String fieldName, TypeDesc type) {
        this.println(String.valueOf(this.mBulder) + "loadField(\"" + className + "\", \"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    @Override
    public void loadField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        this.println(String.valueOf(this.mBulder) + "loadField(\"" + this.getTypeDescName(classDesc) + "\", \"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    @Override
    public void loadStaticField(String fieldName, TypeDesc type) {
        this.println(String.valueOf(this.mBulder) + "loadStaticField(\"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    @Override
    public void loadStaticField(String className, String fieldName, TypeDesc type) {
        this.println(String.valueOf(this.mBulder) + "loadStaticField(\"" + className + "\", \"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    @Override
    public void loadStaticField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        this.println(String.valueOf(this.mBulder) + "loadStaticField(\"" + this.getTypeDescName(classDesc) + "\", \"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    @Override
    public void storeField(String fieldName, TypeDesc type) {
        this.println(String.valueOf(this.mBulder) + "storeField(\"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    @Override
    public void storeField(String className, String fieldName, TypeDesc type) {
        this.println(String.valueOf(this.mBulder) + "storeField(\"" + className + "\", \"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    @Override
    public void storeField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        this.println(String.valueOf(this.mBulder) + "storeField(\"" + this.getTypeDescName(classDesc) + "\", \"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    @Override
    public void storeStaticField(String fieldName, TypeDesc type) {
        this.println(String.valueOf(this.mBulder) + "storeStaticField(\"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    @Override
    public void storeStaticField(String className, String fieldName, TypeDesc type) {
        this.println(String.valueOf(this.mBulder) + "storeStaticField(\"" + className + "\", \"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    @Override
    public void storeStaticField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        this.println(String.valueOf(this.mBulder) + "storeStaticField(\"" + this.getTypeDescName(classDesc) + "\", \"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    @Override
    public void returnVoid() {
        this.println(String.valueOf(this.mBulder) + "returnVoid()");
    }

    @Override
    public void returnValue(TypeDesc type) {
        this.println(String.valueOf(this.mBulder) + "returnValue(" + this.getTypeDescName(type) + ')');
    }

    @Override
    public void convert(TypeDesc fromType, TypeDesc toType) {
        this.println(String.valueOf(this.mBulder) + "convert(" + this.getTypeDescName(fromType) + ", " + this.getTypeDescName(toType) + ')');
    }

    @Override
    public void convert(TypeDesc fromType, TypeDesc toType, int fpConvertMode) {
        switch (fpConvertMode) {
            default: {
                this.convert(fromType, toType);
                break;
            }
            case 1: {
                this.println(String.valueOf(this.mBulder) + "convert(" + this.getTypeDescName(fromType) + ", " + this.getTypeDescName(toType) + ", " + this.mBulder + ".CONVERT_FP_BITS" + ')');
                break;
            }
            case 2: {
                this.println(String.valueOf(this.mBulder) + "convert(" + this.getTypeDescName(fromType) + ", " + this.getTypeDescName(toType) + ", " + this.mBulder + ".CONVERT_FP_RAW_BITS" + ')');
            }
        }
    }

    @Override
    public void invokeVirtual(String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println(String.valueOf(this.mBulder) + "invokeVirtual(\"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void invokeVirtual(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println(String.valueOf(this.mBulder) + "invokeVirtual(\"" + className + "\", \"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void invokeVirtual(TypeDesc classDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println(String.valueOf(this.mBulder) + "invokeVirtual(\"" + this.getTypeDescName(classDesc) + "\", \"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void invokeStatic(String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println(String.valueOf(this.mBulder) + "invokeStatic(\"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void invokeStatic(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println(String.valueOf(this.mBulder) + "invokeStatic(\"" + className + "\", \"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void invokeStatic(TypeDesc classDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println(String.valueOf(this.mBulder) + "invokeStatic(\"" + this.getTypeDescName(classDesc) + "\", \"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void invokeInterface(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println(String.valueOf(this.mBulder) + "invokeInterface(\"" + className + "\", \"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void invokeInterface(TypeDesc classDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println(String.valueOf(this.mBulder) + "invokeInterface(\"" + this.getTypeDescName(classDesc) + "\", \"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void invokePrivate(String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println(String.valueOf(this.mBulder) + "invokePrivate(\"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void invokeSuper(String superClassName, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println(String.valueOf(this.mBulder) + "invokeSuper(\"" + superClassName + "\", \"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void invokeSuper(TypeDesc superClassDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println(String.valueOf(this.mBulder) + "invokeSuper(\"" + this.getTypeDescName(superClassDesc) + "\", \"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void invokeConstructor(TypeDesc[] params) {
        this.println(String.valueOf(this.mBulder) + "invokeConstructor(" + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void invokeConstructor(String className, TypeDesc[] params) {
        this.println(String.valueOf(this.mBulder) + "invokeConstructor(\"" + className + "\", " + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void invokeConstructor(TypeDesc classDesc, TypeDesc[] params) {
        this.println(String.valueOf(this.mBulder) + "invokeConstructor(\"" + this.getTypeDescName(classDesc) + "\", " + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void invokeSuperConstructor(TypeDesc[] params) {
        this.println(String.valueOf(this.mBulder) + "invokeSuperConstructor(" + this.getTypeDescArrayName(params) + ')');
    }

    @Override
    public void newObject(TypeDesc type) {
        this.println(String.valueOf(this.mBulder) + "newObject(" + this.getTypeDescName(type) + ')');
    }

    @Override
    public void newObject(TypeDesc type, int dimensions) {
        if (dimensions == 0 && !type.isArray()) {
            this.newObject(type);
        } else {
            this.println(String.valueOf(this.mBulder) + "newObject(" + this.getTypeDescName(type) + ", " + dimensions + ')');
        }
    }

    @Override
    public void dup() {
        this.println(String.valueOf(this.mBulder) + "dup()");
    }

    @Override
    public void dupX1() {
        this.println(String.valueOf(this.mBulder) + "dupX1()");
    }

    @Override
    public void dupX2() {
        this.println(String.valueOf(this.mBulder) + "dupX2()");
    }

    @Override
    public void dup2() {
        this.println(String.valueOf(this.mBulder) + "dup2()");
    }

    @Override
    public void dup2X1() {
        this.println(String.valueOf(this.mBulder) + "dup2X1()");
    }

    @Override
    public void dup2X2() {
        this.println(String.valueOf(this.mBulder) + "dup2X2()");
    }

    @Override
    public void pop() {
        this.println(String.valueOf(this.mBulder) + "pop()");
    }

    @Override
    public void pop2() {
        this.println(String.valueOf(this.mBulder) + "pop2()");
    }

    @Override
    public void swap() {
        this.println(String.valueOf(this.mBulder) + "swap()");
    }

    @Override
    public void swap2() {
        this.println(String.valueOf(this.mBulder) + "swap2()");
    }

    @Override
    public void branch(Location location) {
        this.println(String.valueOf(this.mBulder) + "branch(" + this.getLabelName(location) + ')');
    }

    @Override
    public void ifNullBranch(Location location, boolean choice) {
        this.println(String.valueOf(this.mBulder) + "ifNullBranch(" + this.getLabelName(location) + ", " + choice + ')');
    }

    @Override
    public void ifEqualBranch(Location location, boolean choice) {
        this.println(String.valueOf(this.mBulder) + "ifEqualBranch(" + this.getLabelName(location) + ", " + choice + ')');
    }

    @Override
    public void ifZeroComparisonBranch(Location location, String choice) {
        this.println(String.valueOf(this.mBulder) + "ifZeroComparisonBranch(" + this.getLabelName(location) + ", \"" + choice + "\")");
    }

    @Override
    public void ifComparisonBranch(Location location, String choice) {
        this.println(String.valueOf(this.mBulder) + "ifComparisonBranch(" + this.getLabelName(location) + ", \"" + choice + "\")");
    }

    @Override
    public void switchBranch(int[] cases, Location[] locations, Location defaultLocation) {
        StringBuffer buf = new StringBuffer(cases.length * 15);
        buf.append(String.valueOf(this.mBulder) + "switchBranch(");
        buf.append("new int[] {");
        int i = 0;
        while (i < cases.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(cases[i]);
            ++i;
        }
        buf.append("}");
        buf.append(", ");
        buf.append("new Location[] {");
        i = 0;
        while (i < locations.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.getLabelName(locations[i]));
            ++i;
        }
        buf.append("}");
        buf.append(", ");
        buf.append(this.getLabelName(defaultLocation));
        buf.append(')');
        this.println(buf.toString());
    }

    @Override
    public void jsr(Location location) {
        this.println(String.valueOf(this.mBulder) + "jsr(" + this.getLabelName(location) + ')');
    }

    @Override
    public void ret(LocalVariable local) {
        this.println(String.valueOf(this.mBulder) + "ret(" + local.getName() + ')');
    }

    @Override
    public void math(byte opcode) {
        this.println(String.valueOf(this.mBulder) + "math(Opcode." + Opcode.getMnemonic(opcode).toUpperCase() + ')');
    }

    @Override
    public void arrayLength() {
        this.println(String.valueOf(this.mBulder) + "arrayLength()");
    }

    @Override
    public void throwObject() {
        this.println(String.valueOf(this.mBulder) + "throwObject()");
    }

    @Override
    public void checkCast(TypeDesc type) {
        this.println(String.valueOf(this.mBulder) + "checkCast(" + this.getTypeDescName(type) + ')');
    }

    @Override
    public void instanceOf(TypeDesc type) {
        this.println(String.valueOf(this.mBulder) + "instanceOf(" + this.getTypeDescName(type) + ')');
    }

    @Override
    public void integerIncrement(LocalVariable local, int amount) {
        this.println(String.valueOf(this.mBulder) + "integerIncrement(" + local.getName() + ", " + amount + ')');
    }

    @Override
    public void monitorEnter() {
        this.println(String.valueOf(this.mBulder) + "monitorEnter()");
    }

    @Override
    public void monitorExit() {
        this.println(String.valueOf(this.mBulder) + "monitorExit()");
    }

    @Override
    public void nop() {
        this.println(String.valueOf(this.mBulder) + "nop()");
    }

    @Override
    public void breakpoint() {
        this.println(String.valueOf(this.mBulder) + "breakpoint()");
    }

    private void separatorLine() {
        if (this.mNeedSeparatorLine) {
            this.mWriter.println();
            this.mNeedSeparatorLine = false;
        }
    }

    private void println(String str) {
        this.mNeedSeparatorLine = true;
        if (this.mLinePrefix != null) {
            this.mWriter.print(this.mLinePrefix);
        }
        if (this.mLineSuffix == null) {
            this.mWriter.println(str);
        } else {
            this.mWriter.print(str);
            this.mWriter.println(this.mLineSuffix);
        }
    }

    private String getLabelName(Location location) {
        if (location instanceof NamedLabel) {
            return ((NamedLabel)location).mName;
        }
        return ((NamedLabel)this.createLabel()).mName;
    }

    private String getTypeDescName(TypeDesc type) {
        if (type == null) {
            return "null";
        }
        String name = this.mTypeDescNames.get(type);
        if (name == null) {
            if (type.isPrimitive()) {
                name = "TypeDesc.".concat(type.getRootName().toUpperCase());
                this.mTypeDescNames.put(type, name);
                return name;
            }
            if (type == TypeDesc.OBJECT) {
                name = "TypeDesc.OBJECT";
                this.mTypeDescNames.put(type, "TypeDesc.OBJECT");
                return name;
            }
            if (type == TypeDesc.STRING) {
                name = "TypeDesc.STRING";
                this.mTypeDescNames.put(type, "TypeDesc.STRING");
                return name;
            }
            name = "type_" + ++this.mTypeDescCounter;
            this.mTypeDescNames.put(type, name);
            StringBuffer buf = new StringBuffer("TypeDesc ");
            buf.append(name);
            buf.append(" = ");
            TypeDesc componentType = type.getComponentType();
            if (componentType != null) {
                buf.append(this.getTypeDescName(componentType));
                buf.append(".toArrayType(");
            } else {
                buf.append("TypeDesc.forClass(");
                buf.append('\"');
                buf.append(type.getRootName());
                buf.append('\"');
            }
            buf.append(')');
            this.println(buf.toString());
        }
        return name;
    }

    private String getTypeDescArrayName(TypeDesc[] types) {
        if (types == null) {
            return "null";
        }
        List<TypeDesc> key = Arrays.asList(types);
        String name = this.mTypeDescArrayNames.get(key);
        if (name == null) {
            name = "params_" + ++this.mTypeDescArrayCounter;
            this.mTypeDescArrayNames.put(key, name);
            StringBuffer buf = new StringBuffer("TypeDesc[] ");
            buf.append(name);
            buf.append(" = new TypeDesc[] {");
            int i = 0;
            while (i < types.length) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(this.getTypeDescName(types[i]));
                ++i;
            }
            buf.append('}');
            this.println(buf.toString());
        }
        return name;
    }

    static String escape(String value) {
        return CodeAssemblerPrinter.escape(value, false);
    }

    static String escape(String value, boolean forChar) {
        int length = value.length();
        int i = 0;
        while (i < length) {
            char c = value.charAt(i);
            if (c < ' ' || c > '~' || c == '\"' || c == '\\' || forChar && c == '\'') break;
            ++i;
        }
        if (i >= length) {
            return value;
        }
        StringBuffer buf = new StringBuffer(length + 16);
        i = 0;
        while (i < length) {
            char c = value.charAt(i);
            if (!(c < ' ' || c > '~' || c == '\"' || c == '\\' || forChar && c == '\'')) {
                buf.append(c);
            } else {
                switch (c) {
                    case '\u0000': {
                        buf.append("\\0");
                        break;
                    }
                    case '\"': {
                        buf.append("\\\"");
                        break;
                    }
                    case '\'': {
                        buf.append("\\'");
                        break;
                    }
                    case '\\': {
                        buf.append("\\\\");
                        break;
                    }
                    case '\b': {
                        buf.append("\\b");
                        break;
                    }
                    case '\f': {
                        buf.append("\\f");
                        break;
                    }
                    case '\n': {
                        buf.append("\\n");
                        break;
                    }
                    case '\r': {
                        buf.append("\\r");
                        break;
                    }
                    case '\t': {
                        buf.append("\\t");
                        break;
                    }
                    default: {
                        String u = Integer.toHexString(c).toLowerCase();
                        buf.append("\\u");
                        int len = u.length();
                        while (len < 4) {
                            buf.append('0');
                            ++len;
                        }
                        buf.append(u);
                    }
                }
            }
            ++i;
        }
        return buf.toString();
    }

    private class NamedLabel
    implements Label {
        public final String mName;

        public NamedLabel(String name) {
            this.mName = name;
        }

        @Override
        public Label setLocation() {
            CodeAssemblerPrinter.this.println(String.valueOf(this.mName) + ".setLocation()");
            return this;
        }

        @Override
        public int getLocation() {
            return -1;
        }

        @Override
        public int compareTo(Location obj) {
            return 0;
        }
    }

    private class NamedLocal
    implements LocalVariable {
        private final String mName;
        private final TypeDesc mType;
        private final int mNumber;

        public NamedLocal(String name, TypeDesc type, int number) {
            this.mName = name;
            this.mType = type;
            this.mNumber = number;
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        public void setName(String name) {
            CodeAssemblerPrinter.this.println(String.valueOf(this.mName) + ".setName(" + name + ')');
        }

        @Override
        public TypeDesc getType() {
            return this.mType;
        }

        @Override
        public boolean isDoubleWord() {
            return this.mType.isDoubleWord();
        }

        @Override
        public int getNumber() {
            return this.mNumber;
        }

        public Location getStartLocation() {
            return null;
        }

        public Location getEndLocation() {
            return null;
        }

        @Override
        public Set<LocationRange> getLocationRangeSet() {
            return null;
        }
    }
}

