/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cojen.classfile.Attribute;
import org.cojen.classfile.AttributeFactory;
import org.cojen.classfile.ClassFileDataLoader;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.FieldInfo;
import org.cojen.classfile.MethodDeclarationParser;
import org.cojen.classfile.MethodDesc;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.cojen.classfile.attribute.Annotation;
import org.cojen.classfile.attribute.AnnotationsAttr;
import org.cojen.classfile.attribute.DeprecatedAttr;
import org.cojen.classfile.attribute.InnerClassesAttr;
import org.cojen.classfile.attribute.RuntimeInvisibleAnnotationsAttr;
import org.cojen.classfile.attribute.RuntimeVisibleAnnotationsAttr;
import org.cojen.classfile.attribute.SignatureAttr;
import org.cojen.classfile.attribute.SourceFileAttr;
import org.cojen.classfile.attribute.SyntheticAttr;
import org.cojen.classfile.constant.ConstantClassInfo;

public class ClassFile {
    private static final int MAGIC = -889275714;
    private int mVersion;
    private String mTarget;
    private final String mClassName;
    private final String mSuperClassName;
    private String mInnerClassName;
    private TypeDesc mType;
    private ConstantPool mCp;
    private Modifiers mModifiers;
    private ConstantClassInfo mThisClass;
    private ConstantClassInfo mSuperClass;
    private List<ConstantClassInfo> mInterfaces;
    private Set<String> mInterfaceSet;
    private List<FieldInfo> mFields;
    private List<MethodInfo> mMethods;
    private List<Attribute> mAttributes;
    private SourceFileAttr mSource;
    private List<ClassFile> mInnerClasses;
    private int mAnonymousInnerClassCount;
    private InnerClassesAttr mInnerClassesAttr;
    private ClassFile mOuterClass;

    public static ClassFile readFrom(InputStream in) throws IOException {
        return ClassFile.readFrom(in, null, null);
    }

    public static ClassFile readFrom(DataInput din) throws IOException {
        return ClassFile.readFrom(din, null, null);
    }

    public static ClassFile readFrom(InputStream in, ClassFileDataLoader loader, AttributeFactory attrFactory) throws IOException {
        if (!(in instanceof DataInput)) {
            in = new DataInputStream(in);
        }
        return ClassFile.readFrom((DataInput)((Object)in), loader, attrFactory);
    }

    public static ClassFile readFrom(DataInput din, ClassFileDataLoader loader, AttributeFactory attrFactory) throws IOException {
        return ClassFile.readFrom(din, loader, attrFactory, new HashMap<String, ClassFile>(11), null);
    }

    private static ClassFile readFrom(DataInput din, ClassFileDataLoader loader, AttributeFactory attrFactory, Map<String, ClassFile> loadedClassFiles, ClassFile outerClass) throws IOException {
        int magic = din.readInt();
        if (magic != -889275714) {
            throw new IOException("Incorrect magic number: 0x" + Integer.toHexString(magic));
        }
        short minor = din.readShort();
        short major = din.readShort();
        ConstantPool cp = ConstantPool.readFrom(din);
        Modifiers modifiers = Modifiers.getInstance(din.readUnsignedShort()).toSynchronized(false);
        int index = din.readUnsignedShort();
        ConstantClassInfo thisClass = (ConstantClassInfo)cp.getConstant(index);
        index = din.readUnsignedShort();
        ConstantClassInfo superClass = null;
        if (index > 0) {
            superClass = (ConstantClassInfo)cp.getConstant(index);
        }
        ClassFile cf = new ClassFile(cp, modifiers, thisClass, superClass, outerClass);
        cf.setVersion(major, minor);
        loadedClassFiles.put(cf.getClassName(), cf);
        int size = din.readUnsignedShort();
        int i = 0;
        while (i < size) {
            index = din.readUnsignedShort();
            ConstantClassInfo info = (ConstantClassInfo)cp.getConstant(index);
            cf.addInterface(info.getType().getRootName());
            ++i;
        }
        size = din.readUnsignedShort();
        i = 0;
        while (i < size) {
            cf.mFields.add(FieldInfo.readFrom(cf, din, attrFactory));
            ++i;
        }
        size = din.readUnsignedShort();
        i = 0;
        while (i < size) {
            cf.mMethods.add(MethodInfo.readFrom(cf, din, attrFactory));
            ++i;
        }
        size = din.readUnsignedShort();
        i = 0;
        while (i < size) {
            Attribute attr = Attribute.readFrom(cp, din, attrFactory);
            cf.addAttribute(attr);
            if (attr instanceof InnerClassesAttr) {
                cf.mInnerClassesAttr = (InnerClassesAttr)attr;
            }
            ++i;
        }
        if (cf.mInnerClassesAttr != null && loader != null) {
            InnerClassesAttr.Info[] infos = cf.mInnerClassesAttr.getInnerClassesInfo();
            int i2 = 0;
            while (i2 < infos.length) {
                ClassFile innerClass;
                ConstantClassInfo inner;
                InnerClassesAttr.Info info = infos[i2];
                if (thisClass.equals(info.getInnerClass())) {
                    if (info.getInnerClassName() != null) {
                        cf.mInnerClassName = info.getInnerClassName().getValue();
                    }
                    ConstantClassInfo outer = info.getOuterClass();
                    if (cf.mOuterClass == null && outer != null) {
                        cf.mOuterClass = ClassFile.readOuterClass(outer, loader, attrFactory, loadedClassFiles);
                    }
                    Modifiers innerFlags = info.getModifiers();
                    cf.mModifiers = cf.mModifiers.toStatic(innerFlags.isStatic()).toPrivate(innerFlags.isPrivate()).toProtected(innerFlags.isProtected()).toPublic(innerFlags.isPublic());
                } else if ((info.getOuterClass() == null || thisClass.equals(info.getOuterClass())) && (inner = info.getInnerClass()) != null && (innerClass = ClassFile.readInnerClass(inner, loader, attrFactory, loadedClassFiles, cf)) != null) {
                    if (innerClass.getInnerClassName() != null) {
                        innerClass.mInnerClassName = info.getInnerClassName().getValue();
                    }
                    if (cf.mInnerClasses == null) {
                        cf.mInnerClasses = new ArrayList<ClassFile>();
                    }
                    cf.mInnerClasses.add(innerClass);
                }
                ++i2;
            }
        }
        return cf;
    }

    private static ClassFile readOuterClass(ConstantClassInfo outer, ClassFileDataLoader loader, AttributeFactory attrFactory, Map<String, ClassFile> loadedClassFiles) throws IOException {
        String name = outer.getType().getRootName();
        ClassFile outerClass = loadedClassFiles.get(name);
        if (outerClass != null) {
            return outerClass;
        }
        InputStream in = loader.getClassData(name);
        if (in == null) {
            return null;
        }
        if (!(in instanceof DataInput)) {
            in = new DataInputStream(in);
        }
        return ClassFile.readFrom((DataInput)((Object)in), loader, attrFactory, loadedClassFiles, null);
    }

    private static ClassFile readInnerClass(ConstantClassInfo inner, ClassFileDataLoader loader, AttributeFactory attrFactory, Map<String, ClassFile> loadedClassFiles, ClassFile outerClass) throws IOException {
        String name = inner.getType().getRootName();
        ClassFile outer = outerClass;
        while (outer != null) {
            if (name.equals(outer.getClassName())) {
                return null;
            }
            outer = outer.getOuterClass();
        }
        ClassFile innerClass = loadedClassFiles.get(name);
        if (innerClass != null) {
            return innerClass;
        }
        InputStream in = loader.getClassData(name);
        if (in == null) {
            return null;
        }
        if (!(in instanceof DataInput)) {
            in = new DataInputStream(in);
        }
        return ClassFile.readFrom((DataInput)((Object)in), loader, attrFactory, loadedClassFiles, outerClass);
    }

    public ClassFile(String className) {
        this(className, (String)null);
    }

    public ClassFile(String className, Class superClass) {
        this(className, superClass.isInterface() ? null : superClass.getName());
        if (superClass.isInterface()) {
            this.addInterface(superClass);
        }
    }

    public ClassFile(String className, String superClassName) {
        this.setTarget(null);
        this.mInterfaces = new ArrayList<ConstantClassInfo>(2);
        this.mInterfaceSet = new HashSet<String>(7);
        this.mFields = new ArrayList<FieldInfo>();
        this.mMethods = new ArrayList<MethodInfo>();
        this.mAttributes = new ArrayList<Attribute>();
        this.mAnonymousInnerClassCount = 0;
        if (superClassName == null && !className.equals(Object.class.getName())) {
            superClassName = Object.class.getName();
        }
        this.mCp = new ConstantPool();
        this.mModifiers = Modifiers.PUBLIC;
        this.mThisClass = this.mCp.addConstantClass(className);
        this.mSuperClass = this.mCp.addConstantClass(superClassName);
        this.mClassName = className;
        this.mSuperClassName = superClassName;
    }

    private ClassFile(ConstantPool cp, Modifiers modifiers, ConstantClassInfo thisClass, ConstantClassInfo superClass, ClassFile outerClass) {
        this.setTarget(null);
        this.mInterfaces = new ArrayList<ConstantClassInfo>(2);
        this.mInterfaceSet = new HashSet<String>(7);
        this.mFields = new ArrayList<FieldInfo>();
        this.mMethods = new ArrayList<MethodInfo>();
        this.mAttributes = new ArrayList<Attribute>();
        this.mAnonymousInnerClassCount = 0;
        this.mCp = cp;
        this.mModifiers = modifiers;
        this.mThisClass = thisClass;
        this.mSuperClass = superClass;
        this.mClassName = thisClass.getType().getRootName();
        this.mSuperClassName = superClass == null ? null : superClass.getType().getRootName();
        this.mOuterClass = outerClass;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public String getSuperClassName() {
        return this.mSuperClassName;
    }

    public TypeDesc getType() {
        if (this.mType == null) {
            this.mType = TypeDesc.forClass(this.mClassName);
        }
        return this.mType;
    }

    public Modifiers getModifiers() {
        return this.mModifiers;
    }

    public String[] getInterfaces() {
        int size = this.mInterfaces.size();
        String[] names = new String[size];
        int i = 0;
        while (i < size) {
            names[i] = this.mInterfaces.get(i).getType().getRootName();
            ++i;
        }
        return names;
    }

    public FieldInfo[] getFields() {
        return this.mFields.toArray(new FieldInfo[this.mFields.size()]);
    }

    public MethodInfo[] getMethods() {
        int size = this.mMethods.size();
        ArrayList<MethodInfo> methodsOnly = new ArrayList<MethodInfo>(size);
        int i = 0;
        while (i < size) {
            MethodInfo method = this.mMethods.get(i);
            String name = method.getName();
            if (!"<init>".equals(name) && !"<clinit>".equals(name)) {
                methodsOnly.add(method);
            }
            ++i;
        }
        return methodsOnly.toArray(new MethodInfo[methodsOnly.size()]);
    }

    public MethodInfo[] getConstructors() {
        int size = this.mMethods.size();
        ArrayList<MethodInfo> ctorsOnly = new ArrayList<MethodInfo>(size);
        int i = 0;
        while (i < size) {
            MethodInfo method = this.mMethods.get(i);
            if ("<init>".equals(method.getName())) {
                ctorsOnly.add(method);
            }
            ++i;
        }
        return ctorsOnly.toArray(new MethodInfo[ctorsOnly.size()]);
    }

    public MethodInfo getInitializer() {
        int size = this.mMethods.size();
        int i = 0;
        while (i < size) {
            MethodInfo method = this.mMethods.get(i);
            if ("<clinit>".equals(method.getName())) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public ClassFile[] getInnerClasses() {
        if (this.mInnerClasses == null) {
            return new ClassFile[0];
        }
        return this.mInnerClasses.toArray(new ClassFile[this.mInnerClasses.size()]);
    }

    public boolean isInnerClass() {
        return this.mOuterClass != null;
    }

    public String getInnerClassName() {
        return this.mInnerClassName;
    }

    public ClassFile getOuterClass() {
        return this.mOuterClass;
    }

    public int getClassDepth() {
        int depth = 0;
        ClassFile outer = this.mOuterClass;
        while (outer != null) {
            ++depth;
            outer = outer.mOuterClass;
        }
        return depth;
    }

    public String getSourceFile() {
        if (this.mSource == null) {
            return null;
        }
        return this.mSource.getFileName().getValue();
    }

    public boolean isSynthetic() {
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Attribute attr = this.mAttributes.get(i);
            if (!(attr instanceof SyntheticAttr)) continue;
            return true;
        }
        return false;
    }

    public boolean isDeprecated() {
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Attribute attr = this.mAttributes.get(i);
            if (!(attr instanceof DeprecatedAttr)) continue;
            return true;
        }
        return false;
    }

    public Annotation[] getRuntimeInvisibleAnnotations() {
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Attribute attr = this.mAttributes.get(i);
            if (!(attr instanceof RuntimeInvisibleAnnotationsAttr)) continue;
            return ((AnnotationsAttr)attr).getAnnotations();
        }
        return new Annotation[0];
    }

    public Annotation[] getRuntimeVisibleAnnotations() {
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Attribute attr = this.mAttributes.get(i);
            if (!(attr instanceof RuntimeVisibleAnnotationsAttr)) continue;
            return ((AnnotationsAttr)attr).getAnnotations();
        }
        return new Annotation[0];
    }

    public Annotation addRuntimeInvisibleAnnotation(TypeDesc type) {
        AnnotationsAttr attr = null;
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Attribute a = this.mAttributes.get(i);
            if (!(a instanceof RuntimeInvisibleAnnotationsAttr)) continue;
            attr = (AnnotationsAttr)a;
        }
        if (attr == null) {
            attr = new RuntimeInvisibleAnnotationsAttr(this.mCp);
            this.addAttribute(attr);
        }
        Annotation ann = new Annotation(this.mCp);
        ann.setType(type);
        attr.addAnnotation(ann);
        return ann;
    }

    public Annotation addRuntimeVisibleAnnotation(TypeDesc type) {
        AnnotationsAttr attr = null;
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Attribute a = this.mAttributes.get(i);
            if (!(a instanceof RuntimeVisibleAnnotationsAttr)) continue;
            attr = (AnnotationsAttr)a;
        }
        if (attr == null) {
            attr = new RuntimeVisibleAnnotationsAttr(this.mCp);
            this.addAttribute(attr);
        }
        Annotation ann = new Annotation(this.mCp);
        ann.setType(type);
        attr.addAnnotation(ann);
        return ann;
    }

    public SignatureAttr getSignatureAttr() {
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Attribute attr = this.mAttributes.get(i);
            if (!(attr instanceof SignatureAttr)) continue;
            return (SignatureAttr)attr;
        }
        return null;
    }

    public ConstantPool getConstantPool() {
        return this.mCp;
    }

    public void setModifiers(Modifiers modifiers) {
        this.mModifiers = modifiers;
    }

    public void addInterface(String interfaceName) {
        if (!this.mInterfaceSet.contains(interfaceName)) {
            this.mInterfaces.add(this.mCp.addConstantClass(interfaceName));
            this.mInterfaceSet.add(interfaceName);
        }
    }

    public void addInterface(Class i) {
        this.addInterface(i.getName());
    }

    public FieldInfo addField(Modifiers modifiers, String fieldName, TypeDesc type) {
        FieldInfo fi = new FieldInfo(this, modifiers, fieldName, type);
        this.mFields.add(fi);
        return fi;
    }

    public MethodInfo addMethod(Modifiers modifiers, String methodName, TypeDesc ret, TypeDesc[] params) {
        MethodDesc md = MethodDesc.forArguments(ret, params);
        return this.addMethod(modifiers, methodName, md);
    }

    public MethodInfo addMethod(Modifiers modifiers, String methodName, MethodDesc md) {
        MethodInfo mi = new MethodInfo(this, modifiers, methodName, md);
        this.mMethods.add(mi);
        return mi;
    }

    public MethodInfo addMethod(Method method) {
        Modifiers modifiers = Modifiers.getInstance(method.getModifiers()).toAbstract(false);
        MethodInfo mi = this.addMethod(modifiers, method.getName(), MethodDesc.forMethod(method));
        Class<?>[] exceptions = method.getExceptionTypes();
        int i = 0;
        while (i < exceptions.length) {
            mi.addException(TypeDesc.forClass(exceptions[i]));
            ++i;
        }
        return mi;
    }

    public MethodInfo addMethod(String declaration) {
        MethodDeclarationParser p = new MethodDeclarationParser(declaration);
        return this.addMethod(p.getModifiers(), p.getMethodName(), p.getReturnType(), p.getParameters());
    }

    public MethodInfo addConstructor(Modifiers modifiers, TypeDesc[] params) {
        MethodDesc md = MethodDesc.forArguments(null, params);
        MethodInfo mi = new MethodInfo(this, modifiers, "<init>", md);
        this.mMethods.add(mi);
        return mi;
    }

    public MethodInfo addDefaultConstructor() {
        MethodInfo mi = this.addConstructor(Modifiers.PUBLIC, null);
        CodeBuilder builder = new CodeBuilder(mi);
        builder.loadThis();
        builder.invokeSuperConstructor(null);
        builder.returnVoid();
        return mi;
    }

    public MethodInfo addInitializer() {
        MethodDesc md = MethodDesc.forArguments(null, null);
        Modifiers af = Modifiers.NONE.toStatic(true);
        MethodInfo mi = new MethodInfo(this, af, "<clinit>", md);
        this.mMethods.add(mi);
        return mi;
    }

    public ClassFile addInnerClass(String fullInnerClassName, String innerClassName) {
        return this.addInnerClass(fullInnerClassName, innerClassName, (String)null);
    }

    public ClassFile addInnerClass(String fullInnerClassName, String innerClassName, Class superClass) {
        return this.addInnerClass(fullInnerClassName, innerClassName, superClass.getName());
    }

    public ClassFile addInnerClass(String fullInnerClassName, String innerClassName, String superClassName) {
        if (fullInnerClassName == null) {
            fullInnerClassName = innerClassName == null ? String.valueOf(this.mClassName) + '$' + ++this.mAnonymousInnerClassCount : String.valueOf(this.mClassName) + '$' + innerClassName;
        }
        ClassFile inner = new ClassFile(fullInnerClassName, superClassName);
        Modifiers modifiers = inner.getModifiers().toPrivate(true).toStatic(true);
        inner.setModifiers(modifiers);
        inner.mInnerClassName = innerClassName;
        inner.mOuterClass = this;
        if (this.mInnerClasses == null) {
            this.mInnerClasses = new ArrayList<ClassFile>();
        }
        this.mInnerClasses.add(inner);
        if (this.mInnerClassesAttr == null) {
            this.addAttribute(new InnerClassesAttr(this.mCp));
        }
        this.mInnerClassesAttr.addInnerClass(fullInnerClassName, this.mClassName, innerClassName, modifiers);
        inner.addAttribute(new InnerClassesAttr(inner.getConstantPool()));
        inner.mInnerClassesAttr.addInnerClass(fullInnerClassName, this.mClassName, innerClassName, modifiers);
        return inner;
    }

    public void setSourceFile(String fileName) {
        this.addAttribute(new SourceFileAttr(this.mCp, fileName));
    }

    public void markSynthetic() {
        this.addAttribute(new SyntheticAttr(this.mCp));
    }

    public void markDeprecated() {
        this.addAttribute(new DeprecatedAttr(this.mCp));
    }

    public void addAttribute(Attribute attr) {
        if (attr instanceof SourceFileAttr) {
            if (this.mSource != null) {
                this.mAttributes.remove(this.mSource);
            }
            this.mSource = (SourceFileAttr)attr;
        } else if (attr instanceof InnerClassesAttr) {
            if (this.mInnerClassesAttr != null) {
                this.mAttributes.remove(this.mInnerClassesAttr);
            }
            this.mInnerClassesAttr = (InnerClassesAttr)attr;
        }
        this.mAttributes.add(attr);
    }

    public Attribute[] getAttributes() {
        return this.mAttributes.toArray(new Attribute[this.mAttributes.size()]);
    }

    public void setTarget(String target) throws IllegalArgumentException {
        int minor;
        int major;
        if (target == null || "1.0".equals(target) || "1.1".equals(target)) {
            major = 45;
            minor = 3;
            if (target == null) {
                target = "1.0";
            }
        } else if ("1.2".equals(target)) {
            major = 46;
            minor = 0;
        } else if ("1.3".equals(target)) {
            major = 47;
            minor = 0;
        } else if ("1.4".equals(target)) {
            major = 48;
            minor = 0;
        } else if ("1.5".equals(target)) {
            major = 49;
            minor = 0;
        } else if ("1.6".equals(target)) {
            major = 50;
            minor = 0;
        } else if ("1.7".equals(target)) {
            major = 51;
            minor = 0;
        } else {
            throw new IllegalArgumentException("Unsupported target version: " + target);
        }
        this.mVersion = minor << 16 | major & 0xFFFF;
        this.mTarget = target.intern();
    }

    public String getTarget() {
        return this.mTarget;
    }

    public void setVersion(int major, int minor) {
        String target;
        if (major > 65535 || minor > 65535) {
            throw new IllegalArgumentException("Version number element cannot exceed 65535");
        }
        this.mVersion = minor << 16 | major & 0xFFFF;
        switch (major) {
            default: {
                target = null;
                break;
            }
            case 45: {
                target = minor == 3 ? "1.0" : null;
                break;
            }
            case 46: {
                target = minor == 0 ? "1.2" : null;
                break;
            }
            case 47: {
                target = minor == 0 ? "1.3" : null;
                break;
            }
            case 48: {
                target = minor == 0 ? "1.4" : null;
                break;
            }
            case 49: {
                target = minor == 0 ? "1.5" : null;
                break;
            }
            case 50: {
                target = minor == 0 ? "1.6" : null;
                break;
            }
            case 51: {
                target = minor == 0 ? "1.7" : null;
            }
        }
        this.mTarget = target;
    }

    public int getMajorVersion() {
        return this.mVersion & 0xFFFF;
    }

    public int getMinorVersion() {
        return this.mVersion >> 16 & 0xFFFF;
    }

    public void writeTo(OutputStream out) throws IOException {
        if (!(out instanceof DataOutput)) {
            out = new DataOutputStream(out);
        }
        this.writeTo((DataOutput)((Object)out));
    }

    public void writeTo(DataOutput dout) throws IOException {
        dout.writeInt(-889275714);
        dout.writeInt(this.mVersion);
        this.mCp.writeTo(dout);
        int flags = this.mModifiers.getBitmask();
        if (!this.mModifiers.isInterface()) {
            flags |= 0x20;
        }
        dout.writeShort(flags);
        dout.writeShort(this.mThisClass.getIndex());
        if (this.mSuperClass != null) {
            dout.writeShort(this.mSuperClass.getIndex());
        } else {
            dout.writeShort(0);
        }
        int size = this.mInterfaces.size();
        if (size > 65535) {
            throw new IllegalStateException("Interfaces count cannot exceed 65535: " + size);
        }
        dout.writeShort(size);
        int i = 0;
        while (i < size) {
            int index = this.mInterfaces.get(i).getIndex();
            dout.writeShort(index);
            ++i;
        }
        size = this.mFields.size();
        if (size > 65535) {
            throw new IllegalStateException("Field count cannot exceed 65535: " + size);
        }
        dout.writeShort(size);
        i = 0;
        while (i < size) {
            FieldInfo field = this.mFields.get(i);
            field.writeTo(dout);
            ++i;
        }
        size = this.mMethods.size();
        if (size > 65535) {
            throw new IllegalStateException("Method count cannot exceed 65535: " + size);
        }
        dout.writeShort(size);
        i = 0;
        while (i < size) {
            MethodInfo method = this.mMethods.get(i);
            method.writeTo(dout);
            ++i;
        }
        size = this.mAttributes.size();
        if (size > 65535) {
            throw new IllegalStateException("Attribute count cannot exceed 65535: " + size);
        }
        dout.writeShort(size);
        i = 0;
        while (i < size) {
            Attribute attr = this.mAttributes.get(i);
            attr.writeTo(dout);
            ++i;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String modStr = this.mModifiers.toString();
        if (modStr.length() > 0) {
            buf.append(modStr);
            buf.append(' ');
        }
        if (this.getModifiers().isInterface()) {
            buf.append("interface");
        } else {
            buf.append("class");
        }
        buf.append(' ');
        buf.append(this.getClassName());
        return buf.toString();
    }
}

