/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.cojen.classfile.AttributeFactory;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.attribute.CodeAttr;
import org.cojen.classfile.attribute.ConstantValueAttr;
import org.cojen.classfile.attribute.DeprecatedAttr;
import org.cojen.classfile.attribute.EnclosingMethodAttr;
import org.cojen.classfile.attribute.ExceptionsAttr;
import org.cojen.classfile.attribute.InnerClassesAttr;
import org.cojen.classfile.attribute.LineNumberTableAttr;
import org.cojen.classfile.attribute.LocalVariableTableAttr;
import org.cojen.classfile.attribute.RuntimeInvisibleAnnotationsAttr;
import org.cojen.classfile.attribute.RuntimeInvisibleParameterAnnotationsAttr;
import org.cojen.classfile.attribute.RuntimeVisibleAnnotationsAttr;
import org.cojen.classfile.attribute.RuntimeVisibleParameterAnnotationsAttr;
import org.cojen.classfile.attribute.SignatureAttr;
import org.cojen.classfile.attribute.SourceFileAttr;
import org.cojen.classfile.attribute.StackMapTableAttr;
import org.cojen.classfile.attribute.SyntheticAttr;
import org.cojen.classfile.attribute.UnknownAttr;
import org.cojen.classfile.constant.ConstantUTFInfo;

public abstract class Attribute {
    static final Attribute[] NO_ATTRIBUTES = new Attribute[0];
    public static final String CODE = "Code";
    public static final String CONSTANT_VALUE = "ConstantValue";
    public static final String DEPRECATED = "Deprecated";
    public static final String EXCEPTIONS = "Exceptions";
    public static final String INNER_CLASSES = "InnerClasses";
    public static final String LINE_NUMBER_TABLE = "LineNumberTable";
    public static final String LOCAL_VARIABLE_TABLE = "LocalVariableTable";
    public static final String SOURCE_FILE = "SourceFile";
    public static final String SYNTHETIC = "Synthetic";
    public static final String SIGNATURE = "Signature";
    public static final String ENCLOSING_METHOD = "EnclosingMethod";
    public static final String RUNTIME_VISIBLE_ANNOTATIONS = "RuntimeVisibleAnnotations";
    public static final String RUNTIME_INVISIBLE_ANNOTATIONS = "RuntimeInvisibleAnnotations";
    public static final String RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS = "RuntimeVisibleParamaterAnnotations";
    public static final String RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS = "RuntimeInvisibleParamaterAnnotations";
    public static final String STACK_MAP_TABLE = "StackMapTable";
    private final ConstantPool mCp;
    private String mName;
    private ConstantUTFInfo mNameConstant;

    protected Attribute(ConstantPool cp, String name) {
        this.mCp = cp;
        this.mName = name;
        this.mNameConstant = cp.addConstantUTF(name);
    }

    public ConstantPool getConstantPool() {
        return this.mCp;
    }

    public String getName() {
        return this.mName;
    }

    public ConstantUTFInfo getNameConstant() {
        return this.mNameConstant;
    }

    public Attribute[] getAttributes() {
        return NO_ATTRIBUTES;
    }

    public abstract int getLength();

    public void writeTo(DataOutput dout) throws IOException {
        dout.writeShort(this.mNameConstant.getIndex());
        dout.writeInt(this.getLength());
        this.writeDataTo(dout);
    }

    public void writeDataTo(DataOutput dout) throws IOException {
    }

    public static Attribute readFrom(ConstantPool cp, DataInput din, AttributeFactory attrFactory) throws IOException {
        int index = din.readUnsignedShort();
        String name = ((ConstantUTFInfo)cp.getConstant(index)).getValue();
        int length = din.readInt();
        attrFactory = new Factory(attrFactory);
        return attrFactory.createAttribute(cp, name, length, din);
    }

    private static class Factory
    implements AttributeFactory {
        private final AttributeFactory mAttrFactory;

        public Factory(AttributeFactory attrFactory) {
            this.mAttrFactory = attrFactory;
        }

        @Override
        public Attribute createAttribute(ConstantPool cp, String name, int length, DataInput din) throws IOException {
            Attribute attr;
            if (name.length() > 0) {
                switch (name.charAt(0)) {
                    case 'C': {
                        if (name.equals(Attribute.CODE)) {
                            return new CodeAttr(cp, name, length, din, this.mAttrFactory);
                        }
                        if (!name.equals(Attribute.CONSTANT_VALUE)) break;
                        return new ConstantValueAttr(cp, name, length, din);
                    }
                    case 'D': {
                        if (!name.equals(Attribute.DEPRECATED)) break;
                        return new DeprecatedAttr(cp, name, length, din);
                    }
                    case 'E': {
                        if (name.equals(Attribute.EXCEPTIONS)) {
                            return new ExceptionsAttr(cp, name, length, din);
                        }
                        if (!name.equals(Attribute.ENCLOSING_METHOD)) break;
                        return new EnclosingMethodAttr(cp, name, length, din);
                    }
                    case 'I': {
                        if (!name.equals(Attribute.INNER_CLASSES)) break;
                        return new InnerClassesAttr(cp, name, length, din);
                    }
                    case 'L': {
                        if (name.equals(Attribute.LINE_NUMBER_TABLE)) {
                            return new LineNumberTableAttr(cp, name, length, din);
                        }
                        if (!name.equals(Attribute.LOCAL_VARIABLE_TABLE)) break;
                        return new LocalVariableTableAttr(cp, name, length, din);
                    }
                    case 'R': {
                        if (name.equals(Attribute.RUNTIME_VISIBLE_ANNOTATIONS)) {
                            return new RuntimeVisibleAnnotationsAttr(cp, name, length, din);
                        }
                        if (name.equals(Attribute.RUNTIME_INVISIBLE_ANNOTATIONS)) {
                            return new RuntimeInvisibleAnnotationsAttr(cp, name, length, din);
                        }
                        if (name.equals(Attribute.RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS)) {
                            return new RuntimeVisibleParameterAnnotationsAttr(cp, name, length, din);
                        }
                        if (!name.equals(Attribute.RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS)) break;
                        return new RuntimeInvisibleParameterAnnotationsAttr(cp, name, length, din);
                    }
                    case 'S': {
                        if (name.equals(Attribute.SOURCE_FILE)) {
                            return new SourceFileAttr(cp, name, length, din);
                        }
                        if (name.equals(Attribute.SYNTHETIC)) {
                            return new SyntheticAttr(cp, name, length, din);
                        }
                        if (name.equals(Attribute.SIGNATURE)) {
                            return new SignatureAttr(cp, name, length, din);
                        }
                        if (!name.equals(Attribute.STACK_MAP_TABLE)) break;
                        return new StackMapTableAttr(cp, name, length, din);
                    }
                }
            }
            if (this.mAttrFactory != null && (attr = this.mAttrFactory.createAttribute(cp, name, length, din)) != null) {
                return attr;
            }
            return new UnknownAttr(cp, name, length, din);
        }
    }
}

