/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeAssemblerPrinter;
import org.cojen.classfile.CodeBuffer;
import org.cojen.classfile.ConstantInfo;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.Descriptor;
import org.cojen.classfile.DisassemblyTool;
import org.cojen.classfile.ExceptionHandler;
import org.cojen.classfile.FieldInfo;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.MethodDesc;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.Opcode;
import org.cojen.classfile.TypeDesc;
import org.cojen.classfile.attribute.Annotation;
import org.cojen.classfile.attribute.CodeAttr;
import org.cojen.classfile.attribute.SignatureAttr;
import org.cojen.classfile.attribute.StackMapTableAttr;
import org.cojen.classfile.constant.ConstantClassInfo;
import org.cojen.classfile.constant.ConstantDoubleInfo;
import org.cojen.classfile.constant.ConstantFieldInfo;
import org.cojen.classfile.constant.ConstantFloatInfo;
import org.cojen.classfile.constant.ConstantIntegerInfo;
import org.cojen.classfile.constant.ConstantInterfaceMethodInfo;
import org.cojen.classfile.constant.ConstantLongInfo;
import org.cojen.classfile.constant.ConstantMethodInfo;
import org.cojen.classfile.constant.ConstantNameAndTypeInfo;
import org.cojen.classfile.constant.ConstantStringInfo;
import org.cojen.classfile.constant.ConstantUTFInfo;
import org.cojen.util.IntHashMap;

class AssemblyStylePrinter
implements DisassemblyTool.Printer {
    private ClassFile mClassFile;
    private ConstantPool mCp;
    private PrintWriter mOut;
    private byte[] mByteCodes;
    private int mAddress;
    private IntHashMap<Object> mLabels;
    private ExceptionHandler[] mExceptionHandlers;
    private IntHashMap<List<ExceptionHandler>> mCatchLocations;

    @Override
    public void disassemble(ClassFile cf, PrintWriter out) {
        this.disassemble(cf, out, "");
    }

    private void disassemble(ClassFile cf, PrintWriter out, String indent) {
        this.mClassFile = cf;
        this.mCp = cf.getConstantPool();
        this.mOut = out;
        if (indent.length() == 0 || this.mClassFile.getSourceFile() != null || this.mClassFile.isDeprecated() || this.mClassFile.isSynthetic()) {
            SignatureAttr sig;
            this.println(indent, "/**");
            boolean addBreak = false;
            if (indent.length() == 0) {
                this.print(indent, " * Disassembled on ");
                this.print(new Date());
                this.println(".");
                addBreak = true;
            }
            if (indent.length() == 0 && this.mClassFile.getTarget() != null) {
                if (addBreak) {
                    this.println(indent, " * ");
                    addBreak = false;
                }
                this.print(indent, " * @target ");
                this.println(CodeAssemblerPrinter.escape(this.mClassFile.getTarget()));
            }
            if (this.mClassFile.getSourceFile() != null) {
                if (addBreak) {
                    this.println(indent, " * ");
                    addBreak = false;
                }
                this.print(indent, " * @source ");
                this.println(CodeAssemblerPrinter.escape(this.mClassFile.getSourceFile()));
            }
            if (this.mClassFile.isInnerClass()) {
                if (addBreak) {
                    this.println(indent, " * ");
                    addBreak = false;
                }
                if (this.mClassFile.getInnerClassName() == null) {
                    this.println(indent, " * @anonymous");
                } else {
                    this.print(indent, " * @name ");
                    this.println(CodeAssemblerPrinter.escape(this.mClassFile.getInnerClassName()));
                }
            }
            if (this.mClassFile.isDeprecated()) {
                if (addBreak) {
                    this.println(indent, " * ");
                    addBreak = false;
                }
                this.println(indent, " * @deprecated");
            }
            if (this.mClassFile.isSynthetic()) {
                if (addBreak) {
                    this.println(indent, " * ");
                    addBreak = false;
                }
                this.println(indent, " * @synthetic");
            }
            if ((sig = this.mClassFile.getSignatureAttr()) != null) {
                if (addBreak) {
                    this.println(indent, " * ");
                    addBreak = false;
                }
                this.println(indent, " * @signature " + sig.getSignature().getValue());
            }
            this.println(indent, " */");
        }
        this.disassemble(indent, this.mClassFile.getRuntimeVisibleAnnotations());
        this.disassemble(indent, this.mClassFile.getRuntimeInvisibleAnnotations());
        this.print(indent);
        this.disassemble(this.mClassFile.getModifiers());
        boolean isInterface = this.mClassFile.getModifiers().isInterface();
        if (!isInterface) {
            this.print("class ");
        }
        this.print(this.mClassFile.getClassName());
        if (this.mClassFile.getSuperClassName() != null) {
            this.print(" extends ");
            this.print(this.mClassFile.getSuperClassName());
        }
        String innerIndent = String.valueOf(indent) + "    ";
        String[] interfaces = this.mClassFile.getInterfaces();
        if (interfaces.length == 0) {
            this.println(" {");
        } else {
            this.println();
            int i = 0;
            while (i < interfaces.length) {
                if (i == 0) {
                    this.print(innerIndent, "implements ");
                } else {
                    this.println(",");
                    this.print(innerIndent, "           ");
                }
                this.print(interfaces[i]);
                ++i;
            }
            this.println();
            this.println(indent, "{");
        }
        FieldInfo[] fields = this.mClassFile.getFields();
        MethodInfo[] methods = this.mClassFile.getMethods();
        MethodInfo[] ctors = this.mClassFile.getConstructors();
        MethodInfo init = this.mClassFile.getInitializer();
        Object[] members = new Object[fields.length + methods.length + ctors.length + (init == null ? 0 : 1)];
        int m = 0;
        int i = 0;
        while (i < fields.length) {
            members[m++] = fields[i];
            ++i;
        }
        i = 0;
        while (i < methods.length) {
            members[m++] = methods[i];
            ++i;
        }
        i = 0;
        while (i < ctors.length) {
            members[m++] = ctors[i];
            ++i;
        }
        if (init != null) {
            members[m++] = init;
        }
        this.sortMembers(members);
        i = 0;
        while (i < members.length) {
            if (i > 0) {
                this.println();
            }
            if (members[i] instanceof FieldInfo) {
                this.disassemble(innerIndent, (FieldInfo)members[i]);
            } else {
                this.disassemble(innerIndent, (MethodInfo)members[i]);
            }
            ++i;
        }
        this.mByteCodes = null;
        this.mLabels = null;
        this.mExceptionHandlers = null;
        this.mCatchLocations = null;
        ClassFile[] innerClasses = this.mClassFile.getInnerClasses();
        int i2 = 0;
        while (i2 < innerClasses.length) {
            if (i2 > 0 || members.length > 0) {
                this.println();
            }
            AssemblyStylePrinter printer = new AssemblyStylePrinter();
            printer.disassemble(innerClasses[i2], this.mOut, innerIndent);
            ++i2;
        }
        this.println(indent, "}");
        this.mOut.flush();
        this.mOut = null;
    }

    private void disassemble(String indent, FieldInfo field) {
        SignatureAttr sig = field.getSignatureAttr();
        if (field.isDeprecated() || field.isSynthetic() || sig != null) {
            this.println(indent, "/**");
            if (field.isDeprecated()) {
                this.println(indent, " * @deprecated");
            }
            if (field.isSynthetic()) {
                this.println(indent, " * @synthetic");
            }
            if (sig != null) {
                this.println(indent, " * @signature " + sig.getSignature().getValue());
            }
            this.println(indent, " */");
        }
        this.disassemble(indent, field.getRuntimeVisibleAnnotations());
        this.disassemble(indent, field.getRuntimeInvisibleAnnotations());
        this.print(indent);
        this.disassemble(field.getModifiers());
        this.disassemble(field.getType());
        this.print(" ");
        this.print(field.getName());
        ConstantInfo constant = field.getConstantValue();
        if (constant != null) {
            this.print(" = ");
            this.disassemble(constant);
        }
        this.println(";");
    }

    private void disassemble(String indent, MethodInfo method) {
        SignatureAttr sig = method.getSignatureAttr();
        if (method.isDeprecated() || method.isSynthetic() || sig != null) {
            this.println(indent, "/**");
            if (method.isDeprecated()) {
                this.println(indent, " * @deprecated");
            }
            if (method.isSynthetic()) {
                this.println(indent, " * @synthetic");
            }
            if (sig != null) {
                this.println(indent, " * @signature " + sig.getSignature().getValue());
            }
            this.println(indent, " */");
        }
        this.disassemble(indent, method.getRuntimeVisibleAnnotations());
        this.disassemble(indent, method.getRuntimeInvisibleAnnotations());
        this.print(indent);
        MethodDesc md = method.getMethodDescriptor();
        if ("<clinit>".equals(method.getName()) && md.getReturnType() == TypeDesc.VOID && md.getParameterCount() == 0 && method.getModifiers().isStatic() && !method.getModifiers().isAbstract() && method.getExceptions().length == 0) {
            this.print("static");
        } else {
            Modifiers modifiers = method.getModifiers();
            boolean varargs = modifiers.isVarArgs();
            if (varargs) {
                modifiers = modifiers.toVarArgs(false);
            }
            this.disassemble(modifiers);
            this.print(md.toMethodSignature(method.getName(), varargs));
        }
        CodeAttr code = method.getCodeAttr();
        TypeDesc[] exceptions = method.getExceptions();
        if (exceptions.length == 0) {
            if (code == null) {
                this.println(";");
            } else {
                this.println(" {");
            }
        } else {
            this.println();
            int i = 0;
            while (i < exceptions.length) {
                if (i == 0) {
                    this.print(String.valueOf(indent) + "    ", "throws ");
                } else {
                    this.println(",");
                    this.print(String.valueOf(indent) + "    ", "       ");
                }
                this.print(exceptions[i].getFullName());
                ++i;
            }
            if (code == null) {
                this.println(";");
            } else {
                this.println();
                this.println(indent, "{");
            }
        }
        if (code != null) {
            this.disassemble(String.valueOf(indent) + "    ", code);
            this.println(indent, "}");
        }
    }

    private void disassemble(Modifiers modifiers) {
        this.print(modifiers);
        if (modifiers.getBitmask() != 0) {
            this.print(" ");
        }
    }

    private void disassemble(ConstantInfo constant) {
        this.disassemble(constant, false);
    }

    private void disassemble(ConstantInfo constant, boolean showClassLiteral) {
        if (constant instanceof ConstantStringInfo) {
            this.print("\"");
            String value = ((ConstantStringInfo)constant).getValue();
            this.print(CodeAssemblerPrinter.escape(value));
            this.print("\"");
        } else if (constant instanceof ConstantIntegerInfo) {
            this.print(String.valueOf(((ConstantIntegerInfo)constant).getValue()));
        } else if (constant instanceof ConstantLongInfo) {
            this.print(String.valueOf(((ConstantLongInfo)constant).getValue()));
            this.print("L");
        } else if (constant instanceof ConstantFloatInfo) {
            float value = ((ConstantFloatInfo)constant).getValue();
            if (value != value) {
                this.print("0.0f/0.0f");
            } else if (value == Float.NEGATIVE_INFINITY) {
                this.print("-1.0f/0.0f");
            } else if (value == Float.POSITIVE_INFINITY) {
                this.print("1.0f/0.0f");
            } else {
                this.print(String.valueOf(value));
                this.print("f");
            }
        } else if (constant instanceof ConstantDoubleInfo) {
            double value = ((ConstantDoubleInfo)constant).getValue();
            if (value != value) {
                this.print("0.0d/0.0d");
            } else if (value == Double.NEGATIVE_INFINITY) {
                this.print("-1.0d/0.0d");
            } else if (value == Double.POSITIVE_INFINITY) {
                this.print("1.0d/0.0d");
            } else {
                this.print(String.valueOf(value));
                this.print("d");
            }
        } else if (constant instanceof ConstantClassInfo) {
            ConstantClassInfo cci = (ConstantClassInfo)constant;
            this.disassemble(cci.getType());
            if (showClassLiteral) {
                this.print(".class");
            }
        } else if (constant instanceof ConstantUTFInfo) {
            this.print("\"");
            String value = ((ConstantUTFInfo)constant).getValue();
            this.print(CodeAssemblerPrinter.escape(value));
            this.print("\"");
        } else {
            this.print(constant);
        }
    }

    private void disassemble(TypeDesc type) {
        this.print(type.getFullName());
    }

    private void disassemble(LocalVariable var) {
        if (var != null) {
            this.print(" // ");
            this.print(var.getName());
            this.print(": ");
            this.disassemble(var.getType());
        }
    }

    private void disassemble(String indent, Annotation[] annotations) {
        int i = 0;
        while (i < annotations.length) {
            this.print(indent);
            this.disassemble(indent, annotations[i]);
            this.println();
            ++i;
        }
    }

    private void disassemble(String indent, Annotation ann) {
        this.print("@");
        this.print(ann.getType().getFullName());
        Map<String, Annotation.MemberValue> mvMap = ann.getMemberValues();
        if (mvMap.size() == 0) {
            return;
        }
        this.print("(");
        Iterator<Map.Entry<String, Annotation.MemberValue>> it = mvMap.entrySet().iterator();
        int ordinal = 0;
        while (it.hasNext()) {
            Map.Entry<String, Annotation.MemberValue> entry;
            String name;
            if (ordinal++ > 0) {
                this.print(", ");
            }
            if (!"value".equals(name = (entry = it.next()).getKey())) {
                this.print(name);
                this.print("=");
            }
            this.disassemble(indent, entry.getValue());
        }
        this.print(")");
    }

    private void disassemble(String indent, Annotation.MemberValue mv) {
        Object value = mv.getValue();
        switch (mv.getTag()) {
            default: {
                this.print("?");
                break;
            }
            case 'Z': {
                ConstantIntegerInfo ci = (ConstantIntegerInfo)value;
                this.print(ci.getValue() == 0 ? "false" : "true");
                break;
            }
            case 'B': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'c': 
            case 's': {
                this.disassemble((ConstantInfo)value, true);
                break;
            }
            case 'C': {
                this.print("'");
                char c = (char)((ConstantIntegerInfo)value).getValue();
                this.print(CodeAssemblerPrinter.escape(String.valueOf(c), true));
                this.print("'");
                break;
            }
            case 'e': {
                Annotation.EnumConstValue ecv = (Annotation.EnumConstValue)value;
                this.print(TypeDesc.forDescriptor(ecv.getTypeName().getValue()).getFullName());
                this.print(".");
                this.print(ecv.getConstName().getValue());
                break;
            }
            case '@': {
                this.disassemble(indent, (Annotation)value);
                break;
            }
            case '[': {
                Annotation.MemberValue[] mvs = (Annotation.MemberValue[])value;
                String originalIndent = indent;
                boolean multiLine = false;
                if (mvs.length > 0 && (mvs.length > 4 || mvs.length > 1 && mvs[0].getTag() == 'e' || mvs[0].getTag() == '[' || mvs[0].getTag() == '@')) {
                    multiLine = true;
                    indent = String.valueOf(indent) + "    ";
                }
                if (multiLine || mvs.length != 1) {
                    this.print("{");
                    if (multiLine) {
                        this.println();
                    }
                }
                int j = 0;
                while (j < mvs.length) {
                    if (multiLine) {
                        this.print(indent);
                    }
                    this.disassemble(indent, mvs[j]);
                    if (j + 1 < mvs.length) {
                        this.print(",");
                        if (!multiLine) {
                            this.print(" ");
                        }
                    }
                    if (multiLine) {
                        this.println();
                    }
                    ++j;
                }
                indent = originalIndent;
                if (!multiLine && mvs.length == 1) break;
                if (multiLine) {
                    this.print(indent);
                }
                this.print("}");
            }
        }
    }

    private void disassemble(String indent, CodeAttr code) {
        CodeBuffer buffer = code.getCodeBuffer();
        this.mExceptionHandlers = buffer.getExceptionHandlers();
        this.print(indent);
        this.print("// max stack:  ");
        this.println(String.valueOf(buffer.getMaxStackDepth()));
        this.print(indent);
        this.print("// max locals: ");
        this.println(String.valueOf(buffer.getMaxLocals()));
        this.mByteCodes = buffer.getByteCodes();
        this.gatherLabels();
        Location currentLoc = new Location(){

            @Override
            public int getLocation() {
                return AssemblyStylePrinter.this.mAddress;
            }

            @Override
            public int compareTo(Location other) {
                int locb;
                if (this == other) {
                    return 0;
                }
                int loca = this.getLocation();
                if (loca < (locb = other.getLocation())) {
                    return -1;
                }
                if (loca > locb) {
                    return 1;
                }
                return 0;
            }
        };
        StackMapTableAttr.StackMapFrame frame = code.getStackMapTable() == null ? null : code.getStackMapTable().getInitialFrame();
        int currentLine = -1;
        this.mAddress = 0;
        while (this.mAddress < this.mByteCodes.length) {
            block78: {
                String mnemonic;
                int nextLine = code.getLineNumber(currentLoc);
                if (nextLine != currentLine && (currentLine = nextLine) >= 0) {
                    this.println(indent, "// line " + currentLine);
                }
                this.locateLabel(indent);
                frame = this.stackMap(indent, frame);
                byte opcode = this.mByteCodes[this.mAddress];
                try {
                    mnemonic = Opcode.getMnemonic(opcode);
                }
                catch (IllegalArgumentException e) {
                    mnemonic = String.valueOf(opcode & 0xFF);
                }
                this.print(indent, mnemonic);
                switch (opcode) {
                    default: {
                        break;
                    }
                    case -128: 
                    case -127: 
                    case -126: 
                    case -125: 
                    case -123: 
                    case -122: 
                    case -121: 
                    case -120: 
                    case -119: 
                    case -118: 
                    case -117: 
                    case -116: 
                    case -115: 
                    case -114: 
                    case -113: 
                    case -112: 
                    case -111: 
                    case -110: 
                    case -109: 
                    case -108: 
                    case -107: 
                    case -106: 
                    case -105: 
                    case -104: 
                    case -84: 
                    case -83: 
                    case -82: 
                    case -81: 
                    case -80: 
                    case -79: 
                    case -66: 
                    case -65: 
                    case -62: 
                    case -61: 
                    case -54: 
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: {
                        this.println();
                        break block78;
                    }
                    case 26: 
                    case 30: 
                    case 34: 
                    case 38: 
                    case 42: {
                        this.disassemble(code.getLocalVariable(this.mAddress, 0));
                        this.println();
                        break block78;
                    }
                    case 59: 
                    case 63: 
                    case 67: 
                    case 71: 
                    case 75: {
                        this.disassemble(code.getLocalVariable(this.mAddress + 1, 0));
                        this.println();
                        break block78;
                    }
                    case 27: 
                    case 31: 
                    case 35: 
                    case 39: 
                    case 43: {
                        this.disassemble(code.getLocalVariable(this.mAddress, 1));
                        this.println();
                        break block78;
                    }
                    case 60: 
                    case 64: 
                    case 68: 
                    case 72: 
                    case 76: {
                        this.disassemble(code.getLocalVariable(this.mAddress + 1, 1));
                        this.println();
                        break block78;
                    }
                    case 28: 
                    case 32: 
                    case 36: 
                    case 40: 
                    case 44: {
                        this.disassemble(code.getLocalVariable(this.mAddress, 2));
                        this.println();
                        break block78;
                    }
                    case 61: 
                    case 65: 
                    case 69: 
                    case 73: 
                    case 77: {
                        this.disassemble(code.getLocalVariable(this.mAddress + 1, 2));
                        this.println();
                        break block78;
                    }
                    case 29: 
                    case 33: 
                    case 37: 
                    case 41: 
                    case 45: {
                        this.disassemble(code.getLocalVariable(this.mAddress, 3));
                        this.println();
                        break block78;
                    }
                    case 62: 
                    case 66: 
                    case 70: 
                    case 74: 
                    case 78: {
                        this.disassemble(code.getLocalVariable(this.mAddress + 1, 3));
                        this.println();
                        break block78;
                    }
                }
                this.print(" ");
                block14 : switch (opcode) {
                    default: {
                        break;
                    }
                    case 18: 
                    case 19: 
                    case 20: {
                        int index;
                        switch (opcode) {
                            case 18: {
                                index = this.readUnsignedByte();
                                break;
                            }
                            case 19: 
                            case 20: {
                                index = this.readUnsignedShort();
                                break;
                            }
                            default: {
                                index = 0;
                            }
                        }
                        this.disassemble(this.getConstant(index), true);
                        break;
                    }
                    case -69: 
                    case -67: 
                    case -64: 
                    case -63: {
                        ConstantInfo constant = this.getConstant(this.readUnsignedShort());
                        if (constant instanceof ConstantClassInfo) {
                            this.disassemble(constant);
                            break;
                        }
                        this.print(constant);
                        break;
                    }
                    case -59: {
                        ConstantInfo constant = this.getConstant(this.readUnsignedShort());
                        int dims = this.readUnsignedByte();
                        if (constant instanceof ConstantClassInfo) {
                            this.disassemble(constant);
                        } else {
                            this.print(constant);
                        }
                        this.print(" ");
                        this.print(String.valueOf(dims));
                        break;
                    }
                    case -78: 
                    case -77: 
                    case -76: 
                    case -75: {
                        ConstantInfo constant = this.getConstant(this.readUnsignedShort());
                        if (constant instanceof ConstantFieldInfo) {
                            ConstantFieldInfo field = (ConstantFieldInfo)constant;
                            Descriptor type = field.getNameAndType().getType();
                            if (type instanceof TypeDesc) {
                                this.disassemble((TypeDesc)type);
                            } else {
                                this.print(type);
                            }
                            this.print(" ");
                            this.print(field.getParentClass().getType().getFullName());
                            this.print(".");
                            this.print(field.getNameAndType().getName());
                            break;
                        }
                        this.print(constant);
                        break;
                    }
                    case -74: 
                    case -73: 
                    case -72: 
                    case -71: 
                    case -70: {
                        ConstantNameAndTypeInfo nameAndType;
                        String className;
                        ConstantInfo method;
                        ConstantInfo constant = this.getConstant(this.readUnsignedShort());
                        if (opcode == -71) {
                            this.readShort();
                            if (!(constant instanceof ConstantInterfaceMethodInfo)) {
                                this.print(constant);
                                break;
                            }
                            method = (ConstantInterfaceMethodInfo)constant;
                            className = ((ConstantInterfaceMethodInfo)method).getParentClass().getType().getFullName();
                            nameAndType = ((ConstantInterfaceMethodInfo)method).getNameAndType();
                        } else if (opcode == -70) {
                            this.readShort();
                            className = null;
                            nameAndType = (ConstantNameAndTypeInfo)constant;
                        } else {
                            if (!(constant instanceof ConstantMethodInfo)) {
                                this.print(constant);
                                break;
                            }
                            method = (ConstantMethodInfo)constant;
                            className = ((ConstantMethodInfo)method).getParentClass().getType().getFullName();
                            nameAndType = ((ConstantMethodInfo)method).getNameAndType();
                        }
                        Descriptor type = nameAndType.getType();
                        if (!(type instanceof MethodDesc)) {
                            this.print(type);
                            break;
                        }
                        this.disassemble(((MethodDesc)type).getReturnType());
                        this.print(" ");
                        if (className != null) {
                            this.print(className);
                            this.print(".");
                        }
                        this.print(nameAndType.getName());
                        this.print("(");
                        TypeDesc[] params = ((MethodDesc)type).getParameterTypes();
                        int i = 0;
                        while (i < params.length) {
                            if (i > 0) {
                                this.print(", ");
                            }
                            this.disassemble(params[i]);
                            ++i;
                        }
                        this.print(")");
                        break;
                    }
                    case -87: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        int varNum = this.readUnsignedByte();
                        this.print(String.valueOf(varNum));
                        this.disassemble(code.getLocalVariable(this.mAddress, varNum));
                        break;
                    }
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: {
                        int varNum = this.readUnsignedByte();
                        this.print(String.valueOf(varNum));
                        this.disassemble(code.getLocalVariable(this.mAddress + 1, varNum));
                        break;
                    }
                    case -124: {
                        int varNum = this.readUnsignedByte();
                        this.print(String.valueOf(varNum));
                        this.print(" ");
                        int incValue = this.readByte();
                        if (incValue >= 0) {
                            this.print("+");
                        }
                        this.print(String.valueOf(incValue));
                        this.disassemble(code.getLocalVariable(this.mAddress, varNum));
                        break;
                    }
                    case -103: 
                    case -102: 
                    case -101: 
                    case -100: 
                    case -99: 
                    case -98: 
                    case -97: 
                    case -96: 
                    case -95: 
                    case -94: 
                    case -93: 
                    case -92: 
                    case -91: 
                    case -90: 
                    case -89: 
                    case -88: 
                    case -58: 
                    case -57: {
                        this.print(this.getLabel(this.mAddress + this.readShort()));
                        break;
                    }
                    case -56: 
                    case -55: {
                        this.print(this.getLabel(this.mAddress + this.readInt()));
                        break;
                    }
                    case 16: {
                        int value = this.readByte();
                        this.print(String.valueOf(value));
                        this.printCharLiteral(value);
                        break;
                    }
                    case 17: {
                        int value = this.readShort();
                        this.print(String.valueOf(value));
                        this.printCharLiteral(value);
                        break;
                    }
                    case -68: {
                        int atype = this.readByte();
                        switch (atype) {
                            case 4: {
                                this.print("boolean");
                                break block14;
                            }
                            case 5: {
                                this.print("char");
                                break block14;
                            }
                            case 6: {
                                this.print("float");
                                break block14;
                            }
                            case 7: {
                                this.print("double");
                                break block14;
                            }
                            case 8: {
                                this.print("byte");
                                break block14;
                            }
                            case 9: {
                                this.print("short");
                                break block14;
                            }
                            case 10: {
                                this.print("int");
                                break block14;
                            }
                            case 11: {
                                this.print("long");
                                break block14;
                            }
                        }
                        this.print("T_" + atype);
                        break;
                    }
                    case -86: 
                    case -85: {
                        int i;
                        String[] locations;
                        int[] cases;
                        int opcodeAddress = this.mAddress;
                        while ((this.mAddress + 1 & 3) != 0) {
                            ++this.mAddress;
                        }
                        String defaultLocation = this.getLabel(opcodeAddress + this.readInt());
                        if (opcode == -86) {
                            int lowValue = this.readInt();
                            int highValue = this.readInt();
                            int caseCount = highValue - lowValue + 1;
                            this.print("// " + caseCount + " cases");
                            try {
                                cases = new int[caseCount];
                            }
                            catch (NegativeArraySizeException e) {
                                break;
                            }
                            locations = new String[caseCount];
                            int i2 = 0;
                            while (i2 < caseCount) {
                                cases[i2] = lowValue + i2;
                                locations[i2] = this.getLabel(opcodeAddress + this.readInt());
                                ++i2;
                            }
                        } else {
                            int caseCount = this.readInt();
                            this.print("// " + caseCount + " cases");
                            try {
                                cases = new int[caseCount];
                            }
                            catch (NegativeArraySizeException e) {
                                break;
                            }
                            locations = new String[caseCount];
                            i = 0;
                            while (i < caseCount) {
                                cases[i] = this.readInt();
                                locations[i] = this.getLabel(opcodeAddress + this.readInt());
                                ++i;
                            }
                        }
                        this.println();
                        this.print(indent, "    default: goto ");
                        this.println(defaultLocation);
                        String prefix = String.valueOf(indent) + "    " + "case ";
                        i = 0;
                        while (i < cases.length) {
                            this.print(String.valueOf(prefix) + cases[i]);
                            this.print(": goto ");
                            this.print(locations[i]);
                            this.printCharLiteral(cases[i]);
                            this.println();
                            ++i;
                        }
                        break;
                    }
                    case -60: {
                        opcode = this.mByteCodes[++this.mAddress];
                        this.print(Opcode.getMnemonic(opcode));
                        this.print(" ");
                        switch (opcode) {
                            default: {
                                break block14;
                            }
                            case -87: 
                            case 21: 
                            case 22: 
                            case 23: 
                            case 24: 
                            case 25: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: {
                                this.print(String.valueOf(this.readUnsignedShort()));
                                break block14;
                            }
                            case -124: 
                        }
                        this.print(String.valueOf(this.readUnsignedShort()));
                        this.print(" ");
                        int incValue = this.readShort();
                        if (incValue >= 0) {
                            this.print("+");
                        }
                        this.print(String.valueOf(incValue));
                    }
                }
                this.println();
            }
            ++this.mAddress;
        }
    }

    private void gatherLabels() {
        this.mLabels = new IntHashMap();
        this.mCatchLocations = new IntHashMap(this.mExceptionHandlers.length * 2 + 1);
        int i = this.mExceptionHandlers.length - 1;
        while (i >= 0) {
            ExceptionHandler handler = this.mExceptionHandlers[i];
            this.createLabel(new Integer(handler.getStartLocation().getLocation()));
            this.createLabel(new Integer(handler.getEndLocation().getLocation()));
            int labelKey = handler.getCatchLocation().getLocation();
            this.createLabel(labelKey);
            List<ExceptionHandler> list = this.mCatchLocations.get(labelKey);
            if (list == null) {
                list = new ArrayList<ExceptionHandler>(2);
                this.mCatchLocations.put(labelKey, list);
            }
            list.add(handler);
            --i;
        }
        this.mAddress = 0;
        while (this.mAddress < this.mByteCodes.length) {
            byte opcode = this.mByteCodes[this.mAddress];
            switch (opcode) {
                default: {
                    break;
                }
                case -103: 
                case -102: 
                case -101: 
                case -100: 
                case -99: 
                case -98: 
                case -97: 
                case -96: 
                case -95: 
                case -94: 
                case -93: 
                case -92: 
                case -91: 
                case -90: 
                case -89: 
                case -88: 
                case -58: 
                case -57: {
                    this.createLabel(new Integer(this.mAddress + this.readShort()));
                    break;
                }
                case -56: 
                case -55: {
                    this.createLabel(new Integer(this.mAddress + this.readInt()));
                    break;
                }
                case -86: 
                case -85: {
                    int opcodeAddress = this.mAddress;
                    while ((this.mAddress + 1 & 3) != 0) {
                        ++this.mAddress;
                    }
                    this.createLabel(new Integer(opcodeAddress + this.readInt()));
                    if (opcode == -86) {
                        int lowValue = this.readInt();
                        int highValue = this.readInt();
                        int caseCount = highValue - lowValue + 1;
                        int i2 = 0;
                        while (i2 < caseCount) {
                            this.createLabel(new Integer(opcodeAddress + this.readInt()));
                            ++i2;
                        }
                    } else {
                        int caseCount = this.readInt();
                        int i3 = 0;
                        while (i3 < caseCount) {
                            this.mAddress += 4;
                            this.createLabel(new Integer(opcodeAddress + this.readInt()));
                            ++i3;
                        }
                    }
                    break;
                }
                case -128: 
                case -127: 
                case -126: 
                case -125: 
                case -123: 
                case -122: 
                case -121: 
                case -120: 
                case -119: 
                case -118: 
                case -117: 
                case -116: 
                case -115: 
                case -114: 
                case -113: 
                case -112: 
                case -111: 
                case -110: 
                case -109: 
                case -108: 
                case -107: 
                case -106: 
                case -105: 
                case -104: 
                case -84: 
                case -83: 
                case -82: 
                case -81: 
                case -80: 
                case -79: 
                case -66: 
                case -65: 
                case -62: 
                case -61: 
                case -54: 
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: {
                    break;
                }
                case -124: 
                case -87: 
                case -68: 
                case 16: 
                case 18: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    ++this.mAddress;
                    break;
                }
                case -78: 
                case -77: 
                case -76: 
                case -75: 
                case -74: 
                case -73: 
                case -72: 
                case -69: 
                case -67: 
                case -64: 
                case -63: 
                case 17: 
                case 19: 
                case 20: {
                    this.mAddress += 2;
                    break;
                }
                case -59: {
                    this.mAddress += 3;
                    break;
                }
                case -71: 
                case -70: {
                    this.mAddress += 4;
                    break;
                }
                case -60: {
                    opcode = this.mByteCodes[++this.mAddress];
                    this.mAddress += 2;
                    if (opcode != -124) break;
                    this.mAddress += 2;
                }
            }
            ++this.mAddress;
        }
        Object[] keys = new Integer[this.mLabels.size()];
        this.mLabels.keySet().toArray(keys);
        Arrays.sort(keys);
        int i4 = 0;
        while (i4 < keys.length) {
            this.mLabels.put((Integer)keys[i4], (Object)("L" + (i4 + 1) + '_' + keys[i4]));
            ++i4;
        }
    }

    private void createLabel(int labelKey) {
        this.mLabels.put(labelKey, (Object)labelKey);
    }

    private ConstantInfo getConstant(int index) {
        try {
            return this.mCp.getConstant(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private String getLabel(int address) {
        Object label = this.mLabels.get(new Integer(address));
        if (label == null || !(label instanceof String)) {
            return "L?_" + address;
        }
        return (String)label;
    }

    private void locateLabel(String indent) {
        int labelKey = this.mAddress;
        Object labelValue = this.mLabels.get(labelKey);
        if (labelValue == null) {
            return;
        }
        int len = indent.length() - 4;
        if (len > 0) {
            this.print(indent.substring(0, len));
        }
        this.print(labelValue);
        this.println(":");
        List<ExceptionHandler> handlers = this.mCatchLocations.get(labelKey);
        if (handlers != null) {
            int i = 0;
            while (i < handlers.size()) {
                ExceptionHandler handler = handlers.get(i);
                this.print(indent, "try (");
                this.print(this.getLabel(handler.getStartLocation().getLocation()));
                this.print("..");
                this.print(this.getLabel(handler.getEndLocation().getLocation()));
                this.print(") catch (");
                if (handler.getCatchType() == null) {
                    this.print("...");
                } else {
                    this.disassemble(handler.getCatchType());
                }
                this.println(")");
                ++i;
            }
        }
    }

    private StackMapTableAttr.StackMapFrame stackMap(String indent, StackMapTableAttr.StackMapFrame frame) {
        if (frame == null) {
            return null;
        }
        if (this.mAddress < frame.getOffset()) {
            return frame;
        }
        this.print(indent);
        this.print("// stack:  ");
        this.print(frame.getStackItemInfos());
        this.println();
        this.print(indent);
        this.print("// locals: ");
        this.print(frame.getLocalInfos());
        this.println();
        return frame.getNext();
    }

    private void print(StackMapTableAttr.VerificationTypeInfo[] infos) {
        this.print(Character.valueOf('{'));
        int num = 0;
        int i = 0;
        while (i < infos.length) {
            if (i > 0) {
                this.print(", ");
            }
            this.print(num);
            this.print(Character.valueOf('='));
            StackMapTableAttr.VerificationTypeInfo info = infos[i];
            this.print(info.toString());
            num = info.getType() == null || !info.getType().isDoubleWord() ? ++num : (num += 2);
            ++i;
        }
        this.print(Character.valueOf('}'));
    }

    private int readByte() {
        return this.mByteCodes[++this.mAddress];
    }

    private int readUnsignedByte() {
        return this.mByteCodes[++this.mAddress] & 0xFF;
    }

    private int readShort() {
        return this.mByteCodes[++this.mAddress] << 8 | this.mByteCodes[++this.mAddress] & 0xFF;
    }

    private int readUnsignedShort() {
        return (this.mByteCodes[++this.mAddress] & 0xFF) << 8 | (this.mByteCodes[++this.mAddress] & 0xFF) << 0;
    }

    private int readInt() {
        return this.mByteCodes[++this.mAddress] << 24 | (this.mByteCodes[++this.mAddress] & 0xFF) << 16 | (this.mByteCodes[++this.mAddress] & 0xFF) << 8 | (this.mByteCodes[++this.mAddress] & 0xFF) << 0;
    }

    private void print(Object text) {
        this.mOut.print(text);
    }

    private void println(Object text) {
        this.mOut.println(text);
    }

    private void print(String indent, Object text) {
        this.mOut.print(indent);
        this.mOut.print(text);
    }

    private void println(String indent, Object text) {
        this.mOut.print(indent);
        this.mOut.println(text);
    }

    private void println() {
        this.mOut.println();
    }

    private void printCharLiteral(int value) {
        if (value >= 0 && value <= 65535) {
            int type = Character.getType((char)value);
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: {
                    this.print(" // '");
                    this.print(String.valueOf((char)value));
                    this.print("'");
                }
            }
        }
    }

    private void sortMembers(Object[] members) {
        Arrays.sort(members, new MemberComparator());
    }

    private class MemberComparator
    implements Comparator<Object> {
        private MemberComparator() {
        }

        @Override
        public int compare(Object a, Object b) {
            Modifiers aFlags = a instanceof FieldInfo ? ((FieldInfo)a).getModifiers() : ((MethodInfo)a).getModifiers();
            Modifiers bFlags = b instanceof FieldInfo ? ((FieldInfo)b).getModifiers() : ((MethodInfo)b).getModifiers();
            if (aFlags.isStatic()) {
                if (!bFlags.isStatic()) {
                    return -1;
                }
            } else if (bFlags.isStatic()) {
                return 1;
            }
            if (a instanceof FieldInfo) {
                if (b instanceof MethodInfo) {
                    return -1;
                }
            } else {
                if (!(b instanceof MethodInfo)) {
                    return 1;
                }
                String aName = ((MethodInfo)a).getName();
                String bName = ((MethodInfo)b).getName();
                if ("<init>".equals(aName) || "<clinit>".equals(aName)) {
                    if (!"<init>".equals(bName) && !"<clinit>".equals(bName)) {
                        return -1;
                    }
                } else if ("<init>".equals(bName) || "<clinit>".equals(bName)) {
                    return 1;
                }
            }
            int aValue = aFlags.isPublic() ? 0 : (aFlags.isProtected() ? 4 : (!aFlags.isPrivate() ? 8 : 12));
            int bValue = bFlags.isPublic() ? 0 : (bFlags.isProtected() ? 4 : (!bFlags.isPrivate() ? 8 : 12));
            aValue += aFlags.isFinal() ? 0 : 2;
            bValue += bFlags.isFinal() ? 0 : 2;
            if ((aValue += aFlags.isTransient() ? 1 : 0) < (bValue += bFlags.isTransient() ? 1 : 0)) {
                return -1;
            }
            if (aValue > bValue) {
                return 1;
            }
            return 0;
        }
    }
}

