/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.swing;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.Outline;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.StaticSymbol;
import org.simantics.g2d.element.handler.Transform;
import org.simantics.g2d.element.handler.impl.SimpleElementLayers;
import org.simantics.g2d.element.handler.impl.StaticSymbolImpl;
import org.simantics.g2d.elementclass.MonitorHandler;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.ProviderUtils;
import org.simantics.g2d.image.impl.AbstractImage;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.swing.SymbolMonitorNode;
import org.simantics.utils.datastructures.cache.IFactory;
import org.simantics.utils.datastructures.cache.IProvider;
import org.simantics.utils.datastructures.cache.ProvisionException;
import org.simantics.utils.datastructures.hints.IHintContext;

public class SymbolMonitorClass {
    public static final IHintContext.Key KEY_SG_NODE = new SceneGraphNodeKey(Node.class, "SYMBOL_MONITOR_SG_NODE");
    static final Rectangle2D DEFAULT_BOX = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    public static final Shape BOX_SHAPE = new Rectangle(-1, -1, 2, 2);
    static final IProvider<Image> MONITOR_IMAGE = ProviderUtils.reference((IProvider)ProviderUtils.cache((IFactory)ProviderUtils.rasterize((IProvider)new MonitorImageFactory(0.5, 0.5))));
    static final StaticSymbol MONITOR_SYMBOL = new StaticSymbolImpl((Image)MONITOR_IMAGE.get());
    public static final ElementClass MONITOR_CLASS = ElementClass.compile((ElementHandler[])new ElementHandler[]{MonitorHandlerImpl.INSTANCE, Transformer.INSTANCE, SymbolMonitorSGNode.INSTANCE, SimpleElementLayers.INSTANCE, MONITOR_SYMBOL});

    public static void update(IElement e) {
        SymbolMonitorSGNode node = (SymbolMonitorSGNode)e.getElementClass().getAtMostOneItemOfClass(SymbolMonitorSGNode.class);
        node.update(e);
    }

    public static void cleanup(IElement e) {
        SymbolMonitorSGNode node = (SymbolMonitorSGNode)e.getElementClass().getAtMostOneItemOfClass(SymbolMonitorSGNode.class);
        node.cleanup(e);
    }

    static Shape createMonitor(IElement e) {
        return DEFAULT_BOX;
    }

    static Path2D makePath(double x, double y, double w, double h) {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(x, y);
        ((Path2D)path).lineTo(x + w, y);
        ((Path2D)path).lineTo(x + w, y + h);
        ((Path2D)path).lineTo(x, y + h);
        path.closePath();
        return path;
    }

    public static ElementClass create(IElement parentElement, Map<String, String> substitutions, Collection<Object> path, double staticScaleX, double staticScaleY, ElementHandler ... extraHandlers) {
        IFactory staticMonitorSymbolProvider = ProviderUtils.reference((IProvider)ProviderUtils.cache((IFactory)ProviderUtils.rasterize((IProvider)new MonitorImageFactory(staticScaleX, staticScaleY))));
        StaticSymbolImpl staticMonitorSymbol = new StaticSymbolImpl((Image)staticMonitorSymbolProvider.get());
        return ElementClass.compile((ElementHandler[])new ElementHandler[]{MonitorHandlerImpl.INSTANCE, Transformer.INSTANCE, SymbolMonitorSGNode.INSTANCE, SimpleElementLayers.INSTANCE, staticMonitorSymbol}).newClassWith(extraHandlers);
    }

    public static class MonitorHandlerImpl
    implements MonitorHandler {
        private static final long serialVersionUID = -4258875745321808416L;
        public static final MonitorHandler INSTANCE = new MonitorHandlerImpl();
    }

    static class MonitorImageFactory
    implements IFactory<Image> {
        private double staticScaleX = 1.0;
        private double staticScaleY = 1.0;

        public MonitorImageFactory(double staticScaleX, double staticScaleY) {
            this.staticScaleX = staticScaleX;
            this.staticScaleY = staticScaleY;
        }

        public Image get() throws ProvisionException {
            return new AbstractImage(){
                Shape path = BOX_SHAPE;

                public Rectangle2D getBounds() {
                    return this.path.getBounds2D();
                }

                public EnumSet<Image.Feature> getFeatures() {
                    return EnumSet.of(Image.Feature.Vector);
                }

                public Shape getOutline() {
                    return this.path;
                }

                public Node init(G2DParentNode parent) {
                    SymbolMonitorNode node = (SymbolMonitorNode)parent.getOrCreateNode("" + ((Object)((Object)this)).hashCode(), SymbolMonitorNode.class);
                    node.setText("");
                    node.setBounds(new Rectangle2D.Double(0.0, 0.0, 50.0, 22.0));
                    node.setText("Drop Me");
                    node.setTransform(AffineTransform.getScaleInstance(MonitorImageFactory.this.staticScaleX, MonitorImageFactory.this.staticScaleY));
                    return node;
                }
            };
        }
    }

    public static class SymbolMonitorSGNode
    implements SceneGraph,
    InternalSize,
    Outline {
        private static final long serialVersionUID = -106278359626957687L;
        static final SymbolMonitorSGNode INSTANCE = new SymbolMonitorSGNode();

        public void init(IElement e, G2DParentNode parent) {
            SymbolMonitorNode node = (SymbolMonitorNode)e.getHint(KEY_SG_NODE);
            if (node != null && node.getBounds() != null) {
                node.getParent();
            }
            this.update(e);
        }

        public void update(IElement e) {
        }

        public void cleanup(IElement e) {
            SymbolMonitorNode node = (SymbolMonitorNode)e.removeHint(KEY_SG_NODE);
            if (node != null) {
                node.remove();
            }
        }

        public Rectangle2D getBounds(IElement e, Rectangle2D size) {
            Rectangle2D shape = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            SymbolMonitorNode node = (SymbolMonitorNode)e.getHint(KEY_SG_NODE);
            if (node != null && node.getBounds() != null) {
                shape = node.getBounds().getBounds2D();
            }
            if (size != null) {
                size.setRect(shape);
            }
            return shape;
        }

        public Shape getElementShape(IElement e) {
            Rectangle2D shape = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            SymbolMonitorNode node = (SymbolMonitorNode)e.getHint(KEY_SG_NODE);
            if (node != null && node.getBounds() != null) {
                shape = node.getBounds();
            }
            return shape;
        }
    }

    public static class Transformer
    implements Transform {
        private static final long serialVersionUID = -3704887325602085677L;
        public static final Transformer INSTANCE = new Transformer(null);
        Double aspectRatio;

        public Transformer() {
            this(null);
        }

        public Transformer(Double aspectRatio) {
            this.aspectRatio = aspectRatio;
        }

        public AffineTransform getTransform(IElement e) {
            AffineTransform at = (AffineTransform)e.getHint(ElementHints.KEY_TRANSFORM);
            IElement parentElement = (IElement)e.getHint(ElementHints.KEY_PARENT_ELEMENT);
            if (parentElement == null) {
                return at;
            }
            Transform parentTransform = (Transform)parentElement.getElementClass().getSingleItem(Transform.class);
            assert (parentTransform != null);
            AffineTransform result = (AffineTransform)at.clone();
            result.preConcatenate(parentTransform.getTransform(parentElement));
            return result;
        }

        public void setTransform(IElement e, AffineTransform at) {
            e.setHint(ElementHints.KEY_TRANSFORM, at.clone());
        }
    }
}

