/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.swing;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DFocusManager;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.ISGMouseEvent;
import org.simantics.scenegraph.g2d.events.SGMouseEvent;
import org.simantics.scenegraph.g2d.events.SGMouseWheelEvent;
import org.simantics.scenegraph.utils.DummyComponent;
import org.simantics.scenegraph.utils.NodeUtil;

public class ComponentNode<T extends JComponent>
extends G2DNode
implements MouseListener,
MouseMotionListener,
KeyListener,
FocusListener {
    private static final long serialVersionUID = 3161843367263793336L;
    protected ComponentContainer container = new ComponentContainer();
    protected Rectangle2D bounds = null;
    protected boolean focusable = true;
    protected T component = null;
    protected boolean visible = true;
    protected boolean scale = false;
    private transient Font componentFont;
    private transient double lastScale = 0.0;

    @INode.PropertySetter(value="Bounds")
    @INode.SyncField(value={"bounds"})
    public void setBounds(Rectangle2D bounds) {
        assert (bounds != null);
        this.bounds = bounds;
        this.setScaleDirty();
    }

    @INode.PropertySetter(value="Background Color")
    @INode.ClientSide
    public void setBackgroundColor(Color color) {
        if (this.component != null) {
            ((JComponent)this.component).setBackground(color);
        }
    }

    protected void setScaleDirty() {
        this.lastScale = 0.0;
    }

    protected Font getComponentFont() {
        if (this.component != null) {
            if (this.componentFont == null) {
                this.componentFont = ((Component)this.component).getFont();
            }
            return this.componentFont;
        }
        return null;
    }

    protected void setComponentFont(Font font) {
        this.componentFont = font;
        this.setScaleDirty();
        ((JComponent)this.component).setFont(font);
    }

    public void render(Graphics2D g2d) {
        if (!this.visible || this.bounds == null) {
            return;
        }
        Graphics2D g = (Graphics2D)g2d.create();
        if (this.component != null) {
            ((JComponent)this.component).putClientProperty("JComponent.sizeVariant", "large");
            double sx = 1.0;
            double sy = 1.0;
            if (this.transform != null) {
                g.transform(this.transform);
            }
            if (!this.scale && this.lastScale != sx) {
                this.lastScale = sx;
                if (this.componentFont == null) {
                    this.componentFont = ((Component)this.component).getFont();
                }
                if (this.componentFont != null) {
                    Font newFont = ((Component)this.component).getFont().deriveFont(this.componentFont.getSize2D() * (float)sx);
                    ((JComponent)this.component).setFont(newFont);
                }
                ((Component)this.component).setSize((int)(this.bounds.getWidth() * sx), (int)(this.bounds.getHeight() * sy));
            }
            ((Component)this.component).setSize((int)(this.bounds.getWidth() * sx), (int)(this.bounds.getHeight() * sy));
            g.translate(this.bounds.getMinX() * sx, this.bounds.getMinY() * sy);
            ((JComponent)this.component).paint(g);
        }
        g.dispose();
    }

    @INode.SyncField(value={"visible"})
    public void setVisible(boolean value) {
        this.visible = value;
    }

    public Component getHeavyweightParent(Component component) {
        if (component.isLightweight()) {
            return this.getHeavyweightParent(component.getParent());
        }
        return component;
    }

    public void handleEvent(AWTEvent event) {
        if (!this.focusable) {
            return;
        }
        if (this.bounds == null) {
            return;
        }
        AWTEvent cevent = event;
        double sx = 1.0;
        double sy = 1.0;
        if (event instanceof MouseEvent) {
            if (!this.scale) {
                IG2DNode node = (IG2DNode)this.getParent();
                while (node != null) {
                    sx *= node.getTransform().getScaleX();
                    sy *= node.getTransform().getScaleY();
                    node = (G2DParentNode)node.getParent();
                }
            }
            MouseEvent me = (MouseEvent)event;
            double mx = me.getX();
            double my = me.getY();
            if (event instanceof ISGMouseEvent) {
                mx = ((ISGMouseEvent)event).getDoubleX();
                my = ((ISGMouseEvent)event).getDoubleY();
            }
            AffineTransform i = AffineTransform.getTranslateInstance(-this.transform.getTranslateX() * sx - this.getBoundsInLocal().getMinX() * sx, -this.transform.getTranslateY() * sy - this.getBoundsInLocal().getMinY() * sy);
            Point2D p = i.transform(new Point2D.Double(sx * mx, sy * my), null);
            cevent = this.relocateEvent(me, p);
            Rectangle2D.Double tb = new Rectangle2D.Double(this.transform.getTranslateX() + this.getBoundsInLocal().getMinX(), this.transform.getTranslateY() + this.getBoundsInLocal().getMinY(), this.getBoundsInLocal().getWidth(), this.getBoundsInLocal().getHeight());
            if ((cevent.getID() == 501 || cevent.getID() == 507) && tb.contains(me.getPoint())) {
                G2DFocusManager.INSTANCE.markFocus(this.component);
                if (this.component != null && !((Component)this.component).hasFocus()) {
                    ((JComponent)this.component).requestFocusInWindow();
                }
            }
            if (tb.contains(me.getPoint())) {
                this.container.setContains(true);
            } else {
                this.container.setContains(false);
            }
            if (cevent.getID() == 506 && this.component != null && ((Component)this.component).hasFocus()) {
                cevent.setSource(this.component);
            }
        }
        if (this.component != null && this.container.contains) {
            cevent.setSource(this.component);
        }
    }

    protected AWTEvent relocateEvent(AWTEvent e, Point2D p) {
        if (!(e instanceof MouseEvent)) {
            return e;
        }
        MouseEvent me = (MouseEvent)e;
        Object cevent = null;
        cevent = me.getID() == 507 ? new SGMouseWheelEvent((Component)new DummyComponent(), me.getID(), me.getWhen(), me.getModifiers(), p.getX(), p.getY(), me.getClickCount(), me.isPopupTrigger(), ((MouseWheelEvent)me).getScrollType(), ((MouseWheelEvent)me).getScrollAmount(), ((MouseWheelEvent)me).getWheelRotation(), me) : new SGMouseEvent((Component)new DummyComponent(), me.getID(), me.getWhen(), me.getModifiers(), p.getX(), p.getY(), me.getClickCount(), me.isPopupTrigger(), me.getButton(), me);
        return cevent;
    }

    protected AWTEvent translateEvent(AWTEvent e, Point2D p) {
        if (!(e instanceof MouseEvent)) {
            return e;
        }
        MouseEvent me = (MouseEvent)e;
        Object cevent = null;
        cevent = me.getID() == 507 ? new SGMouseWheelEvent((Component)new DummyComponent(), me.getID(), me.getWhen(), me.getModifiers(), (double)me.getX() + p.getX(), (double)me.getY() + p.getY(), me.getClickCount(), me.isPopupTrigger(), ((MouseWheelEvent)me).getScrollType(), ((MouseWheelEvent)me).getScrollAmount(), ((MouseWheelEvent)me).getWheelRotation(), me) : new SGMouseEvent((Component)new DummyComponent(), me.getID(), me.getWhen(), me.getModifiers(), (double)me.getX() + p.getX(), (double)me.getY() + p.getY(), me.getClickCount(), me.isPopupTrigger(), me.getButton(), me);
        return cevent;
    }

    public void setFocusable(boolean focusable) {
        this.focusable = focusable;
        this.container.setContains(false);
        ((Component)this.component).setFocusable(focusable);
    }

    public void init() {
        if (this.component == null) {
            return;
        }
        Container rootPane = NodeUtil.findRootPane((INode)this);
        if (rootPane == null) {
            throw new AssertionError((Object)"The canvas has no rootPane!");
        }
        rootPane.add(this.container);
        this.container.add((Component)this.component);
        ((Component)this.component).setFocusable(true);
        ((Component)this.component).setIgnoreRepaint(true);
        UIDefaults cDefaults = new UIDefaults();
        ((JComponent)this.component).putClientProperty("Nimbus.Overrides", cDefaults);
        ((JComponent)this.component).putClientProperty("Nimbus.Overrides.InheritDefaults", false);
        NodeUtil.getEventDelegator((INode)this).addMouseListener((IG2DNode)this);
        NodeUtil.getEventDelegator((INode)this).addMouseMotionListener((IG2DNode)this);
        NodeUtil.getEventDelegator((INode)this).addKeyListener((IG2DNode)this);
        NodeUtil.getEventDelegator((INode)this).addFocusListener((IG2DNode)this);
    }

    public Rectangle2D getBoundsInLocal() {
        return this.bounds;
    }

    public void finalize() {
        this.cleanup();
    }

    public void cleanup() {
        this.retractMapping();
        Container rootPane = NodeUtil.findRootPane((INode)this);
        if (this.container != null) {
            rootPane.remove(this.container);
            this.container.setContains(false);
            if (this.container.getParent() != null) {
                this.container.getParent().remove(this.container);
            }
            if (this.component != null) {
                this.container.remove((Component)this.component);
            }
        }
        this.container = null;
        this.component = null;
        NodeUtil.getEventDelegator((INode)this).removeMouseListener((IG2DNode)this);
        NodeUtil.getEventDelegator((INode)this).removeMouseMotionListener((IG2DNode)this);
        NodeUtil.getEventDelegator((INode)this).removeKeyListener((IG2DNode)this);
        NodeUtil.getEventDelegator((INode)this).removeFocusListener((IG2DNode)this);
        super.cleanup();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.handleEvent(e);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.handleEvent(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.handleEvent(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.handleEvent(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.handleEvent(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.handleEvent(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.handleEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.handleEvent(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.handleEvent(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.handleEvent(e);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.handleEvent(e);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.handleEvent(e);
    }

    public class ComponentContainer
    extends Container {
        private static final long serialVersionUID = 7233440430091475715L;
        protected boolean contains = false;

        public void setContains(boolean contains) {
            this.contains = contains;
        }

        @Override
        public void update(Graphics g) {
            ((JComponent)ComponentNode.this.component).update(g);
        }

        @Override
        public void paint(Graphics g) {
        }

        @Override
        public void paintAll(Graphics g) {
        }

        @Override
        public void paintComponents(Graphics g) {
        }

        @Override
        public void repaint() {
        }

        @Override
        public void repaint(long tm) {
        }

        @Override
        public void repaint(int x, int y, int width, int height) {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public boolean contains(int eventX, int eventY) {
            return true;
        }

        @Override
        public Cursor getCursor() {
            if (!this.contains || ComponentNode.this.component == null || !((Component)ComponentNode.this.component).isCursorSet()) {
                return Cursor.getPredefinedCursor(0);
            }
            return ((Component)ComponentNode.this.component).getCursor();
        }
    }
}

