/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.team.ui;

import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.simantics.browsing.ui.swt.ViewArgumentUtils;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextChangedListener;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.management.SessionContextChangedEvent;
import org.simantics.team.ui.DisplayElement;
import org.simantics.utils.datastructures.disposable.DisposeState;

abstract class TreeView
extends ViewPart {
    protected ISessionContextChangedListener contextChangeListener = new ISessionContextChangedListener(){

        public void sessionContextChanged(SessionContextChangedEvent event) {
            TreeView.this.sessionContext = event.getNewValue();
        }
    };
    protected LocalResourceManager resourceManager;
    protected Composite parent;
    protected TreeViewer treeViewer;
    protected IMemento memento;
    private Map<String, String> args;
    private ISessionContextProvider contextProvider;
    private ISessionContext sessionContext;
    private DisposeState disposeState = DisposeState.Alive;

    protected Map<String, String> getViewArguments() {
        return this.args;
    }

    protected DisposeState getDisposeState() {
        return this.disposeState;
    }

    public ISessionContext getSessionContext() {
        return this.sessionContext;
    }

    public ISessionContextProvider getSessionContextProvider() {
        return this.contextProvider;
    }

    public void dispose() {
        this.disposeState = DisposeState.Disposing;
        try {
            if (this.contextProvider != null) {
                this.contextProvider.removeContextChangedListener(this.contextChangeListener);
                this.contextProvider = null;
            }
            this.resourceManager.dispose();
            this.resourceManager = null;
            this.args = null;
            this.sessionContext = null;
            this.parent = null;
            super.dispose();
        }
        finally {
            this.disposeState = DisposeState.Disposed;
        }
    }

    public void setFocus() {
        this.treeViewer.getTree().setFocus();
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.args = ViewArgumentUtils.parseViewArguments((IViewPart)this);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.args = ViewArgumentUtils.parseViewArguments((IViewPart)this);
        this.memento = memento;
    }

    public void saveState(IMemento memento) {
        if (this.memento != null) {
            memento.putMemento(this.memento);
        }
    }

    protected static class ItemDetailToolTip
    extends NameAndDescriptionToolTip {
        private TreeViewer viewer;
        private Tree tree;

        ItemDetailToolTip(TreeViewer viewer, Tree tree, ViewerFilter filter) {
            super((Control)tree, 2);
            this.tree = tree;
            this.viewer = viewer;
            this.setHideOnMouseDown(false);
        }

        public Point getLocation(Point tipSize, Event event) {
            ViewerCell cell = this.viewer.getCell(new Point(event.x, event.y));
            if (cell != null) {
                return this.tree.toDisplay(event.x, cell.getBounds().y + cell.getBounds().height);
            }
            return super.getLocation(tipSize, event);
        }

        protected Object getToolTipArea(Event event) {
            return this.viewer.getCell(new Point(event.x, event.y));
        }

        @Override
        protected void addContent(Composite destination, Object modelElement) {
            DisplayElement item = (DisplayElement)modelElement;
            String text = null;
            if (item != null) {
                text = item.getValue();
                this.createEntryWithText(destination, null, text.toString());
            }
        }

        @Override
        protected Object getModelElement(Event event) {
            TreeItem treeItem = this.tree.getItem(new Point(event.x, event.y));
            if (treeItem == null) {
                return null;
            }
            return treeItem.getData();
        }
    }

    protected static abstract class NameAndDescriptionToolTip
    extends ToolTip {
        public NameAndDescriptionToolTip(Control control, int style) {
            super(control, style, false);
        }

        protected abstract Object getModelElement(Event var1);

        protected boolean shouldCreateToolTip(Event event) {
            if (!super.shouldCreateToolTip(event)) {
                return false;
            }
            Object tableElement = this.getModelElement(event);
            return tableElement != null && tableElement instanceof DisplayElement;
        }

        protected Composite createToolTipContentArea(Event event, Composite parent) {
            Object modelElement = this.getModelElement(event);
            Image iconImage = null;
            String nameString = "no name";
            if (modelElement instanceof DisplayElement) {
                iconImage = null;
                nameString = ((DisplayElement)modelElement).getIdText();
            }
            Composite composite = new Composite(parent, 0);
            composite.setBackground(parent.getDisplay().getSystemColor(29));
            composite.setLayout((Layout)new GridLayout(2, false));
            Label title = this.createEntry(composite, iconImage, nameString);
            GridDataFactory.createFrom((GridData)((GridData)title.getLayoutData())).hint(-1, -1).applyTo((Control)title);
            this.addContent(composite, modelElement);
            return composite;
        }

        protected Label createEntry(Composite parent, Image icon, String text) {
            if (icon != null) {
                Label iconLabel = new Label(parent, 0);
                iconLabel.setImage(icon);
                iconLabel.setBackground(parent.getDisplay().getSystemColor(29));
                iconLabel.setData((Object)new GridData());
            }
            Label textLabel = new Label(parent, 64);
            if (icon == null) {
                GridDataFactory.generate((Control)textLabel, (int)2, (int)1);
            } else {
                GridDataFactory.generate((Control)textLabel, (int)1, (int)1);
            }
            textLabel.setText(text);
            textLabel.setBackground(parent.getDisplay().getSystemColor(29));
            return textLabel;
        }

        protected Text createEntryWithText(Composite parent, Image icon, String text) {
            if (icon != null) {
                Label iconLabel = new Label(parent, 0);
                iconLabel.setImage(icon);
                iconLabel.setBackground(parent.getDisplay().getSystemColor(29));
                iconLabel.setData((Object)new GridData());
            }
            Text texts = new Text(parent, 522);
            if (icon == null) {
                GridDataFactory.generate((Control)texts, (int)2, (int)1);
            }
            texts.setText(text);
            texts.setBackground(parent.getDisplay().getSystemColor(29));
            return texts;
        }

        protected void addContent(Composite destination, Object modelElement) {
        }
    }
}

