/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural.ui.modelBrowser.contributions;

import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.graph.contributor.labeler.LabelDecoratorContributor;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.structural.ui.modelBrowser.nodes.RunNode;

/**
 * @author Tuukka Lehtonen
 */
public class RunLabelDecorator extends LabelDecoratorContributor<RunNode> {

    @Override
    public LabelDecorator getDecorator(ReadGraph graph, RunNode node) throws DatabaseException {
        return RunLabelDecorationRule.INSTANCE.getLabelDecorator(graph, node.resource);
    }

}
