/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.ui.preferences;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.issues.preferences.IssuePreferences;

public class IssuePreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {

    public IssuePreferencePage() {
        super(GRID);
    }

    @Override
    public void init(IWorkbench workbench) {
    }

    @Override
    protected IPreferenceStore doGetPreferenceStore() {
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.issues"); //$NON-NLS-1$
    }

    @Override
    protected void createFieldEditors() {
        //addField(new BooleanFieldEditor(IssuePreferences.P_ISSUES_ENABLED, "Issue searching &enabled (only takes effect after restart)", getFieldEditorParent()));
        IntegerFieldEditor f = new IntegerFieldEditor(IssuePreferences.P_MAX_BATCH_ISSUES_TO_WRITE, Messages.IssuePreferencePage_MaximumBatchValidationIssues, getFieldEditorParent());
        f.getLabelControl(getFieldEditorParent()).setToolTipText(Messages.IssuePreferencePage_LimitforAmountOfBatchValidation);
        addField(f);
    }

}
