package org.simantics.issues.ui;

import java.util.Collection;
import java.util.Collections;

import org.simantics.browsing.ui.model.children.ChildRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.issues.common.DynamicIssueSources;

/**
 * @author Tuukka Lehtonen
 * @since 1.27
 */
public class DynamicIssueSourceRule implements ChildRule {

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @Override
    public Collection<?> getChildren(ReadGraph graph, Object parent) throws DatabaseException {
        return graph.syncRequest(new DynamicIssueSources((Resource) parent));
    }

    @Override
    public Collection<?> getParents(ReadGraph graph, Object child) throws DatabaseException {
        return Collections.singleton(child);
    }

}
