/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.fastlz.bundle;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.net.URLDecoder;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.simantics.fastlz.FastLZ;
import org.simantics.fastlz.impl.FastLZConfig;
import org.simantics.fastlz.impl.OS;

/**
 * An OSGi bundle activator for that guarantees the FastLZ library is
 * initialized after this bundle is properly activated.
 */
public class Activator implements BundleActivator {

    @Override
    public void start(BundleContext context) throws Exception {
        // Make sure that the FastLZ native library gets initialized properly.
        FastLZConfig.attemptStaticInitialization = false;
        IPath path = new Path("/" + OS.resolveLibName());
        URL libURL = FileLocator.find(context.getBundle(), path, null);
        if (libURL == null) {
            // Fallback for the where org.simantics.fastlz is checked out in the
            // development environment.
            path = new Path("/bin/" + OS.resolveLibName());
            libURL = FileLocator.find(context.getBundle(), path, null);
            if (libURL == null)
                throw new FileNotFoundException(path + " not found in bundle " + context.getBundle().getSymbolicName());
        }
        URL fileURL = FileLocator.toFileURL(libURL);
        File filePath = new File(URLDecoder.decode(fileURL.getPath(), "UTF-8"));
        FastLZ.initialize(filePath);
        
    }

    @Override
    public void stop(BundleContext context) throws Exception {
    }

}
