package org.simantics.db.testing.common;

import org.simantics.Simantics;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;

abstract public class WriteCommand<T extends CommandSequenceEnvironment> extends Command<T> {

	@Override
	public void run(final T environment) throws Exception {
		Simantics.getSession().sync(new WriteRequest() {

			@Override
			public void perform(WriteGraph graph) throws DatabaseException {
				WriteCommand.this.run(graph, environment);
			}
			
			@Override
			public String toString() {
				return WriteCommand.this.toString();
			}
			
		});
		afterRun(environment);
	}
	
	protected void run(WriteGraph graph, T environment) throws DatabaseException {
		
	}
	
	protected void afterRun(T environment) throws Exception {
		
	}

	@Override
	public String toString() {
		return "WriteCommand " + getClass().getSimpleName();
	}
	
}
