package org.simantics.db.testing.common;


import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.core.runtime.Platform;
import org.simantics.DefaultChoiceUserAgent;
import org.simantics.Simantics;
import org.simantics.SimanticsPlatform;
import org.simantics.SimanticsPlatform.OntologyRecoveryPolicy;
import org.simantics.SimanticsPlatform.RecoveryPolicy;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Files;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.management.ISessionContextProviderSource;
import org.simantics.db.management.SessionContext;
import org.simantics.db.management.SessionContextProvider;
import org.simantics.db.management.SingleSessionContextProviderSource;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.db.testing.impl.Configuration;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.scl.osgi.SCLOsgi;

public class Tests {

    private static AcornTestHandler testHandler;

    public static boolean contains(Collection<Statement> stms, Resource predicate, Resource object) {
        for(Statement stm : stms) {
            if(stm.getPredicate().equals(predicate) && stm.getObject().equals(object)) return true;
        }
        return false;
    }

    public static boolean contains(Collection<Statement> stms, Resource subject, Resource predicate, Resource object) {
        for(Statement stm : stms) {
            if(stm.getSubject().equals(subject) && stm.getPredicate().equals(predicate) && stm.getObject().equals(object)) return true;
        }
        return false;
    }

    public static DatabaseState freshWorkspace(String CORE_DIR, ArrayList<String> fileFilter) throws Exception {
        SimanticsPlatform.INSTANCE.resetWorkspace(null, fileFilter);
        return newSimanticsWorkspace(null, CORE_DIR);
    }

    public static void freshDatabase() throws Exception {
        DatabaseState state = freshWorkspace(Configuration.get().coreDir, null);
        shutdown(state);
    }

    public static DatabaseState existingDatabase() throws Exception {
        return oldSimanticsWorkspace(null, Configuration.get().coreDir);
    }

    private static void initSimanticsStuff() {
        // Set session context provider.
        final ISessionContextProvider provider = new SessionContextProvider(null);
        ISessionContextProviderSource source = new SingleSessionContextProviderSource(provider);
        Simantics.setSessionContextProviderSource(source);
        org.simantics.db.layer0.internal.SimanticsInternal.setSessionContextProviderSource(source);
    }

    public static DatabaseState newSimanticsWorkspace(TestSettings testSettings, String address) throws Exception {
        AcornTestHandler testHandler = getTestHandler(testSettings, address);
        testHandler.initNew();
        initSimanticsStuff();
        SessionContext sessionContext = SimanticsPlatform.INSTANCE.startUp(Simantics.getDefaultDatabaseDriver(), null, RecoveryPolicy.FixError, OntologyRecoveryPolicy.Merge, true, new DefaultChoiceUserAgent());
        return new DatabaseState(address, sessionContext);
    }

    public static DatabaseState oldSimanticsWorkspace(TestSettings testSettings, String address) throws Exception {
        getTestHandler(testSettings, address);
        initSimanticsStuff();
        SessionContext sessionContext = SimanticsPlatform.INSTANCE.startUp(Simantics.getDefaultDatabaseDriver(), null, RecoveryPolicy.FixError, OntologyRecoveryPolicy.Merge, false, null);
        return new DatabaseState(address, sessionContext);
    }
    public static void shutdown(DatabaseState state) throws Exception {
        if (SCLOsgi.MODULE_REPOSITORY != null)
            SCLOsgi.MODULE_REPOSITORY.flush();
        SCLOsgi.SOURCE_REPOSITORY = null;
        SCLOsgi.MODULE_REPOSITORY = null;
        SCLOsgi.TEST_REPOSITORY = null;

        if (Platform.isRunning()) {
            SimanticsPlatform.INSTANCE.shutdown(null);
            return;
        } // Cleanup without platform code.
        if (null == state)
            return;
        String address = state.getAddress();
        try {
            if (null != address)
                getTestHandler(null, address).getManagement().shutdown();
        } catch (Throwable t) {
            System.out.println(t);
        }
    }

    public static void initOntology(Session session, String relative) throws DatabaseException {
        // Open transferable graph file for layer0.
        Binding binding;
        try {
            binding = Bindings.getBinding(TransferableGraph1.class);
        } catch (BindingConstructionException e) {
            throw new DatabaseException(e);
        }
        File t = new File(TestSettings.getInstance().getWorkspace(), relative);
        if (!t.exists())
            throw new DatabaseException("File does not exist. File=" + t + ".");

        TransferableGraph1 layer0;
        try {
            InputStream is = new FileInputStream(t);
            layer0 = (TransferableGraph1) Files.readFile(is, binding);
            is.close();
        } catch (Exception e) {
            e.printStackTrace();
            throw new DatabaseException(e);
        }
        try {
            TransferableGraphs.importGraph(session, layer0);
        } catch (Throwable e) {
            e.printStackTrace();
            throw new DatabaseException("Failed to init db.", e);
        }
    }
//    public static TestHandler newTestHandler(TestSettings testSettings, String dbFolderName) throws DatabaseException {
//        return new TestHandler(testSettings, dbFolderName);
//    }

    public static AcornTestHandler getTestHandler() throws DatabaseException {
        return getTestHandler(null, null);
    }

    public static AcornTestHandler getTestHandler(TestSettings testSettings, String address) throws DatabaseException {
        if (null == testHandler)
            testHandler = new AcornTestHandler(testSettings, address);
        return testHandler;
    }

    public static void closeSession(Session session) throws DatabaseException {
        try {
            LifecycleSupport support = session.getService(LifecycleSupport.class);
            support.close(-1, false);
            session = null;
        } catch (Exception e) {
            session = null;
            throw new DatabaseException("Session did not close cleanly.");
        }
    }

    public static void killCore() throws DatabaseException {
    }

}
