/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterI;

public class ClusterTraitsBase {
    private static final int RK_TYPE_BITS = 1;
    private static final int RK_CLUSTER_BITS = 19;
    private static final int RK_CLUSTER_MAX = 524287;
    private static final int RK_INDEX_BITS = 12;
    private static final int RK_INDEX_MAX = 4095;
    private static final int RID_TYPE_BITS = 1;
    private static final int RID_CLUSTER_BITS = 51;
    private static final int RID_CLUSTER_MAX = 524287;
    private static final int RID_INDEX_BITS = 12;
    private static final int RID_INDEX_MAX = 4095;

    public static final boolean isIllegalResourceIndex(int resourceIndex) {
        return resourceIndex < 1 || resourceIndex > 4095;
    }

    public static final short getResourceIndexFromResourceKey(int resourceKey) throws DatabaseException {
        short resourceIndex = (short)(resourceKey & 0xFFF);
        if (ClusterTraitsBase.isIllegalResourceIndex(resourceIndex)) {
            throw new DatabaseException("Illegal resource key " + resourceKey);
        }
        return resourceIndex;
    }

    public static final short getResourceIndexFromResourceKeyNoThrow(int resourceKey) {
        return (short)(resourceKey & 0xFFF);
    }

    public static final int getClusterKeyFromResourceKey(int resourceKey) throws DatabaseException {
        int clusterKey = resourceKey >>> 12;
        if (clusterKey < 1 || clusterKey >= ClusterTraitsBase.getClusterArraySize()) {
            throw new DatabaseException("Illegal cluster key for resource key=" + resourceKey);
        }
        return clusterKey;
    }

    public static final int getClusterKeyFromResourceKeyNoThrow(int resourceKey) {
        return resourceKey >>> 12;
    }

    public static final boolean isVirtualClusterKey(int clusterKey) {
        return (clusterKey & 0xFFF80000) != 0;
    }

    public static final int getCompleteTypeIntFromResourceKey(int resourceKey) {
        if ((resourceKey & 0xFFFFEFFC) != 0) {
            return 0;
        }
        return resourceKey & 3;
    }

    public static final ClusterI.CompleteTypeEnum getCompleteTypeFromResourceKey(int resourceKey) {
        return ClusterI.CompleteTypeEnum.make(ClusterTraitsBase.getCompleteTypeIntFromResourceKey(resourceKey));
    }

    public static final int getCompleteTypeResourceKeyFromEnum(ClusterI.CompleteTypeEnum completeType) throws DatabaseException {
        switch (completeType) {
            default: {
                throw new DatabaseException("Illegal compete type for getCompletePredicateKey: " + (Object)((Object)completeType));
            }
            case InstanceOf: {
                return 4097;
            }
            case Inherits: {
                return 4098;
            }
            case SubrelationOf: 
        }
        return 4099;
    }

    public static final int createResourceKey(int clusterIndex, int resourceIndex) throws DatabaseException {
        if (clusterIndex < 0 || clusterIndex > 524287) {
            throw new DatabaseException("Illegal cluster index " + clusterIndex);
        }
        if (ClusterTraitsBase.isIllegalResourceIndex(resourceIndex)) {
            throw new DatabaseException("Illegal resource index " + resourceIndex);
        }
        return ClusterTraitsBase.createResourceKeyNoThrow(clusterIndex, resourceIndex);
    }

    public static final int createResourceKeyNoThrow(int clusterIndex, int resourceIndex) {
        return clusterIndex << 12 | resourceIndex;
    }

    public static final int getClusterBits(int clusterKey) {
        return clusterKey << 12;
    }

    public static final boolean isCluster(int clusterKeyBits, int resourceKey) {
        return clusterKeyBits == (resourceKey & 0xFFFFF000);
    }

    public static final int getClusterMaskFromResourceKey(int resourceKey) {
        return resourceKey & 0xFFFFF000;
    }

    public static final int getMaxNumberOfResources() {
        return 4095;
    }

    public static final long createResourceId(long clusterId, int resourceIndex) throws DatabaseException {
        if (clusterId < 1L || clusterId > 524287L) {
            throw new DatabaseException("Illegal cluster id " + clusterId);
        }
        if (ClusterTraitsBase.isIllegalResourceIndex(resourceIndex)) {
            throw new DatabaseException("Illegal resource index " + resourceIndex);
        }
        return ClusterTraitsBase.createResourceIdNoThrow(clusterId, resourceIndex);
    }

    public static final long createResourceIdNoThrow(long clusterId, int resourceIndex) {
        return clusterId << 12 | (long)resourceIndex;
    }

    public static final long getClusterIdFromResourceId(long resourceId) {
        return resourceId >>> 12;
    }

    public static final int getResourceIndexFromResourceId(long resourceId) {
        return (int)(resourceId & 0xFFFL);
    }

    public static final int getClusterArraySize() {
        return 524287;
    }
}

