package org.simantics.db.impl;

import org.simantics.db.ReadGraph;
import org.simantics.db.RelationInfo;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.procedure.SyncMultiProcedure;

public final class ForEachObjectProcedure implements SyncMultiProcedure<Resource> {

	public final int predicateKey;
	public final int[] clusterKey;
	public final int[] predicateReference;
	public final RelationInfo info;
	public final QueryProcessor processor;
	public final ClusterI.CompleteTypeEnum completeType;
	private final SyncMultiProcedure<Resource> user;
	
	public ForEachObjectProcedure(int predicateKey, RelationInfo info, QueryProcessor processor, SyncMultiProcedure<Resource> user) {
		this.predicateKey = predicateKey;
		this.completeType = ClusterTraitsBase.getCompleteTypeFromResourceKey(predicateKey); 
		this.info = info;
		this.user = user;
		this.processor = processor;
		this.clusterKey = new int[32*8];
		this.predicateReference = new int[32*8];
	}
	
	@Override
	public void execute(ReadGraph graph, Resource result) throws DatabaseException {
		user.execute(graph, result);
	}

	@Override
	public void finished(ReadGraph graph) throws DatabaseException {
		user.finished(graph);
	}

	@Override
	public void exception(ReadGraph graph, Throwable throwable) throws DatabaseException {
		user.exception(graph, throwable);
	}
	
}
