/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.contributor.imager;

import org.simantics.browsing.ui.content.ImageDecorator;
import org.simantics.browsing.ui.graph.impl.contributor.imager.ImageDecoratorContributorImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * @author Tuukka Lehtonen
 * 
 * @param <T>
 */
public abstract class ImageDecoratorContributor<T> extends ImageDecoratorContributorImpl<T> {

    /**
     * @see org.simantics.browsing.ui.graph.impl.contributor.imager.ImageDecoratorContributorImpl#getDecorator(org.simantics.db.ReadGraph,
     *      java.lang.Object)
     * @return null if no decoration is needed after all
     */
    @Override
    public abstract ImageDecorator getDecorator(ReadGraph graph, T input) throws DatabaseException;

}
