/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl.contributor.labeler;

import java.util.Map;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.BuiltinKeys.LabelerKey;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.content.Contributor;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.browsing.ui.content.LabelerFactory;
import org.simantics.browsing.ui.graph.impl.contribution.LabelerContributionImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.UndoContext;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.ReflectionUtils;
import org.simantics.utils.datastructures.ArrayMap;

abstract public class LabelerContributorImpl<T> implements Contributor<LabelerFactory> {

    abstract public String getLabel(ReadGraph graph, T input) throws DatabaseException;

    public int getCategory(ReadGraph graph, T input) throws DatabaseException {
        return 0;
    }

    public Modifier getModifier(ReadGraph graph, T input, String columnKey) throws DatabaseException {
        return null;
    }

    final private Class<?> clazz;

    @Override
    public Tester getNodeContextTester() {
        return null;
    }

    public LabelerContributorImpl() {
        clazz = ReflectionUtils.getSingleParameterType(getClass());
    }

    public LabelerContributorImpl(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public LabelerFactory getFactory() {

        return new LabelerFactory() {

            @Override
            public Labeler create(final PrimitiveQueryUpdater updater, NodeContext context, final LabelerKey key) {

                return new LabelerContributionImpl(updater, context, key) {

                    @SuppressWarnings("unchecked")
                    @Override
                    public Map<String, String> labels(ReadGraph graph, NodeContext context) throws DatabaseException {

                        T input = (T)context.getConstant(BuiltinKeys.INPUT);

                        String value = LabelerContributorImpl.this.getLabel(graph, input);

                        return new ArrayMap<String, String>(ColumnKeys.KEYS_SINGLE,
                                new String[] { value });

                    }

                    @SuppressWarnings("unchecked")
                    @Override
                    public Modifier getModifier(ReadGraph graph, UndoContext undoContext, NodeContext context, String columnKey) throws DatabaseException {

                        T input = (T)context.getConstant(BuiltinKeys.INPUT);

                        return LabelerContributorImpl.this.getModifier(graph, input, columnKey);

                    }

                    @SuppressWarnings("unchecked")
                    @Override
                    public int category(ReadGraph graph, NodeContext context) throws DatabaseException {

                        T input = (T)context.getConstant(BuiltinKeys.INPUT);

                        return LabelerContributorImpl.this.getCategory(graph, input);

                    }

                    @Override
                    public String toString() {
                        return LabelerContributorImpl.this.toString();
                    }

                };

            }

        };

    }

    @Override
    public Class<?> getInputClass() {
        return clazz;
    }

}
