/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import java.util.Collection;

import org.eclipse.core.runtime.IAdaptable;
import org.simantics.db.Resource;

public class TypeIndex implements IAdaptable {
    
    final public Resource type;
    final public Collection<Resource> instances;
    final public String name;

    public TypeIndex(Resource type, Collection<Resource> instances, String name) {
        this.type = type;
        this.instances = instances;
        this.name = name;
    }

    @SuppressWarnings({ "rawtypes" })
    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == Resource.class)
            return type;
        return null;
    }

}
