/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;


/**
 * @author Tuukka Lehtonen
 */
public interface ObservableInputSource extends SessionContextInputSource {

    /**
     * This method may be invoked at any time. If the source is disposed it
     * shouldn't do anything.
     * 
     * @param listener the listener that shall be invoked when the input source
     *        content has changed. Previous listener will be overridden.
     *        <code>null</code> to remove current listener.
     */
    void setListener(InputSourceListener listener);

}
