package org.simantics.browsing.ui.graph.impl;

import java.util.Map;

import org.simantics.browsing.ui.BuiltinKeys.LabelerKey;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.simantics.Simantics;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.graph.impl.contribution.LabelerContributionImpl;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.browsing.ui.model.tooltips.TooltipContribution;
import org.simantics.db.GraphHints;
import org.simantics.db.ReadGraph;
import org.simantics.db.UndoContext;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.RequestUtil;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.SimanticsUI;

public class EvaluatorLabeler extends LabelerContributionImpl {

    final BrowseContext browseContext;
    final boolean useNodeBrowseContexts;

    private TooltipContribution currentTooltipContribution;

    public EvaluatorLabeler(PrimitiveQueryUpdater updater, NodeContext context,
            LabelerKey key,
            BrowseContext browseContext, boolean useNodeBrowseContexts) {
        super(updater, context, key);
        this.browseContext = browseContext;
        this.useNodeBrowseContexts = useNodeBrowseContexts;
    }

    @Override
    public Map<String, String> labels(
            ReadGraph graph,
            NodeContext context)
                    throws DatabaseException {
        GraphHints old = graph.setHintValue(ReadGraph.GRAPH_HINT_SYNCHRONOUS, false); 
        try {
            return BrowseContext.get(graph,context,browseContext,useNodeBrowseContexts).getLabel(graph, context);
        } finally {
            graph.setHints(old);
        }
    }

    @Override
    public int category(ReadGraph graph,
            NodeContext context)
                    throws DatabaseException {
        return 0;
    }

    public Modifier 
    getModifier(ReadGraph graph, UndoContext undoContext, 
            NodeContext context, String columnKey) throws DatabaseException {
        return BrowseContext.get(graph,context,browseContext,useNodeBrowseContexts).getModifier(graph, context, columnKey);
    }

    public String toString() {
        return "EvaluatorLabeler[" + browseContext + "] " + context;
    }


    @Override
    public boolean shouldCreateToolTip(Event event, NodeContext context) {
        try {
            currentTooltipContribution = RequestUtil.trySyncRequest(
                    Simantics.getSession(),
                    SimanticsUI.UI_THREAD_REQUEST_START_TIMEOUT,
                    SimanticsUI.UI_THREAD_REQUEST_EXECUTION_TIMEOUT,
                    null,
                    new UniqueRead<TooltipContribution>() {
                        @Override
                        public TooltipContribution perform(ReadGraph graph) throws DatabaseException {
                            return BrowseContext.get(graph,context,browseContext,useNodeBrowseContexts).shouldCreateToolTip(graph, event, context);
                        }
                    });
            if (currentTooltipContribution != null)
                return true;
        } catch (DatabaseException | InterruptedException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public Composite createToolTipContentArea(Event event, Composite parent, NodeContext nodeContext) {
        return (Composite) currentTooltipContribution.getTooltip(event, parent, nodeContext);
    }

}
